set optimizer='minimal_pipe';
CREATE TABLE QsoTarget( 
	"targetObjID" bigint	NOT NULL,
	"headObjID" bigint	NOT NULL,
	"targetRa" float	NOT NULL,
	"targetDec" float	NOT NULL,
	"targetCx" float	NOT NULL,
	"targetCy" float	NOT NULL,
	"targetCz" float	NOT NULL,
	"targetPsfMag_u" real	NOT NULL,
	"targetPsfMag_g" real	NOT NULL,
	"targetPsfMag_r" real	NOT NULL,
	"targetPsfMag_i" real	NOT NULL,
	"targetPsfMag_z" real	NOT NULL,
	"targetPsfMagErr_u" real	NOT NULL,
	"targetPsfMagErr_g" real	NOT NULL,
	"targetPsfMagErr_r" real	NOT NULL,
	"targetPsfMagErr_i" real	NOT NULL,
	"targetPsfMagErr_z" real	NOT NULL,
	"targetExtinction_u" real	NOT NULL,
	"targetExtinction_g" real	NOT NULL,
	"targetExtinction_r" real	NOT NULL,
	"targetExtinction_i" real	NOT NULL,
	"targetExtinction_z" real	NOT NULL,
	"targetType" int	NOT NULL,
	"targetMode" int	NOT NULL,
	"targetStatus" int	NOT NULL,
	"targetFlags" bigint	NOT NULL,
	"targetFlags_u" bigint	NOT NULL,
	"targetFlags_g" bigint	NOT NULL,
	"targetFlags_r" bigint	NOT NULL,
	"targetFlags_i" bigint	NOT NULL,
	"targetFlags_z" bigint	NOT NULL,
	"targetRowC_i" real	NOT NULL,
	"targetColC_i" real	NOT NULL,
	"targetInsideMask" int	NOT NULL,
	"targetPrimTarget" int	NOT NULL,
	"targetPriTargHiZ" int	NOT NULL,
	"targetPriTargLowZ" int	NOT NULL,
	"targetPriTargFirst" int	NOT NULL,
	"targetFieldID" bigint	NOT NULL,
	"targetFieldMjd" float	NOT NULL,
	"targetFieldQuality" int	NOT NULL,
	"targetFieldCulled" int	NOT NULL,
	"targetSectorID" bigint	NOT NULL,
	"targetFirstID" int	NOT NULL,
	"targetFirstPeak" float	NOT NULL,
	"targetRosatID" int	NOT NULL,
	"targetRosatCps" float	NOT NULL,
	"targetMi" float	NOT NULL,
	"TargetQsoTargeted" tinyint	NOT NULL,
	"targetUniform" tinyint	NOT NULL
);

COPY 876 RECORDS INTO QsoTarget FROM STDIN USING DELIMITERS '|','\n';
0|0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0.0|0|0|0|0|0|0|0|0|0|0.0|0.0|0|0|0|0|0|0|0.0|0|0|0|0|0.0|0|0.0|0.0|0|0
5738613965003|758883005492166990|251.20187814942599|64.114106169010896|-0.14068130783209601|-0.41329303428041902|0.89966529189578903|23.722553|20.361975|19.059278|17.726887|17.066248|0.82791549|3.0251695E-2|0.01541957|7.8433193E-3|2.2619713E-2|0.32992938|0.2427589|0.17606901|0.1335078|9.4658695E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|198.04427|605.53674|0|0|0|0|0|5738613964800|51638.385234200003|3|0|0|0|0.0|0|0.0|0.0|0|0
5738613965105|587725489985814964|251.467093594516|64.136887639899101|-0.13865301133291599|-0.41360060215586703|0.89983881020137102|23.609306|20.739803|20.335016|20.079485|19.830914|0.76159233|3.6290847E-2|0.02864188|0.03405001|0.09274485|0.38889676|0.28614655|0.20753734|0.15736929|0.11157678|6|1|9843|268435712|142647553|268468224|268468224|268468224|402685952|464.39203|1643.7765|0|0|0|0|0|5738613964800|51638.385234200003|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614095952|587725489985945732|251.532250995222|63.741319623352602|-0.14014718611211699|-0.41964063153721498|0.89680572399372105|16.111917|15.040799|15.046659|15.047159|15.140437|1.6118472E-2|9.2752213E-3|0.01556411|2.0574262E-2|1.2981424E-2|0.14817688|0.10902714|7.9075575E-2|5.9960615E-2|4.2512823E-2|6|1|26227|268435456|276856832|268468224|268468224|268468224|268468256|1104.2595|335.20779|0|1056768|0|0|0|5738614095872|51638.386063400001|3|0|87899|0|0.0|0|0.0|0.0|0|0
5738614096108|587725489985945823|251.51594219625699|63.723799601546297|-0.14035356249848799|-0.41986078336113603|0.89667039657242897|20.029692|19.67275|19.428604|19.061096|18.930609|4.3359473E-2|1.6264822E-2|2.0325754E-2|2.4983384E-2|4.4600017E-2|0.13645001|0.10039862|7.2817452E-2|5.5215269E-2|3.9148316E-2|6|1|26227|268566528|268468224|268468224|268468224|268599296|402685952|1220.1355|207.96022|0|34603008|0|0|0|5738614095872|51638.386063400001|3|0|87899|0|0.0|0|0.0|0.0|0|0
5738614292597|758883004418490759|251.97108427079101|63.349608258818002|-0.13882340061468201|-0.42652194768979101|0.89376008614207103|20.482094|18.10877|17.142185|16.798557|16.542671|0.10415659|1.1337518E-2|7.1865367E-3|1.2249604E-2|2.2044986E-2|0.13125561|9.6576631E-2|7.0045426E-2|5.3113326E-2|0.03765801|6|1|9843|17592454610944|268468224|158329942999040|268468224|268599296|268468224|1000.3965|428.59271|0|0|0|0|0|5738614292480|51638.387307199999|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614292690|758883004418556048|252.20248898094701|63.445075725701898|-0.136644276597959|-0.42566061854792703|0.89450622104623501|20.876541|20.045677|19.60611|19.159483|18.929853|0.11695795|2.0211609E-2|1.6488917E-2|2.0064183E-2|4.5639601E-2|0.1626008|0.11964012|8.6772993E-2|6.5797336E-2|4.6651129E-2|6|1|9843|268435968|276856832|268468224|268468224|276857344|402685952|607.86115|1647.7196|0|0|0|0|0|5738614292480|51638.387307199999|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614358027|758883004418556090|252.30592938826601|63.352557752598102|-0.136314401969966|-0.42728213078538602|0.89378317534347795|22.881693|22.268343|20.963438|19.485554|18.714207|0.41804424|0.16869166|7.8804061E-2|3.3356991E-2|4.3130912E-2|0.15792085|0.11619666|8.4275506E-2|0.06390357|4.5308426E-2|6|1|26227|70369012744976|70369180419345|302022672|70369054588945|302023184|302022672|187.42223|1678.4117|0|33554432|0|0|0|5738614358016|51638.387721799998|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614358237|5738614358237|252.074425467179|63.184783587723899|-0.13884464856015299|-0.42921617278692098|0.89246604449937195|20.908371|19.514061|18.977337|18.532665|18.640278|8.9278303E-2|1.4630593E-2|1.7285615E-2|1.4390607E-2|3.7121814E-2|0.13085859|9.6284501E-2|6.9833547E-2|5.2952666E-2|3.7544101E-2|6|1|26227|268435456|402685952|268468224|268468224|268468224|268468224|1177.0245|180.26959|0|1|1|0|0|5738614358016|51638.387721799998|3|0|87899|0|0.0|0|0.0|5.0173479917850869|1|0
5738614423587|758883003881685071|252.26046285827499|63.114056575846099|-0.13778583485769999|-0.43071369961522599|0.89190850017046697|17.931391|16.891418|16.502535|16.367821|16.228838|3.5004076E-2|1.1915813E-2|2.4194909E-2|0.0259731|0.02095636|0.14298606|0.10520779|7.6305464E-2|5.7860121E-2|4.1023549E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|719.68091|603.09595|0|0|0|0|0|5738614423552|51638.388136299996|3|0|87899|0|0.0|0|0.0|0.0|0|0
5738614423594|758883003881685047|252.25195518063799|63.085650391345702|-0.13798456585806301|-0.43111432861989601|0.89168419030707202|22.25868|19.824356|18.655521|18.18281|17.850731|0.25183114|0.1550504|5.7400119E-2|6.5722451E-2|2.7263861E-2|0.1471682|0.10828496|7.8537285E-2|5.9552446E-2|4.2223427E-2|6|1|9843|70369013268496|70369012645905|268992528|268992528|268992528|268468240|939.99591|463.55307|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423605|758883003881750561|252.549251447919|63.120485364622198|-0.13558315051620301|-0.43130723711875901|0.89195923477762296|17.077394|15.827418|15.269535|15.079822|14.997843|3.4176152E-2|1.1719908E-2|2.4105951E-2|2.5877615E-2|2.0329345E-2|0.15683237|0.11539576|8.3694629E-2|6.3463107E-2|4.4996131E-2|6|1|9843|35184641180180|302547508|302547508|302022672|302678068|302023220|1159.639|1706.4237|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423607|758883003881685175|252.48841421777499|63.111744525307799|-0.136081983258105|-0.43129279336079002|0.89189025122353904|17.450394|16.328419|15.876534|15.705821|15.668841|3.4811437E-2|1.1774001E-2|2.4128161E-2|2.5949212E-2|2.0536255E-2|0.15174159|0.11165003|8.0977909E-2|6.1403099E-2|4.3535564E-2|6|1|9843|52776827228692|158329977077812|302682164|302022672|302678068|436240948|1128.6|1446.0309|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423609|758883003881750565|252.550420458189|63.143136874036202|-0.13546859794437299|-0.43097356704914003|0.892137906086232|18.544382|16.952419|16.325535|16.136822|16.021839|3.6788091E-2|1.1926791E-2|2.4172639E-2|2.5949201E-2|2.0764356E-2|0.15056473|0.1107841|0.08034987|6.0926873E-2|4.3197911E-2|6|1|9843|35184641180180|302547508|302546996|302022672|302546996|302022708|973.96771|1796.0414|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423612|758883003881685176|252.48657323441699|63.109063404807003|-0.13610840042263|-0.431328221051265|0.89186908739968296|21.841063|19.743364|18.276527|17.484818|17.021818|0.24177752|0.01884732|2.4849426E-2|2.6358485E-2|0.02230949|0.15227234|0.11204054|8.1261151E-2|0.06161787|4.3687835E-2|6|1|9843|123145571402516|228698863862069|302546996|302022672|302546996|302023220|1147.6244|1429.0609|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423616|758883003881750820|252.59734828317301|63.122729639127101|-0.13521059319068501|-0.43138756104320197|0.89197694346110801|20.371975|19.825356|18.761518|18.077812|17.681761|0.06428881|1.9644469E-2|2.5521444E-2|2.6872799E-2|2.5375744E-2|0.16364191|0.12040617|0.08732859|6.6218629E-2|4.6949834E-2|3|1|9843|105553385358100|70369046855733|310935860|302023184|302546996|302022708|1222.7177|1894.8236|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423619|758883003881619705|252.21825480672001|63.037909959052797|-0.13846496673448699|-0.431740425846806|0.89130671358227498|16.870396|15.759418|15.365535|15.249822|15.179843|3.4019154E-2|1.1709119E-2|2.4128165E-2|2.5901461E-2|2.0385578E-2|0.16130047|0.11868335|8.6079061E-2|6.5271147E-2|4.6278056E-2|6|1|9843|268566544|268468240|268468240|268599312|268599312|268468240|1276.5809|155.99034|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423620|758883003881685002|252.22229037954699|63.039998801088899|-0.138424635694301|-0.43171923428395997|0.89132324270276497|21.795574|19.504383|18.12553|17.298819|16.779827|0.14974317|0.01692277|0.02466711|2.6213292E-2|0.02176214|0.16059114|0.11816144|8.5700534E-2|0.06498412|4.6074551E-2|6|1|9843|268566544|142770192|268468240|268599312|268468240|268468240|1266.3265|179.00635|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423624|758883003881685027|252.27272512427899|63.045389254345302|-0.13801902638966801|-0.43176103878723798|0.89136589217885898|18.06039|16.979418|16.600534|16.480822|16.396835|3.5720471E-2|1.1948781E-2|2.4194906E-2|2.5997026E-2|2.1130648E-2|0.16016662|0.11784908|8.5473984E-2|6.4812332E-2|4.5952752E-2|6|1|9843|17592455135248|158329976553488|302022672|302546960|302546960|302022672|1308.5159|388.10452|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423672|758883003881619700|252.169402225368|63.105605660995899|-0.13851047779467399|-0.43061940111233199|0.89184179030069399|18.932367|16.578419|15.590534|15.263822|14.978843|3.7956845E-2|1.1839244E-2|2.4128163E-2|2.5901459E-2|2.0329347E-2|0.13817587|0.10166849|7.3738471E-2|5.5913649E-2|3.9643474E-2|6|1|9843|268566528|268599296|268468224|268468224|268468224|268599296|632.96564|231.36435|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423678|758883003881685267|252.326501178109|63.123433240106699|-0.13724499339072399|-0.43073314287733|0.89198249501668903|19.71627|18.769409|18.376528|18.226809|18.064676|4.4667497E-2|1.3605271E-2|2.4964036E-2|2.7046394E-2|2.9022131E-2|0.1460003|0.10742563|7.7914029E-2|5.9079848E-2|4.1888349E-2|6|1|9843|268566544|268599312|268599312|268468240|268468240|402685968|755.3797|885.39655|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423685|758883003881685156|252.41268505180901|63.129741592887697|-0.13656725743231399|-0.43084547764499598|0.89203226320031204|18.838371|17.367418|16.835535|16.65782|16.522833|3.7817735E-2|1.2092688E-2|2.4239505E-2|2.5997015E-2|2.1326026E-2|0.14745535|0.10849624|7.8690521E-2|5.9668642E-2|4.2305809E-2|6|1|9843|268566544|268468240|268468240|268468240|268599312|268468240|850.52289|1230.9323|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423688|758883003881685273|252.35991751514601|63.118141945238101|-0.13701871775301|-0.43089161418393301|0.89194074232052301|20.331005|17.723417|16.410534|15.793821|15.388843|6.0111396E-2|1.2317469E-2|2.4172639E-2|2.5925322E-2|2.0441957E-2|0.14698821|0.10815253|0.07844124|5.9479617E-2|4.2171791E-2|6|1|9843|268566528|268468224|268468224|268599296|268599296|268468224|856.28699|989.99701|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423694|758883003881619835|252.171862941141|63.070535561756898|-0.138659087743633|-0.43114494106933698|0.89156474648587403|19.766258|18.78941|18.426525|18.273808|18.171638|0.04677156|1.3947842E-2|2.5311271E-2|2.7171152E-2|3.0471489E-2|0.14860521|0.10934231|7.9304159E-2|6.0133941E-2|4.2635716E-2|6|1|9843|17592454610960|268468240|268468240|158329942999056|268468240|402685968|927.06445|106.86578|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423695|758883003881619834|252.169906689821|63.072380209178|-0.13866501912851401|-0.43111288096838102|0.891579326999696|22.482611|20.930931|19.786428|19.289726|18.960966|0.30418369|3.9126385E-2|3.2629803E-2|3.1537421E-2|0.04814028|0.14785756|0.10879219|7.8905173E-2|5.9831403E-2|4.2421211E-2|6|1|9843|87961198789392|70369155252497|268468240|158329942999056|268468240|402686480|908.37915|106.65683|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423703|758883003881685137|252.38673883204299|63.096807269180701|-0.13691748152635599|-0.431272231963029|0.89177231690051195|21.437389|19.381392|18.20253|17.736816|17.445789|0.13123029|1.8970823E-2|2.6261386E-2|2.8610036E-2|2.3771275E-2|0.14969018|0.11014061|7.9883158E-2|6.0572978E-2|4.2946998E-2|6|1|9843|268570640|268468240|276856848|268468240|268468240|268603408|1078.6814|1009.4927|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423715|758883003881685291|252.418750660071|63.084486229139003|-0.13673442551411499|-0.43153146360592298|0.89167499280705098|21.243294|18.75341|17.302534|16.39282|15.883841|0.11343887|1.3769174E-2|2.4351345E-2|2.5949189E-2|2.0669015E-2|0.15294178|0.1125331|8.1618391E-2|6.1888758E-2|0.0438799|6|1|9843|268566544|268468240|268468240|268468240|268599312|268468240|1235.235|1082.6453|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423728|758883003881685251|252.31951669340501|63.046872264815299|-0.13765936834936501|-0.43185162841925601|0.89137762443158197|21.421476|18.808409|17.375534|16.692822|16.245838|0.12014056|1.3922152E-2|2.4351336E-2|2.6044942E-2|2.0956343E-2|0.16133061|0.11870553|8.6095154E-2|6.5283351E-2|4.6286706E-2|6|1|9843|268566800|276988176|268468240|268468240|268468240|268468240|1376.6517|568.82501|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423729|758883003881685252|252.32266507759999|63.0453913242822|-0.13764263413664199|-0.43188114375863301|0.89136590855476505|22.550798|19.827354|18.592524|18.13781|17.816736|0.25589725|1.9321412E-2|2.5217976E-2|2.6897477E-2|2.6375014E-2|0.16205007|0.1192349|0.08647909|6.5574475E-2|0.04649312|6|1|9843|87961198788880|87961341427985|268468240|268468240|268468240|268468240|1394.3394|575.06152|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423749|758883003881685275|252.365507332205|63.1122328487847|-0.137004545671679|-0.430992643488389|0.89189410566736405|22.098207|19.995331|18.873514|18.425802|18.145649|0.22115898|2.0970797E-2|2.5497688E-2|2.7246002E-2|2.9943474E-2|0.14735095|0.10841943|7.8634813E-2|5.9626397E-2|4.2275861E-2|6|1|9843|268566528|134250497|268468224|268599296|268599296|402685952|914.72266|988.66187|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423750|758883003881685214|252.20035098916|63.077249454197599|-0.138412763646834|-0.43111435539052401|0.89161781018318598|22.232334|19.55838|18.16753|17.403818|16.871824|0.37126625|1.7332738E-2|2.4758127E-2|2.6285786E-2|2.1822147E-2|0.14765227|0.10864113|7.8795612E-2|5.9748329E-2|0.04236231|6|1|9843|268566528|140737631125505|268468224|268468224|268468224|268599296|920.69507|238.74519|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423753|758883003881750781|252.515907585566|63.129051652922499|-0.13579406382294601|-0.43110105953321898|0.89202682061683902|21.224367|19.092402|17.670532|16.97682|16.578833|0.1205678|1.4835292E-2|2.4463676E-2|2.6116971E-2|2.1384958E-2|0.15091425|0.11104127|8.0536388E-2|6.1068308E-2|4.3298192E-2|6|1|9843|34628174336|293634048|285245952|419463680|419463680|285245952|1031.9625|1613.9867|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423755|758883003881685243|252.29337159342899|63.079058940670699|-0.137704096240196|-0.43131167757469402|0.89163210948595495|21.352823|19.1404|18.04653|17.614817|17.303802|0.11988875|1.5055456E-2|2.4667159E-2|2.6334153E-2|2.3338243E-2|0.15018061|0.11050146|8.0144875E-2|6.0771432E-2|4.3087702E-2|6|1|9843|268566784|402687232|268468224|268468224|268599296|268468224|1065.6035|593.11633|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614423792|5738614423792|252.336608692634|63.075365166664|-0.137396017654282|-0.43147024169991899|0.89160291882662501|19.37233|19.39539|19.081507|18.858778|18.379543|4.1807242E-2|1.6221061E-2|2.6235571E-2|2.8765898E-2|3.3312105E-2|0.15231338|0.11207073|8.1283048E-2|0.06163447|4.3699607E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1170.2048|740.87555|0|4|0|4|0|5738614423552|51638.388136299996|3|0|87899|0|0.0|0|0.0|-22.750766403021878|1|0
5738614423994|758883003881685402|252.366293170094|63.130348926311001|-0.13691319999651|-0.43072574788781098|0.89203705403598699|23.145277|21.119726|19.9174|19.387707|19.060789|0.40327927|4.4371158E-2|3.0901583E-2|0.03221127|5.1234212E-2|0.14669316|0.10793543|7.8283772E-2|5.9360217E-2|4.2087134E-2|6|1|9843|268566784|142737665|268468224|268435456|268435456|268435456|766.27368|1060.2463|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424005|758883003881685479|252.32313082458899|63.116462660150503|-0.137303280867133|-0.43082846010458797|0.89192748978099701|26.015152|22.410933|20.994558|19.486685|18.595396|0.55443901|0.13209006|5.2729424E-2|3.3203691E-2|3.7780866E-2|0.14607058|0.10747735|7.7951543E-2|5.9108295E-2|4.1908517E-2|6|1|9843|268435712|142606593|276824320|268435456|268468224|402685952|807.20197|846.44373|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424014|758883003881685428|252.443944637584|63.135944450992703|-0.13630304472538299|-0.43082784613474101|0.89208118856609098|23.350477|22.294382|20.691975|19.752598|19.178534|0.62845296|0.11825589|4.3571375E-2|3.6635954E-2|5.5583935E-2|0.14695139|0.10812544|7.8421585E-2|5.9464715E-2|4.2161226E-2|6|1|9843|268435456|134250497|276856832|268468224|268468224|268468224|852.64056|1370.9648|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424021|587725489986273913|252.292750063097|63.1004865658727|-0.13760734385506501|-0.43099249680287999|0.89180137172846596|24.601795|22.219166|20.878746|20.276236|20.296535|1.0836587|0.11205943|4.8866179E-2|4.8083693E-2|0.13962308|0.14553733|0.10708499|7.7666968E-2|5.8892511E-2|4.1755524E-2|3|1|9843|268435712|134219009|268435456|268435456|268435456|268435456|887.53754|672.37811|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424053|758883003881685406|252.400215195692|63.109358784085003|-0.13675696707113799|-0.43111820156659703|0.89187141911571899|23.327185|21.183641|19.651453|18.772785|18.207624|0.62248117|4.6540398E-2|2.8789425E-2|2.8423952E-2|3.0695794E-2|0.14856337|0.10931152|7.9281837E-2|6.0117014E-2|4.2623714E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|411074560|997.78986|1107.3365|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424060|758883003881685416|252.43105858970401|63.105080803275499|-0.13654496870064201|-0.43125524198871501|0.89183764653651798|22.717209|21.888565|20.347239|19.314722|18.657343|1.0240399|8.3284058E-2|3.6393993E-2|3.1537082E-2|3.8799193E-2|0.15027638|0.11057193|8.0195986E-2|6.0810186E-2|0.04311518|6|1|9843|70369012744464|71468532760849|268468240|268435472|268435472|268435472|1085.946|1206.3967|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424092|758883003881685245|252.31236661069201|63.052956236276401|-0.137684500698531|-0.43174426697715101|0.89142574912314398|23.152306|20.296267|18.975512|18.393803|17.991697|0.64237666|2.4817251E-2|2.5947548E-2|2.7346645E-2|2.8025283E-2|0.15862407|0.11671408|8.4650785E-2|0.06418813|4.5510184E-2|6|1|9843|70369012744464|70369147012369|268468240|268468240|268468240|402685968|1314.0663|565.19629|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424096|758883003881685399|252.381484314217|63.064939323634498|-0.137107140683252|-0.43173234505838898|0.89152050688924001|24.977791|21.307442|20.234295|19.72261|19.457653|1.0542954|5.1199764E-2|3.4664128E-2|3.6167476E-2|6.8081796E-2|0.1565143|0.11516173|8.3524898E-2|6.3334398E-2|4.4904877E-2|6|1|9843|70369012613464|70369155219737|268468248|268435480|268468248|268435480|1333.3777|869.30237|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424102|758883003881685374|252.301100512163|63.0455486667393|-0.137804428468776|-0.43182697628609601|0.89136715333581895|23.971193|21.040821|19.548466|18.480801|17.836733|0.93111175|0.04164635|2.8160984E-2|2.7548673E-2|2.6569812E-2|0.16115002|0.11857265|8.5998781E-2|6.5210268E-2|4.6234895E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|1356.0374|494.91205|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424103|758883003881685395|252.36473251833101|63.057795103405198|-0.13726703887820199|-0.43179817631237799|0.89146401776567197|25.387203|21.557867|19.959389|19.200741|18.720282|0.88023216|6.2806658E-2|3.1301863E-2|3.0650666E-2|0.04021322|0.15911867|0.117078|8.4914729E-2|6.4388268E-2|4.5652084E-2|6|1|9847|268435712|142606593|268435456|268435456|268468224|268468224|1363.9291|779.55078|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424107|758883003881685029|252.274452939014|63.037875147117198|-0.13804159574043101|-0.43187654629614097|0.89130643810350196|22.995144|20.51919|19.117504|18.512798|18.117659|0.47777906|3.4411423E-2|2.6896065E-2|3.1224877E-2|2.9779173E-2|0.16308878|0.11999918|8.7033413E-2|6.5994799E-2|4.6791136E-2|6|1|9843|87961198788880|70369155252497|158329942999056|268468240|268468240|268468240|1373.6667|366.0495|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424108|758883003881685028|252.274494516901|63.039127648782198|-0.13803535020187599|-0.43185808715149498|0.89131634937125304|23.362053|22.018789|20.579081|19.123751|18.269598|0.63518584|8.8294357E-2|0.0533728|5.2585069E-2|3.2498084E-2|0.16261621|0.11965147|8.6781226E-2|6.5803573E-2|4.6655554E-2|6|1|9843|70369012744976|70369155252497|268599312|268468240|268468240|402686480|1363.3529|370.89221|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614424109|758883003881685427|252.47203740410799|63.0773860878544|-0.13636630710931799|-0.431763807388865|0.89161888994930905|23.434504|20.775053|19.490473|18.805782|18.439508|0.68880099|3.3710606E-2|2.7826276E-2|2.8554993E-2|3.8316581E-2|0.15804541|0.1162883|8.4341981E-2|6.3953966E-2|4.5344163E-2|6|1|9847|17592454611200|134251777|268468224|268468224|268468224|158329942999040|1385.085|1255.2261|0|0|0|0|0|5738614423552|51638.388136299996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489092|758883003881750816|252.60649830659801|63.100042118667403|-0.135247271456924|-0.43174616217134298|0.89179786219399104|21.660748|20.140627|19.143677|18.748919|18.571497|0.1432149|2.1319797E-2|1.6160943E-2|1.7834902E-2|3.2905046E-2|0.18063092|0.13290651|9.6394889E-2|7.3093325E-2|5.1824082E-2|6|3|3|52776827224084|134905908|268992564|158329943490612|268959796|268468276|65.075844|1843.8156|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489093|758883003881750936|252.61459667144999|63.106970703624597|-0.135154021793887|-0.43166235548016202|0.89185256699426296|-9999.0|-9999.0|-9999.0|-9999.0|-9999.0|-9999.0|-9999.0|-9999.0|-9999.0|-9999.0|0.17910986|0.13178733|9.5583171E-2|7.2477825E-2|5.1387679E-2|3|3|3|105553385226516|70369046692277|302514612|302514612|302514612|301990324|21.40457|1900.2959|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489113|758883003881685161|252.47637878277101|63.068786535191101|-0.13637388398133499|-0.43190174711505402|0.89155092092757604|17.224285|16.17474|15.770709|15.614953|15.564922|5.5631794E-2|9.1817211E-3|0.01008612|1.3618337E-2|1.3161944E-2|0.16371571|0.12046047|8.7367974E-2|6.6248491E-2|4.6971008E-2|6|1|9847|34628305408|419463680|268468224|268468224|268599296|268468224|102.54033|1238.9246|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489118|758883003881685092|252.383527525044|63.033077932699896|-0.137241762914177|-0.43220968016441902|0.89126847295547196|18.324276|17.241739|16.857708|16.680952|16.610912|5.6560732E-2|9.5350435E-3|1.0349581E-2|1.3961201E-2|1.4551191E-2|0.17223774|0.12673089|9.1915816E-2|6.9696978E-2|4.9416024E-2|6|1|9843|269094928|302157840|302546960|302546960|302546960|302546960|239.217|756.26825|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489130|758883003881750541|252.59124266289999|63.024857520503801|-0.13571222562551399|-0.43282639464710498|0.89120340209884596|17.353285|16.230742|15.861709|15.734953|15.725922|5.5837091E-2|9.1901803E-3|1.0104715E-2|1.3630886E-2|1.3271457E-2|0.23111224|0.17005019|0.12333458|0.09352088|0.06630747|6|1|9843|17592454610960|158329942999056|268599312|268468240|268468240|268468240|661.87976|1504.2444|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489133|758883003881750570|252.62318785012499|63.018840469920299|-0.13549883362888199|-0.43299131155912002|0.89115576090800497|17.565285|15.93074|15.324709|15.105953|15.039924|0.05583699|9.1395359E-3|1.0039781E-2|1.3580766E-2|1.2898007E-2|0.24935588|0.18347368|0.13307042|0.10090327|7.1541674E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|766.08716|1601.5504|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489137|758883003881685164|252.539419916931|62.9820134376384|-0.13630357140841801|-0.43333905735452199|0.89086396143990698|17.935282|16.34074|15.796709|15.585953|15.510922|5.6146123E-2|9.2156082E-3|1.0095413E-2|1.3618339E-2|1.3125638E-2|0.25578615|0.188205|0.13650197|0.10350531|7.3386557E-2|6|1|9843|268435472|268468272|268468240|268468240|268468240|268468240|928.45215|1148.5908|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489158|758883003881685248|252.33171424797899|63.023288092476001|-0.13767877708892701|-0.43223049086058501|0.89119097678876602|21.0907|18.860729|17.680706|17.116951|16.734909|0.10934251|1.2003302E-2|1.0827241E-2|0.01406439|1.4889936E-2|0.17189865|0.1264814|9.1734856E-2|6.9559768E-2|4.9318742E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468224|231.28439|524.97021|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489167|758883003881750832|252.658448813761|63.060708517266598|-0.13503819937905601|-0.43245290403557901|0.89148705571065701|21.147526|18.602734|17.442707|17.032951|16.823908|0.10960796|1.1233325E-2|1.0649273E-2|1.4012685E-2|1.4889744E-2|0.22749703|0.16739015|0.1214053|9.2057966E-2|6.5270245E-2|6|1|9843|268566544|268599312|268468240|268468240|268468240|268599312|479.08533|1890.7997|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489169|758883003881685328|252.50248262863201|63.025043908530002|-0.13638170594065899|-0.43261287109569502|0.89120487770604995|21.705357|18.994726|17.741707|17.237951|16.946903|0.16986457|0.01244215|1.0897255E-2|1.4103279E-2|1.5491021E-2|0.2022915|0.14884417|0.1079542|8.1858404E-2|0.05803863|6|1|9843|268566528|402685952|268468224|268468224|268599296|268468224|509.10443|1171.879|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489171|758883003881685131|252.43215552442899|63.009046574008799|-0.13698770941212099|-0.43268235261173699|0.89107819477776096|19.558191|17.34474|16.503708|16.201952|16.039921|6.2177986E-2|9.5967092E-3|1.0217003E-2|1.3719037E-2|1.3580459E-2|0.19920117|0.14657032|0.10630503|8.0607884E-2|5.7151992E-2|6|1|9843|268435968|268468224|268468224|268468224|285245952|402685952|521.27551|847.73029|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489185|758883003881750679|252.688736875204|63.0344767921627|-0.134931010374329|-0.432913844291057|0.89127954417259103|20.562687|18.076738|16.936708|16.518953|16.263918|8.3714686E-2|1.0727977E-2|0.12721077|9.2240967E-2|1.4012319E-2|0.25860423|0.19027853|0.13800587|0.10464567|7.4195087E-2|6|1|9843|268566544|402685968|268599312|268468240|268468240|402685968|747.75439|1906.2933|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489197|758883003881750597|252.68218927484801|62.999118624962399|-0.135144182286772|-0.43342342923688598|0.89099954039414497|18.756266|17.20574|16.626709|16.398952|16.308918|5.7557758E-2|9.5790578E-3|1.0503242E-2|1.4365587E-2|1.4863118E-2|0.27482915|0.20221667|0.1466644|0.11121117|7.8850105E-2|6|1|9843|268566544|268599312|268468240|268468240|268468240|268468240|1029.7852|1749.3628|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489198|758883003881750821|252.676282611153|62.997589842547796|-0.13519594261521101|-0.43343219013142797|0.89098742620659799|22.754757|20.275595|19.099678|18.54493|18.233694|0.4040297|2.3267703E-2|1.4523263E-2|1.6799072E-2|2.6365779E-2|0.27459931|0.20204756|0.14654174|0.11111817|7.8784168E-2|6|1|9843|70369012613904|70369155252497|268468240|268468240|268468240|402686480|1032.467|1721.535|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489209|758883003881750785|252.61238953572601|62.973246569247898|-0.135792310736366|-0.43364237456042398|0.890794442803992|21.406446|18.971727|17.532707|16.291952|15.644922|0.13607487|1.2419284E-2|1.0747793E-2|1.3731676E-2|1.3222677E-2|0.27551961|0.2027247|0.14703286|0.11149057|7.9048201E-2|6|1|9843|34628174080|411074816|268468224|268468224|268468224|268468224|1125.4733|1389.9364|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489215|758883003881685133|252.479924182666|62.9353046244048|-0.13697206110934201|-0.433889705259421|0.89049333413863996|18.296278|16.87674|16.348709|16.170952|16.088921|5.6665074E-2|9.3869269E-3|1.0198204E-2|0.01371904|1.3668273E-2|0.27632269|0.20331562|0.14746144|0.11181555|7.9278618E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|1213.5309|748.96906|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489225|758883003881685320|252.537320770234|62.937787095291696|-0.13652576116199699|-0.43398989568486002|0.89051304705915502|21.69842|18.884729|17.548706|16.926952|16.545914|0.17004114|1.2580592E-2|1.0877253E-2|1.4051474E-2|1.4484427E-2|0.28451028|0.20933996|0.15183079|0.1151287|8.1627682E-2|6|1|9843|268566544|163856|268468240|268599312|268599312|268468240|1291.1185|974.40448|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489234|758883003881685285|252.42233571950399|63.058433432607998|-0.13682985520041999|-0.43192649356415502|0.89146906557838901|23.444828|20.313583|18.965685|17.691948|16.975901|0.68776941|0.02374343|1.3679611E-2|1.4618906E-2|1.5634289E-2|0.16254424|0.11959851|8.6742811E-2|6.5774448E-2|4.6634905E-2|6|1|9847|268435712|142639361|268435456|268435456|268468224|268468224|95.713501|997.69092|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489237|758883003881685322|252.46977662576799|63.056206625824203|-0.136482609086928|-0.43207267825831602|0.89145145584014296|22.834213|19.713688|18.450699|17.928946|17.671843|0.42906108|1.6628202E-2|1.2014371E-2|1.4986843E-2|1.9624334E-2|0.17055298|0.12549126|9.1016732E-2|6.9015235E-2|0.04893266|6|1|9843|268436224|142606593|268468224|268435456|268468224|402686464|195.25035|1166.8169|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489241|758883003881750804|252.59731921715601|63.051105920416099|-0.135544196543708|-0.43245114931491102|0.89141111404308504|21.896273|19.359715|18.033705|17.429951|17.089897|0.15833986|1.4153887E-2|1.1264516E-2|1.4325783E-2|1.6042393E-2|0.2050968|0.15090828|0.10945126|8.2993582E-2|5.8843482E-2|6|1|9843|268566544|134381584|268468240|268468240|268468240|268468240|454.77286|1625.6044|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489242|758883003881750805|252.59877325327699|63.049501410033997|-0.135540687309084|-0.43247840941393501|0.89139842240973999|23.147818|20.52351|19.040682|17.739948|17.107895|0.37610903|2.7610824E-2|1.4205906E-2|2.0783419E-2|1.6116383E-2|0.2073397|0.15255858|0.11064821|8.3901189E-2|5.9486989E-2|6|1|9843|70369012744464|70369180517649|302022672|301989904|302022672|302022672|470.58087|1625.1644|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489243|758883003881685323|252.48985523449201|63.0252043292313|-0.13647629524673799|-0.43258042384149398|0.89120614772612405|22.131451|20.097635|18.732693|18.100943|17.676842|0.23867179|2.0624841E-2|1.2814111E-2|1.8936902E-2|0.01964237|0.19901903|0.14643632|0.10620783|8.0534182E-2|5.7099737E-2|6|1|9843|17592454611200|134251777|268468224|268468224|158329942999040|268468224|485.98221|1125.24|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489244|758883003881685310|252.48435378392099|63.013799471009897|-0.13657121800680799|-0.43273648066327602|0.89111584023363599|22.545904|19.905666|18.515699|17.730947|17.295883|0.24066502|1.8451082E-2|1.2181439E-2|1.4672841E-2|1.7047046E-2|0.20848316|0.15339993|0.11125842|8.4363893E-2|5.9815053E-2|6|1|9843|34628305152|142770433|268468224|268468224|268468224|268468224|571.16534|1061.4044|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489247|758883003881685346|252.52571344772201|63.016809477477601|-0.13624474880062701|-0.43279029897774601|0.89113967790409099|22.103989|19.418711|17.993706|17.184952|16.758909|0.23389864|1.4510138E-2|1.1202456E-2|1.4090306E-2|1.4903611E-2|0.21668017|0.1594312|0.11563281|8.7680854E-2|6.2166821E-2|6|1|9843|34628305152|142639361|268468224|268468224|268599296|268468224|616.82306|1227.9087|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489255|758883003881750836|252.724495993478|62.966397815270497|-0.13497519498086599|-0.43400891217116599|0.890740119729587|22.587042|19.566702|18.477699|18.043943|17.799822|0.34805515|1.5662475E-2|1.2237719E-2|0.01522324|2.1026693E-2|0.26864615|0.1976673|0.14336482|0.10870919|7.7076174E-2|6|1|9847|268435712|142606593|268468224|268435456|268468224|402685952|1372.7815|1786.2086|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489259|758883003881750792|252.561883963892|63.085821593847101|-0.135649742916991|-0.43185187262414099|0.89168554286675294|25.798597|20.798359|19.503647|18.339937|17.681841|0.85925269|3.3554465E-2|1.7030157E-2|1.6028622E-2|1.9714832E-2|0.17431948|0.12826261|0.09302675|7.0539363E-2|5.0013289E-2|6|1|9843|34628305152|1099654398209|268468224|268468224|268468224|268468224|106.98263|1623.1592|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489264|758883003881685231|252.297716999816|62.964040416412303|-0.13821536603068199|-0.43302640511873702|0.89072141832502705|22.781952|20.58848|19.188673|18.030943|17.312881|0.31779429|2.9043889E-2|1.4389732E-2|1.5209238E-2|1.7268231E-2|0.20652886|0.15196197|0.1102155|8.3573073E-2|5.9254352E-2|6|1|9843|34628305152|142770433|268468224|268599296|268468224|402685952|662.7038|172.84691|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489265|758883003881685260|252.39477983932099|62.979408539494699|-0.137409326843518|-0.43303219080939498|0.89084330755707397|22.638498|20.539503|19.255669|17.925945|17.19589|0.2744011|2.7840244E-2|1.5277378E-2|1.4822111E-2|1.6582873E-2|0.21566355|0.1586832|0.11509029|8.7269478E-2|0.06187515|6|1|9843|34628305152|134350081|268435456|268435456|268599296|402685952|702.39874|595.37146|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489270|758883003881750907|252.61246658160999|62.962014899245901|-0.135843907879166|-0.43380919163369402|0.89070534855598404|22.781015|20.694426|19.223671|18.159941|17.587854|0.41026285|3.1434577E-2|1.5333931E-2|0.01550613|1.9055052E-2|0.2780492|0.20458595|0.1483828|0.11251418|7.9773955E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|1218.6045|1348.0436|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489332|758883003881685478|252.30134417220199|63.0333206229637|-0.13786042246287|-0.43200878362889999|0.89127039375592199|23.463934|22.20859|20.953802|19.813704|19.219513|0.68979824|0.10912558|4.4718109E-2|3.0385206E-2|0.05435643|0.16594419|0.12210015|8.8557221E-2|6.7150258E-2|4.7610369E-2|6|1|9847|268436224|134219009|268469504|268435456|268468224|402653696|95.942993|449.26135|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489334|758883003881619859|252.22836303661899|63.016528085772698|-0.13849031051656599|-0.432081566294438|0.89113744953378005|22.63945|20.354572|19.086679|18.543928|18.189713|0.35811213|2.4747651E-2|1.4284479E-2|1.6814556E-2|2.6173472E-2|0.16959463|0.12478612|9.0505302E-2|6.8627432E-2|4.8657704E-2|6|1|9847|268436224|142639361|268468224|268468224|268468224|402686464|109.367|112.53853|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489343|758883003881685404|252.42536895076501|63.053546899745001|-0.13682994544245|-0.43200621631429198|0.89143042078225299|23.53109|21.84013|20.526297|19.107885|18.411606|0.73062623|7.8623861E-2|3.2039922E-2|2.0437712E-2|2.9522879E-2|0.16560224|0.12184855|8.8374734E-2|6.7011885E-2|4.7512263E-2|6|1|9843|268435712|142606593|268435456|268435456|268435456|268435456|141.57739|990.19434|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489353|758883003881685305|252.459625538528|63.049196974705403|-0.13659202490620201|-0.43215247830029202|0.89139601425569504|22.417858|20.902277|19.478649|18.762917|18.354637|0.30213422|3.6214542E-2|1.6734837E-2|1.7900677E-2|2.8352199E-2|0.17317377|0.12741962|9.2415333E-2|0.07007575|0.04968458|6|1|9843|268435456|32769|268468224|268468224|268468224|402685952|236.01689|1102.3097|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489355|758883003881685429|252.490791354956|63.054929160851401|-0.13633010570186899|-0.43214166256490499|0.89144135295315796|25.474146|22.021097|20.624216|19.428831|18.673409|0.86640531|9.1353759E-2|3.4548026E-2|2.3942888E-2|3.5122447E-2|0.17457274|0.12844896|9.3161903E-2|7.0641845E-2|5.0085951E-2|6|1|9843|268566784|134382849|411074816|268468224|268468224|402685952|241.65596|1240.714|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489365|758883003881685381|252.33519039206399|63.014311869134197|-0.13769491847842499|-0.43237187260862298|0.89111989833138205|22.816521|20.928255|19.639627|18.999897|18.644434|0.42104584|3.7227627E-2|1.8129963E-2|1.9518476E-2|3.4802515E-2|0.17699398|0.13023049|9.4454013E-2|7.1621619E-2|0.05078062|6|1|9843|268435712|134251777|268468224|268468224|268468224|402685952|311.54617|504.02078|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489374|758883003881685407|252.44548175653401|63.031837918688403|-0.13678014996492299|-0.43237621844597102|0.89125865847010699|23.865973|21.040144|19.605633|18.52693|17.931793|0.90184993|4.0436488E-2|1.7442146E-2|0.01765584|2.2199238E-2|0.18273029|0.13445121|9.7515233E-2|7.3942848E-2|5.2426402E-2|6|1|9843|17592454611200|134251777|268468224|17592454643712|158329942999040|268468224|355.492|983.63599|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489384|758883003881750935|252.63618067935101|63.066055698136097|-0.13518143267820301|-0.43232097920516499|0.89152933277495405|24.518286|20.735399|19.522644|18.983898|18.675406|1.1320245|3.1899568E-2|1.7251082E-2|1.9375265E-2|0.03512229|0.21230969|0.15621544|0.11330047|8.5912317E-2|6.0912907E-2|6|1|9843|268436224|134251777|268468224|268468224|268468224|411075072|396.96283|1827.4962|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489394|758883003881685259|252.37765472469999|63.004929433196402|-0.13741860722270799|-0.43261287653809899|0.89104557989050304|23.421539|20.256599|19.153675|18.565928|18.245689|0.67977434|2.2906445E-2|1.5390839E-2|1.6907679E-2|2.6609467E-2|0.18941207|0.1393676|0.10108101|7.6646671E-2|5.4343443E-2|6|1|9843|17592454615296|134219009|268435456|158329942970368|268468224|268468224|461.91388|627.80536|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489410|758883003881750913|252.59250577623499|63.039461475311803|-0.13563472198120199|-0.432612619562106|0.89131899092788003|23.549456|20.982204|19.520643|18.414934|17.853809|0.74561709|3.8514342E-2|1.7203484E-2|1.6117299E-2|2.1279274E-2|0.21597444|0.15891194|0.1152562|8.7395281E-2|6.1964344E-2|6|1|9843|70369012744536|70369155252505|268468248|268468248|268599320|268468248|543.0376|1563.8804|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489415|758883003881750938|252.66857379651299|63.052746667318999|-0.13499867947071201|-0.43259501324666599|0.89142409158339497|23.854321|20.827337|19.771606|19.354845|19.137711|0.90924525|0.03420838|1.9768544E-2|0.02299279|4.9820185E-2|0.23830922|0.17534566|0.1271753|9.6433178E-2|6.8372324E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|562.21613|1899.0413|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489446|758883003881685439|252.53855380143301|63.000748095136998|-0.136222707269125|-0.43305910089413002|0.89101245174073596|24.088812|21.057125|19.721615|18.951902|18.445585|0.79133481|4.0997561E-2|1.9141842E-2|1.9144822E-2|3.0042714E-2|0.23681661|0.17424741|0.12637876|9.5829189E-2|6.7944087E-2|6|1|9843|268567296|134350081|268435456|268435456|268468736|268435456|771.84424|1215.7924|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489463|758883003881750911|252.598914197195|63.000940477203997|-0.13576551463818601|-0.43319951465738799|0.89101397606077504|24.435585|21.483389|20.13151|18.867908|18.236692|1.0372133|0.05815183|2.4721863E-2|1.8554959E-2|2.6317142E-2|0.25495625|0.18759438|0.13605909|0.10316949|7.3148452E-2|6|1|9843|268566784|134382849|268468224|268468224|268468224|268468224|873.07007|1443.3114|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489477|758883003881750914|252.62483580051199|62.999735612799597|-0.13557510913142201|-0.433278774924717|0.891004429272795|23.590153|20.864309|19.62863|18.903906|18.584486|0.64259309|3.5359785E-2|1.8331621E-2|1.8795608E-2|3.3056162E-2|0.26278153|0.19335215|0.14023511|0.10633603|0.07539358|6|1|9843|268570880|142741761|268435456|268435456|268435456|268435456|927.2655|1536.1989|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489484|758883003881685230|252.31361259652201|62.929969620876101|-0.138256117436728|-0.43356928700747099|0.89045096403741097|22.81279|20.801355|19.367661|18.427933|17.845812|0.43545723|3.4178317E-2|1.5894089E-2|0.0163415|2.1555655E-2|0.22921647|0.16865531|0.12232289|9.2753746E-2|6.5763563E-2|6|1|9843|17592454611712|134251777|268468224|17592454643712|268468224|268468736|971.82898|103.57653|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489489|758883003881685330|252.535512658344|62.974745556608603|-0.13636703571349701|-0.43343755325709699|0.89080633080216398|23.080519|20.556496|19.183674|18.548929|18.174719|0.52528936|2.8227132E-2|1.4957415E-2|1.6830036E-2|2.5483759E-2|0.2613847|0.19232439|0.13948968|0.1057708|7.4992821E-2|6|1|9843|268435712|134219009|268435456|268435456|268468224|268435456|981.97504|1106.5632|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489490|758883003881685422|252.522059882029|62.970613195581002|-0.13648809679541399|-0.433466803594448|0.89077355686772497|23.148695|22.072731|20.680162|19.21487|18.387619|0.55429482|9.6836217E-2|3.7083816E-2|2.0740228E-2|2.9118674E-2|0.25958583|0.19100079|0.1385297|0.10504288|7.4476711E-2|6|1|9843|268570880|134219009|268435456|268435456|268570624|268468224|993.17767|1040.4398|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489500|758883003881750782|252.60131531204399|62.9833832044243|-0.13582899663415601|-0.43346572676132999|0.89087482139559304|23.325422|20.899281|19.871586|19.462822|19.279348|0.63443285|3.6482658E-2|2.1103494E-2|2.4410065E-2|5.6274723E-2|0.2698791|0.19857447|0.14402278|0.10920811|7.7429906E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|402685952|1022.759|1386.4515|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489525|758883003881750905|252.60117639835499|62.975793642082898|-0.135865333219891|-0.43357800218406201|0.89081464247683195|23.984125|21.986322|20.548279|19.194874|18.562504|0.96794337|8.9972518E-2|3.3673152E-2|2.1243181E-2|3.2724183E-2|0.27383611|0.20148601|0.14613445|0.11080933|7.8565203E-2|6|1|9843|268566784|142737665|268435456|268435456|268435456|402685952|1085.2795|1357.4979|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489535|758883003881685437|252.55466003960501|62.960828707789503|-0.13628704331790001|-0.43368950792564698|0.89069593719679396|23.971132|21.79932|20.381393|19.371843|18.768309|0.9608143|7.7003099E-2|3.0212246E-2|2.8576203E-2|3.8080648E-2|0.27465358|0.20208751|0.14657071|0.11114014|7.8799739E-2|6|1|9843|87961198789464|70369146832153|268468248|268435480|158329942966296|402686488|1129.968|1126.1371|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489538|758883003881685403|252.48165110400799|62.944084921881803|-0.136917904686682|-0.43376369373538198|0.89056304963390798|25.359434|21.653889|20.257458|19.170877|18.578491|0.92304105|0.06807138|2.7582811E-2|2.1029225E-2|3.3301163E-2|0.26836735|0.19746216|0.14321603|0.10859638|7.6996185E-2|6|1|9843|268435712|134219009|268435456|268435456|268435456|402685952|1143.771|788.53998|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489539|758883003881685415|252.52073409231599|62.947599537960301|-0.136605582470015|-0.433804881227142|0.89059094979768005|24.70014|21.586107|20.056536|18.566927|17.740831|1.1322881|6.4318985E-2|0.02404963|1.6907675E-2|0.02037899|0.27455023|0.20201145|0.14651555|0.1110983|7.8770086E-2|6|1|9843|268566784|134382849|268468224|268468224|268468224|402685952|1181.5609|948.97748|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614489561|758883003881750912|252.637786925124|62.952327140977602|-0.13569712403044301|-0.43401291715519302|0.89062847376013399|23.923479|21.295784|19.842592|18.744919|18.178717|0.93145388|5.0732329E-2|2.1123374E-2|1.7802091E-2|2.5766991E-2|0.27969262|0.20579517|0.14925982|0.11317921|8.0245465E-2|6|1|9843|268435712|142663937|276856832|276856832|268468224|402685952|1342.077|1407.0928|0|0|0|0|0|5738614489088|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614554713|5738614554713|252.69551417278001|62.9387859479695|-0.13532238026867|-0.43435036613813499|0.89052097832341304|20.235846|19.028048|18.929861|18.821045|18.774384|6.0008928E-2|1.0291647E-2|0.02351239|1.2636715E-2|3.8503498E-2|0.25704935|0.18913446|0.1371761|0.10401648|7.3748976E-2|6|1|26227|268566528|276856832|268468224|268468224|268599296|402685952|191.48839|1573.7113|0|1048580|0|4|0|5738614554624|51638.388965500002|3|0|87899|0|0.0|0|0.0|5.254662216028251|1|0
5738614685986|5738614685986|253.00626830241299|62.535830111303703|-0.13479177372662199|-0.44105660007897701|0.88729941579063598|19.314884|19.187681|19.23719|19.038286|18.994232|3.4677766E-2|1.2418898E-2|1.4792739E-2|2.1342542E-2|6.2995233E-2|0.14166646|0.10423683|0.07560125|5.7326138E-2|4.0644947E-2|6|1|26227|17592454610944|268599296|268468224|268435456|268468224|158329942999040|1342.3711|1253.8927|0|1055748|0|4|0|5738614685696|51638.3897947|3|0|87899|0|0.0|20045|6.8300001323223114E-2|-27.11416888101401|1|0
5738614751748|758882831545991996|253.10949472874799|62.4333627280323|-0.134457761535513|-0.44281641073106198|0.88647320137165897|24.347868|22.323648|21.349522|20.201965|19.544674|1.1834921|0.12004782|6.4999275E-2|0.03977789|0.07384602|0.14784591|0.10878361|7.8898951E-2|5.9826683E-2|4.2417865E-2|6|1|9843|17592454615808|142778625|268468224|17592454648320|268468224|268468224|1008.7474|1270.762|0|0|0|0|0|5738614751232|51638.3902094|3|0|0|0|0.0|0|0.0|0.0|0|0
5738614948062|5738614948062|253.41244128775901|61.9891813573268|-0.13407246068703399|-0.45009408253511801|0.88285893105988|20.060223|19.619928|18.994892|18.547842|18.338205|4.4737864E-2|1.4323429E-2|1.2695962E-2|1.1903246E-2|0.02788646|0.1868519|0.13748385|9.9714756E-2|7.5610682E-2|5.3608917E-2|3|1|26227|268435472|268468240|268468240|268468240|276856848|402685968|1139.5737|815.1825|0|4|0|4|0|5738614947840|51638.391453199998|3|0|88002|0|0.0|0|0.0|-21.951413581926609|1|0
5738614948069|5738614948069|253.64712270984899|62.016084281712303|-0.132111042485302|-0.45024163992786298|0.88307934984831105|20.34306|19.722919|19.202881|18.870821|18.812817|5.2593548E-2|1.5136876E-2|1.3881857E-2|1.4888241E-2|3.8428549E-2|0.15805294|0.11629386|8.4346004E-2|6.3957021E-2|4.5346323E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1314.8156|1830.6133|0|5124|0|4|0|5738614947840|51638.391453199998|3|0|88002|0|0.0|20056|1.4999999664723873E-2|-20.960584405957412|1|0
5738615013395|99020111712616448|253.289390103665|61.916682152796|-0.13535990222074201|-0.45087469224591797|0.88226396773467997|23.721327|21.657423|20.837357|19.024937|19.483267|0.81275547|0.13596104|0.15831867|0.07469219|9.8405056E-2|0.21567762|0.15869355|0.1150978|8.7275177E-2|6.1879188E-2|3|1|26227|105553385357660|70369147454749|70369147454781|70369013368121|70369147454781|403277084|170.58|63.0|0|64|0|0|0|5738615013376|51638.391867899998|3|0|88002|0|0.0|0|0.0|-25.941594753153161|0|0
5738615079031|587725489986928661|253.58999283726001|61.809451806519803|-0.13345877187722299|-0.45316177428940602|0.88138139447795305|18.510191|17.422602|17.396255|17.41012|17.451588|2.3040963E-2|2.7047275E-2|7.8653479E-3|1.8954834E-2|2.0646302E-2|0.20671779|0.15210098|0.11031632|8.3649524E-2|5.9308555E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|219.37619|857.67719|0|1056768|0|0|0|5738615078912|51638.392282499997|3|0|88002|0|0.0|0|0.0|0.0|0|0
5738615079060|5738615079060|253.842731298475|61.793141872180001|-0.13152834242311501|-0.453987033454747|0.88124688288491904|19.35314|19.101585|19.078228|18.916077|19.020662|3.0174319E-2|2.8294804E-2|1.2579259E-2|2.2764852E-2|4.8754781E-2|0.17149022|0.12618087|9.1516897E-2|6.9394492E-2|4.9201559E-2|6|1|26227|268435968|268468224|268468224|268468224|268468224|268468736|785.86768|1794.7939|0|1048580|0|4|0|5738615078912|51638.392282499997|3|0|88002|0|0.0|0|0.0|-27.181344958983381|1|0
5738615144468|5738615144468|253.67402263582699|61.671860577205599|-0.13338861043348299|-0.45538693043980499|0.88024441048565405|17.969069|18.041914|17.807425|17.695248|17.72963|1.6222239E-2|8.1454534E-3|8.4277606E-3|2.0498285E-2|0.02255266|0.20398328|0.15008895|0.10885703|8.2542986E-2|5.8524009E-2|6|1|26227|34628304896|268468224|268468224|268468224|268599296|268468224|150.47209|691.02832|0|1048580|0|4|0|5738615144448|51638.392697199997|3|0|88002|0|0.0|0|0.0|-27.696595404407262|1|0
5738615210566|99019746791391232|253.96168634539001|61.539958824278202|-0.13166010118171101|-0.45799723311976598|0.87914967565907698|23.299955|22.78915|21.837971|21.32037|20.851879|0.91460645|0.17252196|9.9337205E-2|0.10472195|0.22548679|0.30847508|0.22697304|0.16461979|0.12482619|8.8503331E-2|3|1|26227|268566784|1099646010625|134251777|268469504|411074816|142639361|383.33069|1358.7574|0|64|0|0|0|5738615209984|51638.393111799996|3|0|88002|0|0.0|0|0.0|-23.709109608999796|0|0
5738615275628|5738615275628|253.932137334266|61.353470962661|-0.13268757362564401|-0.46067653625523902|0.87759394753451603|24.687143|18.444536|17.093765|16.990507|16.692863|1.0252048|0.10917425|5.5734444E-2|6.6088088E-2|4.8990503E-2|0.16056637|0.11814321|0.08568731|6.4974092E-2|4.6067443E-2|6|1|26227|87961198788880|87961341428017|70369012645905|70369012645905|268468240|70369146863633|530.35681|573.0108|0|4|0|4|0|5738615275520|51638.393526499996|3|0|88002|0|0.0|0|0.0|3.4631678465214151|1|0
5738615537751|5738615537751|254.405425747116|60.827595105953201|-0.13103759782962901|-0.46949558379765|0.87315694164883395|18.515226|18.661774|18.619427|18.691984|18.167984|1.9199723E-2|1.0254258E-2|1.0609295E-2|1.4725343E-2|0.02567251|0.1001385|0.07368096|5.3439576E-2|4.0521614E-2|2.8730329E-2|6|1|26227|34628304896|268468224|268599328|268468224|268468224|268468224|300.27591|620.62695|0|4|0|4|0|5738615537664|51638.395185100002|3|0|88002|0|0.0|0|0.0|-22.817443483144075|1|0
5738615603309|5738615603309|254.48140946996|60.667385597585003|-0.13106757064666799|-0.47201960799668202|0.87179056062304305|18.982059|18.497084|18.526596|18.467121|18.22304|0.049991|1.0207266E-2|1.7543145E-2|1.8268092E-2|0.03697383|0.11586872|8.5255101E-2|6.1834112E-2|4.6886936E-2|3.3243421E-2|6|1|26227|268566528|268468224|268599296|268468224|268468224|268468224|413.4975|369.19986|0|4|0|4|0|5738615603200|51638.395599800002|3|0|88002|0|0.0|0|0.0|-28.736699315012586|1|0
5738615865403|5738615865403|255.04665796279301|60.061556788881497|-0.128776030434998|-0.48216893439679098|0.86656208818991598|19.607376|19.268288|18.671255|18.067633|17.686487|3.9193057E-2|1.6161764E-2|1.2058401E-2|1.8184835E-2|0.01978758|9.3522787E-2|6.8813175E-2|4.9909055E-2|3.7844528E-2|2.6832242E-2|6|1|26227|268567056|268468240|268599312|268468240|268468752|268468240|1031.0469|613.15784|0|4|0|4|0|5738615865344|51638.397258500001|3|0|88065|0|0.0|0|0.0|-28.738368855010918|1|0
5738615930974|587725489987780764|255.09636206870101|59.870132407986397|-0.129101603768429|-0.48507554660957503|0.86488987159397501|17.567316|16.336615|15.917434|15.735767|15.669645|1.4233662E-2|1.2886178E-2|1.2969527E-2|1.0688677E-2|0.01508412|8.8385649E-2|6.5033317E-2|4.7167588E-2|3.5765752E-2|2.5358364E-2|6|1|9843|268566544|268599312|268468240|268599312|268468240|268468240|1367.3927|166.125|0|0|0|0|0|5738615930880|51638.3976731|3|0|0|0|0.0|0|0.0|0.0|0|0
5738615931021|587725489987780896|255.28795721715301|59.916558634516903|-0.12730078782687901|-0.48482655029955601|0.86529632239094101|21.432341|19.585573|18.64842|18.231754|17.901524|0.1209053|1.6782738E-2|9.3945591E-3|1.1483912E-2|2.3788018E-2|8.7485015E-2|0.06437064|4.6686959E-2|3.5401307E-2|2.5099969E-2|3|1|26227|268566544|402685968|268468240|268468240|268599312|268468240|1303.6058|1133.8627|0|64|0|0|0|5738615930880|51638.3976731|3|0|88065|0|0.0|0|0.0|0.0|0|0
5738615931169|5738615931169|255.09226671886401|59.892697335305499|-0.129048635937801|-0.484737123230778|0.86508749321935197|20.117056|19.327589|19.242395|18.976715|19.048616|4.2251445E-2|1.4985857E-2|1.2847938E-2|1.6339378E-2|5.1284026E-2|9.0736486E-2|6.6763043E-2|4.8422128E-2|3.6717035E-2|2.6032835E-2|3|1|26227|268570624|268599296|268603392|268468224|268468224|402685952|1170.2264|226.00117|0|4|0|4|0|5738615930880|51638.3976731|3|0|88065|0|0.0|0|0.0|-18.417964420119674|1|0
5738616127580|5738616127580|255.519988411188|59.609852994710899|-0.12649272541307699|-0.489815946365598|0.86260067766235005|18.709805|18.685511|18.831905|18.93709|19.104731|2.1482648E-2|1.5592355E-2|1.3076232E-2|1.4535519E-2|5.2273847E-2|0.12609228|9.2777506E-2|6.7289986E-2|5.1023956E-2|3.6176622E-2|6|1|26227|268567040|268468736|268468224|268468224|268599296|268468224|204.70682|1079.6626|0|1048580|0|4|0|5738616127488|51638.3989172|3|0|88065|0|0.0|0|0.0|5.4237009886112588|1|0
5738616127778|5738616127778|255.61354720058|59.562852504183802|-0.125868501599706|-0.49070709316663602|0.86218540292734902|19.601723|19.056503|18.749908|18.247126|18.262632|3.1856205E-2|0.01650824|0.0127552|1.0876423E-2|2.8329542E-2|0.13342106|9.8169945E-2|7.1201034E-2|5.3989589E-2|3.8279291E-2|3|1|26227|268570624|268599296|268468224|268468224|268603392|268468224|760.83038|1320.9772|0|68|0|4|0|5738616127488|51638.3989172|3|0|88065|0|0.0|0|0.0|-21.041329559239074|1|0
5738616193259|5738616193259|255.56679018838801|59.448806439683601|-0.126696413111127|-0.49226523823695401|0.86117533297714099|19.390585|19.37179|19.073059|19.034203|18.984034|3.0118419E-2|1.6721789E-2|1.2349639E-2|1.7491708E-2|4.5884043E-2|0.14835688|0.10915958|7.9171635E-2|6.0033452E-2|4.2564467E-2|6|1|26227|268435456|268468224|268468224|268435456|268435456|268468224|284.08896|736.95959|0|1048580|0|4|0|5738616193024|51638.399331799999|3|0|88065|0|0.0|0|0.0|-26.144945205984861|1|0
5738616193351|5738616193351|255.76767654557401|59.491493634720698|-0.12481191723667601|-0.49208437842313502|0.86155379972908397|23.634586|22.68049|20.715504|18.714228|17.613876|0.75180668|0.16406946|3.5673052E-2|1.4549974E-2|1.7250091E-2|0.14891303|0.1095688|7.9468429E-2|6.0258504E-2|4.2724028E-2|6|1|26227|70369012613392|70369155219729|8388880|268435472|268435472|268468240|264.60007|1741.9684|0|4|0|4|0|5738616193024|51638.399331799999|3|0|88065|0|0.0|0|0.0|-2.8945627490017607|1|0
5738616258782|587725489988108483|255.53810460810499|59.303384196934601|-0.127488303960588|-0.49431664614480902|0.85988242550793004|20.398039|19.808054|19.456192|19.049322|19.080931|5.3222459E-2|1.6566494E-2|0.01413856|2.2869077E-2|5.0853666E-2|0.10963572|8.0668919E-2|0.05850783|4.4364717E-2|3.1455137E-2|3|1|26227|34628304912|268599312|268468240|268599312|268468240|268468240|102.10445|123.85313|0|33554496|0|0|0|5738616258560|51638.399746499999|3|0|88065|0|0.0|0|0.0|0.0|0|0
5738616258811|5738616258811|255.58360760854501|59.260733433188598|-0.127255015662047|-0.49503753948939599|0.85950217887166402|20.111221|19.794056|19.338203|18.774347|18.454679|5.2658707E-2|1.6612435E-2|1.2624479E-2|2.1070549E-2|3.1779375E-2|0.10695525|7.8696653E-2|5.7077374E-2|4.3280046E-2|3.0686092E-2|6|1|26227|17592454610960|158329942999056|268468240|268599312|268468240|268468240|540.79749|176.22475|0|4|0|4|0|5738616258560|51638.399746499999|3|0|88065|0|0.0|0|0.0|-27.651208995879244|1|0
5738616324243|5738616324243|255.809234165513|59.179905499437403|-0.12560173643341099|-0.49670983870742902|0.85878026289392095|19.472225|18.276409|18.376404|15.943505|14.599098|2.8366905E-2|1.1948581E-2|1.0570612E-2|6.5301484E-3|0.0215836|0.10719828|7.8875475E-2|5.7207074E-2|0.04337839|0.03075582|6|1|26227|34628174336|268468224|268468224|268468224|285245952|419463680|249.16907|880.64728|0|1056769|1|0|0|5738616324096|51638.400161099999|3|0|88065|0|0.0|0|0.0|2.4377619627323526|1|0
5738616389783|5738616389783|256.16245099739399|58.963528062289797|-0.123312049746434|-0.50062020747245894|0.85683927679440897|18.953096|18.641703|18.430563|18.455606|18.374874|2.8137198E-2|0.02566353|1.0678197E-2|1.7017342E-2|2.9688222E-2|0.12844515|9.4508715E-2|6.8545602E-2|5.1976055E-2|3.6851671E-2|6|1|26227|268566544|268468240|268468240|268468240|268599312|268468240|1320.5088|1699.9377|0|7172|0|4|0|5738616389632|51638.400575699998|3|0|88065|0|0.0|20104|2.2199999541044235E-2|-26.014444654995891|1|0
5738616389852|5738616389852|256.02251069010799|59.020429935721602|-0.124328805038966|-0.49949153571577198|0.85735089315045498|19.237076|19.190689|19.190536|18.901581|18.866436|2.9624706E-2|2.6552349E-2|1.3894717E-2|1.9645333E-2|4.1822333E-2|0.1213244|0.08926934|6.4745568E-2|4.9094606E-2|3.4808688E-2|6|1|26227|268566528|268599296|268468224|268468224|268468224|402685952|601.25323|1277.3617|0|1048580|0|4|0|5738616389632|51638.400575699998|3|0|88065|0|0.0|0|0.0|-27.199502722658977|1|0
5738616455234|587725489988305000|256.06183686485201|58.819853983175399|-0.12470812380235601|-0.50248665356740596|0.855543714163295|21.786224|19.780947|18.870712|18.523726|18.256008|0.16774864|1.6781716E-2|1.0262696E-2|1.4917012E-2|2.6633685E-2|0.11961194|8.8009328E-2|6.3831702E-2|0.04840165|3.4317374E-2|6|1|9843|269090832|276856848|268992528|268992528|268992528|268992528|1006.5731|786.21259|0|0|0|0|0|5738616455168|51638.400990399998|3|0|0|0|0.0|0|0.0|0.0|0|0
5738616455399|5738616455399|255.924781752922|58.860694870690203|-0.125761403661205|-0.50159524966550595|0.85591253925980204|20.416491|19.876934|19.352686|19.007692|18.819571|5.9937254E-2|0.01799806|1.3565027E-2|1.7491885E-2|4.0800132E-2|0.10729763|7.8948572E-2|5.7260092E-2|4.3418594E-2|3.0784324E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|426.54987|321.14621|0|4|0|4|0|5738616455168|51638.400990399998|3|0|88065|0|0.0|0|0.0|-21.996768255245861|1|0
5738616521210|587725489988370683|256.13269731331002|58.664762400025097|-0.12464116965057299|-0.50488699488542399|0.85413915799692897|23.724358|19.821236|19.522827|19.556715|19.405333|1.6963013|1.7540151E-2|1.5878404E-2|3.0448191E-2|7.2180465E-2|0.11210385|8.2484946E-2|5.9824962E-2|0.04536346|3.2163259E-2|6|1|9843|268566784|140737631092993|268468224|268435456|268599296|268435456|1081.2769|586.26422|0|0|0|0|0|5738616520704|51638.401404999997|3|0|0|0|0.0|0|0.0|0.0|0|0
5738616586491|5738616586491|256.16619199824999|58.492912395066597|-0.12495799242589101|-0.50744504779500199|0.85257552369113898|22.759724|21.616863|20.201826|19.003935|18.315128|0.29626828|6.5442927E-2|0.03041449|3.0343479E-2|3.4154031E-2|0.10345788|7.6123327E-2|5.5210985E-2|0.04186482|2.9682679E-2|6|1|26227|87961198788880|70369146995985|268468240|158329942999056|268468240|268468240|1234.8112|168.81352|0|4|0|4|0|5738616586240|51638.401819799998|3|0|88065|0|0.0|0|0.0|5.4997050169315713|1|0
5738616717352|587725489988567124|256.43485503042098|58.306497395047003|-0.12322716086745999|-0.51071922886884702|0.85087069293057405|19.094156|18.841166|18.160364|17.528227|17.430489|5.7080314E-2|0.02468952|2.5663629E-2|1.9921372E-2|2.9489292E-2|0.1262033|9.2859186E-2|6.7349233E-2|5.1068883E-2|3.6208473E-2|3|1|26227|34628309008|268468240|268468240|268468240|268468240|268603408|554.85181|752.47314|0|64|0|0|0|5738616717312|51638.402649000003|3|0|88065|0|0.0|0|0.0|0.0|0|0
5738616717553|5738616717553|256.37280657389101|58.260590073329197|-0.123940753848303|-0.51124787142358596|0.85044947145633998|20.461699|19.794115|19.345324|18.949179|18.852823|7.9083905E-2|2.1540251E-2|1.8537544E-2|1.5333247E-2|4.3836631E-2|0.12981647|9.5517725E-2|6.9277421E-2|0.05253097|3.7245113E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|411074560|838.63892|326.35364|0|4|0|4|0|5738616717312|51638.402649000003|3|0|88065|0|0.0|0|0.0|-19.550424871039873|1|0
5738616717563|5738616717563|256.45898156517899|58.247559500497402|-0.123216961268939|-0.51162172961786201|0.85032981027274102|19.721069|19.560137|19.419315|19.031172|19.058491|6.2345762E-2|2.0159241E-2|1.8951491E-2|1.6219055E-2|5.0764784E-2|0.12330817|9.0728983E-2|6.5804228E-2|4.9897354E-2|3.5377845E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|1096.452|668.46973|0|4|0|4|0|5738616717312|51638.402649000003|3|0|88065|0|0.0|0|0.0|-27.000111093586142|1|0
5738616782919|100146045861756928|256.73159301482599|58.256323384483601|-0.120751443152101|-0.51207559933047098|0.85041029482657604|19.261948|20.587208|21.074396|20.512445|19.721054|7.2924882E-2|2.9124396E-2|5.7376262E-2|6.4113691E-2|0.15361543|0.11116046|8.1790805E-2|5.9321515E-2|4.4981711E-2|3.1892594E-2|0|1|26227|123145571401820|17592488722460|70369046331421|70369046200349|70369046200349|70369046724669|123.64516|1911.579|0|64|0|0|0|5738616782848|51638.403063500002|3|0|88063|0|0.0|0|0.0|-24.380536749403568|0|0
5738616783066|587725489988632641|256.62317398303401|58.160719654519603|-0.122048332277805|-0.51322597178535501|0.84953122748559695|19.393932|19.225445|19.203491|19.11528|18.995678|2.9650426E-2|1.3380868E-2|1.8521186E-2|3.7849322E-2|4.6349581E-2|0.11291787|8.3083898E-2|6.0259372E-2|4.5692857E-2|3.2396805E-2|6|1|26227|268567040|268468736|268468224|268468224|268599296|268468224|752.89612|1121.4|0|34603008|0|0|0|5738616782848|51638.403063500002|3|0|88063|0|0.0|0|0.0|0.0|0|0
5738616783074|5738616783074|256.43524993946897|58.102620022244899|-0.123932983579116|-0.51366006294503996|0.84899585117742304|19.312943|19.307442|19.063499|18.993294|18.858887|2.9083226E-2|1.3882884E-2|1.8000318E-2|3.7711289E-2|4.2249423E-2|0.10238614|0.07533475|5.4639045E-2|4.1431133E-2|0.02937519|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|925.49902|91.000023|0|1048580|0|4|0|5738616782848|51638.403063500002|3|0|88224|0|0.0|0|0.0|-26.5009829695314|1|0
5738616848405|587725489988698153|256.79756553442297|58.063535133554197|-0.120814592021908|-0.51499721412450306|0.84863520065961195|17.987801|16.803755|16.827684|16.939466|16.901667|2.1053027E-2|1.0610203E-2|6.3055228E-3|9.9751726E-3|1.2684447E-2|0.10649153|7.8355454E-2|5.6829911E-2|0.0430924|3.0553048E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|514.3197|1591.4554|0|1056768|0|0|0|5738616848384|51638.403478200002|3|0|88224|0|0.0|0|0.0|0.0|0|0
5738616979873|5738616979873|256.93327890169098|57.795006142272598|-0.12049230452722801|-0.51915059133758401|0.84614671781172501|22.032381|20.920851|20.38768|19.835445|19.46262|0.19898854|3.7885703E-2|3.0632503E-2|2.9692652E-2|6.4773805E-2|0.10543773|7.7580079E-2|5.6267548E-2|4.2665977E-2|0.03025071|6|1|26227|70369012613904|70369146864913|268468240|268468240|268468240|402686480|308.6116|1346.0142|0|1|1|0|0|5738616979456|51638.404307500001|3|0|88224|0|0.0|0|0.0|-26.071334184067894|1|0
5738617241820|5738617241820|257.36458305248601|57.215511668708402|-0.118446967057641|-0.52836690118367702|0.84071322918603097|19.996349|19.430437|19.157585|18.865129|18.773495|4.1946799E-2|1.9110991E-2|1.2281235E-2|1.6613206E-2|4.1069284E-2|0.11139007|8.1959754E-2|5.9444051E-2|4.5074623E-2|3.1958468E-2|3|1|26227|268567056|268599312|268468240|268468240|268468240|402686480|537.08838|1486.7604|0|4|0|4|0|5738617241600|51638.405965899998|3|0|88224|0|0.0|0|0.0|-21.107674330874197|1|0
5738617241851|587725489989091549|257.15490061333497|57.112892423114701|-0.120714366914803|-0.52939711421785396|0.83974206580245003|19.636452|19.138451|19.005594|18.726139|18.793472|3.7222046E-2|1.7951429E-2|1.1936024E-2|1.5706018E-2|4.1600384E-2|9.7625799E-2|7.1832135E-2|5.2098658E-2|3.9504834E-2|0.02800942|3|1|9843|17592454610960|17592454643728|268468240|268468240|268599312|268468240|1055.9659|194.80678|0|0|0|0|0|5738617241600|51638.405965899998|3|0|0|0|0.0|0|0.0|0.0|0|0
5738617307155|5738617307155|257.24593681002398|57.059572749404801|-0.120045535610941|-0.53035020308411296|0.83923639784540005|22.052971|22.261074|20.040604|19.811039|18.824505|0.32765406|0.28495818|0.1488633|6.9680937E-2|4.4779237E-2|0.10112324|7.4405514E-2|5.3965088E-2|4.0920094E-2|2.9012855E-2|6|1|26227|70403373007632|70369155383569|277512464|277381648|276988176|268468752|305.22925|448.84534|0|1|1|0|0|5738617307136|51638.406380400003|3|0|88224|0|0.0|0|0.0|6.3077532652225869|1|0
5738617307256|5738617307256|257.53241809818297|57.118071953724701|-0.117207225920374|-0.53010686999825596|0.83979114818667999|18.946312|18.909739|18.777756|18.793251|18.816515|0.02318853|1.9164992E-2|1.3642335E-2|2.0762211E-2|4.0092319E-2|0.10483409|7.7135935E-2|5.5945411E-2|4.2421713E-2|3.0077523E-2|6|1|26227|268435456|276856832|268468224|268468224|268468224|402685952|292.21265|1959.4073|0|1048580|0|4|0|5738617307136|51638.406380400003|3|0|88224|0|0.0|0|0.0|-26.018082002585068|1|0
5738617307271|5738617307271|257.28556550235498|57.046615685261301|-0.119720457302069|-0.53061822632731803|0.83911340711052496|19.346279|18.676743|18.351765|17.911282|17.906061|2.7367383E-2|0.01872897|0.01262718|1.8184993E-2|2.0208372E-2|0.10485055|7.7148035E-2|5.5954192E-2|4.2428367E-2|3.0082243E-2|3|1|26227|34628304912|268599312|268468240|268468240|268599312|268468240|483.84842|591.23853|0|68|0|4|0|5738617307136|51638.406380400003|3|0|88224|0|0.0|0|0.0|-21.235156095968613|1|0
5738617307344|5738617307344|257.47472745079699|56.977348575514696|-0.11818788749498001|-0.53200049631198099|0.83845518375956196|17.979338|17.498749|17.316771|16.901287|16.869167|1.7624322E-2|1.7738752E-2|1.1453052E-2|1.7318986E-2|1.1294462E-2|0.119731|8.8096932E-2|6.3895248E-2|4.8449829E-2|3.4351531E-2|3|1|26227|19937506758656|268599297|268468224|268603393|268599297|17592454643713|1397.0621|1252.6649|0|68|0|4|0|5738617307136|51638.406380400003|3|0|88224|2157|2.5799999237060547|0|0.0|-20.253703154887397|1|0
5738617307444|5738617307444|257.469339138127|56.993137192567303|-0.118187785291073|-0.53176381494727898|0.83860532583612102|20.158058|19.409721|19.303728|19.01923|18.999247|4.3313712E-2|2.0705566E-2|1.6056353E-2|2.2493236E-2|4.5460582E-2|0.12174147|8.9576222E-2|6.4968146E-2|4.9263377E-2|3.4928348E-2|3|1|26227|34628305408|276987904|268468224|268468224|268468224|268468736|1253.3481|1277.178|0|4|0|4|0|5738617307136|51638.406380400003|3|0|88224|0|0.0|0|0.0|-18.148394605886843|1|0
5738617307569|5738617307569|257.462643745398|57.053794780670998|-0.118057136015751|-0.53088306239254801|0.83918155765034996|22.73035|20.870314|20.348475|19.923983|19.252686|0.3620744|3.8416434E-2|2.8144373E-2|3.4691378E-2|5.7014521E-2|0.11587545|8.5260056E-2|6.1837703E-2|4.6889659E-2|3.3245351E-2|6|1|26227|268566784|134382849|268468224|268468224|268468224|402685952|723.52716|1435.3823|0|1|1|0|0|5738617307136|51638.406380400003|3|0|88224|2153|2.2100000381469727|0|0.0|-27.533379051576503|1|0
5738617372917|5738617372917|257.46262131197602|56.968567847386701|-0.118328184246751|-0.53210093746131104|0.83837165575039596|20.020901|19.22201|19.048897|18.810364|18.867519|4.5740183E-2|1.4167302E-2|1.6401254E-2|1.5193361E-2|4.2170539E-2|0.11830861|8.7050349E-2|6.3136175E-2|0.04787425|3.3943441E-2|3|1|26227|2242241495552|276857344|268468224|268468224|268599296|268468224|90.798615|1169.3523|0|4|0|4|0|5738617372672|51638.406795000003|3|0|88224|0|0.0|0|0.0|0.0|1|0
5738617503865|587725489989353482|257.45830283678202|56.643125546669502|-0.119400439373695|-0.53673176390095301|0.83526196411493603|19.138628|18.151587|17.799227|17.641628|17.56233|2.4572864E-2|1.1421355E-2|8.6798659E-3|1.1505692E-2|2.3207787E-2|9.8938316E-2|7.2797872E-2|5.2799091E-2|4.0035952E-2|2.8385989E-2|6|1|9843|268566528|268599296|268468224|268468224|268468224|268468224|141.67|133.37773|0|0|0|0|0|5738617503744|51638.407624200001|3|0|0|0|0.0|0|0.0|0.0|0|0
5738617503925|5738617503925|257.78721317950402|56.560049914464898|-0.116573417089901|-0.53859145160435995|0.83446383186252804|19.283615|18.912577|18.45122|18.319616|18.328123|0.02584872|1.2909248E-2|1.0188144E-2|1.4141432E-2|0.03155173|0.12848586|9.4538674E-2|6.8567328E-2|5.1992532E-2|3.6863353E-2|6|1|26231|268567056|268599312|268468240|268468240|268468240|268468752|1411.9939|1421.7595|0|4|0|4|0|5738617503744|51638.407624200001|3|0|88224|0|0.0|0|0.0|-26.920864679124151|1|0
5738617504005|5738617504005|257.51231022659698|56.597403657156001|-0.119038546724959|-0.53749467046454102|0.83482291751953297|21.52911|20.508364|20.029064|19.538483|19.140177|0.13182075|2.7636794E-2|0.02225912|2.5583005E-2|5.3286813E-2|0.10484739|7.7145711E-2|5.5952504E-2|4.2427089E-2|3.0081335E-2|6|1|26227|268435456|268435456|268435456|268435456|268468224|268435456|624.75513|244.15123|0|1|1|0|0|5738617503744|51638.407624200001|3|0|88224|0|0.0|0|0.0|6.0336901548710244|1|0
5738617634830|5738617634830|257.95302253247098|56.411970551827899|-0.115464028359545|-0.54103390013041597|0.83303684016054003|17.988203|16.958141|16.88953|16.822861|16.866518|2.3950573E-2|1.1192409E-2|1.0827365E-2|8.7040309E-3|0.01585212|0.10985149|8.0827683E-2|5.8622979E-2|0.04445203|3.1517044E-2|6|1|26227|268566544|302153744|302022672|302022672|302022672|302022672|237.88313|1750.2358|0|4|0|4|0|5738617634816|51638.4084535|3|0|88224|0|0.0|0|0.0|3.3160426023807901|1|0
5738617635053|587725489989484851|257.92607875685098|56.318588171503002|-0.116002283681165|-0.54230649731899605|0.83213408363457597|20.879135|20.676836|19.622454|19.059799|18.838837|7.8195751E-2|0.03080469|0.01926676|1.7539946E-2|4.0460929E-2|9.9456638E-2|7.3179252E-2|5.3075697E-2|4.0245693E-2|2.8534697E-2|3|1|9843|268567056|268468240|268468240|268468240|268468240|402817552|992.05719|1336.9443|0|0|0|0|0|5738617634816|51638.4084535|3|0|0|0|0.0|0|0.0|0.0|0|0
5738617635081|587725489989484807|257.91825241515801|56.270561600110199|-0.116222312776734|-0.54297251927948398|0.83166893492550098|19.801062|19.499107|19.406479|19.121792|19.083437|3.9551448E-2|0.01593931|1.6843626E-2|1.7685505E-2|4.9603406E-2|9.6991666E-2|0.07136555|5.1760249E-2|3.9248228E-2|2.7827483E-2|6|1|26231|268435472|268468240|268468240|268468240|268468240|402685968|1389.9586|1152.865|0|33554432|0|0|0|5738617634816|51638.4084535|3|0|0|0|0.0|0|0.0|0.0|0|0
5738617766636|5738617766636|258.10385370190198|56.106940117305797|-0.114951942479702|-0.54566795242016597|0.83007983749861503|24.077728|22.932997|20.539408|20.019722|20.088655|0.96955246|0.19266672|3.3150442E-2|3.7374284E-2|0.1147012|9.6918575E-2|7.1311772E-2|5.1721245E-2|3.9218653E-2|2.7806513E-2|6|1|26227|268435712|142639361|8421633|268468224|268468224|402702336|384.13974|1538.0276|0|33554433|1|0|0|5738617765888|51638.409282699999|3|0|88222|0|0.0|0|0.0|-28.935506071477754|1|0
5738617831453|5738617831453|257.93929123075998|55.912357163507203|-0.117107070920415|-0.54808921166729396|0.82818123016303902|17.921488|18.243959|18.579967|18.263186|17.748648|2.5195166E-2|1.1926604E-2|1.0131808E-2|1.3246287E-2|1.9659663E-2|9.9187076E-2|7.2980903E-2|5.2931841E-2|4.0136613E-2|2.8457358E-2|6|1|26227|34628308992|268468224|268603392|268468224|268468224|268468224|410.7132|157.5883|0|4|0|4|0|5738617831424|51638.409697399999|3|0|88365|0|0.0|0|0.0|4.7606837156620401|1|0
5738617831518|5738617831518|258.18381581564603|55.997172671392001|-0.11451572922520099|-0.54738341677277402|0.82900997750460403|18.75947|18.708956|18.572968|18.534176|18.60129|2.8294006E-2|1.2838319E-2|1.0029675E-2|1.4350901E-2|3.2994229E-2|0.1108972|8.1597105E-2|5.9181027E-2|4.4875182E-2|3.1817064E-2|6|1|26231|268435456|268468224|268468224|268468224|268468224|268468224|99.954575|1587.4059|0|1048580|0|4|0|5738617831424|51638.409697399999|3|0|88365|0|0.0|0|0.0|-27.069440719094906|1|0
5738618028163|5738618028163|258.39339201789102|55.513975265591498|-0.11391533185200101|-0.55462746958490805|0.82426431874180395|18.88872|18.851765|18.65341|18.577507|18.616482|5.2492559E-2|2.5032979E-2|1.3517478E-2|1.7720876E-2|3.7779365E-2|0.12069295|8.8804729E-2|6.4408593E-2|4.8839089E-2|3.4627523E-2|6|1|26227|268435472|268468240|268468240|268435472|268468240|268468240|517.31342|1141.1926|0|4|0|4|0|5738618028032|51638.410941299997|3|0|88365|0|0.0|0|0.0|-26.844700411279156|1|0
5738618028164|5738618028164|258.39599079248399|55.513295047021202|-0.113892143753651|-0.55464222155458598|0.82425759666513998|19.426674|19.082758|18.858404|18.632505|18.355659|5.5418406E-2|2.5568575E-2|1.4219527E-2|1.7901171E-2|3.2644745E-2|0.12083185|8.8906921E-2|6.4482719E-2|4.8895292E-2|3.4667373E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|527.51923|1151.7488|0|4|0|4|0|5738618028032|51638.410941299997|3|0|88365|0|0.0|0|0.0|0.0|1|0
5738618028249|5738618028249|258.22154742673399|55.471210908409397|-0.115703835635264|-0.55488541971142802|0.82384148560931303|21.622517|19.293751|17.970419|17.197531|16.755932|0.13952276|2.5947664E-2|1.2170685E-2|1.4863485E-2|2.1149596E-2|0.11065677|8.1420198E-2|5.9052721E-2|4.4777889E-2|3.1748082E-2|6|1|26227|268567040|402817024|268468736|268468224|268468224|268468224|591.74548|177.80463|0|16|0|0|16|5738618028032|51638.410941299997|3|0|88365|2340|20.229999542236328|0|0.0|3.6903864744511026|1|0
5738618028310|587725489989878133|258.51912603583702|55.523277731560299|-0.11267130534440201|-0.55474496193982703|0.82435623619547405|21.962814|21.346724|19.864302|19.460403|19.249454|0.20840853|5.5311721E-2|2.1318624E-2|2.4886979E-2|5.8884665E-2|0.12340666|9.0801448E-2|6.5856785E-2|4.9937207E-2|3.5406101E-2|3|1|9843|17592454610944|158330077216768|268468224|268468224|268468224|268468224|650.11829|1779.6609|0|0|0|0|0|5738618028032|51638.410941299997|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618159435|587725489990009343|258.46156164723999|55.261258186673302|-0.113981476126222|-0.55831935037772995|0.82175892212611701|23.713667|20.786936|20.330427|20.129307|19.977367|0.65621489|3.2640472E-2|2.8405633E-2|3.5685126E-2|0.10799862|0.11612469|8.5443445E-2|6.1970711E-2|4.6990514E-2|3.3316858E-2|6|1|9847|268566784|134350081|268435456|268435456|268468224|268435456|81.342224|715.72357|0|0|0|0|0|5738618159104|51638.411770600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618224935|100709103092891648|258.65178439388399|55.020122393691402|-0.112806755421856|-0.56208058544263895|0.81935343497153501|20.535404|20.422384|20.534441|20.726522|20.792273|6.2287435E-2|2.8230891E-2|3.1338777E-2|6.2773176E-2|0.16726163|0.11484385|8.4501013E-2|6.1287183E-2|4.6472214E-2|3.2949381E-2|6|1|26227|268566528|268468224|268468224|268468224|268468224|134381569|1115.2992|929.89795|0|34603008|0|0|0|5738618224640|51638.412185200003|3|0|88365|0|0.0|0|0.0|7.2176844480839151|0|0
5738618290224|587725489990139992|258.81521057613099|54.9075419141762|-0.11151513521277701|-0.56397834273097203|0.81822539898789604|23.598633|25.10848|21.340158|20.372274|19.996296|11.107984|0.78926837|2.1431267|4.4664836|0.14418408|0.12069669|8.8807479E-2|0.06441059|4.8840601E-2|3.4628592E-2|3|1|9843|70369012613392|70369155252497|70369155252529|276857104|268469520|402685968|999.2652|1403.2954|0|0|0|0|0|5738618290176|51638.412599900003|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618290421|103524643146563584|258.86764651217402|55.010824717142398|-0.110713988649716|-0.56263204672440303|0.81926039371861503|19.360643|19.156822|19.142973|19.306875|19.120039|3.1220581E-2|1.8625118E-2|1.2224862E-2|2.8315088E-2|5.1790833E-2|0.12780252|9.4035879E-2|6.8202667E-2|5.1716015E-2|3.6667299E-2|6|1|26227|268435456|268435456|268435456|268435456|268468224|268468224|199.32722|1966.0459|0|42991616|0|0|0|5738618290176|51638.412599900003|3|0|88365|0|0.0|0|0.0|-24.544719526460391|0|0
5738618355729|5738618355729|258.82639177039101|54.830519704179103|-0.111618120527971|-0.56507866749888103|0.81745183020621603|16.763441|15.691104|15.586148|15.589081|15.614278|1.5970662E-2|1.0897433E-2|5.7772864E-3|8.4590949E-3|1.1904714E-2|0.10965646|8.0684178E-2|5.8518898E-2|0.04437311|3.1461086E-2|6|1|26227|268566544|268468240|268468240|268468240|268599312|402685968|319.85443|1231.5513|0|4|0|4|0|5738618355712|51638.413014500002|3|0|88365|0|0.0|0|0.0|2.0823428037968057|1|0
5738618356032|5738618356032|258.74034149230698|54.748635782166403|-0.11269465749310401|-0.56605558837126901|0.81662781304959697|20.17115|19.693054|19.190113|18.793043|18.629805|4.5146633E-2|1.7605694E-2|1.2521014E-2|1.4820207E-2|3.6143802E-2|9.9779293E-2|7.3416658E-2|5.3247884E-2|4.0376257E-2|2.8627269E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|878.18762|563.29718|0|4|0|4|0|5738618355712|51638.413014500002|3|0|88365|0|0.0|0|0.0|-20.730928301881164|1|0
5738618356046|587725489990205738|258.703212574384|54.730523586434899|-0.11311201391608|-0.56623556144424803|0.81644532043717799|19.908262|19.353077|19.171114|18.970028|19.025293|0.03804728|1.5377334E-2|1.2360641E-2|1.6399752E-2|4.9341597E-2|0.09795513|7.2074451E-2|5.2274406E-2|3.9638098E-2|2.8103905E-2|3|1|9843|34628174352|268468240|268468240|268468240|268468240|268468752|970.53735|325.54327|0|0|0|0|0|5738618355712|51638.413014500002|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618487016|5738618487016|258.86724330290002|54.419172907759801|-0.11234547963971001|-0.570901834039377|0.81329551154239099|18.66988|18.722618|18.436426|18.170284|17.929281|3.0150909E-2|1.0927078E-2|9.1136135E-3|1.3209879E-2|2.4635116E-2|9.7652644E-2|7.1851887E-2|5.2112985E-2|3.9515696E-2|2.8017122E-2|3|1|26227|268566528|268599296|268468224|268468224|268468224|268468224|1207.0874|224.52065|0|5124|0|4|0|5738618486784|51638.413843800001|3|0|88365|0|0.0|20169|5.8299999684095383E-2|-22.765324710668018|1|0
5738618552407|587725489990402186|259.12704587512297|54.308588588154997|-0.110051523077546|-0.57294584832899598|0.81217099009437599|16.853621|15.780887|15.637577|15.657404|15.644475|2.6848709E-2|5.4365583E-3|1.5882697E-2|2.2414248E-2|1.1233578E-2|0.11775395|8.6642243E-2|6.2840179E-2|4.7649805E-2|3.3784308E-2|6|1|9843|17592454610960|158329951387696|268468240|268468240|268468240|268468240|1239.7484|1203.2679|0|0|0|0|0|5738618552320|51638.414258800003|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618683421|587725489990533190|259.37308993899097|54.129355566358598|-0.10805812612041001|-0.57590740991460099|0.810341962744619|24.320141|21.562838|20.189638|18.546593|17.63353|1.4890783|6.1262168E-2|0.02569581|0.01274298|2.0606762E-2|0.12644027|9.3033545E-2|6.7475691E-2|5.1164772E-2|0.03627646|6|1|9843|105553385361680|211106635351313|268992528|268992528|269127696|268992528|478.54791|1923.9346|0|0|0|0|0|5738618683392|51638.4150878|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618683648|5738618683648|259.24114751154599|54.149597429658698|-0.109330606148279|-0.57537575672197205|0.810548923345079|20.014837|19.308378|19.143827|18.868572|18.924786|0.05369265|1.6830146E-2|0.01482045|1.5461355E-2|4.3585178E-2|0.11970775|8.8079825E-2|6.3882835E-2|4.8440419E-2|3.4344859E-2|3|1|26231|17592454611472|158329951387664|268468240|268468240|268468240|402686480|81.182411|1316.3374|0|4|0|4|0|5738618683392|51638.4150878|3|0|88363|0|0.0|0|0.0|-19.269190257747461|1|0
5738618683980|5738618683980|259.38719584756302|54.027793627321799|-0.108180711919847|-0.57734492365547296|0.80930202810679497|22.279793|21.246529|20.478481|19.985275|19.353798|0.24404833|4.8412051E-2|3.1083072E-2|3.3649728E-2|6.3174643E-2|0.1318776|9.7034283E-2|7.0377357E-2|5.3365018E-2|3.7836462E-2|6|1|26227|70369012613648|70369146830865|268468240|268435472|268435472|402686480|1378.691|1702.6781|0|1|1|0|0|5738618683392|51638.4150878|3|0|88363|0|0.0|0|0.0|-24.880804630050982|1|0
5738618748998|587725489990598782|259.187355957796|53.905564216120098|-0.110517385381932|-0.57865861519534201|0.80804709923899298|23.617128|22.423004|20.912161|20.129276|20.150799|0.70494586|0.12774126|4.5935988E-2|4.1087251E-2|0.1286194|0.11433177|0.08412423|6.1013907E-2|4.6264999E-2|3.2802459E-2|3|1|9843|70369013269264|70369188806929|310935568|302514192|302546960|436240912|733.34784|336.21216|0|0|0|0|0|5738618748928|51638.415502399999|3|0|0|0|0.0|0|0.0|0.0|0|0
5738618749043|5738618749043|259.46355201156302|53.901189519910098|-0.107737952203057|-0.57924529701146299|0.808002116052424|16.452768|15.422659|15.348999|15.350722|15.38167|2.5901439E-2|1.7804274E-2|1.3922726E-2|1.7207755E-2|2.2290645E-2|0.11498068|8.4601693E-2|6.1360206E-2|4.6527587E-2|3.2988638E-2|6|1|26227|34628173840|302022672|302022672|302022672|302022672|302022672|1238.8062|1726.0859|0|4|0|4|0|5738618748928|51638.415502399999|3|0|88475|0|0.0|0|0.0|1.8418299558964151|1|0
5738618749253|101272087607377920|259.40544886632102|53.946494723078303|-0.10820780224149699|-0.57850754620846301|0.80846774240777797|20.090517|19.951578|19.790894|19.641541|19.691301|4.6845846E-2|2.4189863E-2|2.2119964E-2|2.9698323E-2|8.6158149E-2|0.12672947|9.3246348E-2|0.06763003|5.1281802E-2|3.6359437E-2|6|1|26227|268435968|268435456|268435456|268435456|268468736|268435456|750.1507|1560.8922|0|34603008|0|0|0|5738618748928|51638.415502399999|3|0|88475|0|0.0|0|0.0|-26.187991953620688|0|0
5738618814526|101272087649320960|259.56139319981401|53.752708204996701|-0.10712766966604|-0.58148575552881199|0.80647255285534103|20.698708|21.614193|20.079958|19.484692|19.035728|0.11457274|0.10193343|0.02385059|0.03084486|5.1050942E-2|9.8610498E-2|7.2556667E-2|5.2624147E-2|3.9903298E-2|2.8291935E-2|3|1|26227|105553385361684|70369046859829|310935860|302022672|302022672|302022676|1324.558|1799.0245|0|32|0|0|0|5738618814464|51638.415917099999|3|0|88475|0|0.0|0|0.0|-25.398889104181279|0|0
5738618814735|101272087619960832|259.50565455451999|53.8069086366934|-0.107554299247702|-0.58063086162842403|0.80703152059753502|20.441998|20.385735|20.40481|20.147366|20.457836|5.6921035E-2|3.3262122E-2|2.9605061E-2|4.3341029E-2|0.1641809|9.6560486E-2|0.07104829|5.1530145E-2|3.9073747E-2|2.7703775E-2|6|1|26227|268435456|268468224|268468224|268435456|268435456|134234113|762.7312|1669.7943|0|34603008|0|0|0|5738618814464|51638.415917099999|3|0|88475|0|0.0|0|0.0|-26.060503572708662|0|0
5738618945786|101272087456382976|259.45512170832899|53.523143867186803|-0.108796485184377|-0.58445806832046399|0.80409706577417495|20.144609|19.323395|19.509354|19.426914|19.077774|4.9917366E-2|1.3454797E-2|1.7685715E-2|2.1635495E-2|0.04933111|8.3838262E-2|6.1687399E-2|4.4740848E-2|0.03392563|2.4053695E-2|6|1|26227|268435968|268468736|268468224|268468224|268468224|268468224|404.90936|598.6322|0|36700160|0|0|0|5738618945536|51638.416746399998|3|0|88475|2728|32.560001373291016|0|0.0|-28.084400211990356|0|0
5738618945815|101272087427022848|259.60467315362098|53.487628462201599|-0.10736049947448401|-0.58523018858341203|0.80372840532309997|20.542309|20.421228|20.41708|20.007679|19.841417|6.3386537E-2|2.5746366E-2|3.0631214E-2|3.4242831E-2|9.3847774E-2|9.0604439E-2|6.6665888E-2|4.8351664E-2|3.6663603E-2|2.5994951E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402702336|965.57764|1263.9875|0|34603008|0|0|0|5738618945536|51638.416746399998|3|0|88475|0|0.0|0|0.0|-26.212391368583269|0|0
5738618945824|5738618945824|259.61842453593903|53.448703786588801|-0.107318407421666|-0.58579288913009997|0.803324000931808|19.915705|19.529383|18.854397|18.556011|18.118677|4.4293143E-2|1.4671066E-2|1.3819239E-2|1.2696085E-2|2.3717921E-2|9.2891462E-2|6.8348654E-2|4.9572144E-2|3.7589055E-2|2.6651109E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1324.7003|1223.8929|0|4|0|4|0|5738618945536|51638.416746399998|3|0|88475|0|0.0|0|0.0|-22.844302084464736|1|0
5738619011356|587725489990861074|259.49239805464202|53.325084140317799|-0.108922472089741|-0.58725821557132596|0.80203720818790003|20.170296|19.175652|19.093525|19.096073|19.076839|5.4380953E-2|1.4510797E-2|1.3454259E-2|2.1499991E-2|5.3056754E-2|7.9159044E-2|5.8244474E-2|4.2243749E-2|3.2032158E-2|2.2711199E-2|6|2|4723|268435456|268468224|268468224|268468224|268468224|268468224|817.19379|223.05408|0|0|0|0|0|5738619011072|51638.417160999998|3|0|0|0|0.0|0|0.0|0.0|0|0
5738619076924|587725489990926634|259.63689543899699|53.217971158393603|-0.10771061900076399|-0.58900494688623395|0.80091921883422001|20.383852|20.119812|19.285648|18.664213|18.448647|6.9268942E-2|1.9696187E-2|1.4697445E-2|0.01957413|3.3555254E-2|8.8339143E-2|6.4999104E-2|0.04714277|3.5746936E-2|2.5345024E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|626.59961|663.29425|0|5120|0|0|0|5738619076608|51638.417575799998|3|0|88475|0|0.0|20191|1.8300000578165054E-2|-21.596950934318457|0|0
5738619273513|5738619273513|259.97217772320198|52.816325230326001|-0.105237126324723|-0.59513933311089995|0.79670215352239804|20.576735|20.237528|19.567028|19.024492|18.765564|7.2640605E-2|2.2864688E-2|1.5247257E-2|2.3531722E-2|0.04129786|0.08886949|0.06538932|4.7425792E-2|3.5961542E-2|2.5497181E-2|3|1|26227|17592454610944|17592454643712|268468224|268468224|268468224|268468224|583.69043|1271.7211|0|4|0|4|0|5738619273216|51638.418819300001|3|0|88475|0|0.0|0|0.0|-21.732805517367296|1|0
5738619273553|587725489991123170|259.89818727761002|52.710695806026699|-0.10626302904299401|-0.59644793964401799|0.79558659110936103|19.419277|19.206644|19.113068|19.138477|18.954309|4.9482599E-2|1.3368604E-2|0.01156758|0.02599217|4.8856568E-2|8.8548198E-2|6.5152921E-2|4.7254335E-2|0.03583153|2.5405001E-2|6|1|9847|17592454610960|158329951387664|268468240|268468240|158329942999056|268468240|1372.4442|588.26855|0|0|0|0|0|5738619273216|51638.418819300001|3|0|0|0|0.0|0|0.0|0.0|0|0
5738619339053|101272087334748160|260.032645471357|52.595599072277501|-0.105139444395054|-0.59826852919951401|0.79436796524139197|20.413576|19.435879|19.359184|19.267561|19.083138|6.1165281E-2|1.6340941E-2|1.6056061E-2|2.5919128E-2|5.3942747E-2|0.10478311|7.7098414E-2|5.5918202E-2|4.2401079E-2|3.0062895E-2|6|1|26227|17592454610944|268468224|268468224|268468224|158329942999040|268468224|1236.1106|970.72546|0|1048576|0|0|0|5738619338752|51638.419234300003|3|0|88475|0|0.0|0|0.0|-28.381927976011845|0|0
5738619404516|101272087317970944|259.98263677625198|52.556771374354703|-0.10575519757243899|-0.59870651012634502|0.79395614042511697|20.374287|20.261011|19.893238|19.752529|20.16127|7.5119287E-2|2.3440171E-2|2.0698845E-2|2.8515669E-2|0.12989263|0.10849097|7.9826631E-2|5.7896931E-2|4.3901488E-2|3.1126702E-2|6|1|26231|268435968|402686464|268468224|268468224|268468224|402685952|126.02297|599.22913|0|34603008|0|0|0|5738619404288|51638.419649000003|3|0|88475|0|0.0|0|0.0|-25.338687038901142|0|0
5738882334777|587725490254184573|251.059303421225|64.201249058242993|-0.141265000475393|-0.411646966634242|0.90032825930408|18.152201|17.771816|17.366129|17.211758|17.218157|3.2278638E-2|1.7065624E-2|1.6862512E-2|2.6504645E-2|1.8317411E-2|0.25959823|0.19100991|0.13853632|0.1050479|7.4480265E-2|6|1|26483|17592454610960|158329976553488|302153744|302022672|302153744|436240400|600.07422|440.96124|0|7168|0|0|0|5738882334720|51638.384819600004|3|0|0|0|0.0|20011|1.2600000016391277E-2|0.0|0|0
5738882334876|758883005492232377|251.42004427281501|64.212087219113599|-0.13861617358870601|-0.41236678402829902|0.90041056849072099|20.706427|20.790442|19.63105|18.942709|19.973518|0.14043617|0.3734411|0.26500902|0.22557136|0.82260871|0.28735515|0.21143319|0.15334898|0.11627989|8.2443893E-2|3|1|10099|70369012744208|70369180549137|70369046200337|70369046200337|302022672|70369180418065|1127.4385|1770.2594|0|0|0|0|0|5738882334720|51638.384819600004|3|0|0|0|0.0|0|0.0|0.0|0|0
5738882334877|587725490254184619|251.425285016023|64.211817356101506|-0.13857980546072801|-0.41238348129192598|0.90040851943771505|19.702085|18.770809|18.314123|17.873753|17.695107|6.2059719E-2|4.1315775E-2|4.7480788E-2|2.6309729E-2|2.3659745E-2|0.28839734|0.21220002|0.15390515|0.11670162|0.0827429|3|1|26483|34628304912|268599312|268468240|268468240|268468240|268468240|1138.8986|1787.3038|0|64|0|0|0|5738882334720|51638.384819600004|3|0|0|0|0.0|0|0.0|0.0|0|0
5738882334878|5738882334878|251.42002104626101|64.211237664205598|-0.138620594699494|-0.41237938280608|0.90040411780579699|19.516121|19.135801|19.139097|18.773722|19.268646|0.05686444|6.0997076E-2|0.11336999|0.13492563|0.2592276|0.28828195|0.21211512|0.15384358|0.11665493|8.2709797E-2|3|1|26483|70403372486672|268599312|268603408|268468240|268468240|70369012645905|1134.1936|1766.5034|0|68|0|4|0|5738882334720|51638.384819600004|3|0|0|0|0.0|0|0.0|-19.122810476499815|1|0
5738882334972|5738882334972|251.051785116172|64.138451038007304|-0.141639353869774|-0.412561496090871|0.89985071282886397|19.816057|19.605776|19.431076|19.085693|19.176888|4.5663167E-2|1.3869022E-2|1.7751522E-2|1.7346896E-2|5.3671464E-2|0.31166095|0.22931716|0.16631994|0.12611537|8.9417368E-2|6|1|26483|268566528|268468224|268468224|268599296|268468224|402685952|1101.3683|165.74898|0|1048580|0|4|0|5738882334720|51638.384819600004|3|0|0|0|0.0|0|0.0|-26.826840466147125|1|0
5738882335074|758883005492232662|251.34245467922099|64.2593305840836|-0.13893691026525001|-0.41147513397430902|0.90076897653436705|23.944496|21.948629|20.491743|20.059366|19.915098|1.6782014|7.8899562E-2|3.2398134E-2|3.4334704E-2|9.8061614E-2|0.25040275|0.18424396|0.1336291|0.1013269|0.07184203|3|1|10099|268570880|140737631097089|268570624|268435456|268468224|402685952|607.98328|1677.9341|0|0|0|0|0|5738882334720|51638.384819600004|3|0|0|0|0.0|0|0.0|0.0|0|0
5739150835796|5739150835796|252.37952904434599|64.358599253228306|-0.130994089737789|-0.41243436235822001|0.901520074762585|19.22369|18.996071|19.04203|18.975552|18.981771|5.0590314E-2|1.2778774E-2|1.9111004E-2|1.6114512E-2|4.7169879E-2|0.20912093|0.15386918|0.11159877|8.4621966E-2|5.9998032E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|159.70534|1947.1923|0|1048580|0|4|0|5739150835712|51638.385234200003|3|0|87899|0|0.0|0|0.0|-24.712953149780134|1|0
5739150835916|98456813963313152|252.073061826458|64.2238277518573|-0.133850607959933|-0.41374426321395702|0.90049969428439902|22.957268|23.649481|22.529432|22.551266|21.945469|0.56505805|0.28324726|0.18655236|0.28070438|0.53077906|0.45340279|0.33360946|0.2419614|0.18347201|0.13008395|3|1|26227|70369012613464|70369180419353|70369180419353|436241688|70369180419353|70369180419353|765.22583|334.34784|0|64|0|0|0|5739150835712|51638.385234200003|3|0|87899|0|0.0|0|0.0|-20.993475331215606|0|0
5739150836465|98456813808123904|252.034661178638|64.224661713501106|-0.134123833828871|-0.41364199314736499|0.90050602369119104|23.972158|24.43421|22.686787|22.426462|21.899069|1.1467439|0.47469112|0.21318632|0.25015175|0.51505435|0.43849999|0.32264411|0.23400842|0.17744151|0.12580824|3|1|26227|2208418496768|134251777|671122688|671122688|939556864|142639105|696.70282|207.22762|0|64|0|0|0|5739150835712|51638.385234200003|3|0|87899|0|0.0|0|0.0|-21.83149807823208|0|0
5739150836496|98456813946535936|252.22477838259101|64.208259373354693|-0.13282925731484399|-0.41433022965391803|0.90038150202906697|23.845491|23.651228|22.546886|21.423752|20.565706|1.0732446|0.28892466|0.18791756|0.10659013|0.250357|0.41650698|0.30646187|0.22227171|0.16854191|0.11949831|3|1|26227|87961198793048|70369188806937|70369188806937|70369180419353|436241688|228698854952985|1149.9731|818.0354|0|64|0|0|0|5739150835712|51638.385234200003|3|0|87899|0|0.0|0|0.0|-21.590887217230964|0|0
5739150901441|758882833693540696|252.39302291940001|64.1017389649585|-0.13211815031978999|-0.41631327863565898|0.89957103576521702|22.414366|19.931339|18.722221|18.267725|17.991619|0.35701287|3.1105675E-2|1.5307197E-2|1.0540757E-2|2.3052506E-2|0.2694999|0.19829547|0.14382042|0.10905467|0.07732112|6|1|9843|268566784|142639361|276856832|268599296|268468224|402685952|945.2041|1022.4648|0|0|0|0|0|5739150901248|51638.385648800002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739150901871|98456814160445440|252.28255696650501|64.039587749581003|-0.13321743533776501|-0.416987057227244|0.89909671839407301|22.8085|22.658583|21.909954|21.516977|21.267593|0.50069642|0.12638618|0.10427498|0.11667897|0.30787486|0.26713315|0.19655403|0.14255738|0.10809694|7.6642081E-2|3|1|26227|268435712|142704897|276922624|268535040|276922624|134317313|1276.8646|387.13031|0|128|0|0|0|5739150901248|51638.385648800002|3|0|87899|0|0.0|0|0.0|-22.726098475431264|0|0
5739150901966|98456814185611264|252.265585287032|64.1464978508304|-0.13282969178486501|-0.41534892331112999|0.89991196507470805|23.502056|23.392908|22.354223|22.200308|21.414232|0.860093|0.23936631|0.15894324|0.21310303|0.36165449|0.42711955|0.31427053|0.22793519|0.17283636|0.12254313|3|1|26227|268435712|142639361|134251777|268469504|134251777|134250497|364.52496|732.81128|0|64|0|0|0|5739150901248|51638.385648800002|3|0|87899|0|0.0|0|0.0|-20.054279721822219|0|0
5739150966842|587725490522816613|252.427026424139|63.914315082209498|-0.13275879305197499|-0.41919470151549898|0.89813746447229004|17.876575|17.915749|17.910412|17.616871|17.560781|5.4666307E-2|8.1981309E-3|7.7500939E-3|1.8370323E-2|2.0231083E-2|0.21117823|0.15538293|0.11269667|8.5454471E-2|6.0588285E-2|6|1|9843|268435984|268468272|268468240|268468240|268468240|402686480|1190.7471|435.82281|0|0|0|0|0|5739150966784|51638.386063400001|3|0|0|0|0.0|0|0.0|0.0|0|0
5739150967039|5739150967039|252.513748789614|63.978124455304197|-0.131823520744594|-0.41844088490388498|0.89862661056712101|20.528019|20.267607|19.340368|19.005819|18.596401|8.8474095E-2|1.9138051E-2|1.4283252E-2|2.2348264E-2|3.4327678E-2|0.19032246|0.14003746|0.10156685|7.7015065E-2|5.4604642E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|806.05597|992.00653|0|4|0|4|0|5739150966784|51638.386063400001|3|0|87899|0|0.0|0|0.0|-22.537157973877143|1|0
5739151032434|758883004955623489|252.857280682897|63.902096146465396|-0.129663651570637|-0.420362824123165|0.89804367018345299|18.718477|16.974081|16.262594|15.972012|15.919929|2.9409625E-2|8.7281624E-3|1.6987288E-2|0.00813061|3.3091832E-2|0.13892366|0.10221871|7.4137531E-2|5.6216247E-2|3.9858021E-2|6|1|9843|268435968|276857344|268468224|276856832|268468736|268468224|639.4751|1957.359|0|0|0|0|0|5739151032320|51638.386478|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151097989|5739151097989|252.66316688520001|63.741423825704402|-0.131836985193476|-0.422323406363669|0.89680652861834298|18.962381|18.621405|18.05777|17.722141|17.596943|3.4904249E-2|1.1222851E-2|1.6297331E-2|1.9130025E-2|3.0877607E-2|0.13398245|9.8583005E-2|7.1500622E-2|5.4216757E-2|3.8440354E-2|3|1|26227|34628309008|268468240|268468240|268599312|268468240|268603408|291.35941|646.61731|0|68|0|4|0|5739151097856|51638.3868926|3|0|87899|0|0.0|0|0.0|-21.929570067525887|1|0
5739151163513|758883004418687236|252.724056981546|63.558136662971101|-0.132239394656951|-0.425200534639326|0.89538664712133997|20.690567|18.17074|16.753952|16.024282|15.609096|8.5395187E-2|9.9750087E-3|1.0847338E-2|9.3437955E-3|1.9903131E-2|0.11386576|8.3781347E-2|6.0765222E-2|4.6076428E-2|3.2668762E-2|3|1|26227|17626814349824|411075072|268468224|268468224|158329942999040|268468224|550.24023|183.69095|0|64|0|0|0|5739151163392|51638.387307199999|3|0|87899|0|0.0|0|0.0|0.0|0|0
5739151229067|5739151229067|253.07513825884001|63.500308980840302|-0.12989451818665201|-0.42686718749334002|0.89493676781467801|18.767214|18.394068|18.186125|17.852409|17.859064|0.03912868|8.3426125E-3|1.1140589E-2|9.4296401E-3|2.2780392E-2|0.1153001|8.4836721E-2|6.1530665E-2|0.04665684|0.03308028|3|1|26227|34628173840|268468240|268468240|268468240|268468240|268468240|250.2215|1267.2576|0|68|0|4|0|5739151228928|51638.387721799998|3|0|87899|0|0.0|0|0.0|-20.776150711606157|1|0
5739151229068|758883004418752649|253.069312036816|63.4982159093774|-0.12994744482627801|-0.42688525238894498|0.89492046734665098|19.776096|19.035057|18.56312|18.235403|18.135988|0.05147174|1.0168848E-2|1.2069669E-2|1.0570003E-2|2.6198808E-2|0.11503325|8.4640376E-2|6.1388262E-2|4.6548858E-2|3.3003721E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|258.07962|1237.8611|0|64|0|0|0|5739151228928|51638.387721799998|3|0|87899|0|0.0|0|0.0|0.0|0|0
5739151229154|758883004418752867|253.158570855363|63.503067693767001|-0.12926030365101199|-0.42701464145930301|0.89495825035553001|24.332571|20.870634|19.355082|18.016407|17.29414|1.2663252|2.8577436E-2|1.5503645E-2|9.8285042E-3|1.8520549E-2|0.1161885|8.5490398E-2|6.2004767E-2|4.7016338E-2|3.3335168E-2|6|1|9843|268566784|134276353|268468224|268599296|268468224|402685952|364.3241|1586.5747|0|0|0|0|0|5739151228928|51638.387721799998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151229183|5739151229183|253.04316467757201|63.475717598183202|-0.13024472211837601|-0.42716200304525898|0.89474517909551698|20.330845|19.718019|19.228092|18.922369|18.922363|6.8130814E-2|0.01377858|1.5207264E-2|1.4508204E-2|5.5078886E-2|0.11228681|8.2619563E-2|5.9922598E-2|4.5437492E-2|3.2215748E-2|3|1|26227|19971866492928|268468224|268468224|268468224|268468224|158329942999041|401.90793|1057.8389|0|4|0|4|0|5739151228928|51638.387721799998|3|0|87899|0|0.0|0|0.0|-19.71555663884066|1|0
5739151294690|758883003881816486|253.06047316401899|63.212667598673498|-0.131311172786477|-0.43112643921746402|0.89268548173985096|22.409998|20.020309|18.898287|18.418531|18.198048|0.34513935|1.9194694E-2|1.4958348E-2|2.8346639E-2|2.5789859E-2|0.11150172|8.2041904E-2|5.9503634E-2|4.5119803E-2|3.1990502E-2|6|1|9843|268435456|142647297|268468224|268468224|268468224|268468224|1255.1045|148.28352|0|0|0|0|0|5739151294464|51638.388136399997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151295028|587725490523144907|253.08926264966701|63.2606765389827|-0.13087690401802601|-0.43047656379843602|0.89306279959191404|24.637602|21.369305|20.222073|20.064156|19.802128|1.297707|0.04420688|2.8200574E-2|4.2085994E-2|9.0753376E-2|0.10593294|0.07794445|0.05653182|4.2866368E-2|3.0392788E-2|6|1|9843|268435712|134251777|268468224|276856832|402685952|402685952|903.72406|433.46301|0|0|0|0|0|5739151294464|51638.388136399997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360006|758883003881816338|253.13414071305601|63.202955069323998|-0.130800649435553|-0.43143972398418601|0.89260907158491698|17.081053|15.774729|15.291485|15.143684|15.073343|2.9793575E-2|1.0226433E-2|8.5295113E-3|1.1784853E-2|1.8387519E-2|0.1103541|8.1197493E-2|5.8891196E-2|4.4655412E-2|3.1661242E-2|6|1|9847|34628174336|285310976|293700096|285311488|285311488|285310976|97.247635|388.55551|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360024|758883003881816319|253.10282371375999|63.190888757680497|-0.131091082882379|-0.43154802148809801|0.89251410808929699|22.020239|19.673681|18.21648|17.091682|16.385336|0.24991022|1.5820906E-2|1.0396935E-2|1.2272119E-2|1.9218152E-2|0.11606006|8.5395895E-2|6.1936226E-2|4.6964366E-2|3.3298321E-2|3|1|9843|70369013268496|70369155260433|268992528|268468272|268992528|268468240|145.61958|226.39871|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360039|758883003881947143|253.479620800497|63.243219200730401|-0.12801840634365999|-0.43161908769107699|0.89292566923453998|17.849049|16.875729|16.503485|16.420685|16.320337|3.0996861E-2|1.0435743E-2|8.7603861E-3|1.2037128E-2|1.9182844E-2|0.12835076|9.4439276E-2|6.8495236E-2|5.1937867E-2|3.6824595E-2|6|1|9843|268435472|310411280|302022672|302022672|302022672|436240400|331.50836|1831.2064|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360040|758883003881947142|253.48419524955401|63.238611836806903|-0.12800435766650001|-0.43169814672472101|0.89288946378195599|19.073015|17.254728|16.439486|16.200684|16.019341|3.7538029E-2|1.0580895E-2|8.7362165E-3|1.1937774E-2|1.8832922E-2|0.12833716|9.4429262E-2|6.8487979E-2|5.1932361E-2|3.6820691E-2|6|1|9843|268566544|302022672|302022672|302022672|302022672|436371472|377.38327|1831.5038|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360054|758883003881881853|253.41687972851099|63.213380680697597|-0.12862367048731299|-0.43192426191431599|0.89269109066918795|17.392052|16.28373|15.853485|15.751685|15.697342|0.03020796|1.0302057E-2|8.6005051E-3|1.1850151E-2|1.8626044E-2|0.12667716|9.3207851E-2|6.7602105E-2|5.1260632E-2|3.6344428E-2|6|1|26227|34628174336|268468224|268468224|268468736|268468736|402686464|477.19324|1487.0059|0|0|0|0|0|5739151360000|51638.388550999996|3|0|87899|0|0.0|0|0.0|0.0|0|0
5739151360056|758883003881881857|253.42687776808299|63.213747566498498|-0.128546667810924|-0.43194122123890999|0.89269397644957105|18.110046|16.870729|16.387486|16.268684|16.185339|3.1427786E-2|1.0435743E-2|8.6880727E-3|1.1948771E-2|1.8989582E-2|0.12720338|9.3595043E-2|6.7882933E-2|5.1473569E-2|3.6495402E-2|6|1|9843|268567040|268599296|268468224|276988416|268468224|268468736|490.51929|1525.8862|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360077|758883003881881701|253.316992006861|63.164871830353498|-0.12959340059928701|-0.43242318662719198|0.89230921668909002|17.143053|15.826729|15.377485|15.222685|15.178344|2.9875999E-2|1.0226432E-2|8.5452385E-3|1.1795712E-2|0.01842141|0.11961576|8.8012137E-2|6.3833743E-2|4.8403196E-2|3.4318469E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468224|716.67706|934.35065|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360102|758883003881816656|253.17712384997199|63.100341351587701|-0.13093940003321999|-0.43306723738368502|0.89180022506377699|23.911955|21.91573|20.64797|19.246597|18.496971|1.1287029|6.8667017E-2|3.7498601E-2|0.01969623|3.4492593E-2|0.1393899|0.10256176|7.4386343E-2|5.6404915E-2|3.9991789E-2|6|1|9843|70369012613392|70369155219729|268435472|268435472|268468240|268435472|1021.8333|171.84207|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360105|758883003881881849|253.44867049828699|63.147857452461203|-0.128674733769815|-0.43297385788268999|0.89217512366095897|17.179052|15.983728|15.586485|15.436685|15.343343|2.9931076E-2|1.0245288E-2|8.5688811E-3|1.1817458E-2|0.01847236|0.12736215|9.3711853E-2|6.7967653E-2|5.1537812E-2|3.6540952E-2|6|1|9843|34628304912|268468240|268468240|268468240|268468240|268599312|1075.2946|1366.9995|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360122|758883003881816333|253.18597307250101|63.066082566094302|-0.131026734889753|-0.43359781457799701|0.89152954518474303|17.88505|16.252729|15.680485|15.407685|15.264343|3.1139906E-2|1.0283099E-2|8.5767768E-3|1.1817458E-2|1.8438375E-2|0.16648953|0.1225014|8.8848241E-2|6.7370929E-2|4.7766827E-2|6|1|9843|268570640|268468240|268599312|268603408|268468240|268468240|1321.5762|78.815773|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360127|758883003881881740|253.47086069604401|63.110538808251903|-0.12867233513208901|-0.43358065750910502|0.89188073395809297|17.260052|16.154728|15.778485|15.598684|15.505342|3.0041527E-2|1.0283099E-2|8.6005069E-3|1.1828344E-2|1.8557597E-2|0.13126065|9.6580334E-2|7.0048116E-2|5.3115364E-2|3.7659455E-2|6|1|9847|268435968|293700128|419529216|285311520|419529216|285311488|1422.6154|1315.0596|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360135|758883003881881889|253.19499299231299|63.214598559711099|-0.13028990905650301|-0.43140474450115301|0.89270066988881702|20.670322|18.474724|17.435484|17.071684|16.813328|8.3225206E-2|1.1719503E-2|9.1900714E-3|1.2260825E-2|1.9957099E-2|0.11043567|8.1257522E-2|5.8934733E-2|4.4688422E-2|3.1684648E-2|6|1|9847|268566528|402685952|268468224|268599296|268468224|268468224|101.31307|659.49829|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360141|758883003881881877|253.18485706514599|63.198573169829601|-0.13043844967603299|-0.43162068079438398|0.89257459002410899|21.378359|19.007715|17.785482|17.351683|17.041319|0.14530066|0.01292079|0.00964972|1.2465702E-2|2.0572381E-2|0.11115919|8.1789874E-2|5.9320841E-2|4.4981197E-2|3.1892229E-2|6|1|9843|268435456|402685952|268468224|268468224|268468224|268468224|217.73088|562.41888|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360143|758883003881881962|253.35930096216899|63.2300721824693|-0.128983184347923|-0.43154559779318702|0.89282234245161596|19.467974|18.046726|17.413485|17.219683|17.061317|4.2581905E-2|1.1151079E-2|9.2495186E-3|1.2374234E-2|2.0629238E-2|0.12458448|9.1668077E-2|6.6485338E-2|5.0413817E-2|3.5744026E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|243.53189|1332.075|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360144|758883003881881975|253.40506059968001|63.232182133466701|-0.128629096251615|-0.431616963855534|0.89283892842417201|21.64465|19.026714|17.845482|17.445683|17.139313|0.18335846|1.2956508E-2|9.7210612E-3|1.2557854E-2|2.0896688E-2|0.12712193|0.09353511|6.7839459E-2|5.1440611E-2|3.6472034E-2|6|1|9843|268435456|402685952|268468224|268468224|268468224|402685952|301.216|1511.2737|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360147|758883003881881873|253.17699808837401|63.186048583370201|-0.130554117312977|-0.431789537254755|0.89247600414238304|19.541962|17.659727|16.974485|16.799685|16.67333|4.3133195E-2|1.0827309E-2|8.9561604E-3|1.2114946E-2|0.01966542|0.11258024|8.2835466E-2|6.0079191E-2|4.5556232E-2|3.2299936E-2|6|1|9843|17592454610960|17592454643728|268468240|268468240|268468240|268468240|308.86972|486.86185|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360150|758883003881881693|253.28409306744899|63.188485875843398|-0.12973588618201701|-0.4319964484246|0.89249519235965502|18.99402|18.172726|17.907482|17.814678|17.772245|3.6717895E-2|1.1306162E-2|9.8109841E-3|1.3028898E-2|2.4411425E-2|0.11518153|8.4749475E-2|6.1467387E-2|4.6608858E-2|0.03304626|6|1|26227|268435456|276856832|268468224|268468224|268468224|268468224|465.86609|897.52942|0|0|0|0|0|5739151360000|51638.388550999996|3|0|87899|0|0.0|0|0.0|0.0|0|0
5739151360152|758883003881881844|253.380396049159|63.206804020724|-0.128927983000172|-0.43194045546216198|0.89263935502231095|18.729033|17.454727|16.933485|16.814684|16.744329|3.4617383E-2|1.0688621E-2|8.9232298E-3|1.2126106E-2|1.9810729E-2|0.1244676|9.1582075E-2|6.6422962E-2|5.0366521E-2|3.5710491E-2|6|1|9843|268435968|268468224|268468224|268468224|268468224|402686464|471.97043|1326.1042|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360154|758883003881881912|253.27150935333|63.185164606665602|-0.129845652357019|-0.43201748962116998|0.89246904440736896|19.791908|17.607727|16.644485|16.345684|16.161339|4.9154144E-2|1.0787501E-2|8.8089257E-3|1.1959777E-2|0.01895465|0.11373307|8.3683707E-2|6.0694408E-2|4.6022732E-2|3.2630689E-2|6|1|9843|34628174336|402686464|268468224|268468224|268468224|268468224|472.70193|838.1084|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360156|758883003881881887|253.215152573475|63.170350704123699|-0.130337157837879|-0.43211046679871301|0.89235237981962201|20.605406|18.212725|17.101484|16.735683|16.458336|8.0598198E-2|1.1347874E-2|9.0306979E-3|1.2092658E-2|1.9324573E-2|0.11546297|8.4956557E-2|6.1617579E-2|4.6722747E-2|0.03312701|6|1|9843|34628173824|402685952|268468224|268468224|268468224|402685952|502.76389|572.12689|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360159|758883003881881945|253.33895785362799|63.174702504942204|-0.12938371308686999|-0.43232615872750002|0.89238665793913496|21.54936|18.799719|17.534483|17.023684|16.69833|0.17055738|1.2373678E-2|9.3609076E-3|1.2238272E-2|1.9575017E-2|0.12048781|8.8653781E-2|6.4299121E-2|4.8756074E-2|3.4568664E-2|6|1|9843|17626814349824|402685952|268468736|268468224|268468224|17592454643712|670.98804|1052.9523|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360160|758883003881881676|253.255124175981|63.151647085950401|-0.130119589779506|-0.43248021384356|0.89220499717802604|19.253|18.445724|18.319479|18.279671|18.257105|3.9632719E-2|1.1687185E-2|1.1150739E-2|1.4063356E-2|0.03005022|0.11930475|8.7783299E-2|6.3667774E-2|4.8277345E-2|3.4229238E-2|6|1|9843|17592454610944|268468224|268468224|158329942999040|268468224|268468224|724.56097|653.34467|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360163|758883003881881898|253.27510788750899|63.151955187598702|-0.12996736006606599|-0.43252097606815099|0.89220742575844503|21.231997|19.056713|17.993481|17.55368|17.280304|0.13109405|1.3088396E-2|9.9565964E-3|1.2673998E-2|2.1461746E-2|0.11938021|8.7838829E-2|6.3708045E-2|4.8307881E-2|3.4250889E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|754.90106|729.63196|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360165|758883003881881997|253.49779959408701|63.188041310592098|-0.12812565852468499|-0.432483981670785|0.89249169252480998|22.145931|19.568689|18.16448|17.101683|16.481335|0.28573081|1.5207015E-2|1.0263766E-2|1.2283425E-2|1.9360173E-2|0.12837948|9.4460405E-2|6.8510562E-2|5.1949486E-2|3.6832832E-2|6|1|9843|34628173824|32769|268468224|268468224|268468224|268468224|821.09155|1698.2919|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360167|758883003881881949|253.358052941311|63.153153166412999|-0.12933573633008699|-0.43269079830850898|0.89221686846141801|20.634369|18.471724|17.344484|16.848684|16.545334|8.3080187E-2|1.1730305E-2|9.1985567E-3|1.2137275E-2|1.9360092E-2|0.12195161|8.9730836E-2|6.5080285E-2|0.04934841|3.4988638E-2|6|1|9843|268566528|268468224|268468224|268468224|268468224|268599296|881.99957|1045.8483|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360176|758883003881947338|253.543605739745|63.1733428452279|-0.12784471643103701|-0.43280583930657102|0.89237594876980098|21.504652|19.139711|17.752483|16.813684|16.242338|0.16599947|1.3356151E-2|9.6231047E-3|1.2159659E-2|0.01944978|0.1293882|9.5202602E-2|6.9048874E-2|5.2357666E-2|3.7122238E-2|6|1|9843|17592454611472|268468240|268468240|268468240|268468240|158330077217296|1018.5674|1817.2413|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360180|758883003881881698|253.33476503329501|63.130735632299498|-0.129611694567106|-0.43297258654529802|0.89204010444133996|18.678034|17.627728|17.265484|17.091682|16.995321|3.4395114E-2|1.0807388E-2|9.1563053E-3|1.2283427E-2|2.0459151E-2|0.12553632|9.2368431E-2|6.6993296E-2|5.0798986E-2|3.6017112E-2|6|1|9843|34628173840|268468240|268468240|268468240|268468240|402685968|1030.3069|876.00446|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360195|758883003881947343|253.559023741277|63.151473921420902|-0.12782463758347601|-0.433166873952396|0.89220363221462096|21.899996|19.249706|17.965481|17.352682|16.981321|0.23141289|1.3806192E-2|9.9199954E-3|1.2488686E-2|2.0459197E-2|0.12983935|9.5534556E-2|6.9289625E-2|5.2540228E-2|3.7251677E-2|6|1|9843|268435712|142639361|268468224|268468224|268468256|402685952|1226.4999|1795.4999|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360200|758883003881947150|253.55042464147201|63.142364479835102|-0.12792981355144301|-0.43328372450811298|0.89213181586639501|19.079014|16.603729|15.478485|15.057685|14.830344|3.7676547E-2|1.0368687E-2|8.5609928E-3|1.1795714E-2|1.8319918E-2|0.12980734|9.5511004E-2|6.9272548E-2|5.2527275E-2|3.7242495E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468224|1288.1267|1730.1841|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360213|758883003881881613|253.174057255572|63.205612221180402|-0.130488061656829|-0.43149112089470198|0.89262997840878999|22.327482|19.962646|18.71447|18.23867|17.914217|0.32481059|1.7361278E-2|1.1860011E-2|1.3947335E-2|2.5749028E-2|0.1096251|8.0661103E-2|5.8502164E-2|4.4360418E-2|0.03145209|6|1|9843|70369012744464|70369146864913|268599312|268468240|268468240|402685968|141.24867|547.88611|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360219|758883003881947323|253.49887606924401|63.2275205739586|-0.12794283143753099|-0.431896648790626|0.89280228306561504|21.991692|19.730675|18.564474|18.161673|17.879225|0.24943036|1.6099896E-2|1.1284763E-2|1.3756093E-2|2.5419649E-2|0.12820235|9.4330072E-2|6.8416037E-2|5.1877808E-2|3.6782011E-2|6|1|9843|70369012613136|70369012613137|268468240|268435472|268468240|268468240|493.7547|1846.2236|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360224|758883003881881956|253.38454009234701|63.164416994492299|-0.12908553667991399|-0.432582456181691|0.89230563307864097|22.370197|19.833664|18.394478|17.493681|16.958323|0.3783032|1.6889174E-2|1.0806858E-2|1.2604183E-2|2.0327775E-2|0.12271321|0.09029121|6.5486722E-2|4.9656596E-2|3.5207145E-2|6|1|9843|268566784|142770433|268468224|268468224|268468224|268468224|831.74628|1186.6206|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360225|758883003881947321|253.51671246902899|63.187236046337802|-0.12798645110667201|-0.432538279340689|0.89248535295438702|21.969036|19.654682|18.513475|17.985676|17.633268|0.24571012|1.5690386E-2|1.1140244E-2|1.3356796E-2|2.3421746E-2|0.12870288|9.4698355E-2|6.8683147E-2|5.2080348E-2|3.6925618E-2|6|1|9843|268435712|8421633|268468224|268468224|268468224|402685952|858.7038|1766.6218|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360226|758883003881881947|253.36777507172599|63.133513029011297|-0.12934984588434201|-0.43300575561216198|0.89206201184471401|22.200743|19.873659|18.375477|17.362682|16.766329|0.2996507|1.7282344E-2|1.0560865E-2|1.2488683E-2|1.9883808E-2|0.12604022|9.2739187E-2|6.7262195E-2|5.1002886E-2|3.6161683E-2|6|1|9843|268566528|134250497|268468224|268599296|268468224|268468224|1061.4976|1010.4929|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360236|758883003881816582|253.07984882407001|63.195662472093098|-0.131242475121539|-0.43142427680680701|0.89255168259641704|22.7752|21.235872|19.725391|17.918676|16.864326|0.47616655|3.9526131E-2|1.9230103E-2|0.0131736|2.0086071E-2|0.11544566|8.4943816E-2|6.1608341E-2|0.04671574|3.3122044E-2|6|1|9847|268435712|134219009|268435456|268435456|268468224|268468224|67.617508|158.2448|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360241|758883003881881951|253.35899158335999|63.160340028501402|-0.12929659730384599|-0.43258568621024701|0.89227350852283904|22.860945|20.679422|19.315441|18.327669|17.739252|0.52544487|0.02672741|1.5178824E-2|1.4219564E-2|2.4210293E-2|0.12152153|0.08941438|0.06485077|4.9174372E-2|3.4865245E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|823.65173|1075.7465|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360242|758883003881881916|253.29768188896401|63.139617818695498|-0.129852152033088|-0.43275615012375201|0.892110157515564|22.436007|20.699409|19.302443|18.079674|17.358299|0.36584339|2.7173601E-2|1.4943026E-2|1.3542494E-2|0.02184022|0.12255188|9.0172507E-2|6.5400623E-2|4.9591314E-2|3.5160858E-2|6|1|9843|268566784|134251777|268468224|268599296|268468224|268468224|894.85858|769.41089|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360243|758883003881881870|253.22012500918399|63.105284420239002|-0.130592128932665|-0.43309172319057998|0.89183925410616904|22.711243|20.196602|18.843466|18.117674|17.677261|0.46398795|2.0264523E-2|1.2124842E-2|1.3604949E-2|2.3812883E-2|0.13292332|9.7803719E-2|7.0935413E-2|5.3788178E-2|3.8136486E-2|6|1|9843|268570880|142639361|268468224|268603392|268468224|268468224|1052.0815|351.77231|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360247|758883003881947361|253.584870384266|63.158366233446699|-0.12759888831688501|-0.43312153794444003|0.89225795433211896|24.162584|21.573133|20.073307|18.976631|18.406029|1.264179|5.1794227E-2|2.4249393E-2|1.7669652E-2|3.2823011E-2|0.12984176|9.5536329E-2|6.9290914E-2|5.2541204E-2|3.7252367E-2|6|1|9843|70369012613392|70369155252497|268468240|268468240|268468240|268468240|1210.9855|1918.1849|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360251|758883003881816361|253.18552226045301|63.072092540313598|-0.13100309407417901|-0.43350726342566798|0.89157705326022196|22.650648|20.673426|19.370436|18.067675|17.118315|0.4183577|2.5594698E-2|1.5835563E-2|1.3344388E-2|0.02091603|0.16069254|0.11823604|0.08575464|6.5025151E-2|4.6103641E-2|6|1|9843|70369012748560|70369155383569|268599312|268468240|268603408|268468240|1270.8428|99.796761|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360252|758883003881816357|253.18255906697399|63.073618723032702|-0.13101864266059801|-0.43347775438494002|0.89158911597706503|22.56963|20.224596|18.877466|17.834679|17.261307|0.26406917|2.2926958E-2|1.2649572E-2|1.3052902E-2|2.1481624E-2|0.16006245|0.11777242|8.5418388E-2|6.4770177E-2|4.5922861E-2|6|1|9843|87961198788880|70369021165841|158329942999056|268468240|268468240|268468240|1253.1443|93.911224|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360277|758883003881882083|253.436863667811|63.2166300885834|-0.12845858117732301|-0.43192057066255901|0.892716647968681|22.387642|21.057112|19.710394|19.167608|18.775721|0.3494488|3.5735101E-2|1.9732805E-2|1.9570477E-2|4.0804323E-2|0.12787272|9.4087534E-2|6.8240128E-2|5.1744424E-2|3.6687441E-2|6|1|9843|70369012744464|70369146864913|268468240|268599312|268468240|268468240|482.87756|1573.7278|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360376|758883003881882019|253.214107366402|63.196742488217303|-0.130226320376641|-0.43171451883815898|0.89256018267985604|22.191942|21.436489|20.001329|19.057623|18.48498|0.29078239|4.5979824E-2|2.2841239E-2|0.01806405|3.3925887E-2|0.11256498|8.2824245E-2|6.0071051E-2|0.04555006|3.2295559E-2|6|1|26227|70369012613136|70369146863633|268468240|268468240|268468240|268468240|281.37653|665.31665|0|33554432|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360383|758883003881816662|253.14891999544699|63.181491662555203|-0.13078627840226101|-0.43179343901560602|0.89244012426871699|25.24548|22.720455|21.383486|19.856415|18.808681|1.1530449|0.13445149|6.8677403E-2|2.8615743E-2|4.1674726E-2|0.11516199|8.4735096E-2|0.06145696|4.6600953E-2|3.3040654E-2|6|1|9843|268435712|134219009|276824320|268435456|268435456|268468224|299.87479|364.81671|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360386|758883003881816593|253.117657270336|63.174383051942797|-0.131054015615689|-0.431827961522041|0.89238414185748605|23.379934|21.752508|20.441133|19.671494|19.312668|0.78290892|5.9727501E-2|3.1809047E-2|0.02522761|6.0455758E-2|0.12082887|8.8904738E-2|6.4481132E-2|4.8894092E-2|0.03466652|6|1|9843|268435712|142606593|268435456|268435456|268435456|268435456|307.31897|221.25356|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360399|758883003881882062|253.38705663007599|63.221690479712699|-0.128811457044441|-0.43173318314824799|0.89275644332750104|23.382393|21.400568|20.218252|19.838425|19.479067|0.78580976|4.4486761E-2|2.6512438E-2|0.02853743|6.8889059E-2|0.12562443|9.2433259E-2|6.7040309E-2|5.0834637E-2|3.6042392E-2|6|1|9843|268436224|142655745|268468224|268468224|268468224|268468736|358.86664|1405.5435|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360402|758883003881882016|253.20939471943299|63.185079200468898|-0.13031431252838499|-0.431877743087483|0.89246837197511797|23.215628|21.373625|19.980335|19.041624|18.491974|0.68982655|4.3840859E-2|2.2548905E-2|1.7931534E-2|3.4082156E-2|0.11325131|8.3329238E-2|6.0437314E-2|4.5827784E-2|0.03249247|6|1|9843|268435456|134217729|268468224|268435456|268468224|268468224|370.60757|604.8147|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360404|758883003881816613|253.157233558803|63.172651487644103|-0.13076351918494999|-0.43194419440050102|0.89237050319588096|23.268784|21.22389|19.778381|18.698652|18.075172|0.71872687|3.9273597E-2|1.9823091E-2|1.5691265E-2|2.7511528E-2|0.11662351|8.5810468E-2|6.2236909E-2|4.7192365E-2|3.3459976E-2|6|1|9843|268435456|134225921|268435456|268435456|268435456|268468224|387.44254|363.42575|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360484|758883003881882024|253.261011631625|63.158237032448902|-0.130045593254562|-0.432395309379767|0.89225693614644697|24.448332|21.153992|19.713392|18.723652|18.08217|1.3454342|3.7237886E-2|1.8966313E-2|1.5865574E-2|2.7612932E-2|0.11805067|0.08686056|6.2998526E-2|4.7769874E-2|3.3869438E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|679.34442|699.80463|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360488|758883003881947512|253.50435527253799|63.204464157847397|-0.12800353098947501|-0.43225333273010202|0.89262094552948201|24.251205|21.567152|20.274227|18.955633|18.212124|1.2974401|5.0709575E-2|2.7658444E-2|1.7379204E-2|2.9340386E-2|0.12844405|0.09450791|6.8545021E-2|5.1975612E-2|3.6851358E-2|6|1|9843|268436224|134227201|268435456|268435456|268468736|402685952|694.78607|1782.9514|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360504|758883003881882014|253.20652993758401|63.136926771983497|-0.13055256570151799|-0.43258913343223498|0.89208893571498704|24.303312|21.587091|20.3262|19.701483|19.183023|1.3064959|5.2221164E-2|0.0290407|2.5767136E-2|5.4818671E-2|0.12244385|9.0093017E-2|0.06534297|4.9547598E-2|3.5129864E-2|6|1|9843|268435712|142606593|268435456|268435456|268435456|402685952|766.41089|417.08966|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360509|758883003881882135|253.45588683663601|63.185853559717998|-0.128451696855891|-0.43242280732694899|0.89247446869830505|24.8599|22.486128|20.997503|19.716476|18.88658|1.221033|0.10941303|4.9026553E-2|2.6318612E-2|4.3993317E-2|0.12743813|9.3767762E-2|6.8008207E-2|5.1568564E-2|3.6562752E-2|6|1|9843|268567296|134350081|276824320|268435456|268435456|402686464|770.27094|1533.0603|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360513|758883003881882060|253.40456945539299|63.1729479660926|-0.12889635992578|-0.43250022608901401|0.89237283846542304|23.297585|21.718643|20.332197|19.033627|18.235113|0.74597216|5.7581071E-2|2.8960299E-2|0.01796467|2.9693177E-2|0.12417972|9.1370262E-2|6.6269331E-2|5.0250031E-2|3.5627898E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|793.65796|1293.29|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360527|758883003881882131|253.43291294495199|63.172528353483301|-0.12868425531757399|-0.43257020063011198|0.89236953329894997|24.211569|22.478252|20.868711|19.258595|18.318075|1.2771882|0.10883499|4.4197764E-2|2.0025451E-2|2.9964997E-2|0.12572831|9.2509694E-2|6.7095749E-2|5.0876677E-2|3.6072198E-2|6|1|9843|70369012744464|70369146832145|276824336|268435472|268435472|268566544|843.77673|1398.2069|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360567|758883003881816496|253.15550400650901|63.097486767304702|-0.131115678084397|-0.43306032252282101|0.89177768306730998|22.92918|20.814335|19.653402|19.102617|18.762735|0.56039274|2.9517621E-2|1.8483937E-2|1.8348802E-2|4.0768113E-2|0.14489681|0.1066137|7.7325143E-2|5.8633316E-2|4.1571751E-2|6|1|9843|268435456|134250497|276856832|268468224|268468224|402685952|1009.6244|80.022331|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360570|758883003881816592|253.15791882120001|63.095236645352799|-0.131107572975805|-0.433099367595768|0.89175991281092004|23.527155|21.59108|20.245239|18.991631|18.221119|0.89078009|5.2703414E-2|2.7532293E-2|1.7475275E-2|2.9666295E-2|0.14644632|0.10775381|7.8152053E-2|5.9260335E-2|4.2016316E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|1032.4591|80.737259|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360612|758883003881947600|253.580408320543|63.159467394518003|-0.12762777114326501|-0.43309515058727799|0.89226663199448697|25.318224|22.63735|21.353592|20.038307|19.326624|1.1415925|0.12579623|6.6695899E-2|3.3305485E-2|6.1916437E-2|0.12989283|0.09557391|6.9318168E-2|5.2561868E-2|3.7267022E-2|6|1|9843|268435712|134219009|276857088|268435456|268468224|268435456|1194.421|1905.3959|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360618|758883003881947353|253.572668337393|63.155708738665297|-0.12770282896503299|-0.43313404882517997|0.89223701067745098|24.258986|20.751377|19.506422|18.75465|18.28809|1.3041685|2.8217535E-2|1.6338481E-2|1.6160445E-2|3.0777663E-2|0.13004251|9.5684037E-2|6.9398046E-2|5.2622437E-2|3.7309963E-2|6|1|9843|70369012744464|70369155219729|268435472|268566544|268435472|268468240|1213.1632|1862.6554|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151360639|758883003881882115|253.276938660301|63.089964322284601|-0.130231230261038|-0.43344936798217498|0.89171826944419497|25.084389|22.145147|20.818779|19.712479|19.139128|1.2606485|8.3691813E-2|5.1225748E-2|2.5981395E-2|5.3878665E-2|0.13927583|0.10247784|0.07432548|5.6358758E-2|3.9959062E-2|6|1|9843|17592454611200|134251777|268468224|158329942999040|268468224|268468224|1273.9709|509.38272|0|0|0|0|0|5739151360000|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425545|758883003881881742|253.46941973322799|63.097800656425797|-0.12873965380577401|-0.43376750040162698|0.89178016188592901|18.415947|17.200056|16.806662|16.578817|16.493418|3.0068025E-2|6.021712E-3|7.9308935E-3|1.2921788E-2|1.9164998E-2|0.13281506|9.7724058E-2|7.0877641E-2|5.3744368E-2|3.8105428E-2|6|1|26227|35184641179664|302546960|302546992|302546992|302546960|302546960|165.55211|1262.821|0|134221824|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|20052|0.01679999940097332|0.0|0|0
5739151425549|758883003881881744|253.444224483836|63.108839286353501|-0.12888142667309399|-0.43354615047015699|0.89186731819885401|21.832726|19.129038|17.80566|17.150818|16.715412|0.22774726|1.5124755E-2|9.9292118E-3|1.3668465E-2|1.9574985E-2|0.13168862|9.6895233E-2|7.0276506E-2|5.3288545E-2|3.7782244E-2|6|3|3|35184641179664|268992528|268992560|269123632|268992528|268992528|31.968618|1207.9681|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425550|758883003881881965|253.448588455314|63.082075137219597|-0.128967073293318|-0.43395526705200599|0.89165594272902005|22.740368|20.045959|18.60865|17.330816|16.649414|0.4745934|1.6855927E-2|1.0492664E-2|1.3113469E-2|0.01943139|0.13686769|0.10070594|7.3040351E-2|5.5384289E-2|3.9268151E-2|6|1|9843|105553385357584|70369155793169|268992560|269123632|268992528|268992528|262.23074|1127.0599|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425560|758883003881881695|253.35622615867999|63.072313619472503|-0.12970996148758199|-0.43389234618373002|0.89157880067555895|17.366957|16.278055|15.984662|15.755818|15.723424|2.6577925E-2|5.371843E-3|7.5809532E-3|1.2534988E-2|1.8404346E-2|0.14680043|0.10801436|7.8341022E-2|5.9403624E-2|4.2117909E-2|6|1|9843|268567040|268468224|285377024|268468224|285245952|268468256|191.21138|743.11517|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425625|758883003881947341|253.57165998027401|63.127813467748403|-0.127833291372385|-0.433548413655094|0.89201705288298905|20.665236|18.109053|16.718662|15.971819|15.531425|8.3610721E-2|6.9969147E-3|7.8220833E-3|1.2569666E-2|0.01830297|0.12993467|9.5604688E-2|6.9340497E-2|5.2578799E-2|3.7279025E-2|6|1|9847|34628173824|268468224|268468224|268468224|268468224|419463168|83.233932|1757.189|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425634|758883003881881924|253.36809655842401|63.057281833624501|-0.12968701148803399|-0.43414331834624298|0.89145995882407103|21.333479|18.939043|17.748659|17.107817|16.78541|0.14035891|9.282683E-3|8.6639039E-3|1.2945528E-2|1.9755976E-2|0.15662639|0.11524421|8.3584711E-2|6.3379757E-2|4.4937037E-2|6|1|9843|34628174080|402687232|293634048|268468224|268468224|427851776|336.02954|732.9389|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425643|758883003881881882|253.28480267843699|63.029527828019901|-0.130442194175722|-0.434367851922485|0.89124037340936801|20.744122|18.271053|16.993662|16.186819|15.765424|0.08769346|7.3468699E-3|0.00796015|1.2616051E-2|1.8438267E-2|0.2006855|0.14766249|0.10709716|8.1208527E-2|0.05757786|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|428.96094|317.1485|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425706|758883003881881982|253.50686165196399|63.113664358671898|-0.12838606291850599|-0.43361476940571297|0.89190540451413103|22.128195|19.579016|18.534651|18.065809|17.738335|0.2783812|1.2624674E-2|1.0444568E-2|0.01398622|2.4232619E-2|0.13068345|9.6155643E-2|6.9740094E-2|5.2881803E-2|3.7493858E-2|6|1|9847|34628305152|142639361|268468224|268468224|268599296|268468224|94.822342|1461.5229|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425707|758883003881947350|253.58894969734601|63.123475637248703|-0.12772153670957401|-0.43365175068959799|0.89198282953451002|22.366226|19.903982|18.492653|17.643814|17.167395|0.34412766|1.5176618E-2|1.0339333E-2|1.3431134E-2|2.0858107E-2|0.12970681|9.5437042E-2|6.9218904E-2|5.2486598E-2|3.7213653E-2|6|1|9843|34628174080|142639361|268468224|268468224|268468224|402685952|147.69656|1806.5826|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425708|758883003881947363|253.620137904476|63.117927298516499|-0.12750982316109699|-0.43380407893614797|0.89193904841966998|22.641056|19.725002|18.351654|17.504816|17.0424|0.43727386|1.3677347E-2|9.937983E-3|1.3271352E-2|2.0421341E-2|0.12899125|9.4910532E-2|6.8837032E-2|5.2197039E-2|3.7008353E-2|6|1|9843|268435712|142655745|268468224|268468256|268468224|402685952|244.56107|1904.2581|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425715|758883003881816607|253.21620737487899|63.045221204813103|-0.13089163694688299|-0.43397764431973601|0.89136456268356201|23.721205|20.900595|19.565592|18.515797|17.899302|0.99831718|3.0451884E-2|1.7060999E-2|1.5448134E-2|2.5844358E-2|0.18802455|0.13834667|0.10034055|7.6085202E-2|5.3945355E-2|6|1|9843|268435712|134219009|268435456|268435456|268468224|268435456|184.24855|115.7411|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425717|758883003881881987|253.52274281007101|63.100654642194499|-0.12832330717757301|-0.43384452865813999|0.89180269891294095|22.543688|20.038961|18.94264|18.399799|18.056261|0.39808428|1.6639965E-2|1.2214256E-2|1.5041252E-2|2.7562724E-2|0.13128345|9.6597113E-2|7.0060283E-2|5.3124592E-2|3.7665997E-2|6|1|9843|70369012613392|70369155252497|268468240|268468240|268468240|402685968|229.31419|1474.2661|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425722|758883003881882077|253.50102228394601|63.068062277583898|-0.12863181667936099|-0.434282189227648|0.89154519563363099|24.524042|21.020479|19.678576|18.475798|17.870308|1.3496269|3.3722557E-2|1.8162932E-2|1.5306608E-2|2.5537163E-2|0.13505097|0.09936922|7.2070844E-2|5.4649141E-2|3.8746923E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|465.3815|1273.7079|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425745|758883003881881976|253.50125277788001|63.0853481308095|-0.128553676436828|-0.43402478694136498|0.89168180232360805|21.618759|20.158937|19.483603|19.217735|19.136215|0.17974874|1.8077077E-2|1.6129272E-2|2.0025928E-2|5.4528799E-2|0.13303852|9.7888485E-2|7.0996895E-2|5.3834796E-2|0.03816954|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|321.68716|1337.5573|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425887|758883003881882034|253.36869753197701|63.066468570353798|-0.129641546224775|-0.43400771692072199|0.89153259679369701|23.042648|21.142336|19.91153|18.571793|17.808321|0.60110515|0.0368976|2.4274964E-2|1.5677318E-2|2.4933683E-2|0.15001532|0.11037985|8.0056675E-2|6.0704552E-2|4.3040283E-2|6|1|9843|17592454611200|142606593|268435456|158329942966272|268435456|268468224|260.39801|768.74426|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425925|758883003881947511|253.56351252175801|63.094386198996901|-0.12804217205582599|-0.43402930713256299|0.89175319608356496|23.096298|21.098391|19.760561|18.900772|18.381124|0.63231987|3.5632361E-2|1.9229682E-2|1.7459806E-2|3.2583114E-2|0.13029158|9.5867306E-2|6.9530964E-2|5.2723225E-2|3.7381425E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|348.52411|1605.2751|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425933|758883003881882031|253.352110690671|63.051368371730199|-0.12983449337511099|-0.43419526609191|0.89141318995929397|22.659101|21.384928|20.161451|19.594652|19.197071|0.43531445|4.4901919E-2|2.3782516E-2|2.4541676E-2|5.7452649E-2|0.16367579|0.12043109|8.7346673E-2|6.6232339E-2|4.6959553E-2|6|1|9843|268566784|142606593|268435456|268566528|268468224|268435456|358.7533|650.96857|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151425980|758883003881947507|253.55962692930001|63.078302890234198|-0.12814244622610399|-0.434260692333924|0.89162613497409904|22.767611|21.866318|20.310385|18.488796|17.45837|0.78528273|6.7013793E-2|2.8432332E-2|1.5377229E-2|2.2307191E-2|0.13084632|9.6275486E-2|6.9827013E-2|5.2947707E-2|3.7540585E-2|6|1|9843|87961198788880|228698829799697|268468240|268468240|268468240|402685968|476.21057|1532.1967|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151426043|758883003881947537|253.67344514410701|63.073253224176099|-0.12730162376076801|-0.43458980208710402|0.89158622718712|23.861057|21.345009|19.880537|18.599792|17.940292|1.4076704|4.3403994E-2|2.1045014E-2|1.5866084E-2|2.6155006E-2|0.12481567|9.1838181E-2|6.6608712E-2|5.0507367E-2|3.5810355E-2|6|1|9843|268571392|140737622709505|268435456|268435456|268468224|402686464|704.74109|1943.5953|0|0|0|0|0|5739151425536|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151491178|5739151491178|253.4845428077|62.914264879662397|-0.12943656542047899|-0.43653802178343398|0.89032619363329801|18.978828|18.682375|18.923817|19.090887|19.392565|2.3423461E-2|0.01440481|1.6799137E-2|1.6919963E-2|6.5830715E-2|0.25015947|0.18406495|0.13349926|0.10122845|7.1772233E-2|6|1|26227|268567040|268468224|268468736|268599296|268468224|402686464|358.67545|651.3609|0|1048580|0|4|0|5739151491072|51638.389380200002|3|0|87899|0|0.0|0|0.0|-5.1810574525267761|1|0
5739151491190|5739151491190|253.50523051700901|62.898602407623002|-0.12934803462448799|-0.43681807739522799|0.89020169242678904|19.519773|18.371378|17.864836|18.084942|18.548098|3.2748282E-2|1.3909594E-2|1.5028591E-2|1.1160663E-2|3.5163384E-2|0.2534402|0.1864789|0.13525005|0.10255602|7.2713494E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|523.53436|672.65424|0|8388613|1|4|0|5739151491072|51638.389380200002|3|0|87899|0|0.0|0|0.0|4.5200201872196573|1|0
5739151491744|587725490523341606|253.780365205176|62.877633755209601|-0.12733993913303299|-0.43774696130076801|0.89003490817694297|25.104958|21.299419|20.392517|20.082542|19.957994|1.1983111|4.2423174E-2|3.2017231E-2|3.4521464E-2|0.10635788|0.20207775|0.14868689|0.10784014|0.08177191|5.7977304E-2|6|1|9843|70369012613464|70369155252505|268468248|268468248|268468248|402685976|1151.2548|1642.1969|0|0|0|0|0|5739151491072|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151556691|5739151556691|253.82084501203499|62.733145344385498|-0.12765564016528599|-0.43999101997107798|0.88888241060266304|18.172756|17.117708|16.948015|16.958084|16.989567|0.02006799|9.2155766E-3|1.9594016E-2|1.7350897E-2|2.5031906E-2|0.2995964|0.22044018|0.15988161|0.12123338|8.5955977E-2|6|1|26227|268435456|268468224|268468224|268468224|285245440|268468224|1063.7649|1276.5852|0|8196|0|4|0|5739151556608|51638.3897947|3|0|87899|0|0.0|0|0.0|3.3744856718387979|1|0
5739151556766|5739151556766|253.907419315406|62.7941549280619|-0.126728233362459|-0.43927374714649697|0.88936973747519998|19.273706|18.953695|18.805998|18.622057|18.577158|3.1479996E-2|1.1708135E-2|2.1305924E-2|1.9937934E-2|0.04041047|0.26430264|0.19447137|0.14104687|0.10695156|7.5829998E-2|6|1|26227|268435968|268468224|268468224|268468224|268468224|402686464|695.97626|1826.9589|0|1048580|0|4|0|5739151556608|51638.3897947|3|0|87899|0|0.0|0|0.0|-24.691538270673483|1|0
5739151622524|758883003345011136|253.76299095429101|62.666513583022301|-0.12838880638537301|-0.44085408695396799|0.88834902398264703|24.858747|22.35528|21.229685|19.625042|18.748079|1.3091729|0.11743584|6.0479976E-2|2.4768133E-2|4.3286216E-2|0.23382901|0.17204916|0.1247844|9.4620235E-2|6.7086928E-2|6|1|9843|87961198793048|70369155219737|228698695536921|268435480|268468248|268435480|163.89484|814.65723|0|0|0|0|0|5739151622144|51638.3902094|3|0|0|0|0.0|0|0.0|0.0|0|0
5739151687772|5739151687772|254.11380117885901|62.540738776725298|-0.12622064827169499|-0.44350646186897202|0.88733892410416604|18.134552|18.027355|17.655365|17.260349|17.31271|1.7935021E-2|1.4064333E-2|9.8927505E-3|1.3643278E-2|2.2535343E-2|0.16953669|0.12474349|9.0474382E-2|6.8603985E-2|4.8641082E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|411074560|431.40067|1713.2014|0|68|0|4|0|5739151687680|51638.390623899999|3|0|87897|0|0.0|0|0.0|-22.940234085509708|1|0
5739151753365|5739151753365|254.26709461384601|62.293407294677202|-0.12607106995380599|-0.447525344551302|0.88534013311548299|19.821301|19.013666|18.823523|18.442463|18.417511|5.8125388E-2|1.2956536E-2|8.0781013E-2|1.9270433E-2|3.7861243E-2|0.27805158|0.20458771|0.14838408|0.11251515|7.9774648E-2|3|1|26231|268566544|276856848|268599312|268468240|268468240|402685968|1392.6063|1428.6235|0|4|0|4|0|5739151753216|51638.391038599999|3|0|87897|0|0.0|0|0.0|-19.218462337507447|1|0
5739151949965|5739151949965|254.36366553200801|61.914007160738002|-0.12689396774202899|-0.45337290919373302|0.88224198843622004|18.741102|18.47864|18.907043|19.043818|19.198717|6.3577503E-2|1.2047854E-2|1.4011338E-2|1.6353294E-2|5.6506984E-2|0.24702704|0.18176015|0.13182762|9.9960893E-2|7.0873521E-2|6|1|26227|17592454610944|268468224|268468224|268468224|17592454643712|402685952|648.35089|465.77966|0|1048580|0|4|0|5739151949824|51638.392282499997|3|0|88002|0|0.0|0|0.0|5.4814917448368448|1|0
5739151949997|5739151949997|254.59305223326899|61.9152620273384|-0.125072719586905|-0.45385867297045102|0.88225229939322702|19.538033|19.489611|19.30102|19.047817|18.652578|6.8744257E-2|1.5054081E-2|1.6309742E-2|1.7139997E-2|0.03788057|0.2056676|0.15132827|0.10975588|8.3224565E-2|5.9007253E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1016.2524|1375.9402|0|4|0|4|0|5739151949824|51638.392282499997|3|0|88002|0|0.0|0|0.0|-22.984381761437497|1|0
5739152015449|5739152015449|254.53475235984601|61.833884834850402|-0.12586847449693001|-0.45493840785317102|0.88158276536456703|19.638899|19.194944|18.490227|18.031|17.75106|5.9760284E-2|1.5984036E-2|1.2442284E-2|0.01795179|2.4098884E-2|0.24466099|0.18001923|0.13056496|9.9003457E-2|7.0194684E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|242.36008|860.3338|0|4|0|4|0|5739152015360|51638.392697199997|3|0|88002|0|0.0|0|0.0|-24.005171118989587|1|0
5739152015516|5739152015516|254.622330049456|61.747644940366399|-0.12552468009772799|-0.45640917894576299|0.88087128234516598|19.054972|18.554958|18.29023|17.992001|17.995007|5.3862225E-2|1.4632259E-2|1.2014529E-2|1.7902302E-2|2.6517881E-2|0.22737603|0.16730112|0.12134073|0.092009|6.5235525E-2|3|1|26227|268566544|268468240|268468240|276856848|268599312|402685968|1110.9868|905.83563|0|68|0|4|0|5739152015360|51638.392697199997|3|0|88002|0|0.0|0|0.0|-20.978640914760405|1|0
5739152016053|99020112010412032|254.574896103507|61.780837598863798|-0.125766736483574|-0.45581310123250401|0.88114535959685902|22.862757|23.260681|21.803894|21.56669|20.890099|0.50443834|0.20996372|0.10151862|0.11960419|0.24024568|0.2503767|0.18422481|0.1336152|0.10131636|7.1834564E-2|3|1|26227|268435712|134251777|142639361|268469504|402687232|134266881|753.53375|833.34503|0|64|0|0|0|5739152015360|51638.392697199997|3|0|88002|0|0.0|0|0.0|-25.444617575036879|0|0
5739152081054|5739152081054|254.97628986807999|61.625624003020597|-0.123188720458953|-0.458986728067169|0.87986119508129301|19.243839|18.076281|18.007406|18.06513|18.131044|6.6385403E-2|2.2663182E-2|8.6478293E-3|1.4605007E-2|5.9587501E-2|0.1532784|0.11278079|8.1798039E-2|6.2024973E-2|4.3976478E-2|6|1|26227|268435456|276856832|268468224|276856832|268468224|402685952|1356.9792|1893.4822|0|1056772|0|4|0|5739152080896|51638.393111799996|3|0|88002|0|0.0|0|0.0|4.5407397154178994|1|0
5739152147215|99020111368683520|254.656868959066|61.468891485986802|-0.12638200071622599|-0.46061218576825902|0.87855791170346398|22.919743|23.819761|22.633417|22.403439|21.065199|0.55762482|0.32606283|0.1758616|0.23857066|0.27473462|0.40876481|0.30076528|0.21814007|0.165409|0.11727704|3|1|26227|70369012744464|70369180484881|70369180484881|436438288|70369180484881|70369180483601|786.16669|70.384613|0|64|0|0|0|5739152146432|51638.393526499996|3|0|88002|0|0.0|0|0.0|-19.715427672454062|0|0
5739152212019|99019746153857024|255.027075278334|61.358872575627203|-0.123838850839359|-0.46304803102426401|0.87763913995863896|24.833466|21.992462|20.278494|19.536251|19.002447|1.3066094|8.1436247E-2|3.1091699E-2|2.2883119E-2|4.7296889E-2|0.15295492|0.11254279|8.1625417E-2|6.1894078E-2|4.3883674E-2|3|1|26227|87961198788952|70369180419385|228698729120025|70369046200345|302022680|302022680|965.5|1178.7106|0|67108896|0|0|0|5739152211968|51638.393941100003|3|0|88002|0|0.0|0|0.0|-24.350632086514317|0|0
5739152212084|5739152212084|254.85172437840799|61.416773913896797|-0.12502357361663899|-0.46181052720908|0.87812307964145697|19.785509|19.256897|18.843735|18.409382|18.460047|5.8019798E-2|1.4944394E-2|1.8386329E-2|1.2124654E-2|3.3063129E-2|0.18288302|0.13456358|9.7596735E-2|0.07400465|5.2470222E-2|3|1|26227|34628304896|268468224|268468224|268599296|268468224|268468224|187.30833|672.57031|0|68|0|4|0|5739152211968|51638.393941100003|3|0|88002|0|0.0|0|0.0|-19.640482473050177|1|0
5739152212144|587725490524061801|254.842355176186|61.2914727173277|-0.125600922927491|-0.463642544499488|0.87707468273220801|19.11561|17.375919|16.648754|16.436399|16.250389|4.9348898E-2|1.2249615E-2|1.6297603E-2|8.9561623E-3|1.8867495E-2|0.1318004|9.6977487E-2|7.0336163E-2|5.3333782E-2|3.7814315E-2|6|1|9843|268435968|402751488|276922880|276922880|268534272|402751488|1225.0568|200.10257|0|0|0|0|0|5739152211968|51638.393941100003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739152277959|5739152277959|255.095875261354|61.258141042663702|-0.123679405988629|-0.464686749764947|0.87679508958888996|22.781265|20.770872|20.248678|19.755306|19.285877|0.48199773|2.7396655E-2|2.8070115E-2|2.7355932E-2|5.8384761E-2|0.14139912|0.10404012|7.5458579E-2|5.7217956E-2|4.0568244E-2|6|1|26227|268436224|142639361|268468224|276856832|268468736|402685952|563.63983|1110.1284|0|1|1|0|0|5739152277504|51638.394355800003|3|0|88002|0|0.0|0|0.0|-27.913319090463503|1|0
5739152408860|5739152408860|255.31453249523699|60.942692290498499|-0.123127058488985|-0.46981788982540201|0.87413435916216897|20.37285|19.794806|19.403215|19.044727|19.018656|6.8693586E-2|1.4655395E-2|1.6219247E-2|1.7604142E-2|5.4706719E-2|0.12185859|8.9662388E-2|6.5030649E-2|0.04931077|0.03496195|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|860.64813|922.06104|0|4|0|4|0|5739152408576|51638.395185200003|3|0|88002|0|0.0|0|0.0|-20.663975382052136|1|0
5739152474178|5739152474178|255.57697961811999|60.851029446480297|-0.121321913435312|-0.47173072958472401|0.87335623435449194|18.314133|17.193178|17.020437|16.967915|16.929689|5.7824846E-2|1.2838759E-2|1.3259369E-2|1.4051451E-2|1.8659012E-2|0.11392748|8.3826758E-2|6.0798153E-2|4.6101399E-2|3.2686468E-2|6|1|26227|268567040|268599296|276857344|276856832|268468224|411075072|704.48834|1688.6759|0|4|0|4|0|5739152474112|51638.395599800002|3|0|88002|0|0.0|0|0.0|3.4594485166874307|1|0
5739152474276|5739152474276|255.506022844151|60.7961792120729|-0.122115221887061|-0.47238937289011301|0.87288954224687598|18.893114|18.747171|18.502428|18.265902|18.627235|5.9551958E-2|1.4154845E-2|1.4781022E-2|1.5881624E-2|3.6010452E-2|0.10793623|7.9418458E-2|5.7600889E-2|0.04367701|3.0967545E-2|3|1|26227|268566544|268599312|268599312|268599312|268468240|268468240|1051.4633|1211.6744|0|68|0|4|0|5739152474112|51638.395599800002|3|0|88002|0|0.0|0|0.0|-20.975634124584772|1|0
5739152539753|587725490524389572|255.61053319790801|60.722867201184201|-0.121530819405577|-0.47369279932307901|0.87226451939997796|19.524921|18.91548|18.4056|18.27203|18.113605|4.3093938E-2|1.5194988E-2|1.4564898E-2|1.0796267E-2|2.5768474E-2|0.11074076|8.1481993E-2|0.05909754|4.4811875E-2|3.1772178E-2|3|1|26227|268566800|268469520|268468240|268469520|268468240|268599312|481.2872|1395.7239|0|64|0|0|0|5739152539648|51638.396014400001|3|0|88002|0|0.0|0|0.0|0.0|0|0
5739152605293|5739152605293|255.435836795201|60.550190068410899|-0.123635048115671|-0.47586223840334202|0.87078671610170799|18.484859|18.598797|18.654764|18.364155|18.27062|4.1543964E-2|1.0698004E-2|9.7292075E-3|9.7107617E-3|2.7404593E-2|9.8091856E-2|7.2175056E-2|5.2347373E-2|3.9693426E-2|2.8143134E-2|6|1|26227|268566528|276856832|268599296|268468224|268468224|402685952|290.0304|89.605682|0|4|0|4|0|5739152605184|51638.396429200002|3|0|88000|0|0.0|0|0.0|-28.095431090892923|1|0
5739152670781|587725490524520572|255.72757540478099|60.353156211224899|-0.12194799431565|-0.47938488004405899|0.86909080277467798|18.165728|17.157114|17.162945|17.237297|17.235909|2.7778653E-2|9.2837289E-3|1.3320558E-2|5.2492595E-3|2.6845958E-2|0.10037167|7.3852524E-2|5.3564012E-2|4.0615968E-2|2.8797228E-2|6|1|26227|34628174336|268468224|285245952|268468224|268468224|268468224|1077.2377|640.86969|0|8192|0|0|0|5739152670720|51638.396843800001|3|0|88000|0|0.0|0|0.0|0.0|0|0
5739152736377|5739152736377|255.951672496264|60.301181543772699|-0.12026340232110901|-0.48062277966038403|0.86864173151747504|19.855431|18.778416|17.024113|16.799425|16.616011|4.4048261E-2|3.8204551E-2|1.2420031E-2|1.8867861E-2|1.9865777E-2|9.5789477E-2|7.0480987E-2|5.1118691E-2|3.8761757E-2|2.7482567E-2|6|1|26227|34628305424|276856848|268599824|268468240|268468240|402686480|525.02838|1405.743|0|5|1|4|0|5739152736256|51638.397258500001|3|0|88000|0|0.0|0|0.0|3.2982985380497354|1|0
5739152736379|99582731029053440|255.95605158935999|60.301699288016401|-0.120224763392191|-0.48062435519416102|0.86864620845398699|21.746281|21.208611|20.744497|20.482571|20.184643|0.18627866|0.25696215|0.58942842|6.1797392E-2|0.47580785|9.5726736E-2|7.0434824E-2|5.1085211E-2|3.8736369E-2|2.7464567E-2|3|1|26227|70369012744536|276857112|268599320|268469528|268468248|70369146864921|527.58783|1425.7389|0|64|0|0|0|5739152736256|51638.397258500001|3|0|88000|0|0.0|0|0.0|-14.229223554278967|0|0
5739152802001|587725490524651638|255.81790293042599|60.106479469352898|-0.122107697584685|-0.48319975593600001|0.86695311641054595|19.752316|19.61569|19.475222|19.050493|19.05905|3.9332267E-2|1.5404184E-2|1.6263643E-2|1.6657375E-2|5.0857496E-2|0.08153186|5.9990369E-2|0.04351002|3.2992329E-2|2.3391973E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|591.15302|195.17406|0|33554432|0|0|0|5739152801792|51638.3976731|3|0|0|0|0.0|0|0.0|0.0|0|0
5739152802193|587725490524652074|256.13615685041702|60.211504647935101|-0.119040869986313|-0.48232688299736498|0.86786522525732501|23.789194|21.527267|20.55085|20.192053|19.653955|0.98009628|0.04970352|3.3241238E-2|3.6408748E-2|8.3689034E-2|8.8186309E-2|6.4886652E-2|4.7061209E-2|3.5685092E-2|2.5301173E-2|6|1|9843|268435712|134219009|268435456|268435456|268435456|268435456|225.78889|1884.2988|0|0|0|0|0|5739152801792|51638.3976731|3|0|0|0|0.0|0|0.0|0.0|0|0
5739152867762|587725490524717437|256.16177089090002|60.029287910137903|-0.119484786173152|-0.48505755327725297|0.86628087586061897|23.897396|21.538546|20.244204|19.510538|19.778221|1.0545189|5.0206795E-2|2.8382363E-2|2.4999933E-2|0.20013957|0.10033416|0.07382492|5.3543992E-2|4.0600788E-2|2.8786464E-2|6|1|9843|17592454611200|134219009|268435456|268435456|268435456|158329942966272|451.13489|1391.9152|0|0|0|0|0|5739152867328|51638.398087900001|3|0|0|0|0.0|0|0.0|0.0|0|0
5739152932956|5739152932956|256.15491342101001|59.907051993901099|-0.11998482274168799|-0.48683658891959197|0.86521314021504603|25.829668|25.108377|20.794939|19.779572|21.062366|0.82232839|0.58733594|0.26374304|0.18842338|0.68050051|0.10358091|7.6213852E-2|0.05527664|4.1914605E-2|2.9717976E-2|6|1|26227|70369012744976|70369155252529|411074864|276856848|268599824|411074576|115.25136|960.16199|0|1|1|0|0|5739152932864|51638.398502700002|3|0|88065|0|0.0|0|0.0|6.275292098840751|1|0
5739152998523|5739152998523|256.14369414606898|59.716052301562002|-0.120770223801829|-0.48961069301492099|0.86353686796123796|19.454926|18.915642|18.827765|18.866888|19.144102|3.3113658E-2|9.6667213E-3|0.01604322|4.0372077E-2|0.11394927|9.5214948E-2|7.0058249E-2|5.0812088E-2|3.8529269E-2|2.7317731E-2|6|1|26227|70369012744208|268599312|268468240|268468240|70369012645905|70369012645905|354.83917|282.62711|0|4|0|4|0|5739152998400|51638.3989172|3|0|88065|0|0.0|0|0.0|5.3659941557255166|1|0
5739153064189|5739153064189|256.323906629497|59.5962601555078|-0.119656263571267|-0.49174132324898501|0.86248063723048396|19.594748|19.312935|19.149916|18.77902|18.964525|4.2072643E-2|2.1168452E-2|1.6086632E-2|1.4656855E-2|0.04939732|9.8603375E-2|7.2551422E-2|5.2620344E-2|3.9900415E-2|2.8289892E-2|3|1|26227|34628309008|268468240|268468240|268599312|268603408|268468240|308.25427|661.15613|0|4|0|4|0|5739153063936|51638.399331799999|3|0|88065|0|0.0|0|0.0|-20.118334094298099|1|0
5739153064236|5739153064236|256.64868766513098|59.558799667076002|-0.116997112092843|-0.49296024213077799|0.86214956674599097|20.320465|19.658913|19.202911|18.833015|18.661901|6.0386002E-2|2.2103449E-2|1.6355366E-2|1.5262887E-2|3.9374616E-2|0.11755964|8.6499266E-2|6.2736481E-2|4.7571175E-2|3.3728555E-2|3|1|26227|268566544|268599312|268468240|268468240|268468240|268468240|1159.4016|1935.8022|0|4|0|4|0|5739153063936|51638.399331799999|3|0|88065|0|0.0|0|0.0|-20.929266816153564|1|0
5739153260659|5739153260659|256.75193331749102|59.178121554716903|-0.117418764103639|-0.49873509323426601|0.85876431028133804|18.817345|18.73386|18.755426|18.478409|18.462286|3.6990616E-2|1.4821996E-2|1.0966734E-2|1.2247938E-2|0.02876802|0.16251691|0.1195784|0.08672823|6.5763392E-2|4.6627063E-2|6|1|26227|17592454610944|268468224|268468256|17592454643712|268468224|402685952|482.53192|1155.7343|0|1048580|0|4|0|5739153260544|51638.400575799998|3|0|88065|0|0.0|0|0.0|-28.02131364566246|1|0
5739153260694|587725490525110580|256.59060973786598|59.068442110867899|-0.11920356469192001|-0.500000683297667|0.85778192267417597|21.188471|19.38084|19.087412|18.976376|18.934801|0.12921669|1.6325725E-2|1.3087496E-2|1.5276025E-2|4.4067584E-2|0.19131128|0.14076503|0.10209454|7.7415198E-2|5.4888342E-2|6|1|9843|268567040|268468224|268599296|268468224|268468224|268468736|1148.5555|97.93045|0|0|0|0|0|5739153260544|51638.400575799998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739153260790|5739153260790|256.847180224346|59.174584007102702|-0.116601583743391|-0.49898122751269602|0.85873267392038599|27.662472|21.849215|20.491056|19.473297|18.969744|0.15680681|6.6288225E-2|3.2547679E-2|2.1773595E-2|4.2979196E-2|0.14749995|0.10852905|7.8714326E-2|5.9686691E-2|4.2318605E-2|6|1|26227|2207881625856|402654465|268435456|268435456|268468224|268468224|668.745|1559.6774|0|4|0|4|0|5739153260544|51638.400575799998|3|0|88065|0|0.0|0|0.0|-3.7031842017381109|1|0
5739153326185|5739153326185|256.81479932500702|58.947963006694202|-0.117657396216757|-0.50221832943893396|0.85669918097956599|18.040199|17.11817|17.076605|17.036552|17.039686|1.9847626E-2|8.5373344E-3|8.5925329E-3|9.6943378E-3|2.4756584E-2|0.18393509|0.13533768|9.8158181E-2|7.4430376E-2|5.2772064E-2|6|1|26227|268567040|268468224|268468736|268599296|268468224|268468224|1183.4672|691.02563|0|4|0|4|0|5739153326080|51638.400990399998|3|0|88065|0|0.0|0|0.0|3.4997565153446573|1|0
5739153326273|5739153326273|256.65620544046499|58.9827234976173|-0.118927100701716|-0.50138492479889696|0.85701196135356705|18.587189|18.256166|18.343597|18.398535|18.542305|2.2913355E-2|9.6407523E-3|1.0358584E-2|1.2475925E-2|0.03902252|0.17549098|0.12912458|9.3651921E-2|7.1013413E-2|5.0349396E-2|6|1|26227|268566528|268599296|268468224|268468224|268468224|268468224|625.15314|107.50175|0|1048580|0|4|0|5739153326080|51638.400990399998|3|0|88065|0|0.0|0|0.0|4.8651568296757119|1|0
5739153326444|5739153326444|256.83362047809402|59.0000886891292|-0.117314836845567|-0.50149783741728104|0.85716809793743998|20.314825|19.806108|19.333559|18.941504|18.919899|6.0777359E-2|0.0158638|1.5136845E-2|1.5966993E-2|4.8279554E-2|0.20640773|0.15187284|0.11015085|8.3524056E-2|5.9219599E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|770.75317|940.8396|0|4|0|4|0|5739153326080|51638.400990399998|3|0|88065|0|0.0|0|0.0|-21.577745823958971|1|0
5739153326462|587725490525176097|256.71935795768701|58.954800216035302|-0.118470325311495|-0.50192214203649299|0.85676072818149596|21.724104|19.436138|18.978582|18.651524|18.510328|0.19157781|1.3342919E-2|1.2789901E-2|1.3780112E-2|3.8241539E-2|0.17577992|0.12933721|9.3806125E-2|7.1130343E-2|5.0432302E-2|6|1|9843|268435472|402685968|268468240|268468240|268468240|402685968|967.33014|294.38895|0|0|0|0|0|5739153326080|51638.400990399998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739153391655|5739153391655|256.89137293297699|58.8499244782193|-0.11731838613401099|-0.50380208460669296|0.85581531642105002|17.114035|16.015469|15.856769|15.769676|15.731784|1.6162943E-2|1.3757014E-2|1.5393033E-2|1.1527201E-2|2.1326564E-2|0.15247856|0.11219227|8.1371196E-2|6.1701313E-2|0.043747|6|1|26227|268435984|268468240|268468240|268468240|268468240|268468752|783.4541|713.474|0|4|0|4|0|5739153391616|51638.401405099998|3|0|88065|0|0.0|0|0.0|-3.3525276027469566|1|0
5739153457198|5739153457198|256.98747346619501|58.6553025431067|-0.117127094080742|-0.50682761547252297|0.85405328406759096|16.911865|15.813768|15.768931|15.712799|15.777859|2.7172087E-2|1.0283103E-2|9.5790857E-3|1.5195816E-2|1.3555577E-2|0.151474|0.11145313|8.0835111E-2|6.1294816E-2|4.3458786E-2|6|1|26227|268567056|268468240|268468240|268599312|268468240|268468752|1238.5507|516.60016|0|4|0|4|0|5739153457152|51638.401819699997|3|0|88065|0|0.0|0|0.0|2.1891390684452432|1|0
5739153522721|587725490525372480|256.99287514108198|58.580641778368999|-0.11732969397425599|-0.50792256687312798|0.85337471779571705|19.355627|19.331041|18.914072|18.96587|18.108753|4.0892422E-2|0.01398516|1.6221328E-2|1.5038704E-2|2.8333882E-2|0.151978|0.11182398|8.1104077E-2|6.1498765E-2|0.04360339|3|1|26227|269091344|268468240|268992560|268468240|268468752|268468240|522.45984|302.66333|0|5120|0|0|0|5739153522688|51638.402234399997|3|0|88065|0|0.0|20111|2.8999999165534973E-2|0.0|0|0
5739153653977|5739153653977|257.27328642051299|58.2382855297041|-0.11596375978409899|-0.51345544429617096|0.85024461958859698|19.039301|18.73065|18.872396|18.604137|18.598635|2.5284378E-2|9.4295535E-3|1.0796048E-2|1.7671606E-2|3.5946276E-2|0.12237887|9.0045206E-2|6.5308295E-2|4.9521305E-2|3.5111222E-2|6|1|26227|268567040|268468224|268468736|268468224|268599296|268468224|1183.1434|470.01578|0|1048580|0|4|0|5739153653760|51638.403063500002|3|0|88063|0|0.0|0|0.0|-24.780552932951565|1|0
5739153719317|587725490525569054|257.56873792164703|58.259573384285197|-0.113246533056255|-0.51373806233295305|0.85044013667107798|20.863111|20.349787|19.437521|19.108219|18.865423|9.2725322E-2|2.2423228E-2|0.01676596|2.1341426E-2|4.1783269E-2|0.15477175|0.11387958|8.2594968E-2|0.06262926|4.4404928E-2|3|1|9847|269090832|268992528|268992528|269123600|268992528|268992528|125.56235|1863.9441|0|0|0|0|0|5739153719296|51638.403478200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739153719375|5739153719375|257.54148156207901|58.130071529439199|-0.11390530202299499|-0.51555974817476902|0.84924892006585395|23.58267|25.112785|18.618565|18.094276|17.672077|0.89163429|0.55287158|0.75598735|0.6099804|0.59821731|0.12422681|9.1404907E-2|6.6294461E-2|5.0269082E-2|3.5641406E-2|6|1|26227|70403372486928|70369146864913|411074864|276992016|268468240|402685968|1187.5356|1338.0597|0|1|1|0|0|5739153719296|51638.403478200002|3|0|88063|0|0.0|0|0.0|4.5816428068485635|1|0
5739153719663|587725490525569256|257.49438196727499|58.252132906344698|-0.113937057230482|-0.51369847772138499|0.85037181337129797|24.745571|19.789894|19.21154|19.106218|19.00421|1.3113686|1.7572073E-2|1.5734628E-2|2.1204263E-2|4.6304613E-2|0.1473788|0.10843992|7.8649677E-2|5.9637669E-2|4.2283852E-2|6|1|9847|268435712|134219009|268468224|268435456|268468224|268435456|67.630447|1506.7019|0|0|0|0|0|5739153719296|51638.403478200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739153720025|5739153720025|257.55210970136898|58.143597075078297|-0.113766449212477|-0.51538508846743902|0.84937353715488095|22.752771|22.23554|20.601103|18.941236|17.919029|0.46570119|7.8698069E-2|3.6446266E-2|1.9626547E-2|2.3096424E-2|0.12861876|9.4636455E-2|0.06863825|0.05204631|3.6901481E-2|6|1|26227|70369012744464|70369155252497|268599312|268468240|268468240|268468240|1089.3962|1428.2012|0|4|0|4|0|5739153719296|51638.403478200002|3|0|88063|0|0.0|0|0.0|5.4268252256718057|1|0
5739154112573|5739154112573|257.96704135764901|57.278832913708698|-0.112691038628431|-0.52867409093526896|0.84131114065285795|19.145956|19.255676|19.264486|18.987949|18.931767|3.1890139E-2|1.5491047E-2|2.9599207E-2|0.02295348|4.9539577E-2|0.10583489|7.7872306E-2|5.6479491E-2|0.04282669|3.0364655E-2|6|1|26227|17592454610960|268468240|268468240|158329942999056|268468240|402685968|1003.4435|653.84668|0|4|0|4|0|5739154112512|51638.405965899998|3|0|88224|0|0.0|0|0.0|-27.408965379564343|1|0
5739154112580|587725490525962342|258.163379347861|57.287478832102401|-0.11085270736333599|-0.52893288938999306|0.84139270010606304|20.071758|19.057684|18.626514|18.55798|18.373301|0.05290113|1.2214713E-2|1.5083429E-2|0.0227452|3.3158965E-2|0.12429912|9.1458112E-2|6.6333055E-2|5.0298344E-2|3.5662152E-2|6|1|9843|269091344|268468240|268992528|269123600|403210800|268992528|1251.7543|1589.3635|0|0|0|0|0|5739154112512|51638.405965899998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739154243779|5739154243779|258.32629617412999|57.040520155670897|-0.110081056654458|-0.53279261863256699|0.83905553242707998|25.365541|20.25713|17.950836|17.428236|15.597739|1.1441246|0.37498257|0.11893822|0.3057186|9.3094245E-2|0.10618593|7.8130595E-2|5.6666825E-2|4.2968739E-2|0.03046537|6|1|26227|70369012613392|70369155252497|70369012645905|70369012645905|70369012645905|268468240|915.00671|1601.3325|0|4|0|4|0|5739154243584|51638.406795100003|3|0|88224|0|0.0|0|0.0|3.9229018095341104|1|0
5739154374787|5739154374787|258.52304005494898|56.784822129213303|-0.108994872736652|-0.53683179628983502|0.83661923251222803|18.605154|18.277836|18.292143|18.551449|18.60243|1.7983476E-2|7.2194128E-3|1.1827867E-2|0.0203651|4.1732989E-2|0.10534842|7.7514365E-2|5.6219883E-2|4.2629834E-2|3.0225083E-2|6|1|26227|34628173824|268468224|268468224|268468224|268468224|402685952|709.58099|1753.639|0|9437188|0|4|0|5739154374656|51638.407624300002|3|0|88224|0|0.0|0|0.0|-3.623905417452427|1|0
5739154374888|587725490526224636|258.46365008669102|56.749981113138297|-0.109652989816011|-0.53721689256724603|0.836285975109473|20.769293|20.362669|19.449093|19.211391|19.084782|8.2134478E-2|1.9745402E-2|1.7363211E-2|0.02418883|5.4190665E-2|9.9603891E-2|7.3287599E-2|5.3154279E-2|4.0305283E-2|2.8576946E-2|3|1|26227|34628173824|268468224|268468224|268468224|268468224|402685952|911.73566|1369.9385|0|33554432|0|0|0|5739154374656|51638.407624300002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739154505949|587725490526355808|258.67306141875298|56.4251690180186|-0.108618197528669|-0.54225400935863499|0.83316425541432604|21.971678|19.866335|18.657444|18.149694|18.173819|0.234201|0.01757147|2.0592339E-2|1.3393524E-2|4.4169892E-2|0.12803596|9.4207637E-2|6.8327241E-2|5.1810477E-2|3.6734272E-2|6|1|9843|17626814349568|134251777|268468224|268468224|268468224|158330077216768|1322.9443|1391.7876|0|0|0|0|0|5739154505728|51638.408453600001|3|0|0|0|0.0|0|0.0|0.0|0|0
5739154571413|5739154571413|258.81265794585102|56.366255523310102|-0.107462874330745|-0.54335716159493597|0.83259517509055303|19.487432|19.116667|18.967587|18.740786|18.572666|4.0217962E-2|1.1947505E-2|1.2778164E-2|1.5291525E-2|0.04104881|0.12796547|9.4155774E-2|6.8289623E-2|5.1781952E-2|3.6714051E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|696.75092|1881.1309|0|1048580|0|4|0|5739154571264|51638.408868099999|3|0|88222|0|0.0|0|0.0|-24.242774415815077|1|0
5739154571466|5739154571466|258.62548647905601|56.256646949598398|-0.109551244333225|-0.54456370931373799|0.83153405905200595|19.341454|18.887672|18.798594|18.551796|18.465744|3.8057588E-2|1.1315947E-2|1.1568509E-2|1.4350533E-2|3.9171461E-2|0.10508678|7.7321857E-2|5.6080259E-2|4.2523962E-2|0.03015002|6|1|26227|268566544|268468240|268468240|268599312|268468240|402685968|1332.2484|663.68817|0|4|0|4|0|5739154571264|51638.408868099999|3|0|88222|0|0.0|0|0.0|-27.669149702705049|1|0
5739154637024|5739154637024|258.86621824176501|56.288559630151497|-0.107172815054822|-0.54456467112962903|0.83184331858271499|20.164003|19.892891|19.244724|18.919888|18.562744|0.06586352|1.8298155E-2|1.7850956E-2|1.9973237E-2|3.5717648E-2|0.13097262|9.6368417E-2|6.9894418E-2|5.2998818E-2|3.7576824E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|91.438553|1907.048|0|4|0|4|0|5739154636800|51638.409282699999|3|0|88222|0|0.0|0|0.0|-22.407644885112148|1|0
5739154637365|587725490526487252|258.78219723936002|56.1676019359669|-0.108312664468493|-0.54612827018643895|0.83066977748013904|23.11079|20.858536|20.389442|20.203424|20.181828|0.63088995|2.9843552E-2|3.0632284E-2|3.6812741E-2|0.12639068|0.12017846|8.8426173E-2|6.4134032E-2|4.8630897E-2|3.4479912E-2|6|1|9843|268435712|142606593|268435456|268435456|268468224|268435456|994.51501|1148.524|0|0|0|0|0|5739154636800|51638.409282699999|3|0|0|0|0.0|0|0.0|0.0|0|0
5739154702465|5739154702465|258.92048353259901|56.115286763922001|-0.1071399515258|-0.54713219424094695|0.83016106437976001|18.872038|18.832232|18.535904|18.43503|17.962095|4.1888207E-2|2.3491517E-2|0.10837164|0.0635195|2.2300987E-2|0.13084318|9.6273169E-2|6.9825329E-2|5.2946433E-2|3.7539683E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|310.25238|1657.6049|0|4|0|4|0|5739154702336|51638.409697399999|3|0|88222|0|0.0|0|0.0|-22.951830082859367|1|0
5739154702743|587725490526552643|258.682999433737|56.0780088327488|-0.109512790414905|-0.54721291743178702|0.82979815119782796|24.56916|21.443985|20.279654|20.090635|20.265503|1.2895246|4.4931222E-2|3.0552177E-2|4.3025143E-2|0.134463|0.11394074|8.3836511E-2|6.0805231E-2|4.6106767E-2|3.2690272E-2|6|1|26227|17592454611200|134219009|276856832|268435456|158329951387648|268435456|240.75386|408.17865|0|33554432|0|0|0|5739154702336|51638.409697399999|3|0|0|0|0.0|0|0.0|0.0|0|0
5739154768000|587725490526617826|258.76565121625998|55.884107682427199|-0.10926977644644401|-0.55012159009268102|0.82790479650092896|19.653721|19.295494|19.009041|19.158091|18.968416|4.0362984E-2|2.2871388E-2|1.5419724E-2|1.7586926E-2|5.8848035E-2|0.12916794|9.5040545E-2|6.8931334E-2|5.2268542E-2|0.03705905|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|683.16266|230.83105|0|42991616|0|0|0|5739154767872|51638.410111999998|3|0|88365|0|0.0|0|0.0|-25.600177755339878|0|0
5739155030554|587725490526879992|259.234613363346|55.298115553025902|-0.106339556830103|-0.55928692247032497|0.82212531709396297|22.775969|20.4844|20.065487|19.792376|19.702143|0.46873009|2.2030864E-2|2.5769994E-2|2.6559941E-2|8.4806062E-2|0.14002897|0.10303199|7.4727386E-2|5.6663517E-2|0.04017514|6|1|26227|268435712|142639361|268468224|268435456|268468224|268435456|1058.7053|795.6214|0|2097152|0|0|0|5739155030016|51638.411770600003|3|0|88365|2658|18.340000152587891|0|0.0|-28.067378242491486|0|0
5739155161469|103524642991374336|259.34844775258102|55.100424878852699|-0.105751846546683|-0.56228150249134301|0.82015611861891602|22.442114|22.24465|21.487535|21.452719|22.686678|0.3489162|9.0855174E-2|7.2121926E-2|0.10982659|0.73351002|0.15341476|0.11288112|8.1870802E-2|6.2080152E-2|4.4015601E-2|3|1|26227|70369012613464|70369146864921|276857112|268469560|411074840|70369146864921|228.02901|784.02948|0|64|0|0|0|5739155161088|51638.412599900003|3|0|88365|0|0.0|0|0.0|-19.704043252297666|0|0
5739155423424|5739155423424|259.68268880310399|54.425061012136901|-0.104194212237235|-0.57236065423451699|0.81335530220223995|18.628332|17.57222|17.516541|17.515274|17.564917|4.7962885E-2|7.5878501E-3|0.01319838|1.1882655E-2|4.3416962E-2|0.11586044|8.5249014E-2|6.1829694E-2|4.6883587E-2|3.3241045E-2|6|1|26227|268566544|276856848|268468240|268599312|268468240|402685968|1164.3451|514.70612|0|4|0|4|0|5739155423232|51638.414258500001|3|0|88363|0|0.0|0|0.0|4.0060240629520791|1|0
5739155423536|103524642777464832|259.75838611027001|54.501321889264602|-0.10324536384546|-0.57143197620321096|0.81412891572337098|20.177053|19.80616|19.758442|19.802034|19.689625|6.9477469E-2|1.4547746E-2|2.1202469E-2|2.8460054E-2|9.7303472E-2|0.12463724|9.1706894E-2|6.6513486E-2|5.0435163E-2|3.5759162E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|629.69391|1111.656|0|34603008|0|0|0|5739155423232|51638.414258500001|3|0|88365|0|0.0|0|0.0|-24.504482803885743|0|0
5739155489018|5739155489018|260.02571457055399|54.319486208923799|-0.101025097567569|-0.57444928175735099|0.81228194141561905|18.910053|17.523483|16.884686|16.314386|15.834047|4.4801347E-2|1.0767662E-2|7.0229769E-3|1.6282592E-2|1.6815856E-2|0.1392094|0.10242897|0.07429003|5.6331877E-2|3.9940003E-2|6|1|26227|34628173840|268468240|268468240|268468240|268468240|268468240|1278.0778|1943.8503|0|1|1|0|0|5739155488768|51638.414673200001|3|0|88363|0|0.0|0|0.0|2.7956892851200479|1|0
5739155554481|5739155554481|259.967592615238|54.191654934635302|-0.101923230517824|-0.57612962605414297|0.810978611964288|18.830788|18.582741|18.436821|18.475473|18.275867|3.3303384E-2|1.7985133E-2|2.7549537E-2|1.8590385E-2|2.6805032E-2|0.14333387|0.1054637|7.6491073E-2|5.8000863E-2|4.1123334E-2|6|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|928.33807|1291.6604|0|1048580|0|4|0|5739155554304|51638.4150878|3|0|88363|0|0.0|0|0.0|-26.030894540486564|1|0
5739155554788|587725490527404701|260.03449610344597|54.273883604084403|-0.10104890203787099|-0.57510133020514498|0.81181745447681397|24.776484|21.447481|20.434483|20.149033|19.822821|1.3818029|4.8057728E-2|4.4853993E-2|3.9017569E-2|0.09139704|0.14245602|0.10481779|7.6022603E-2|5.7645641E-2|4.0871479E-2|6|1|9843|17592454611200|142606593|268435456|158329942966272|268435456|268435456|326.01413|1860.4581|0|0|0|0|0|5739155554304|51638.4150878|3|0|0|0|0.0|0|0.0|0.0|0|0
5739155619977|587725490527469816|260.017621523093|54.136830281004798|-0.10155460288910401|-0.57698239261109197|0.81041839888345102|21.708582|19.185987|17.733971|17.003601|17.039156|0.18987426|1.4875939E-2|1.9866476E-2|8.8007068E-3|3.8521089E-2|0.15477625|0.11388289|8.2597375E-2|6.2631086E-2|4.4406224E-2|6|1|9847|17626814349824|411090944|268468224|268468224|268468224|158330093994496|123.54378|1390.9645|0|0|0|0|0|5739155619840|51638.4155025|3|0|0|0|0.0|0|0.0|0.0|0|0
5739155751187|5739155751187|260.26026579369898|53.746440497016998|-0.10004205360940201|-0.58283611644105604|0.80640786757169103|19.684862|19.377499|18.745241|18.220804|18.109129|6.7423314E-2|1.9093305E-2|2.1169128E-2|1.9774396E-2|3.0416958E-2|0.11609086|8.5418552E-2|6.1952658E-2|4.6976823E-2|3.3307154E-2|3|1|26227|268435456|276856832|268468224|268468224|268468224|268468224|1177.5115|1539.6298|0|4|0|4|0|5739155750912|51638.416331699998|3|0|88475|0|0.0|0|0.0|-22.052079450197532|1|0
5739155816457|5739155816457|260.28433267274102|53.711637206105998|-9.9879872752020801E-2|-0.583360792139483|0.80604850797792305|16.805696|15.765783|15.685398|15.639923|15.696374|2.7651792E-2|1.2137359E-2|0.01435239|1.4392097E-2|2.2455424E-2|0.11787675|8.6732589E-2|6.2905706E-2|4.7699492E-2|3.3819534E-2|6|1|26227|268435456|268468224|285245440|276856832|268468224|268468224|157.36197|1566.4938|0|8196|0|4|0|5739155816448|51638.416746399998|3|0|88475|0|0.0|0|0.0|2.1298586729374307|1|0
5739155882162|101272087309582336|260.25412668701802|53.409364797636997|-0.100905850398328|-0.587490976982457|0.80291491536749304|18.876385|18.985025|19.378489|19.704824|19.914354|0.0250999|9.8282285E-3|1.8503204E-2|2.5460312E-2|0.11725937|0.11496489|0.08459007|6.1351776E-2|4.6521194E-2|3.2984108E-2|6|1|26231|268435456|268468224|268468224|268468224|268468224|268468224|1365.0011|573.44318|0|42991616|0|0|0|5739155881984|51638.417160999998|3|0|88475|0|0.0|0|0.0|-27.989348282790594|0|0
5739155947544|5739155947544|260.41477234678098|53.377970721407898|-9.9331492953334405E-2|-0.58820529768332097|0.80258817726461495|23.012127|22.601643|20.318398|19.690935|18.964622|0.60464048|0.26791859|4.7936678E-2|4.2690512E-2|5.7934213E-2|0.11811058|8.6904645E-2|6.3030496E-2|4.7794115E-2|3.3886623E-2|6|1|26227|70369012613392|70369146889489|276857104|268468240|268468240|402685968|539.66284|1316.7302|0|1|1|0|0|5739155947520|51638.417575699998|3|0|88475|0|0.0|0|0.0|6.1807753446903604|1|0
5739155947849|587725490527797596|260.46787341180999|53.438288886582598|-9.8646333677623696E-2|-0.58746351928073504|0.80321573339063501|24.701109|21.992836|20.520271|19.480999|18.561085|1.3390496|7.9949319E-2|3.8488161E-2|2.8416097E-2|4.2905837E-2|0.11689814|8.6012542E-2|6.2383469E-2|4.7303498E-2|0.03353877|6|1|9843|268436224|134219009|268435456|268435456|268435968|268435456|103.36958|1757.0853|0|0|0|0|0|5739155947520|51638.417575699998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739155948175|101272087267639296|260.34698360943997|53.365533723108797|-0.10005656072486201|-0.588259097838988|0.80245867087693201|24.531153|22.99807|21.168333|20.193632|19.534979|1.3367122|0.17120685|0.05825676|4.1080009E-2|8.4332228E-2|0.11969869|8.8073157E-2|0.063878|4.8436753E-2|3.4342263E-2|3|1|26227|2345320579840|134251777|142639361|276857089|268468224|268468736|536.83508|932.36884|0|2097152|0|0|0|5739155947520|51638.417575699998|3|0|88475|2994|3.0899999141693115|0|0.0|-23.079286013607273|0|0
5739156013272|101272087259250688|260.57930879368303|53.2799920383044|-9.7866440423815093E-2|-0.58984121744573803|0.80156690178730705|20.099571|20.226416|20.402489|20.24069|20.118156|5.8165491E-2|1.9316141E-2|0.03645844|0.04100015|0.12602827|9.8728411E-2|7.2643422E-2|5.2687071E-2|3.9951012E-2|2.8325764E-2|6|1|26227|268435968|268468224|268468224|268468736|268468224|402685952|296.66931|1900.2786|0|34603008|0|0|0|5739156013056|51638.417990299997|3|0|88475|0|0.0|0|0.0|-26.46860629565974|0|0
5739156013286|5739156013286|260.32319524867398|53.202157113591802|-0.10068500096574701|-0.59047073221471102|0.80075392286166902|20.299458|19.965466|19.071789|18.758204|18.304308|6.2945068E-2|1.6733168E-2|2.3296369E-2|1.9110216E-2|3.4343529E-2|0.10302432|7.5804316E-2|5.4979611E-2|4.1689374E-2|2.9558286E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|551.77325|358.03018|0|4|0|4|0|5739156013056|51638.417990299997|3|0|88475|0|0.0|0|0.0|-22.334105778734639|1|0
5739156078738|5739156078738|260.51191340979602|53.102668007725001|-9.8968647942342294E-2|-0.59216968660658298|0.79971261649965597|18.089523|17.886799|17.945951|17.848337|17.890511|3.1341128E-2|1.6029539E-2|1.1368793E-2|1.5492103E-2|2.3591593E-2|0.10339737|7.6078802E-2|5.5178694E-2|4.1840333E-2|2.9665317E-2|6|1|26227|268566544|268468240|268468240|268468240|268468240|268599312|363.61511|1065.3429|0|4|0|4|0|5739156078592|51638.418404999997|3|0|88475|0|0.0|0|0.0|-25.662995335806443|1|0
5739156144422|101272087062118400|260.58662046961598|52.909131045543603|-9.8637699503419093E-2|-0.59495978185354303|0.79768005002849196|20.184929|20.44985|20.762457|20.853752|20.982758|6.4066753E-2|2.2838013E-2|0.04095595|6.9929719E-2|0.26260021|0.11122061|8.1835069E-2|0.05935362|4.5006052E-2|3.1909853E-2|6|1|26227|268435968|268435456|268468224|268435456|402686464|1|803.67889|925.95215|0|34603008|0|0|0|5739156144128|51638.418819600003|3|0|88475|0|0.0|0|0.0|-21.154816168700044|0|0
5739156209879|101272087007592448|260.78396731999601|52.748761583661597|-9.6945069842379897E-2|-0.59749752623262298|0.79598891925651305|18.725904|17.9263|17.456228|17.150549|17.096729|6.1560791E-2|0.01200381|1.7447047E-2|3.7785262E-2|4.0410686E-2|0.10704192|7.8760423E-2|5.7123631E-2|0.04331512|0.03071096|3|1|26227|2345320710144|276856833|268468224|268599296|268468224|402685952|1157.6746|1524.34|0|64|0|0|0|5739156209664|51638.419234300003|3|0|88475|3127|2.0699999332427979|0|0.0|-29.307576171043181|0|0
5739156209992|587725490528059705|260.69646234147001|52.779449808633899|-9.7788546318597402E-2|-0.59692795255425002|0.79631301613642302|21.280674|19.781242|19.591156|19.611378|19.445616|0.14146328|1.7156277E-2|2.2868047E-2|0.04445903|7.9123229E-2|0.10805734|0.07950756|5.7665512E-2|4.3726012E-2|3.1002289E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|748.3335|1148.1216|0|33554432|0|0|0|5739156209664|51638.419234300003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739419205843|5739419205843|252.281818329061|64.406183233005294|-0.13146934936441401|-0.41149703203674898|0.90187915088588499|19.967619|19.636705|18.982851|18.559443|18.350313|6.0578644E-2|0.01326831|0.01820061|2.4529662E-2|2.9771026E-2|0.18611725|0.1369433|9.9322699E-2|7.5313397E-2|5.3398136E-2|3|1|26483|268571152|268468240|268468240|268468240|268468240|268603920|967.5885|1778.6447|0|4|0|4|0|5739419205632|51638.384819600004|3|0|0|0|0.0|0|0.0|-21.633248088703269|1|0
5739419206052|758882834230411627|252.27186154286699|64.432772642229196|-0.131413397592123|-0.41107547291834001|0.90207952781240897|22.125116|21.020174|20.401548|20.024101|19.886765|0.27662143|3.2561887E-2|0.03270252|3.7544668E-2|9.7387515E-2|0.18147108|0.13352469|9.6843243E-2|7.3433302E-2|5.2065127E-2|6|1|10099|268435968|32769|276856832|268468224|268468224|402686464|731.50793|1843.9045|0|0|0|0|0|5739419205632|51638.384819600004|3|0|0|0|0.0|0|0.0|0.0|0|0
5739687706971|758883005492625464|253.25527523242201|64.513683003832497|-0.123971630386258|-0.41205009684538502|0.90268807045904897|22.627483|21.203291|20.228153|19.753683|19.568596|0.36482707|5.1215202E-2|2.3803242E-2|2.4973363E-2|8.0059759E-2|0.15345584|0.11291134|8.1892721E-2|6.2096775E-2|4.4027388E-2|6|1|9843|17592454611712|134251777|268599808|276856832|17592597250560|402685952|280.71429|1843.9908|0|0|0|0|0|5739687706624|51638.385234300004|3|0|0|0|0.0|0|0.0|0.0|0|0
5739687772475|587725491059622150|253.27176897039701|64.358811089017493|-0.12455486281159001|-0.414420989116566|0.90152167468654498|23.667719|22.927931|21.319796|20.332396|19.971714|0.78926361|0.2496742|0.12344548|0.10403844|0.15700845|0.16632439|0.1223799|8.8760115E-2|6.7304105E-2|4.7719449E-2|6|1|9843|70369012613392|70369155219729|70369012613137|70369021001745|268435472|70369012613137|234.77661|1334.2362|0|0|0|0|0|5739687772160|51638.385648800002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739687903408|5739687903408|253.59530012028799|63.960470764555502|-0.123979940586294|-0.42112016126530399|0.898491393452438|19.343445|19.219093|18.984917|18.678291|18.243303|3.9888665E-2|2.1129806E-2|1.9093681E-2|1.3318841E-2|0.05174917|0.19248392|0.14162783|0.10272032|7.7889711E-2|5.5224776E-2|6|1|26227|17592454615552|268468224|268603392|268468224|268468224|17592588866048|1344.5651|1053.4993|0|4|0|4|0|5739687903232|51638.386478|3|0|87899|0|0.0|0|0.0|-28.209301864785033|1|0
5739687903460|758883004955754895|253.67387120526601|64.123247297676002|-0.122684287342943|-0.41883841125582|0.89973493368650204|20.152227|19.454082|18.822922|18.445301|18.308273|5.4080542E-2|2.1761103E-2|1.8625075E-2|1.2282388E-2|5.2321009E-2|0.13478616|0.09917438|7.1929529E-2|5.4541986E-2|0.03867095|3|1|9847|17592454610944|268468224|17592454643712|268468224|268468224|268468224|110.96077|1930.4874|0|0|0|0|0|5739687903232|51638.386478|3|0|0|0|0.0|0|0.0|0.0|0|0
5739687968824|587725491059818587|253.52179894831301|63.870893724318599|-0.124918362744505|-0.42230727313289701|0.89780397064631501|21.203489|18.408447|18.376116|18.226446|17.474564|0.24919756|0.13756897|0.13668409|0.30939519|0.15548125|0.15901473|0.11700153|8.4859267E-2|6.4346209E-2|4.5622267E-2|3|1|9843|70369013268496|70369046724625|70369046855729|302678064|70369046724657|70369046724625|612.96796|459.03839|0|0|0|0|0|5739687968768|51638.3868927|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688034528|758882833156931842|253.989953099579|63.803977097290201|-0.121752745630663|-0.42432145169581398|0.89728901395378302|22.157993|19.491755|18.372297|17.803591|17.488647|0.22705625|1.3111267E-2|1.1089279E-2|1.9593693E-2|2.3946291E-2|0.1740891|0.12809311|9.2903808E-2|7.0446141E-2|4.9947195E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|268468224|553.5144|1939.6901|0|0|0|0|0|5739688034304|51638.387307199999|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230957|758883003882078717|254.21616818568299|63.3305040347675|-0.122089289025088|-0.43191957632747302|0.89361047727208598|21.751783|20.945292|20.357546|19.997658|19.755167|0.1669255|3.1826936E-2|0.02757976|2.9441981E-2|9.3525186E-2|0.11684574|8.5973985E-2|6.2355507E-2|4.7282293E-2|3.3523735E-2|6|1|9843|269091088|411074832|268468240|268468240|268992528|268468240|790.72388|1094.7948|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230962|758883003882012841|254.10614799747501|63.309607340062101|-0.123007687050485|-0.43199776851664401|0.89344671745053195|17.841148|16.422794|15.915848|15.724008|15.630955|1.8421037E-2|9.097537E-3|1.0349612E-2|9.5000071E-3|2.3644026E-2|0.12649491|9.3073756E-2|6.7504853E-2|5.1186886E-2|3.6292139E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|790.59137|607.04327|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230969|758883003882078217|254.14501209334|63.3015823078875|-0.12274881913854201|-0.43220148007304698|0.89338379659738698|17.340151|15.973794|15.464849|15.279008|15.193956|1.7018441E-2|9.0141362E-3|1.0302063E-2|9.4302716E-3|2.3470538E-2|0.12411089|9.1319621E-2|6.6232607E-2|5.0222177E-2|0.03560815|6|1|9843|268566544|268599312|268468272|268468240|268468240|268468272|919.69037|724.56506|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230973|758883003882012838|254.10893651293401|63.292147531897101|-0.123061203970177|-0.432265590892218|0.89330980012983896|18.051147|16.354794|15.700848|15.460008|15.294956|1.9147409E-2|9.0807956E-3|1.0330566E-2|9.4476566E-3|0.02349215|0.12674533|9.3258008E-2|6.7638487E-2|5.1288217E-2|3.6363985E-2|6|1|9843|268566544|268468240|268468240|268468240|268599312|268468240|941.21002|555.20831|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230976|758883003882078357|254.267988892609|63.320772516709297|-0.121739743775656|-0.43217590767675301|0.89353422967965401|17.71015|16.366795|15.894848|15.687008|15.604955|1.8051615E-2|9.0891626E-3|1.0359148E-2|9.4912611E-3|2.3622269E-2|0.11513546|8.4715575E-2|6.1442804E-2|4.6590216E-2|3.3033043E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|954.50714|1255.1176|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230994|758883003882078237|254.18430336634299|63.2809013505709|-0.122540281491633|-0.432595786815195|0.89322156525785601|17.510151|16.397795|16.021849|15.884007|15.830955|1.7543586E-2|9.0891626E-3|1.0368693E-2|0.00952629|0.02373123|0.12261856|9.0221569E-2|6.5436207E-2|4.9618293E-2|3.5179988E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|1155.4342|798.76489|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688230997|758883003882078362|254.285767607385|63.298750267051801|-0.121698643004471|-0.432544233703481|0.89336158758967199|18.321142|16.975794|16.451847|16.219007|16.116953|2.0403408E-2|9.2751952E-3|1.0445366E-2|9.6055744E-3|2.3928609E-2|0.11537356|8.4890768E-2|6.1569866E-2|4.6686564E-2|3.3101358E-2|6|1|9843|268435968|276857344|268468224|268468224|268468224|268468224|1167.1484|1243.879|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231000|758883003882078494|254.46288806448601|63.304087021433403|-0.120338634758996|-0.43283820530874401|0.89340343686905899|18.041147|16.772795|16.326847|16.164007|16.135952|1.9147422E-2|9.1901673E-3|1.0426145E-2|9.5967334E-3|2.3928596E-2|0.11730463|8.6311631E-2|6.2600397E-2|4.7467984E-2|3.3655394E-2|6|1|9847|268566544|268468240|268599312|268468240|268468240|268468240|1402.4376|1929.4165|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231034|758883003882012985|254.001110916274|63.303320624476399|-0.123826455581346|-0.431865772508914|0.89339742748311002|19.355087|17.204794|16.314848|15.977008|15.747954|2.9568417E-2|9.3610035E-3|1.0426146E-2|9.5438519E-3|2.3709413E-2|0.13049117|9.6014164E-2|6.9637477E-2|5.2803993E-2|3.7438691E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468224|675.24542|190.05899|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231040|758883003882078556|254.201467176558|63.325643282740202|-0.122220746748188|-0.43196118147218199|0.89357239592853999|19.570057|18.022791|17.381847|17.118006|16.994934|3.3296246E-2|9.9842735E-3|1.0807389E-2|1.0039675E-2|2.5333276E-2|0.11814904|8.6932942E-2|6.3051023E-2|4.7809683E-2|3.3897661E-2|6|1|9843|268435456|268468224|268468224|268468224|411074560|268468224|808.07202|1022.3737|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231047|758883003882078248|254.17861907769301|63.314520207435798|-0.122440285413754|-0.43207930170721698|0.89348522849793199|22.598373|20.893339|19.537781|18.851965|18.383654|0.34483007|3.0650251E-2|1.7108738E-2|1.4670763E-2|3.6660183E-2|0.12084429|8.8916078E-2|6.4489357E-2|4.8900329E-2|3.4670942E-2|6|1|9843|70369013268752|70369146864913|268468240|268468240|268992528|268468240|864.98444|896.89093|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231058|758883003882078371|254.29012207183499|63.329699202176201|-0.121535090910807|-0.43208888546271501|0.89360417229156397|18.754131|16.857794|16.199848|15.950007|15.823955|2.2370802E-2|9.2240851E-3|0.01040696|9.5438529E-3|0.02373123|0.11366697|8.3635077E-2|6.0659133E-2|4.5995984E-2|3.2611724E-2|6|1|9843|268570624|276992000|268468224|268468224|268468224|268468224|914.73029|1369.9283|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231059|758883003882078577|254.246058498678|63.316870460263203|-0.12192167517506999|-0.43218784537602101|0.89350364936677096|19.937963|18.889782|18.516838|18.348991|18.272711|4.1562997E-2|1.1483992E-2|1.2305536E-2|1.2259973E-2|0.03475742|0.11644463|8.5678853E-2|6.2141452E-2|4.7119983E-2|3.3408653E-2|6|1|9843|268571136|268468224|268603392|268468224|268468224|402686464|952.43707|1158.8636|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231062|758883003882078627|254.36321440505299|63.326912936058903|-0.120995488348471|-0.43228542309648399|0.89358234359101396|21.847742|19.02478|17.608847|16.374008|15.730955|0.1831871|1.2002905E-2|1.0988012E-2|9.6587976E-3|2.4781128E-2|0.11409984|8.3953582E-2|6.0890138E-2|4.6171147E-2|3.2735918E-2|6|1|9843|268570640|402685968|268468240|268468240|268468240|268603408|1053.6648|1635.0287|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231065|758883003882078631|254.380931604615|63.311204136658503|-0.12092776741908801|-0.432558747655438|0.89345923516061698|21.731976|19.265772|17.922844|16.822006|16.257952|0.16469383|1.2920247E-2|1.1316586E-2|9.8202266E-3|2.4038946E-2|0.114264|8.4074371E-2|6.0977746E-2|4.6237577E-2|0.03278302|6|1|9843|268566784|276858112|268468224|268468256|268599296|268468224|1213.0558|1646.2487|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231068|758883003882078543|254.21572136979799|63.276934389838402|-0.12231987237441599|-0.43272242700966401|0.89319043321408897|20.577538|18.300791|17.282846|16.910007|16.652945|6.4497486E-2|0.01037796|1.0777583E-2|9.8928418E-3|2.4598371E-2|0.1210321|8.9054264E-2|6.4589582E-2|4.8976324E-2|3.4724824E-2|6|1|9843|268435984|268468752|268468240|268468240|268468240|402685968|1238.6766|902.91156|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231073|758883003882078758|254.44055661844001|63.304416352765301|-0.120505949987571|-0.432786322553456|0.89340601913589601|22.897066|21.482445|20.164637|19.094942|18.478596|0.44650823|4.7434032E-2|2.3805002E-2|1.7849719E-2|3.7961088E-2|0.11615583|8.5466355E-2|6.1987329E-2|4.7003113E-2|3.3325795E-2|6|1|9847|87961198792976|70369188806929|17592488198160|302157840|158329976553488|302022672|1364.5593|1846.5802|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231077|758883003882078423|254.40055567048|63.3004242889564|-0.12082480838826|-0.43276203989298101|0.89337471561803605|18.377142|17.263794|16.867847|16.690006|16.618946|2.0687155E-2|9.4042076E-3|1.0580908E-2|9.7571304E-3|2.4485406E-2|0.1146239|8.4339179E-2|6.1169807E-2|4.6383213E-2|3.2886278E-2|6|1|9843|268566544|268468240|268468240|268468240|268599312|268468240|1334.8293|1681.8604|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231079|5739688231079|254.21201721172099|63.2570046061496|-0.122432371525674|-0.43301345897269899|0.89303396282061898|19.196104|18.328791|18.268841|18.307993|18.316689|2.7545298E-2|1.0425849E-2|0.01189347|1.2091815E-2|3.5467252E-2|0.12235684|9.0029001E-2|6.5296546E-2|0.04951239|3.5104901E-2|6|1|26231|268435456|276856832|268468224|268468224|268468224|402685952|1399.7474|817.99933|0|1048580|0|4|0|5739688230912|51638.388551099997|3|0|87899|0|0.0|0|0.0|4.7961146238651651|1|0
5739688231099|758883003882013004|254.04117892815299|63.3013613559879|-0.123532813136844|-0.43198163372214199|0.89338206395989805|22.383856|19.896721|18.813831|18.360991|18.019802|0.28540698|1.6595783E-2|1.2873173E-2|1.2259951E-2|3.1589307E-2|0.12942788|9.5231801E-2|6.9070049E-2|5.2373726E-2|3.7133627E-2|6|1|9843|268566784|134251777|268468224|268599296|268468224|402685952|755.77429|333.49094|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231103|758883003882078603|254.31572571487001|63.304398116657502|-0.12144865611325401|-0.43252302180541002|0.89340587614846201|22.644081|20.209665|18.946825|18.363991|18.043795|0.36092263|1.9748531E-2|1.3717615E-2|1.2305201E-2|3.1646959E-2|0.11326453|8.3338961E-2|0.06044437|4.5833133E-2|3.2496262E-2|6|1|9843|70369012613392|70369155252497|268468240|268468240|268468240|268468240|1167.3734|1376.5945|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231105|758883003882078587|254.27653159730201|63.278380268503803|-0.12185443026293701|-0.43283030940228001|0.89320178072371803|21.591162|19.652748|18.590836|18.173996|17.918829|0.14656307|1.4984204E-2|1.2568916E-2|1.1686852E-2|3.0392563E-2|0.1173188|8.6322062E-2|6.2607959E-2|4.7473721E-2|3.3659458E-2|6|1|9843|268435456|402685952|268468224|268468224|268468224|402685952|1323.3059|1136.983|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231116|758883003882012976|253.986033541056|63.300730798807301|-0.12395123694704401|-0.431871987585144|0.89337711924951102|22.515078|20.625515|19.331802|18.133997|17.491898|0.31688702|2.5245765E-2|1.5604299E-2|1.1558436E-2|2.7343052E-2|0.13087495|9.6296541E-2|6.9842286E-2|5.2959293E-2|3.7548799E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|268468224|672.79004|124.11231|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231119|758883003882078583|254.253400965949|63.315048878615499|-0.121873998273273|-0.43223080663209501|0.89348937226083203|22.548655|20.918316|19.536781|18.473988|17.936825|0.33280721|3.0790173E-2|1.7140299E-2|1.2743318E-2|3.0560656E-2|0.11619065|8.5491978E-2|6.2005915E-2|4.7017206E-2|3.3335786E-2|6|1|9843|70369012744464|70369146832145|268599312|268435472|268468240|402685968|979.34613|1179.9603|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231121|758883003882013029|254.12204792465499|63.255779777204701|-0.123117387108632|-0.432839036698764|0.893024343061951|22.699045|20.496574|19.022821|18.090998|17.530893|0.57374257|2.3694495E-2|1.4271649E-2|1.1463066E-2|2.7494235E-2|0.12741677|9.3752049E-2|6.7996807E-2|5.1559921E-2|3.6556628E-2|6|1|9843|34628309248|140737631129857|268468224|268468224|268468224|268468224|1266.5104|474.82446|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231378|758883003882013082|253.992011677341|63.2986057256851|-0.123915313123589|-0.431916767847771|0.89336045403040898|24.715708|22.073778|20.676306|19.702805|19.195606|1.0994192|7.7400602E-2|3.5057995E-2|0.02354461|0.06094005|0.13093483|9.6340612E-2|6.9874249E-2|5.2983526E-2|0.03756598|6|1|9843|268435712|134251777|268468224|268468224|268468224|402685952|700.11377|138.91371|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231386|758883003882078765|254.13740011231999|63.319322660004801|-0.122730624023431|-0.431919065183205|0.89352286767496103|23.90074|22.250231|20.947952|19.838747|19.179646|0.905101|9.0429544E-2|4.3141551E-2|2.6076056E-2|5.9942324E-2|0.12391576|0.09117604|0.06612847|5.0143216E-2|3.5552166E-2|6|1|9843|268435712|142639361|268468224|276856832|268468224|402685952|759.13324|759.27386|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231408|758883003882078729|254.29281623436501|63.335980603843197|-0.12148825066324501|-0.43200028866408202|0.89365337550133706|24.854473|21.734646|20.497458|19.848742|19.675684|1.0963185|5.8917884E-2|3.0599531E-2|2.6414264E-2|8.6964317E-2|0.11331289|8.3374545E-2|6.0470175E-2|4.5852702E-2|3.2510139E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|866.37476|1402.3054|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231426|758883003882078730|254.300022726865|63.330383730588203|-0.121457535585777|-0.43209960229875799|0.893609534832012|24.279579|22.008236|20.585388|19.578846|18.931128|1.0674601|7.4048199E-2|3.2723296E-2|2.1934642E-2|4.9903516E-2|0.11317801|8.3275311E-2|6.0398199E-2|4.5798127E-2|3.2471444E-2|6|1|9843|268436224|134219009|268435456|268435456|268468224|268468736|924.66772|1409.6239|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231445|758883003882013078|254.00694377965701|63.267278990373498|-0.12393730458588|-0.43241852633322703|0.89311464136234298|22.834097|21.026213|19.955704|19.549854|19.21356|0.41466922|0.03387874|2.1995805E-2|2.1297907E-2|6.1385226E-2|0.13250951|9.7499236E-2|7.0714578E-2|5.3620726E-2|3.8017761E-2|6|1|9843|268436224|142639361|268468224|268468224|268468736|402685952|986.10748|82.956299|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231466|758883003882013077|254.011206885685|63.258930325736998|-0.12394097494030901|-0.43255284508770298|0.89304908652177695|24.71847|22.001282|20.441496|19.129936|18.38965|1.0971831|7.4123025E-2|3.0828768E-2|1.6673202E-2|3.6761351E-2|0.13282822|9.7733736E-2|0.07088466|5.3749692E-2|3.8109202E-2|6|1|9843|268435712|142606593|268435456|268435456|268435456|268435456|1062.6322|69.145996|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231512|758883003882013112|254.10507126214199|63.2661570480035|-0.123201332260061|-0.43264697284029502|0.89310583282244604|23.891262|21.319794|19.9737|18.880962|18.217733|0.90376258|4.2656213E-2|2.1121642E-2|1.4833706E-2|3.4030717E-2|0.12794971|9.4144188E-2|6.8281218E-2|5.1775582E-2|3.6709532E-2|6|1|9843|70369012744464|70369146832145|276856848|268566544|268468240|402653200|1152.5275|448.06418|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688231573|758883003882013147|254.039024239273|63.231746112420602|-0.123847453166106|-0.43302029564012301|0.89283550103477005|24.230679|22.50292|21.043779|19.444881|18.616493|1.0331799|0.1156869|5.1996887E-2|1.9987693E-2|4.1157208E-2|0.13183695|9.7004376E-2|7.0355661E-2|5.3348571E-2|3.7824802E-2|6|1|9843|268436224|134251777|411074816|268468736|268468224|402685952|1334.5627|76.37574|0|0|0|0|0|5739688230912|51638.388551099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296462|758883003882078285|254.253886175877|63.2514854665014|-0.122139257780356|-0.43318560423203201|0.89299061248984801|16.373075|15.310127|15.017029|14.875144|14.83304|0.01874665|8.0635119E-3|2.3319772E-2|1.3974113E-2|2.8165909E-2|0.12010708|8.8373646E-2|6.4095944E-2|4.8602011E-2|3.4459431E-2|6|1|9843|268566544|268468240|268468240|268599312|268599312|268468272|151.53529|956.42572|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296463|758883003882078280|254.24635254103001|63.251335502874397|-0.122196849458461|-0.43317179027818298|0.89298943447815804|18.06007|16.813128|16.392029|16.183144|16.066036|2.1503633E-2|8.3199972E-3|2.3384284E-2|1.4116393E-2|2.8610067E-2|0.12051941|8.8677041E-2|0.06431599|4.8768867E-2|3.4577735E-2|6|1|9843|268570640|268468240|268603408|268468240|268468240|268468272|140.79529|927.63806|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296466|758883003882078353|254.29357072818499|63.256372520450903|-0.1218185731408|-0.43319677178459398|0.89302899849520301|17.310074|16.253128|15.931028|15.762144|15.686038|1.9702476E-2|8.1907539E-3|2.3362763E-2|1.4025684E-2|2.8400214E-2|0.11776444|8.6649954E-2|6.2845774E-2|4.7654048E-2|3.3787314E-2|6|1|9843|268566544|268468240|268468240|268468240|268599312|268468272|173.5752|1123.2982|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296471|758883003882078430|254.42530628883799|63.276161070799198|-0.120739418674918|-0.43317858323685698|0.89318436383702604|17.162075|15.759128|15.338028|15.154144|15.07804|1.9503906E-2|8.108194E-3|2.3341257E-2|1.3999877E-2|2.8243821E-2|0.11489203|8.4536463E-2|6.1312895E-2|4.6491712E-2|3.2963201E-2|6|1|9843|268435456|268468224|293634048|268468224|293634048|268468224|216.2798|1689.7805|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296511|758883003882012811|254.130218469364|63.136562435996098|-0.123563508951629|-0.43464297596872198|0.89208606238221999|17.561073|16.035128|15.507029|15.298144|15.25704|2.0124212E-2|8.1531238E-3|2.3341261E-2|1.3999876E-2|2.8269826E-2|0.12370868|9.1023669E-2|6.6017956E-2|5.0059419E-2|3.5492752E-2|6|1|9843|268435968|268468224|268484608|268468736|268468736|402686464|916.19714|81.713074|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296518|758883003882012824|254.18143715543201|63.131983402763801|-0.123194351189245|-0.43482185346576802|0.89204994679875205|17.786072|16.663128|16.284029|16.111143|16.077036|2.0630814E-2|8.3123427E-3|2.3384286E-2|1.4090417E-2|2.8610062E-2|0.1226273|9.0227999E-2|6.5440871E-2|4.9621832E-2|3.5182498E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468224|1036.6366|259.06857|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296528|758883003882078377|254.396962752739|63.149831429766202|-0.121483096532063|-0.43501452733053603|0.892190684925802|17.642073|16.389128|15.933028|15.757144|15.717038|2.0291686E-2|8.228559E-3|2.3362765E-2|1.4038609E-2|2.8426375E-2|0.11819162|8.6964272E-2|6.3073739E-2|4.7826909E-2|3.3909876E-2|6|1|9843|268435456|276856832|285245440|268468224|268468224|402685952|1230.6281|1137.99|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296555|758883003882078281|254.24946515178601|63.255436725388101|-0.12215596571710299|-0.43311690689773902|0.89302164867323197|19.27302|17.410126|16.793028|16.546144|16.391033|3.0119171E-2|8.6481087E-3|2.3448972E-2|1.4181536E-2|2.8874505E-2|0.12023376|0.08846686|6.4163543E-2|4.8653271E-2|3.4495778E-2|6|1|9843|268566544|268468240|268468240|268599312|268468240|268468240|111.39526|953.84064|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296559|758883003882078221|254.19387390897001|63.2320116590219|-0.12267557867305599|-0.43334944691427302|0.892837588397982|18.548061|17.502127|17.178028|16.996143|16.886021|2.3708116E-2|8.7200832E-3|2.3513824E-2|1.4352312E-2|2.9600594E-2|0.12395288|9.1203347E-2|6.6148274E-2|5.0158236E-2|3.5562813E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|219.09245|661.14172|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296575|758883003882078571|254.283120707124|63.228045783994098|-0.12201716350834101|-0.43359949523256403|0.89280641213168099|19.986868|17.588127|16.543028|16.041143|15.770038|4.3280479E-2|8.7764729E-3|2.3405828E-2|1.4064487E-2|2.8452549E-2|0.11979782|8.8146098E-2|6.3930906E-2|4.8476867E-2|3.4370705E-2|6|1|9843|268566544|268468240|268468240|268468240|268599312|402685968|394.39554|983.79663|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296583|758883003882078599|254.35060596836701|63.237683834577297|-0.121465854277455|-0.43359828818899598|0.89288217068335496|19.807926|17.579126|16.584028|16.054144|15.788038|3.9115295E-2|8.7683946E-3|2.3427393E-2|1.4090418E-2|0.02847876|0.11705692|8.6129367E-2|6.2468205E-2|4.7367748E-2|3.3584323E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468272|420.70627|1272.3895|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296594|758883003882078622|254.40510549546201|63.231280981807103|-0.12108018594577399|-0.43380973425771302|0.89283184476954502|19.878904|17.292128|15.983028|15.184144|14.78204|4.0731177E-2|8.5688336E-3|2.3362763E-2|1.3986989E-2|0.02816591|0.11624139|8.5529312E-2|0.06203299|4.7037739E-2|3.3350341E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|560.67139|1455.5817|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296596|758883003882078388|254.38470193078001|63.2253747065729|-0.121259435480297|-0.43385522628475098|0.89278541202934503|18.54706|17.142126|16.691029|16.445145|16.388033|2.3708116E-2|8.4902858E-3|2.3427388E-2|1.4155443E-2|2.8874509E-2|0.11697237|8.6067162E-2|6.2423084E-2|4.7333535E-2|3.3560067E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|577.8952|1357.7272|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296603|758883003882078654|254.48136004947699|63.228692479079399|-0.120513516447515|-0.434009360088352|0.89281149617887101|21.318661|18.577122|17.195028|16.092144|15.537039|0.11494364|1.0104224E-2|2.3513822E-2|1.4090418E-2|0.02834799|0.1144391|8.4203199E-2|6.1071184E-2|4.6308428E-2|3.2833252E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468256|702.84497|1734.4171|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296606|758883003882143913|254.53859940439|63.231679028177602|-0.120067467769748|-0.43408468402863398|0.89283497370741505|21.497715|19.086111|17.700026|16.825144|16.360033|0.13394548|1.1547275E-2|2.3665821E-2|0.01427324|2.8847959E-2|0.11285452|0.08303728|6.0225565E-2|0.04566722|3.2378629E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|768.04156|1961.0802|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296609|758883003882078620|254.41238675213501|63.202788522418203|-0.121144346931524|-0.43425272827774097|0.89260776110779605|19.941885|17.451126|16.129028|15.396144|15.02204|4.2102419E-2|8.6720325E-3|2.3384288E-2|1.3999877E-2|2.8217826E-2|0.11701848|8.6101085E-2|6.2447689E-2|4.7352195E-2|3.3573296E-2|6|1|9843|268566528|276856832|268468224|276856832|268599296|268468224|811.02386|1382.7673|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296611|758883003882012822|254.15109192190801|63.151843541939002|-0.12334017387855099|-0.434459067429665|0.89220654572568303|18.856049|17.049128|16.406029|16.133144|16.031036|2.5472984E-2|8.4668649E-3|2.3384282E-2|1.4090417E-2|2.8583752E-2|0.12361308|9.0953335E-2|6.5966941E-2|5.0020736E-2|3.5465326E-2|6|1|9843|34628305408|268599296|268468224|268599296|268468224|419463680|821.7934|214.91049|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296620|758883003882078658|254.50927011033701|63.201490398818997|-0.120415282848208|-0.43447644304815802|0.89259754654200496|21.346533|18.937115|17.628027|16.306145|15.614038|0.11705275|1.1068484E-2|2.3622286E-2|1.4116389E-2|2.8400237E-2|0.11193645|8.2361773E-2|0.05973563|4.5295719E-2|3.2115228E-2|6|1|9843|268566544|276856848|268468240|268599312|268599312|268468240|975.05157|1744.4196|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296624|758883003882078533|254.260504052839|63.149957127298997|-0.12251827397713901|-0.43472207925773898|0.89219167578917202|21.119404|18.797117|17.717026|17.287142|17.043015|9.6001647E-2|1.0717537E-2|2.3687625E-2|1.4808818E-2|2.9956615E-2|0.12266342|9.0254582E-2|6.5460153E-2|0.04963645|3.5192862E-2|6|1|9843|17592454610944|402685952|268468224|268468224|158329942999040|402685952|1012.4939|622.04028|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296640|758883003882078396|254.42414026722301|63.168650594580797|-0.12119804592059|-0.43478979501196002|0.89233898705508097|18.628057|17.382126|16.954027|16.778143|16.729027|0.02410423|8.8577094E-3|2.3470568E-2|1.4260105E-2|2.9329613E-2|0.11709593|8.6158074E-2|6.2489022E-2|4.7383532E-2|3.3595517E-2|6|1|9843|17592454610944|285245440|158329959776256|285245440|419463168|419463168|1115.8645|1307.0779|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296647|758883003882078592|254.378144459797|63.146498408875701|-0.121639942642342|-0.43502458655058401|0.89216440942825204|20.970804|18.70912|17.544027|17.095142|16.89702|8.5075073E-2|1.0464017E-2|2.3600558E-2|1.4392009E-2|2.9627839E-2|0.11904648|8.7593265E-2|6.3529946E-2|4.8172835E-2|3.4155138E-2|6|1|9843|268435968|402686464|293634048|268468224|268468224|402685984|1228.7034|1054.9615|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296649|758883003882078607|254.40775098294|63.149540143497397|-0.121402404611133|-0.43504176257189198|0.89218838872346695|19.945883|17.969126|17.187027|16.891144|16.748026|4.1831613E-2|9.1477903E-3|2.3535492E-2|1.4299548E-2|2.9356597E-2|0.11761212|8.6537875E-2|6.2764488E-2|4.7592409E-2|3.3743612E-2|6|1|9843|34628174336|293634048|293634560|293634560|293634560|419463680|1250.2156|1177.7705|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296664|758883003882078550|254.23534917302501|63.251218183112499|-0.12228053245970701|-0.43315007471744899|0.89298851289008097|22.190979|20.083025|18.809011|17.434141|16.646029|0.2387656|1.8095113E-2|2.4734536E-2|1.4619046E-2|2.9195022E-2|0.12112997|8.9126281E-2|6.4641818E-2|4.9015932E-2|3.4752905E-2|6|1|9847|268435456|32769|268468224|268468224|268468256|402685952|124.4999|885.49988|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296665|758883003882012990|254.06472649139101|63.2072002560244|-0.12375819603459701|-0.4334435666275|0.89264247236141203|23.026522|20.115019|18.852009|18.064135|17.647963|0.47717598|1.8704966E-2|2.4825737E-2|1.5378301E-2|0.03227251|0.12941812|9.5224626E-2|6.9064841E-2|5.2369777E-2|3.7130825E-2|6|1|9843|268435712|134219009|268468224|268435456|268435456|268435456|220.25316|85.942268|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296667|758883003882078547|254.244951775174|63.232502003045703|-0.122287134206831|-0.43345128318878601|0.89284144275984101|21.882242|19.640081|18.399021|17.56814|17.117012|0.18287387|1.4442148E-2|2.4172107E-2|1.4727114E-2|3.0177848E-2|0.12095901|8.9000493E-2|6.4550579E-2|4.8946749E-2|3.4703858E-2|6|1|9843|268435472|402685968|268468240|268468240|268468240|268468240|296.41449|855.44373|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296669|758883003882078633|254.414856058476|63.259681027463003|-0.12088744287580599|-0.43340399795433499|0.89305498190881105|22.941093|19.904053|18.622017|17.401142|16.790024|0.45293105|1.6307734E-2|2.4373034E-2|1.4565296E-2|2.9437725E-2|0.11520079|8.4763646E-2|6.1477665E-2|4.6616655E-2|3.3051789E-2|6|1|9843|268566784|142655745|268468224|268599296|268599296|268468256|337.94525|1592.3534|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296671|758883003882078525|254.22405780228601|63.218677127434901|-0.122503759790068|-0.433613965929875|0.89273274690013604|22.155745|19.564089|18.230022|17.346142|16.900021|0.28406549|1.3971419E-2|2.4016907E-2|1.4538507E-2|2.9627832E-2|0.12277741|9.0338446E-2|6.5520979E-2|4.9682576E-2|3.5225566E-2|6|1|9843|268566528|140737622736897|268468224|268468224|268468224|402685952|378.94052|727.67731|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296678|758883003882078613|254.386740872454|63.220795768554702|-0.121263198859222|-0.43392825624643799|0.89274940774741196|22.175325|19.757071|18.386021|17.292141|16.681026|0.23498763|1.5234093E-2|2.4149869E-2|1.4511764E-2|2.9275738E-2|0.11712715|8.6181045E-2|6.2505685E-2|4.7396164E-2|3.3604473E-2|6|1|9843|268436224|142639361|276857344|276856832|268468224|402685952|619.55981|1349.3088|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296681|758883003882013012|254.12803807767699|63.1460203534253|-0.123539774077233|-0.43449662345310602|0.89216064048398602|21.834816|19.231106|18.046024|17.55814|17.316998|0.17402282|1.2316032E-2|2.3884665E-2|1.4713559E-2|3.0794488E-2|0.12385315|9.1129974E-2|6.6095054E-2|0.05011788|3.5534203E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|833.6637|106.93768|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296683|758883003882078616|254.41582944900199|63.192057118178198|-0.121163166495544|-0.434421036739919|0.89252330497448995|21.874342|19.414097|18.181023|17.59614|17.219006|0.18072961|1.3087455E-2|2.3972742E-2|1.4754253E-2|3.0512739E-2|0.11708373|8.6149096E-2|0.06248251|4.7378596E-2|3.3592016E-2|6|1|9843|268435712|276857088|268468224|268468224|268468224|268468224|906.479|1358.0906|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296684|758883003882013026|254.16037216003099|63.138378745001297|-0.123327028563072|-0.43468073885993003|0.89210038632991795|22.311939|19.85906|18.959005|18.54512|18.356752|0.27212816|1.6263111E-2|2.5055174E-2|1.6553439E-2|3.9757866E-2|0.12310782|9.0581566E-2|6.5697305E-2|4.9816277E-2|0.03532036|6|1|9843|268567296|142770433|268468224|268468224|268468224|402686464|949.41016|202.26152|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296685|758883003882078629|254.44708520635001|63.176556451903103|-0.120990903031643|-0.434719672268012|0.892401259482964|22.498665|20.364956|18.925007|17.764139|17.104012|0.30720031|0.0215919|2.4940148E-2|1.4931892E-2|3.0150125E-2|0.11564495|8.5090458E-2|6.1714698E-2|4.6796389E-2|3.3179224E-2|6|1|9843|268435712|8421633|268468224|268468224|268468224|268468224|1085.9709|1421.7786|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296686|758883003882078609|254.399707642344|63.1663673718826|-0.121393004928407|-0.43477232220414402|0.89232099952857102|22.144968|20.260984|18.892008|17.786139|17.204006|0.2263348|2.0282477E-2|2.4871413E-2|0.01495941|3.0456664E-2|0.1185907|8.7257907E-2|6.3286714E-2|4.7988396E-2|3.4024373E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|1096.3674|1206.6908|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296687|758883003882078518|254.238015128928|63.130398491355301|-0.12277161975975601|-0.43496704021189903|0.89203744501610804|23.397882|20.334965|18.939007|17.901136|17.313999|0.6320433|2.0544425E-2|2.5009118E-2|1.5125589E-2|3.0822884E-2|0.12195516|8.9733452E-2|6.5082185E-2|4.9349848E-2|3.4989659E-2|6|1|9843|17592454611200|142639361|17592454643712|268468224|268468224|268468224|1140.3254|467.56467|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296689|758883003882078527|254.26835001995599|63.1332316998895|-0.122529352148546|-0.43498952145571701|0.89205979288710502|22.296371|19.755072|18.622017|18.102133|17.792938|0.20655352|1.5346803E-2|2.4417972E-2|0.01546348|3.3450861E-2|0.12169618|8.9542896E-2|6.4943977E-2|4.9245052E-2|3.4915354E-2|6|1|9843|70369012744208|70369146994705|268468240|268468240|268468240|402685968|1165.0834|592.33783|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296691|758883003882143908|254.55110285055599|63.182278148331299|-0.120177752513537|-0.43485270915373903|0.89244631723283496|22.198803|19.586086|18.494019|18.107134|17.887918|0.23934855|1.4009975E-2|2.4238886E-2|1.5420806E-2|3.4196902E-2|0.10718299|7.8864224E-2|5.7198916E-2|4.3372206E-2|3.0751433E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|1202.2782|1835.254|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296702|758883003882013025|254.11229584044401|63.230212325766502|-0.12330013529096499|-0.433201309145195|0.89282344413222003|22.629744|20.389948|19.084|17.931137|17.287001|0.3451317|2.1972695E-2|2.5356583E-2|1.5153454E-2|3.0653182E-2|0.12832227|0.09441831|6.8480037E-2|5.1926337E-2|3.6816422E-2|6|1|9847|34628174080|134251777|268468224|268468224|268468224|268468224|103.83898|347.01498|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296703|758883003882078614|254.36622847195599|63.276090293919999|-0.121186303234218|-0.43305492080216801|0.89318380833815603|22.323608|20.31897|19.172995|18.54612|18.131851|0.26946795|2.0677684E-2|2.5590865E-2|1.6614538E-2|3.6772005E-2|0.11472972|8.4417038E-2|6.1226275E-2|4.6426032E-2|3.2916635E-2|6|1|9847|268435712|142639361|268468224|268468224|268468224|402685952|123.57419|1466.8466|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296709|758883003882078723|254.31803876580199|63.222539651814898|-0.121776080747084|-0.43375637936349898|0.89276312060890395|23.372517|21.478786|19.907896|18.557119|17.865925|0.6292901|0.04908045|2.9592644E-2|0.01661451|3.4071557E-2|0.11900678|8.7564051E-2|6.3508756E-2|4.8156768E-2|0.03414375|6|1|9843|268435712|142655745|276856832|268468224|268468224|268468224|496.00543|1096.0568|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296710|758883003882078605|254.36171074099801|63.227627657160497|-0.121424056377124|-0.43377272694823499|0.89280312493226499|22.419592|20.621851|19.269987|17.803139|17.001017|0.29008549|2.5550155E-2|2.5922546E-2|1.4986982E-2|0.02990164|0.11740316|8.6384125E-2|6.2652975E-2|4.7507852E-2|3.3683661E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|522.68909|1278.8231|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296711|758883003882078636|254.446540668826|63.213038100830403|-0.12084265064265801|-0.43417102778399702|0.892688396036738|22.996677|20.633844|19.307985|18.578119|18.186831|0.46977201|2.5667714E-2|2.6042005E-2|0.01669115|3.7523009E-2|0.11555307|8.5022852E-2|6.1665665E-2|4.6759207E-2|0.03315286|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|779.23621|1547.8274|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296712|758883003882013099|254.13813561294799|63.134018112692601|-0.12351427603965399|-0.43469815173640902|0.89206599559189004|23.177416|21.225286|19.915895|18.354128|17.51298|0.536349|4.0824592E-2|2.9756516E-2|1.5999194E-2|0.03162656|0.12351651|9.0882272E-2|6.5915406E-2|4.9981654E-2|3.5437617E-2|6|1|9843|268435968|134275073|268468736|268468224|268468224|402685952|950.25256|102.43698|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296713|758883003882078618|254.42087756913901|63.183561844819998|-0.12116043047861599|-0.43455917846911502|0.89245642498358702|23.300091|20.620852|19.171995|18.470123|18.074869|0.59256774|2.5620924E-2|2.5590871E-2|1.6341522E-2|3.6102399E-2|0.1170145|8.6098157E-2|6.2445566E-2|4.7350582E-2|3.3572152E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|985.80878|1347.1613|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296714|758883003882013031|254.19587365278201|63.140756749733498|-0.123047584872177|-0.43472144456478501|0.89211913862030301|22.757383|20.534891|19.297985|18.735109|18.410723|0.38075903|0.02442495|2.6042057E-2|1.7301155E-2|0.04071882|0.12275396|9.0321198E-2|0.06550847|4.9673088E-2|3.5218839E-2|6|1|9843|268435712|134251777|268435456|268435456|268435456|268435456|986.42749|344.7117|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296715|758883003882078610|254.405298914338|63.166392500632703|-0.121350471404784|-0.43478378945760998|0.89232119750385697|23.482744|20.875687|19.399977|18.028135|17.285|0.67470771|3.0849729E-2|2.6403755E-2|1.5321783E-2|3.0738017E-2|0.11823693|8.6997613E-2|6.3097924E-2|4.7845244E-2|3.3922873E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|1105.0374|1227.7444|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296717|758883003882143904|254.52791207231999|63.181096719064698|-0.120358660742886|-0.434821766053411|0.89243701433231204|23.199165|20.492908|19.054001|18.136133|17.593969|0.55032116|2.3326319E-2|2.5031812E-2|1.5349917E-2|3.2124855E-2|0.10916435|8.0322094E-2|0.05825628|4.4173975E-2|3.1319898E-2|6|1|9843|70369012744536|70369146864921|268468248|268599320|268599320|268468248|1175.6057|1743.4489|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296740|758883003882078368|254.33681839483|63.212446731749203|-0.121676360093757|-0.43394768789698801|0.89268374442643095|19.994865|19.835062|19.719934|19.698942|19.686699|4.3439932E-2|0.01596638|2.8367609E-2|2.5674632E-2|9.2662573E-2|0.11904096|8.7589204E-2|6.3526995E-2|0.0481706|3.4153555E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|610.34735|1131.3032|0|33554432|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296804|758883003882078724|254.312491101326|63.266278835446101|-0.12163376417959|-0.43308831759176802|0.89310678901071905|23.472498|21.247252|19.966881|18.997089|18.348757|0.68405741|4.0298156E-2|3.0058607E-2|1.8708963E-2|3.9794914E-2|0.11600415|8.5354745E-2|6.1906382E-2|4.6941735E-2|3.3282276E-2|6|1|9847|268436224|142647553|268468224|276856832|268468224|402686464|120.67805|1229.5837|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296835|758883003882078786|254.41563769143099|63.271948035888002|-0.12083015961133001|-0.43322146373866799|0.89315129506955704|25.395784|22.465841|21.051943|19.897854|19.426971|0.87223929|0.11080209|5.1947288E-2|2.8988453E-2|9.0109602E-2|0.11493126|8.4565327E-2|6.1333828E-2|4.6507582E-2|3.2974456E-2|6|1|9843|17592454611200|142639361|268469504|268468224|268468224|158330077216768|236.55234|1638.5179|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296838|758883003882078753|254.41562126989299|63.267569756846299|-0.120848619413089|-0.43328716917092902|0.89311692415819399|22.761137|21.059509|19.80092|18.8631|18.367746|0.39090052|3.4729321E-2|2.8734732E-2|1.7966522E-2|0.04016228|0.11501809|8.4629223E-2|0.06138017|4.6542723E-2|0.03299937|6|1|9843|268435712|8421633|268468224|268468224|268468224|268468224|273.13074|1622.9438|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296850|758883003882078756|254.43626085896901|63.265892733144099|-0.120699542953651|-0.433355856655673|0.89310375759651095|24.443087|21.082481|19.738932|19.016087|18.670527|1.0896244|3.5373189E-2|2.8289089E-2|1.8881984E-2|4.6346907E-2|0.11519645|0.08476045|6.1475351E-2|4.6614897E-2|3.3050545E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|319.79883|1694.9514|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296871|758883003882078787|254.43635580953199|63.254880019891203|-0.12074488090075999|-0.43352141613316603|0.89301727614316395|24.068005|21.982733|20.711449|19.671951|19.016069|0.86880744|7.3731199E-2|4.2032424E-2|2.5322895E-2|5.6810867E-2|0.11517345|0.08474353|6.1463077E-2|4.6605591E-2|3.3043943E-2|6|1|9843|268566784|142737665|268435456|268435456|268435456|268435456|412.10516|1656.3237|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296875|758883003882013105|254.13132409974099|63.195330107709701|-0.12330486430312999|-0.43376499852459699|0.89254906671518197|24.392439|22.278269|20.657503|19.863871|19.421989|1.0618875|9.7474612E-2|4.0891368E-2|2.8069783E-2|7.4326068E-2|0.12647349|0.09305799|6.7493416E-2|5.1178217E-2|3.6285993E-2|6|1|9843|268435456|134242305|268435456|268435456|268435456|268435456|426.13858|294.72708|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296883|758883003882013161|254.143450184503|63.1952262985536|-0.12321350132081201|-0.433792640660496|0.89254824967676705|24.420551|22.420507|21.379045|20.036768|19.303392|1.0675972|0.11012571|6.6257305E-2|3.1343687E-2|6.8213344E-2|0.12615442|0.09282323|6.7323148E-2|5.1049106E-2|3.6194451E-2|6|1|9843|268436224|134217729|276824320|268435456|268435456|268435968|446.33209|340.42105|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296924|758883003882078780|254.35362358716|63.213879952583198|-0.121543053012642|-0.43396185497167999|0.89269501773780802|24.148626|22.229771|21.08288|19.835884|19.247555|0.99234414|9.2148289E-2|5.3101979E-2|2.7685452E-2|6.6436201E-2|0.11839948|0.08711721|6.3184671E-2|4.7911022E-2|0.03396951|6|1|26227|70369012613392|70369155252497|268468240|276856848|268468240|402685968|624.96185|1199.8881|0|33554432|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296930|758883003882013160|254.14762192948899|63.1726512474836|-0.12327796933558|-0.43413987455494701|0.89237050130420104|23.185259|22.478643|21.454748|19.897854|18.971148|0.54272854|0.1160919|7.0371129E-2|2.7505385E-2|5.4562375E-2|0.12485998|9.1870785E-2|0.06663236|0.0505253|3.5823066E-2|6|1|9843|268566784|142655745|276857088|268468224|268599296|402685952|642.10419|275.82297|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296932|758883003882078611|254.381619604744|63.215687059934801|-0.1213234145531|-0.43399407567418602|0.89270923113905598|22.927345|20.413939|19.341982|18.831104|18.566616|0.44359863|2.1314057E-2|2.6186133E-2|0.0177528|4.3984532E-2|0.11751115|8.6463585E-2|6.2710606E-2|4.7551554E-2|3.3714645E-2|6|1|9843|268566784|134251777|276987904|268468224|268468224|268468224|654.32758|1311.9592|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296935|758883003882013103|254.14008634615899|63.167313406629901|-0.123357786011079|-0.43420362637580101|0.892328452685752|25.21316|21.958879|20.539606|18.922096|18.007889|0.93986726|7.4435078E-2|3.8381316E-2|1.8182674E-2|3.5184838E-2|0.12471779|9.1766164E-2|6.6556476E-2|5.0467759E-2|0.03578227|6|1|9843|268435712|142639361|276857088|268468224|268468224|268468224|674.73572|228.16484|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296946|758883003882078737|254.41495263529799|63.213907801911397|-0.121078356809628|-0.43409128732288799|0.89269523678724605|25.182592|21.476791|20.061853|18.814104|18.171835|0.95961547|4.8720401E-2|3.1070055E-2|1.7671296E-2|3.7316699E-2|0.11657839|8.5777268E-2|6.2212832E-2|4.7174107E-2|3.3447031E-2|6|1|9843|268436224|142639361|276856832|268468224|268468224|402686464|721.99426|1431.6276|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296985|758883003882078674|254.21136729673799|63.153313211184503|-0.122876826174941|-0.43456655900176|0.892218129936028|25.237509|21.802692|20.367722|19.342039|18.797392|0.9269042|6.4987354E-2|3.3745464E-2|0.02130083|4.9465511E-2|0.12310542|0.0905798|6.5696023E-2|4.9815308E-2|3.5319675E-2|6|1|9843|268566784|134251777|268468224|268599296|268468224|268468224|905.91309|447.89618|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688296999|758883003882078741|254.447419111605|63.192782826597103|-0.120920601768644|-0.43447688243568799|0.89252901728564205|22.792055|21.069496|19.63295|18.728111|18.246805|0.39486387|3.5407055E-2|2.7595386E-2|1.7285252E-2|3.7659246E-2|0.11557206|8.5036822E-2|6.1675798E-2|4.6766888E-2|3.3158306E-2|6|1|9843|70369012744976|70369155277073|268468240|268468240|268468240|402817552|950.42627|1480.0494|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688297023|758883003882013019|254.14851420080501|63.125160990195603|-0.123473197988187|-0.43485316975521698|0.89199612674742601|24.298149|20.852705|19.475969|18.753109|18.37874|1.0286334|3.0681014E-2|2.6819918E-2|1.7364953E-2|4.0050846E-2|0.12318145|9.0635739E-2|6.5736599E-2|4.9846072E-2|3.5341486E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|1040.9749|110.22292|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688297070|758883003882144060|254.575343358955|63.185579852355701|-0.119980087230288|-0.43485393853184601|0.89247231375071501|23.102594|21.780788|20.570581|19.970812|19.66185|0.51181167|6.2186848E-2|3.8591966E-2|0.02966097|9.0078712E-2|0.10637342|0.07826855|5.6766883E-2|4.3044608E-2|3.0519165E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|402685952|1212.9026|1938.4282|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688297211|758883003882078764|254.201189132004|63.165268332276902|-0.12290333320076|-0.43436558038044898|0.89231234064586296|24.035568|23.176149|21.73818|19.712936|18.527645|0.94142735|0.21101351|0.10601617|2.5697958E-2|4.2946272E-2|0.12367282|9.0997286E-2|6.5998822E-2|5.0044905E-2|3.5482462E-2|6|1|9843|17592454611200|134219009|142639361|158329942966272|268435456|268435456|789.50641|451.93323|0|0|0|0|0|5739688296448|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688362087|5739688362087|254.24325613721001|63.014184623555501|-0.12322290979016901|-0.43671871652142702|0.89111889057674099|19.086956|19.067444|18.80619|18.466259|18.353838|2.3229985E-2|1.3629806E-2|1.5110987E-2|1.5721411E-2|0.03849639|0.13570292|9.9848926E-2|7.2418772E-2|5.4912958E-2|3.8933974E-2|3|1|26227|34628173824|276856832|268468224|268468224|268468224|268468224|760.88434|75.573433|0|5124|0|4|0|5739688361984|51638.389380300003|3|0|87899|0|0.0|20068|3.7599999457597733E-2|-21.502892112242684|1|0
5739688427566|758883003345207439|254.5712617266|62.917689115833703|-0.12111988519854899|-0.43886306436954298|0.89035340407147601|22.37878|20.803406|19.387337|18.634388|17.617134|0.27288702|3.9459467E-2|7.0677556E-2|0.62994349|3.3177163E-2|0.18264501|0.13438846|9.7469725E-2|7.3908336E-2|5.2401934E-2|6|1|9843|70369013535504|70369155383569|268992528|269127696|277774864|268992528|733.18951|985.36432|0|0|0|0|0|5739688427520|51638.389795000003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739688493265|98456812767936512|254.78317192501899|62.850934411250897|-0.119768104485074|-0.44030870047961301|0.88982236959407002|21.184944|20.931633|20.44821|20.163076|19.479012|0.10727981|3.4548339E-2|3.7271701E-2|3.5226654E-2|8.1992134E-2|0.27130878|0.19962642|0.14478573|0.10978664|7.7840097E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|268.72815|1563.2737|0|33559552|0|0|0|5739688493056|51638.3902094|3|0|87897|0|0.0|20082|1.9600000232458115E-2|-25.163613303814586|0|0
5739688493439|99020111758753792|254.69534446170701|62.789033373743599|-0.120696580867342|-0.44105158670410199|0.88932886674881195|25.394117|23.505594|22.422924|22.289427|21.30188|0.87003374|0.25742406|0.15429272|0.2042333|0.36743796|0.32424098|0.23857342|0.17303334|0.13120595|9.3026653E-2|3|1|26227|70369012613392|70369188806929|70369180419345|302023952|444629264|70369180419345|648.74872|1009.7152|0|128|0|0|0|5739688493056|51638.3902094|3|0|87897|0|0.0|0|0.0|-22.716702767721429|0|0
5739688493659|98456812776325120|254.72121138300699|62.7823372808042|-0.12052483779567701|-0.44120629006134998|0.88927542026338802|24.365017|23.726511|22.099075|22.579092|21.147005|1.0726119|0.30678549|0.1172803|0.26173073|0.3240442|0.33689797|0.24788633|0.17978784|0.13632767|9.6658021E-2|3|1|26227|268436224|134251777|134251777|268469504|142639105|134251009|746.94348|1087.1267|0|128|0|0|0|5739688493056|51638.3902094|3|0|87897|0|0.0|0|0.0|-19.318851050263419|0|0
5739688558860|587725491060408556|254.948980418297|62.6386109553005|-0.11934885760903401|-0.44383475490046798|0.88812530677256296|20.071501|19.7194|19.468687|19.156612|19.100239|5.0848085E-2|1.8588448E-2|2.0438297E-2|1.5402989E-2|5.3587679E-2|0.28506407|0.20974743|0.15212634|0.11535279|8.1786573E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|955.40686|1466.2816|0|34603008|0|0|0|5739688558592|51638.390624|3|0|87897|0|0.0|0|0.0|0.0|0|0
5739688624268|5739688624268|254.767346169159|62.503429648277397|-0.12130547166453901|-0.445474727773294|0.88703847123986301|18.807632|18.860771|18.660912|18.570797|18.102276|0.04004024|1.0580125E-2|1.1150362E-2|1.4834817E-2|3.9294772E-2|0.23520374|0.17306067|0.12551804|9.5176525E-2|6.7481346E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|442.33368|294.61295|0|4|0|4|0|5739688624128|51638.3910388|3|0|87897|0|0.0|0|0.0|-22.706370288656757|1|0
5739688624316|5739688624316|254.96661775529799|62.466295883691998|-0.119904496617789|-0.44644905226767001|0.88673905711890999|19.234604|19.290758|19.091894|19.018764|18.979548|4.2664424E-2|1.2158043E-2|1.2943753E-2|1.7572863E-2|0.05603851|0.19662379|0.14467391|0.1049296|7.9564936E-2|5.6412529E-2|6|1|26227|268435456|268468224|268468224|268435456|268468224|402685952|1072.4578|939.92523|0|1048580|0|4|0|5739688624128|51638.3910388|3|0|87897|0|0.0|0|0.0|-26.543139560672998|1|0
5739688689932|5739688689932|255.195633879637|62.348994007211701|-0.118582676878253|-0.44867897467581802|0.88579079156889196|20.05533|19.923035|19.298059|18.878912|18.45919|6.4968511E-2|1.8758897E-2|1.7205067E-2|0.01760602|0.06129289|0.13157414|9.6811004E-2|7.0215419E-2|5.3242225E-2|3.7749402E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|1062.5265|1429.9088|0|4|0|4|0|5739688689664|51638.391453199998|3|0|87897|0|0.0|0|0.0|-22.320381181327534|1|0
5739688820927|5739688820927|255.24533783705601|62.027107049468398|-0.119458915341244|-0.45358683549633499|0.88316960444181603|19.036341|19.102749|18.903437|18.860182|19.001757|0.03548776|1.7918322E-2|1.5082961E-2|1.5968263E-2|5.2533403E-2|0.13513066|9.9427849E-2|7.2113372E-2|5.4681387E-2|3.8769785E-2|6|1|26227|17592454611456|268468736|268468224|268468224|17592454643712|402685952|1132.5018|524.96191|0|1048580|0|4|0|5739688820736|51638.392282499997|3|0|88002|0|0.0|0|0.0|-26.375563402865005|1|0
5739688821122|587725491060670673|255.40468340387901|62.160811241900603|-0.11767732292904801|-0.45192163626014498|0.88426177252451998|24.539526|20.80238|20.293188|20.207708|20.047201|0.95011038|3.1082299E-2|2.8276915E-2|3.5288483E-2|0.11966418|0.12915936|9.5034234E-2|6.8926752E-2|0.05226507|3.7056584E-2|6|1|9843|268567296|134382849|268468224|268468224|402685952|402686464|258.04065|1608.8843|0|0|0|0|0|5739688820736|51638.392282499997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739689017380|5739689017380|255.870687237005|61.686102818446898|-0.11578235689538|-0.45995282565800599|0.88036233676876896|17.392076|16.96874|16.700985|16.262623|16.218941|5.0086714E-2|1.3948374E-2|1.1400486E-2|7.3539852E-3|2.4395863E-2|0.15376766|0.11314078|8.2059138E-2|6.2222958E-2|4.4116855E-2|3|1|26227|34628309008|276856848|268603408|268468240|268599312|268468240|921.89044|1865.5162|0|7236|0|4|0|5739689017344|51638.393526499996|3|0|88002|0|0.0|20098|0.18080000579357147|-21.850020805576946|1|0
5739689083068|5739689083068|255.79036931937699|61.460402732325498|-0.117277379217685|-0.46314831993017003|0.87848713711112003|18.244965|18.217062|18.296154|18.836714|18.470673|5.2591532E-2|2.8954808E-2|3.9638564E-2|0.06749779|6.7392223E-2|0.16038546|0.1180101|8.5590765E-2|0.06490089|4.6015538E-2|3|1|26227|34628309008|268599312|268603408|268468240|268468240|268599312|1343.1809|789.36133|0|68|0|4|0|5739689082880|51638.393941100003|3|0|88002|0|0.0|0|0.0|-16.206776720347264|1|0
5739689148610|587725491060998267|256.09743187229901|61.398213283620301|-0.115022613982366|-0.46469549810312799|0.87796804743415902|20.438389|18.549381|17.707333|17.391886|17.136078|6.2642895E-2|1.2511503E-2|1.0104557E-2|1.1161373E-2|1.8555203E-2|0.1343866|0.09888038|7.1716301E-2|5.4380301E-2|3.8556311E-2|6|1|9843|268570640|302022672|302022672|302157840|302022672|302022672|995.01288|1824.9634|0|0|0|0|0|5739689148416|51638.394355700002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739689148853|5739689148853|255.89730858390899|61.435383074845703|-0.116506196282258|-0.46373841218091599|0.87827842470128004|25.537621|20.812994|19.873213|19.798645|19.848604|0.79977965|0.02863431|1.9406594E-2|2.6221829E-2|9.9346265E-2|0.15014654|0.1104764|8.0126703E-2|6.0757652E-2|4.3077931E-2|6|1|26227|268435712|134251777|268468224|268468224|268468224|268468224|363.73743|1137.7677|0|1|1|0|0|5739689148416|51638.394355700002|3|0|88002|0|0.0|0|0.0|-28.685123963214082|1|0
5739689279893|587725491061129528|256.01680954282199|61.136295586581099|-0.116644978308269|-0.468422865219703|0.87577049983133604|24.867323|21.047422|20.201458|19.95083|19.863638|1.0211018|3.4730524E-2|2.5413355E-2|2.9936371E-2|0.10448718|0.13240841|0.09742485|7.0660628E-2|5.3579815E-2|3.7988756E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|364.10754|630.24475|0|0|0|0|0|5739689279488|51638.395185100002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739689476372|587725491061326116|256.39522910006099|60.704427272120903|-0.115098179793131|-0.47558557791759498|0.87210708464333397|20.716497|20.199858|19.301159|18.898497|18.496136|7.2077349E-2|0.02062273|1.5475624E-2|1.2168245E-2|0.03737|0.1169792|8.6072184E-2|6.2426727E-2|4.7336299E-2|3.3562027E-2|3|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|546.35211|769.18756|0|4096|0|0|0|5739689476096|51638.396429200002|3|0|88000|0|0.0|20107|9.4400003552436829E-2|0.0|0|0
5739689476389|587725491061325914|256.61129796983602|60.71264574584|-0.11327491101050299|-0.47589454387401697|0.87217726274336205|19.567198|19.472952|19.240164|19.117474|19.074429|0.04006942|1.5734872E-2|1.5137517E-2|1.4190693E-2|5.3890977E-2|0.121303|8.9253597E-2|6.4734153E-2|4.9085949E-2|3.4802549E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|819.03912|1693.7378|0|34603008|0|0|0|5739689476096|51638.396429200002|3|0|88000|0|0.0|0|0.0|0.0|0|0
5739689607292|5739689607292|256.81913216589402|60.408866299209102|-0.112600787392249|-0.48079800519677701|0.86957135467852498|19.467968|19.191597|19.285503|19.039742|19.077581|3.0228039E-2|1.6266318E-2|1.4244366E-2|2.0895377E-2|0.05596555|0.11370321|8.3661735E-2|6.0678471E-2|4.6010647E-2|3.2622121E-2|6|1|26227|268567056|268468240|268468240|268566544|268566544|402686480|1008.8583|1583.0464|0|4|0|4|0|5739689607168|51638.397258500001|3|0|88000|0|0.0|0|0.0|-27.404733646058823|1|0
5739689607311|5739689607311|256.62274492485199|60.334909146751002|-0.11450770205350499|-0.481500815032947|0.86893322602662304|19.003014|19.132599|18.955523|19.020744|19.137453|2.8188538E-2|0.01610247|1.3015922E-2|2.0914758E-2|5.9679043E-2|0.10413319|7.6620206E-2|5.5571366E-2|4.2138085E-2|2.9876428E-2|6|1|26227|17592454610944|158329942999040|268468224|268468224|268468224|402685952|1325.9528|519.06299|0|4|0|4|0|5739689607168|51638.397258500001|3|0|88000|0|0.0|0|0.0|-26.211097135592055|1|0
5739689607416|587725491061456988|256.73374328224997|60.393884712021297|-0.113369376684251|-0.48085095014738|0.86944220519398896|19.661932|19.700565|19.300503|19.131731|19.15242|0.03338673|0.01804862|1.4683978E-2|2.1619147E-2|5.9564911E-2|0.10848176|7.9819843E-2|0.05789201|4.3897759E-2|3.1124057E-2|6|1|26227|268566544|268468240|268599312|276856848|268468240|402685968|1001.1185|1176.0427|0|33554432|0|0|0|5739689607168|51638.397258500001|3|0|0|0|0.0|0|0.0|0.0|0|0
5739689803968|5739689803968|257.01767768969501|59.976472575519097|-0.11240508873996399|-0.487566197752344|0.86582001526569197|19.063618|19.001545|19.105028|18.924141|18.992973|0.05851775|0.01410247|1.6552934E-2|1.7094407E-2|5.1670864E-2|0.11117545|8.1801839E-2|5.9329517E-2|4.4987775E-2|3.1896893E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|921.90729|1040.8549|0|4|0|4|0|5739689803776|51638.3985025|3|0|88065|0|0.0|0|0.0|-27.336795020118437|1|0
5739689803984|5739689803984|257.18991644300502|59.954511833029599|-0.11101246544391299|-0.48822546101464698|0.86562817175338003|19.471577|19.401529|18.951035|18.980135|18.432571|6.0988452E-2|1.5447908E-2|1.5808305E-2|1.6115434E-2|3.4558266E-2|0.11036187|8.1203215E-2|5.8895342E-2|4.4658557E-2|3.1663474E-2|6|1|26227|268566544|268468240|268468240|268468240|268599312|268468240|1381.6947|1705.9827|0|4|0|4|0|5739689803776|51638.3985025|3|0|88065|0|0.0|0|0.0|-22.18688122468842|1|0
5739689869365|587725491061719171|257.00200808414598|59.789062326618001|-0.113174796129798|-0.49029229590860901|0.86417876049671805|19.160475|18.382866|18.019222|17.972309|17.874863|6.5175138E-2|2.3319466E-2|1.2838532E-2|9.4297389E-3|2.5093226E-2|0.12449364|9.1601238E-2|6.6436857E-2|5.0377056E-2|0.03571796|6|1|9843|269090832|268468240|268468240|268992528|269123600|268992528|1132.5356|377.25989|0|0|0|0|0|5739689869312|51638.398917099999|3|0|0|0|0.0|0|0.0|0.0|0|0
5739689934938|5739689934938|257.26275696997902|59.758534799650903|-0.111043849689068|-0.49125130618608198|0.863910537970628|19.34132|19.176161|19.01037|18.72941|18.59861|3.5062611E-2|2.2187017E-2|1.2521807E-2|1.4536733E-2|4.0036488E-2|0.11835662|8.7085672E-2|6.3161798E-2|4.7893677E-2|3.3957213E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|446.23605|1399.0317|0|1048580|0|4|0|5739689934848|51638.399331799999|3|0|88065|0|0.0|0|0.0|-27.554029824031289|1|0
5739690066539|5739690066539|257.56052111617498|59.390694612063797|-0.10968182602058001|-0.49722770775823699|0.860659342410387|23.173067|22.505878|20.480354|19.668507|19.359388|0.52859539|0.11148968|0.03065693|2.4361864E-2|6.9713734E-2|0.11391879|8.3820358E-2|6.0793519E-2|4.6097882E-2|3.2683972E-2|6|1|26227|268435712|134251777|268468224|268468224|268468224|268468224|1335.7089|1533.6888|0|33554433|1|0|0|5739690065920|51638.400161199999|3|0|88065|0|0.0|0|0.0|-29.480114449456117|1|0
5739690131599|587725491061981242|257.52127118284898|59.349160614112499|-0.110157202216842|-0.49776148144882698|0.860290008302797|19.32489|19.314083|19.068871|19.07176|19.19594|0.0501258|2.1110099E-2|1.1750462E-2|0.02072265|6.4226851E-2|0.11305162|8.3182313E-2|6.0330752E-2|4.5746982E-2|3.2435179E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|267.33472|1233.3135|0|34603008|0|0|0|5739690131456|51638.400575799998|3|0|88065|0|0.0|0|0.0|0.0|0|0
5739690197166|5739690197166|257.62283973384501|59.142997777925103|-0.10993744694445901|-0.50097631187946201|0.85845005253362705|18.474791|18.429409|18.21106|18.302935|18.162169|2.3147305E-2|2.6044656E-2|1.5265603E-2|1.2058459E-2|0.02766059|0.1149124|8.4551446E-2|6.1323762E-2|4.6499953E-2|3.2969046E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|829.05426|1035.3979|0|4|0|4|0|5739690196992|51638.400990499998|3|0|88065|0|0.0|0|0.0|-25.989228506405894|1|0
5739690197233|587725491062046969|257.74834582551398|59.2003619019277|-0.108657358226598|-0.50037577658417798|0.85896313117094703|22.612343|22.77084|20.774416|19.553795|18.942522|0.33749735|0.14268012|3.9510068E-2|2.1995815E-2|4.8630413E-2|0.11308247|8.3205007E-2|6.0347211E-2|4.5759462E-2|0.03244403|6|1|26227|70369012613904|70369146832145|276824336|268435472|268468240|402686480|537.05664|1762.7963|0|33554432|0|0|0|5739690196992|51638.400990499998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739690328208|5739690328208|257.862263119094|58.9289321683287|-0.108516670542515|-0.50456342675675303|0.85652780491578295|19.158451|18.875013|19.002373|18.858158|18.842817|6.8309754E-2|2.2065291E-2|1.2372773E-2|1.6265195E-2|0.05843598|0.12364087|9.0973772E-2|6.5981768E-2|5.0031975E-2|3.5473295E-2|6|1|26227|268570624|268468224|268603392|268468224|268468224|402685952|317.58405|1427.1732|0|7172|0|4|0|5739690328064|51638.401819699997|3|0|88065|0|0.0|20136|2.1800000220537186E-2|-24.106098311214268|1|0
5739690328276|5739690328276|257.93680562204298|58.822119900240402|-0.108193655922401|-0.50626480430768195|0.85556418855480898|19.184448|19.108007|19.096369|18.859158|18.968634|0.06849844|2.2516567E-2|1.2825055E-2|1.6116047E-2|6.2076025E-2|0.1569712|0.11549792|8.3768725E-2|6.3519292E-2|4.5035969E-2|6|1|26227|268435968|268468224|268468224|268468224|268468224|402686464|1349.9891|1428.8292|0|1048580|0|4|0|5739690328064|51638.401819699997|3|0|88063|0|0.0|0|0.0|-27.116188218613097|1|0
5739690393658|5739690393658|258.03102199288799|58.798475388347001|-0.10743422647806899|-0.50678738261448397|0.85535047542151998|17.952333|18.055325|17.98756|18.018316|17.533535|2.2893652E-2|1.1295813E-2|1.6508896E-2|1.8218465E-2|2.5120888E-2|0.16440345|0.1209665|8.7734997E-2|6.6526793E-2|4.7168326E-2|6|1|26227|268435984|268468752|268468240|268468240|268468240|268468240|340.39377|1774.51|0|7172|0|4|0|5739690393600|51638.402234300003|3|0|88063|0|0.0|20139|0.05820000171661377|-23.129808617297648|1|0
5739690393795|5739690393795|257.82361661440399|58.689960557390499|-0.10960953544169701|-0.50797779052412395|0.85436778618723996|19.227285|18.749319|18.749548|18.461306|18.488232|3.0092014E-2|1.2305593E-2|1.7656324E-2|1.8936375E-2|3.7439454E-2|0.22939864|0.16878934|0.12242011|9.2827462E-2|6.5815829E-2|6|1|26227|268566528|268599296|276856832|268468224|268599296|411074560|940.62781|520.45361|0|1048580|0|4|0|5739690393600|51638.402234300003|3|0|88063|0|0.0|0|0.0|-24.927518021224564|1|0
5739690524723|5739690524723|258.211908139228|58.463430853704097|-0.106853746154264|-0.51201161954729901|0.852306504950744|17.073011|16.016932|15.903893|15.940574|15.868747|1.9848246E-2|9.3696658E-3|1.1130741E-2|1.3769683E-2|2.1843366E-2|0.22689979|0.1669507|0.12108658|9.1816291E-2|6.5098889E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|775.38403|1562.1448|0|4|0|4|0|5739690524672|51638.403063600002|3|0|88063|0|0.0|0|0.0|2.3863932493534463|1|0
5739690655782|587725491062505537|258.23528746526102|58.168986408142104|-0.107536457678452|-0.51633641169466804|0.84960733296520297|23.85829|21.353466|19.715126|18.730785|18.112717|0.92617375|6.5949477E-2|3.4295116E-2|3.3150595E-2|6.3967586E-2|0.19569555|0.14399093|0.10443423|7.9189315E-2|5.6146212E-2|6|1|9843|87961199579920|70369155387665|17592455168560|268992528|277774896|158329943523344|615.49628|775.54913|0|0|0|0|0|5739690655744|51638.403892900002|3|0|0|0|0.0|0|0.0|0.0|0|0
5739690721391|5739690721391|258.54845846512501|57.976127947271898|-0.10527982625261|-0.51971640316287704|0.84782723385585002|17.035503|16.602829|16.305382|15.980943|15.910972|1.8506406E-2|1.0330558E-2|2.5782447E-2|1.7641034E-2|2.8715758E-2|0.22611637|0.16637428|0.1206685|9.1499269E-2|6.4874128E-2|3|1|26231|268566544|268599312|268468240|268599312|268599312|268468240|1406.3262|1616.5985|0|7236|0|4|0|5739690721280|51638.404307500001|3|0|88224|0|0.0|20153|0.14470000565052032|-22.587273380756649|1|0
5739690721430|587725491062571041|258.35714884658302|58.074444911581203|-0.106720802262847|-0.51793631588554501|0.84873590889703898|19.187456|18.069826|17.710379|17.51594|17.499916|2.7749261E-2|0.01134795|2.6261631E-2|1.8608846E-2|3.3640034E-2|0.19801942|0.1457008|0.10567438|8.0129683E-2|5.6812942E-2|6|1|9843|268435472|302022672|302022672|302022672|302022672|302022672|259.28949|1042.2264|0|0|0|0|0|5739690721280|51638.404307500001|3|0|0|0|0.0|0|0.0|0.0|0|0
5739690786951|5739690786951|258.55581177365099|57.953070432416702|-0.105280813527777|-0.52006427567389202|0.847613767862886|19.196281|18.804115|18.366535|18.228052|18.165848|4.2079467E-2|1.7902302E-2|1.5014479E-2|1.5321551E-2|3.2321177E-2|0.22388048|0.16472913|0.11947531|9.0594508E-2|6.4232633E-2|6|1|26227|268566528|268468224|276856832|268468224|268599296|402685952|254.83124|1581.2748|0|1048580|0|4|0|5739690786816|51638.4047221|3|0|88224|0|0.0|0|0.0|-27.174296933185133|1|0
5739690917954|5739690917954|258.84237095723898|57.607415230193901|-0.103666091096469|-0.525591666625013|0.84439726523190495|17.272968|17.449715|17.440863|17.067307|16.960176|2.4373725E-2|0.01343144|8.1605297E-3|1.0445286E-2|3.4938138E-2|0.21157344|0.15567371|0.11290757|8.5614391E-2|6.0701668E-2|6|1|26227|268435968|268468224|285245952|268468224|285245952|402686464|956.22437|1868.4437|0|4|0|4|0|5739690917888|51638.405551299998|3|0|88224|0|0.0|0|0.0|-29.756560436567284|1|0
5739690983628|587725491062833504|258.94760730509603|57.439403050968103|-0.103174790455959|-0.52820907756061697|0.84282271741863402|21.395004|18.848|17.488024|16.739428|16.374264|0.11841092|9.2573091E-3|7.0748311E-3|1.6924782E-2|2.2434304E-2|0.17500402|0.1287663|9.3392059E-2|7.0816368E-2|5.0209686E-2|6|1|9843|268566800|276857104|268599312|268468240|268468240|268468240|1206.6377|1859.9713|0|0|0|0|0|5739690983424|51638.405965799997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739690983722|5739690983722|258.628717903557|57.4305013836683|-0.106138831079474|-0.52775502965363397|0.84273909201625097|19.720657|19.21999|19.088995|19.051367|18.917463|0.03403778|1.1211547E-2|1.2372494E-2|2.3815235E-2|5.6101933E-2|0.16811845|0.12369996|0.08971753|6.8030082E-2|0.04823418|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|777.42841|357.5253|0|4|0|4|0|5739690983424|51638.405965799997|3|0|88224|0|0.0|0|0.0|-16.972482833981047|1|0
5739690984202|587725491062833596|258.96223893759498|57.418064157220897|-0.103099988310381|-0.52854346056523105|0.84262221825924399|24.64744|21.731873|20.278763|18.892384|18.152075|1.0796736|5.5801094E-2|2.4044281E-2|2.0289283E-2|3.2202728E-2|0.17229162|0.12677054|9.1944568E-2|6.9718786E-2|4.9431488E-2|6|1|9847|268435712|142639361|276856832|276856832|268468224|268468224|1413.4261|1864.9648|0|0|0|0|0|5739690983424|51638.405965799997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739691114662|587725491062964500|258.99531648118398|57.190429662296197|-0.103433066244272|-0.53188486767780496|0.84047610813316498|20.167116|19.724541|19.370295|19.095602|19.038406|5.6995846E-2|1.3766114E-2|2.0139905E-2|1.6765881E-2|4.9837761E-2|0.1346312|9.9060357E-2|7.1846835E-2|5.4479279E-2|3.8626488E-2|3|1|9843|268435472|268468240|268468272|268468240|268468240|268468240|703.70349|1351.5946|0|0|0|0|0|5739691114496|51638.406795100003|3|0|0|0|0.0|0|0.0|0.0|0|0
5739691245698|5739691245698|259.09857815643397|56.912477145285997|-0.103244196550279|-0.53606786751318602|0.83783761988738203|19.264959|19.103155|18.85264|18.922859|18.759958|7.1133524E-2|1.3479924E-2|1.5083085E-2|1.4860871E-2|4.3764107E-2|0.11498406|8.4604174E-2|6.1362006E-2|0.04652895|3.2989606E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|538.88721|1021.886|0|1048580|0|4|0|5739691245568|51638.407624400003|3|0|88224|0|0.0|0|0.0|-25.604432979735222|1|0
5739691245743|587725491063095562|259.28696217739298|56.898954980157697|-0.10151784680928|-0.53659870175065305|0.83770875610722895|20.071772|19.431143|19.332613|19.140835|18.788925|7.8254275E-2|1.4657618E-2|1.7220765E-2|1.6983187E-2|0.04420663|0.12240481|9.0064302E-2|6.5322146E-2|4.9531803E-2|3.5118666E-2|6|1|26227|268435456|268468224|276856832|268468224|268468224|268468224|953.48389|1868.868|0|1048576|0|0|0|5739691245568|51638.407624400003|3|0|88224|0|0.0|0|0.0|0.0|0|0
5739691245781|5739691245781|259.074686079917|56.928593113699897|-0.103423056045607|-0.535793354537763|0.83799114118906903|22.8997|20.283026|18.579647|17.991898|17.483505|0.41461539|2.1043669E-2|1.4115687E-2|1.0076301E-2|2.5377195E-2|0.11386396|0.08378002|6.0764257E-2|4.6075698E-2|3.2668244E-2|6|1|26227|268571392|134219009|268435456|268570624|268468224|268468736|362.21811|957.02917|0|1|1|0|0|5739691245568|51638.407624400003|3|0|88224|0|0.0|0|0.0|4.4834563139286416|1|0
5739691311237|5739691311237|259.03882530574202|56.776195611485001|-0.10418183059358301|-0.53791487761330203|0.83653674791752997|19.029779|19.119444|19.094786|18.993971|18.765024|2.2452082E-2|1.7835967E-2|1.2429595E-2|1.5432508E-2|0.04667962|0.1222422|8.9944646E-2|6.5235361E-2|4.9465999E-2|0.03507201|6|1|26227|268566544|268468240|268468240|268599312|268468240|402685968|256.65952|342.37827|0|4|0|4|0|5739691311104|51638.408038900001|3|0|88224|0|0.0|0|0.0|-27.845594414227776|1|0
5739691311740|587725491063161659|259.17688672963101|56.723469620266997|-0.103029866146816|-0.53892024959451801|0.83603218314772498|24.158901|21.279531|20.445461|20.037649|19.519182|0.95427775|4.0368084E-2|2.9767923E-2|3.0799787E-2|8.0467001E-2|0.12582314|9.2579469E-2|6.7146353E-2|5.0915048E-2|3.6099404E-2|6|1|9843|268435712|134219009|268468224|268435456|268435456|268435456|930.49451|840.7312|0|0|0|0|0|5739691311104|51638.408038900001|3|0|0|0|0.0|0|0.0|0.0|0|0
5739691508134|5739691508134|259.32778736336797|56.336156625790601|-0.102654418094281|-0.54473109742291903|0.83230409223200796|23.348663|21.364233|20.47291|19.475245|18.786215|0.59446692|4.1409228E-2|2.9547973E-2|2.2385504E-2|4.3279797E-2|0.12872264|9.4712891E-2|0.06869369|5.2088346E-2|3.6931287E-2|3|1|26227|34628174080|142606593|268468224|268435456|268468224|268468224|426.31711|434.88998|0|4|0|4|0|5739691507712|51638.409282699999|3|0|88222|0|0.0|0|0.0|-20.801381047703771|1|0
5739691573398|587725491063423251|259.56606274571999|56.204041324800798|-0.100735466214964|-0.54703927395163499|0.831023705197945|22.55328|19.944521|18.975414|18.673464|18.479561|0.31450501|2.3143204E-2|0.06469997|1.8487705E-2|3.7856299E-2|0.11956453|8.7974444E-2|6.3806407E-2|4.8382469E-2|3.4303773E-2|6|1|9843|70369012744464|70369021034769|268599312|268468240|268468240|268468240|584.59167|1197.7863|0|0|0|0|0|5739691573248|51638.409697199997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739691573486|587725491063423232|259.372026864048|56.190213185720097|-0.102624456481823|-0.54689209863699295|0.83088943511169799|19.834826|19.352573|18.537428|18.169483|17.741829|4.0285196E-2|1.7851796E-2|1.2980802E-2|1.2568986E-2|2.5467999E-2|0.13372074|9.8390445E-2|7.1360961E-2|5.4110855E-2|3.8365271E-2|3|1|9843|268566528|268468224|268468224|268599296|268468224|268468224|395.40604|226.47009|0|0|0|0|0|5739691573248|51638.409697199997|3|0|0|0|0.0|0|0.0|0.0|0|0
5739691770590|5739691770590|259.93650378527798|55.735681576625801|-9.8380317398447895E-2|-0.554349382063822|0.826449076322334|25.896135|21.114758|19.948757|19.792603|19.880358|0.89259809|3.5305146E-2|2.3722081E-2|3.1238193E-2|0.10503763|0.17768617|0.13073979|9.4823405E-2|7.1901716E-2|5.0979212E-2|6|1|26227|17592454610944|1099645976577|268435456|268435456|158329942999040|268435456|1133.8219|1660.884|0|1|1|0|0|5739691769856|51638.410941299997|3|0|88365|0|0.0|0|0.0|-28.944575723531806|1|0
5739691770866|100709103596208128|259.69965303273102|55.798594634514401|-0.100508729429152|-0.55304477665224305|0.82706678710138504|24.237057|24.206001|23.254309|21.093204|19.377245|0.94144177|0.4148185|0.3163467|7.2765097E-2|7.2723925E-2|0.15731227|0.11574887|8.3950736E-2|6.3657299E-2|4.5133822E-2|6|1|26227|268435712|134219009|142606593|142606593|268468224|268435456|214.79266|686.91956|0|262144|0|0|0|5739691769856|51638.410941299997|3|0|88365|0|0.0|0|0.0|7.5671812895145791|0|0
5739692032030|5739692032030|260.134552451133|55.225089965042798|-9.7721587631789106E-2|-0.56192000891435401|0.82139904729212698|17.959396|18.025547|17.9625|17.984289|17.470356|1.7640531E-2|9.1225337E-3|9.9658174E-3|2.0235479E-2|0.02876425|0.20996717|0.15449184|0.11205037|8.4964402E-2|0.06024082|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|421.04437|1201.417|0|134224900|0|4|0|5739692032000|51638.412599900003|3|0|88365|0|0.0|20203|3.5199999809265137E-2|-23.213323494059956|1|0
5739692097632|5739692097632|260.11038706306601|54.9509846665905|-9.8632365697168295E-2|-0.56574351250874699|0.81866106203437095|17.822159|17.663822|17.550652|17.674406|17.553415|1.6058799E-2|9.6943835E-3|6.0271523E-3|1.3756743E-2|2.1638034E-2|0.21340075|0.15701824|0.11388273|8.6353824E-2|0.06122594|6|1|26231|268435968|276857344|276857344|276857344|268468736|419463680|1394.4183|317.38544|0|1048580|0|4|0|5739692097536|51638.413014400001|3|0|88365|0|0.0|0|0.0|-26.790634494848845|1|0
5739692228615|103524642420948992|260.15776610664199|54.783453263098401|-9.8573263623045304E-2|-0.56818097143881896|0.81697839346799195|22.240417|22.202276|21.334124|20.777163|20.854559|0.24202307|8.7881319E-2|0.05928519|5.6138262E-2|0.25433668|0.21773219|0.16020527|0.11619423|8.8106565E-2|6.2468652E-2|3|1|26227|105553385358100|70369180483633|302613812|302613776|302613812|70369181008405|198.08484|86.459587|0|64|0|0|0|5739692228608|51638.413844100003|3|0|88365|0|0.0|0|0.0|-23.380077389284082|0|0
5739692228801|5739692228801|260.49755005171897|54.706001802532498|-9.5384273194043606E-2|-0.56984425452152199|0.81619811689077904|19.648563|18.543362|18.445942|18.458614|18.415297|3.3572331E-2|9.6405828E-3|1.0396767E-2|1.6266467E-2|5.2026182E-2|0.22960076|0.16893806|0.12252797|9.2909247E-2|6.5873817E-2|6|1|26231|268435456|268468224|268468224|268468224|268468224|402685952|1409.2974|1571.9718|0|1056772|0|4|0|5739692228608|51638.413844100003|3|0|88363|0|0.0|0|0.0|4.9033400419559854|1|0
5739692294226|101272087485743104|260.312615858171|54.526787430716901|-9.7652183469866899E-2|-0.57204719021899797|0.81438692476372498|22.542206|20.669334|19.244059|18.679716|18.294428|0.32271332|4.1327462E-2|2.8215135E-2|2.6945831E-2|4.3880086E-2|0.2336846|0.1719429|0.12470733|0.0945618|6.7045495E-2|3|1|26227|70369012744464|70369155252497|268468240|268468240|268599312|268468240|1307.5962|150.21698|0|32|0|0|0|5739692294144|51638.414258500001|3|0|88363|0|0.0|0|0.0|-26.605790022725856|0|0
5739692359775|587725491064209569|260.619750179991|54.464500930833502|-9.4728572563698696E-2|-0.57343558087523305|0.81375557271598897|17.790171|17.245905|17.164244|17.018856|16.931732|2.3796767E-2|2.9547704E-2|5.6822922E-2|0.0930086|6.3636407E-2|0.26035631|0.19156769|0.13894087|0.10535465|7.4697763E-2|6|1|9843|17592454610960|268468240|268599312|268468240|158329942999056|268468240|974.64825|1525.579|0|0|0|0|0|5739692359680|51638.4146731|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692360021|101272087687069696|260.45539244691503|54.405221490150502|-9.6512681659006394E-2|-0.57399145212772495|0.81315380781454405|19.852011|19.691856|19.738148|19.438732|19.526266|4.1490026E-2|1.8367391E-2|1.9301368E-2|2.0680889E-2|7.8339785E-2|0.23175658|0.1705243|0.12367844|0.09378162|6.6492334E-2|6|1|26227|268435968|268468736|268468224|268435456|268468224|268435456|1228.0784|534.28601|0|34603008|0|0|0|5739692359680|51638.4146731|3|0|88363|0|0.0|0|0.0|-26.98449682124194|0|0
5739692425266|5739692425266|260.51930341859298|54.343822269070003|-9.6015835347865994E-2|-0.57495790946918401|0.81252960666136698|22.460955|20.255032|18.866371|18.247953|17.329777|0.30632249|0.05360429|0.67438638|6.8314455E-2|0.02399167|0.23161341|0.17041895|0.12360204|9.3723685E-2|6.6451259E-2|6|1|26227|70403373007120|70369146864913|276856848|268992528|268468240|268468240|500.78995|688.63562|0|1|1|0|0|5739692425216|51638.4150878|3|0|88363|0|0.0|0|0.0|4.6918646696415323|1|0
5739692425284|587725491064275056|260.48658912432001|54.3062281469767|-9.6432199476168004E-2|-0.57542867152660804|0.81214695399866599|22.178104|20.701853|19.838276|19.643785|19.316132|0.23845726|3.7205763E-2|2.7848218E-2|4.8883688E-2|6.8586327E-2|0.2184706|0.16074859|0.11658829|8.8405363E-2|6.2680505E-2|6|1|9843|70369012613904|70369155252497|276856848|268468240|268468752|402685968|775.33002|419.94772|0|0|0|0|0|5739692425216|51638.4150878|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692425551|101272087825481728|260.76411773335002|54.290056325779901|-9.3680612119303994E-2|-0.57611525143633302|0.81198224116996698|20.526356|20.376997|20.13619|20.143509|20.142075|6.2115069E-2|2.6663769E-2|2.5228515E-2|3.6181953E-2|0.13079043|0.27232316|0.20037279|0.14532706|0.1101971|7.8131124E-2|6|1|26227|268435456|268435456|268468224|268435456|268435456|268435456|1355.6511|1780.9508|0|34603008|0|0|0|5739692425216|51638.4150878|3|0|88363|0|0.0|0|0.0|-25.221751939244946|0|0
5739692490943|5739692490943|260.78748608618702|54.158054433192099|-9.3744877752558201E-2|-0.57799845096925895|0.81063536104237099|19.196609|19.19142|18.956514|18.912029|18.995951|3.1021185E-2|1.4903426E-2|0.12025569|1.9092461E-2|5.5164304E-2|0.26803154|0.19721507|0.14303681|0.10846049|7.6899834E-2|6|1|26227|17592454610960|268468240|268468240|268468240|158329942999056|268468240|1177.5676|1541.5576|0|4|0|4|0|5739692490752|51638.415502399999|3|0|88363|0|0.0|0|0.0|-26.116838126982636|1|0
5739692556387|587725491064406188|260.86432087127503|54.014594104139697|-9.3291657987101803E-2|-0.58012579747936999|0.80916668594854002|23.025|21.99523|20.13648|19.477053|18.629477|0.4786469|0.11284466|6.5396242E-2|6.7672372E-2|3.9230548E-2|0.26763138|0.19692062|0.14282326|0.10829856|7.6785028E-2|3|1|9843|70369013269336|70369146864921|276857144|277381656|277512728|402686488|1183.6549|1545.4449|0|0|0|0|0|5739692556288|51638.415917099999|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692556433|5739692556433|260.87140596261202|54.132171614388|-9.2956283733904202E-2|-0.57849663678400698|0.81037076116057805|18.983362|18.722696|18.883661|19.024128|19.283365|2.8292811E-2|2.0291427E-2|0.01350465|3.1598516E-2|6.4670831E-2|0.28976569|0.21320684|0.15463538|0.11725534|8.3135493E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|173.77608|1898.6771|0|1048580|0|4|0|5739692556288|51638.415917099999|3|0|88363|0|0.0|0|0.0|5.4445063474979776|1|0
5739692556496|5739692556496|260.75227754587502|54.015520663173298|-9.4423826461391205E-2|-0.57992933876475805|0.80917618788262602|19.392326|19.299681|19.324636|19.067123|18.854233|3.2872599E-2|2.1384137E-2|1.5777823E-2|3.1510979E-2|4.5186888E-2|0.2187068|0.16092239|0.11671434|8.8500947E-2|6.2748276E-2|3|1|26227|268566528|268468224|268468224|268468224|268599296|402685952|998.23993|976.20306|0|4|0|4|0|5739692556288|51638.415917099999|3|0|88363|0|0.0|0|0.0|-17.191655777652201|1|0
5739692621874|587725491064471665|260.87313836123099|53.899917447979902|-9.3459084260010802E-2|-0.58173801570872696|0.80798903498039698|16.736128|15.562967|15.541826|15.549295|15.545017|2.9574919E-2|1.3468656E-2|1.8781241E-2|2.3973102E-2|2.7247218E-2|0.23002787|0.16925232|0.1227559|9.3082085E-2|6.5996356E-2|6|1|9843|34628309008|302157840|302022672|302022672|302022672|302022672|832.35687|1280.9341|0|0|0|0|0|5739692621824|51638.416331699998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692621881|587725491064471674|260.922305311505|53.8939583212589|-9.2973104046170499E-2|-0.58190098144471003|0.80792775030797304|23.013922|21.605276|20.033659|19.593128|20.666548|0.4921869|3.7563927|1.8689224|1.8466786|0.20649773|0.23833875|0.17536739|0.12719105|9.6445128E-2|6.8380795E-2|6|1|9843|87961198789392|70369155252497|87961198821393|276857360|268599312|402694160|962.02924|1516.5901|0|0|0|0|0|5739692621824|51638.416331699998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692621994|5739692621994|260.829315286743|53.950105870755202|-9.3791167101194506E-2|-0.58096742570062898|0.808504834400253|18.945099|18.808958|18.634813|18.393276|18.367725|3.4776539E-2|1.1130041E-2|1.2849811E-2|1.9359788E-2|3.9465398E-2|0.24113919|0.17742793|0.12868553|9.7578339E-2|6.9184259E-2|6|1|26227|268566544|268468240|268599312|268468240|268468240|268468272|327.3735|1192.1093|0|16|0|0|16|5739692621824|51638.416331699998|3|0|0|3144|60.439998626708984|0|0.0|0.0|1|0
5739692622194|587725491064471905|260.835759622811|53.852982402176899|-9.3943962849743004E-2|-0.58233015855878001|0.807506110365112|23.690657|22.371014|20.585367|20.128849|19.66481|0.78111649|0.27476117|0.1497449|5.1019408E-2|9.1161691E-2|0.19092387|0.14047997|0.10188779|0.07725843|0.05477719|3|1|9843|87961198792976|70369155219729|70369021169937|158329942966288|268468240|268435472|1180.7889|962.75702|0|0|0|0|0|5739692621824|51638.416331699998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692622201|101272088119083008|260.763866783693|53.822514448727198|-9.4743484821536106E-2|-0.58263557732328397|0.80719232907717597|20.25379|20.369795|20.204597|20.047911|20.090971|5.5232253E-2|2.2651697E-2|2.5018379E-2|3.7408076E-2|0.12403055|0.17123568|0.12599358|9.1381058E-2|6.9291487E-2|4.9128529E-2|6|1|26227|17592454610944|268435456|268468224|268435456|158329942966272|268435456|1330.928|512.50842|0|34603008|0|0|0|5739692621824|51638.416331699998|3|0|88475|0|0.0|0|0.0|-25.744153954881781|0|0
5739692752926|5739692752926|260.842523771863|53.644586060098497|-9.4342021474699098E-2|-0.58523701606766698|0.80535533648711899|18.374575|17.475491|17.372112|17.393509|17.360106|2.1702193E-2|0.01275623|1.4233835E-2|1.5435466E-2|3.7572924E-2|0.12676056|9.3269214E-2|6.7646615E-2|5.1294379E-2|3.6368355E-2|6|1|26227|34628174336|268468224|268468224|268468224|268468224|402686464|280.10046|434.9798|0|1048580|0|4|0|5739692752896|51638.417160999998|3|0|88475|0|0.0|0|0.0|3.8798491361942666|1|0
5739692753075|101272087137615872|260.97627566207899|53.655049275082902|-9.2952513180495203E-2|-0.58531039274961305|0.80546357734705998|19.739454|19.23247|19.358065|19.349405|19.254644|3.5872694E-2|1.5320906E-2|1.8384581E-2|2.2908751E-2|7.0469834E-2|0.16911604|0.12443397|9.0249896E-2|6.8433762E-2|0.04852039|6|1|26227|268435968|268468224|268468224|268435456|268468736|268435456|401.711|1151.5852|0|168827904|0|0|0|5739692752896|51638.417160999998|3|0|88475|0|0.0|20222|2.7400000020861626E-2|-24.212649007187984|0|0
5739692753083|587725491064602687|260.81762233300299|53.608677759710503|-9.4676888765216696E-2|-0.58569410647157005|0.80498366466544402|19.083546|19.101475|19.070084|19.131441|19.244673|2.6306452E-2|1.4658562E-2|1.6690861E-2|2.0991199E-2|7.0799209E-2|0.12551323|9.2351437E-2|6.6980965E-2|5.0789636E-2|3.6010485E-2|6|1|26227|268570640|268599312|268603408|268599312|268468240|402685968|552.1507|209.58864|0|33554432|0|0|0|5739692752896|51638.417160999998|3|0|0|0|0.0|0|0.0|0.0|0|0
5739692818494|5739692818494|261.069651488217|53.424798034541098|-9.2500227664505899E-2|-0.58865399742805502|0.80307545049888496|23.722015|25.112822|24.801754|18.473597|17.800112|0.45655832|0.59588212|0.70224029|1.8018034|0.2337981|0.1444952|0.10631821|7.7110827E-2|5.8470808E-2|4.1456532E-2|6|1|26227|70369012744464|70369146995985|70369155252529|70369155252529|268468240|268468240|1188.9875|1017.3882|0|4|0|4|0|5739692818432|51638.417575799998|3|0|88475|0|0.0|0|0.0|4.9527594450321573|1|0
5739692884044|5739692884044|261.14235655299802|53.336554267938297|-9.1943526724695607E-2|-0.58999230349934695|0.80215676130352498|16.874029|15.853009|15.772397|15.742725|15.803278|2.9848561E-2|1.2081594E-2|8.4435297E-3|0.01091752|2.2476062E-2|0.13629371|0.10028362|7.2734043E-2|5.5152021E-2|3.9103471E-2|6|1|26227|268571152|268468752|268599312|268603408|268468240|268468240|710.38293|1158.6753|0|4|0|4|0|5739692883968|51638.417990399998|3|0|88475|0|0.0|0|0.0|2.2252070310917276|1|0
5739692949596|5739692949596|261.27841062184598|53.133119882730902|-9.0973578960189996E-2|-0.59302044613263605|0.80003159837585303|24.633825|18.705259|18.39953|18.819792|17.538282|4.140563|0.20536093|0.19467838|0.22578348|0.14179865|0.14265069|0.10496102|7.6126486E-2|5.7724409E-2|4.0927328E-2|6|1|26227|105553385357584|70369189331249|70369046724657|70369046724657|302546992|70369046724657|1334.0931|1327.0697|0|1|1|0|0|5739692949504|51638.418405099997|3|0|88475|0|0.0|0|0.0|0.0|1|0
5739692949639|5739692949639|261.03830282612603|53.234875451593602|-9.3236450650295705E-2|-0.59122957840391099|0.80109584313643001|18.583731|18.084265|17.904535|17.786825|17.650267|5.3865276E-2|2.3084531E-2|1.1243869E-2|3.1544119E-2|2.6817584E-2|0.13087086|9.6293539E-2|6.9840111E-2|5.2957639E-2|3.7547626E-2|6|1|26231|268435456|276856832|268468256|268468224|268468224|402685952|67.9692|346.77466|0|4|0|4|0|5739692949504|51638.418405099997|3|0|88475|0|0.0|0|0.0|-29.680257688238974|1|0
5739693080911|101272086684631040|261.331430075318|52.951815023055197|-9.0805885027466393E-2|-0.59560407655462999|0.79812910937760195|21.054684|20.28163|20.388498|20.575027|20.359884|9.5510304E-2|2.0697618E-2|2.9963162E-2|6.0431127E-2|0.16456506|0.11443453|8.4199838E-2|6.1068743E-2|0.04630658|3.2831941E-2|6|1|26227|268435456|268435456|268468224|268435456|268468224|402653184|274.1835|1125.5928|0|34603008|0|0|0|5739693080576|51638.419234399997|3|0|88475|0|0.0|0|0.0|-26.801561030958844|0|0
5739693080920|101272086722379776|261.25273232929698|52.913933044356199|-9.1704111910767105E-2|-0.59600021701670602|0.79773059185084305|19.406096|19.408747|19.155785|19.168966|19.021494|4.1883759E-2|1.4075489E-2|1.7412981E-2|3.4902111E-2|5.5108208E-2|0.10649529|7.8358226E-2|5.6831919E-2|4.3093923E-2|3.0554129E-2|6|1|26227|268435456|276856832|268468224|268468224|268468224|402685952|478.78546|612.60773|0|34603008|0|0|0|5739693080576|51638.419234399997|3|0|88475|0|0.0|0|0.0|-26.435581690932942|0|0
5739956076722|5739956076722|253.15031902692499|64.620241555261998|-0.124239387927049|-0.410214856249633|0.90348677145800205|22.759903|25.114058|21.375238|17.698763|17.81109|0.42437196|0.57217962|1.2524174|6.6026762E-2|0.16445173|0.15588471|0.11469848|8.3188914E-2|6.3079633E-2|4.4724245E-2|6|1|26483|70369012613392|70369012613137|70369155219761|70369012613137|268468240|70369012613137|590.56403|1861.5085|0|5|1|4|0|5739956076544|51638.384819600004|3|0|0|0|0.0|0|0.0|4.1733176115360635|1|0
5739956076937|758882834230608057|253.07274143622001|64.622948589011301|-0.124782269690523|-0.410005424304276|0.903507021119345|22.846743|20.997206|20.187986|19.76454|19.712692|0.41663489|3.8475629E-2|2.1688927E-2|2.8411092E-2|8.9527138E-2|0.16002776|0.1177469|8.5399874E-2|0.06475614|0.04591291|6|1|10099|268566784|142606593|268435456|268566528|268566528|402685952|445.38058|1595.3016|0|0|0|0|0|5739956076544|51638.384819600004|3|0|0|0|0.0|0|0.0|0.0|0|0
5740224577863|758882834230739211|253.95172713058099|64.635554168989898|-0.11842290496204699|-0.411680368459515|0.90360128917868898|23.130848|20.53805|19.71022|19.315098|19.273417|0.5727427|2.9775942E-2|2.4188558E-2|0.02271991|6.9815263E-2|0.14007002|0.10306219|7.4749298E-2|5.6680128E-2|4.0186919E-2|6|1|9843|268435968|134217729|268435456|268435456|268468224|268435968|346.37204|964.82202|0|0|0|0|0|5740224577536|51638.385234200003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740224708701|758882833693933862|254.33076452765101|64.400245567902701|-0.11669818613659499|-0.41602438325630298|0.90183437830271296|21.557154|19.10396|17.862682|17.366478|17.022123|0.15213428|1.5292979E-2|1.7754946E-2|1.2581103E-2|2.7854281E-2|0.12709403|9.3514577E-2|6.7824572E-2|0.05142932|3.6464028E-2|6|1|9843|268435472|402685968|268468240|268468240|268468240|402685968|172.45595|1491.1361|0|0|0|0|0|5740224708608|51638.386063400001|3|0|0|0|0.0|0|0.0|0.0|0|0
5740224905406|5740224905406|254.860759567412|63.870244879353699|-0.115018794213483|-0.42512076224360201|0.89779898334042196|18.252745|17.868008|18.034239|18.155891|18.368113|3.6117144E-2|1.1871886E-2|1.2036866E-2|8.4271794E-3|3.6091022E-2|0.1728607|0.12718925|9.2248254E-2|6.9949061E-2|4.9594756E-2|6|1|26227|17626814349312|268468224|158329942999040|268468224|268468224|402685952|1345.9054|1577.4585|0|4|0|4|0|5740224905216|51638.387307199999|3|0|87899|0|0.0|0|0.0|4.6235777738895791|1|0
5740225036350|758883004419145756|255.01690199254199|63.645704135111004|-0.1147685928043|-0.42882818888652502|0.896066155215129|19.973442|17.512691|16.093613|15.313182|14.760577|4.4534691E-2|5.7400614E-3|8.4435241E-3|8.1832176E-3|1.6372818E-2|0.12318737|9.0640098E-2|6.5739758E-2|4.9848471E-2|3.5343185E-2|6|1|9843|269094928|302022672|302157840|302022672|302546960|302022672|750.87341|1382.4895|0|0|0|0|0|5740225036288|51638.388136399997|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225036388|5740225036388|254.99091414012801|63.568664583644598|-0.115275003502245|-0.42993944228221398|0.89546845256414098|18.053638|17.051693|16.909613|16.913181|16.965555|2.0592585E-2|5.3966041E-3|8.8740559E-3|8.7120486E-3|1.9323371E-2|0.13994907|0.10297319|7.4684747E-2|5.6631185E-2|4.0152214E-2|6|1|26227|17592454610960|268468240|268468240|158329942999056|268468240|268468240|1359.6808|1019.9406|0|4|0|4|0|5740225036288|51638.388136399997|3|0|87899|0|0.0|0|0.0|3.3941847685184854|1|0
5740225036408|5740225036408|254.77270092660899|63.656559130015303|-0.116550668317716|-0.42817132666862301|0.89615024227722295|18.846619|18.660685|18.488604|18.564157|17.997429|2.5239399E-2|7.8430865E-3|0.01070766|1.2418595E-2|0.02865058|0.15167242|0.11159913|8.0940999E-2|6.1375108E-2|4.3515716E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|285.64529|509.08334|0|1048580|0|4|0|5740225036288|51638.388136399997|3|0|87899|0|0.0|0|0.0|-23.388341938738577|1|0
5740225036450|758883004419145831|255.145162596772|63.658331314721103|-0.113757713206064|-0.42889314108002202|0.89616396726304404|18.704626|16.376692|15.542613|15.357182|15.115577|2.5947196E-2|5.0643431E-3|8.3584189E-3|8.1907576E-3|1.6463518E-2|0.11206734|8.2458086E-2|5.9805483E-2|4.5348685E-2|3.2152783E-2|3|1|9843|17592454610960|158329942999056|268468240|268468240|268468240|268599312|839.55554|1904.9442|0|0|0|0|0|5740225036288|51638.388136399997|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225036755|758883004419146094|255.04341466138499|63.6629161073798|-0.114500669523385|-0.42862116708544401|0.89619947099125696|23.501987|21.316698|19.929476|19.318081|18.765966|0.75392979|4.0287573E-2|2.0376435E-2|1.8146146E-2|4.6765268E-2|0.12265816|9.0250708E-2|6.5457344E-2|4.9634323E-2|3.5191353E-2|6|1|9843|70369012613904|70369146864913|268468240|268468240|268468240|402686480|646.32855|1540.832|0|0|0|0|0|5740225036288|51638.388136399997|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225036777|758883004419080535|254.915309482559|63.628029092254401|-0.11560071070342701|-0.42889089593205099|0.89592916855712701|23.1875|20.778324|19.343567|18.894136|18.650084|0.59641987|2.6259791E-2|1.4562287E-2|1.4429267E-2|4.3054916E-2|0.14524736|0.10687162|7.7512212E-2|5.8775164E-2|4.1672323E-2|6|1|26227|268436224|142639361|268468224|268468224|268468224|402686464|744.37048|942.14612|0|16384|0|0|0|5740225036288|51638.388136399997|3|0|87899|0|0.0|0|0.0|0.0|0|0
5740225102024|758883003882209581|255.02591374949799|63.417979467881203|-0.115620451344987|-0.43228335700237702|0.89429470002317302|22.213966|19.290009|18.020794|17.484318|17.155632|0.26397869|1.1016781E-2|3.3061311E-2|1.2454241E-2|1.8503865E-2|0.1798131|0.13230477|9.5958456E-2|7.2762392E-2|5.1589444E-2|6|1|9843|34628174592|142639361|268468736|268468224|268468224|268468224|1320.8643|632.18945|0|0|0|0|0|5740225101824|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225102032|758883003882209355|254.97616283552699|63.400649118119297|-0.116065880440385|-0.43244403167586398|0.89415930955592204|22.663481|20.026941|18.654783|17.389318|16.70365|0.3700017|1.6533438E-2|3.3582326E-2|0.01234009|1.6599443E-2|0.17344037|0.12761576|9.2557602E-2|7.0183627E-2|4.9761064E-2|6|1|9847|70403372482832|70369147012369|268468240|268468240|268468240|402685968|1390.3524|385.07324|0|0|0|0|0|5740225101824|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225102037|758883003882209573|255.02214354663701|63.405784673893997|-0.11569808661297|-0.43245961253969101|0.89419943875855701|19.9324|17.693031|16.586798|16.090321|15.82666|5.0574113E-2|6.8377997E-3|3.2728344E-2|1.1741504E-2|1.4918229E-2|0.18361501|0.13510218|9.7987369E-2|7.4300855E-2|5.2680235E-2|6|1|9847|17626814349328|158329942999056|268468240|268468240|268599312|268468240|1417.7627|575.99121|0|0|0|0|0|5740225101824|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225102327|5740225102327|255.02705282621801|63.476228252069298|-0.11537690182275|-0.43140713091332|0.89474915921889597|22.406548|21.149303|20.609318|20.006966|19.738983|0.31166592|0.03655941|4.5675166E-2|3.1373877E-2|9.9595182E-2|0.15695922|0.1154891|8.3762325E-2|6.3514434E-2|4.5032527E-2|6|1|26227|268435456|134250497|268435456|268435456|268468224|268435456|832.22693|836.95624|0|1|1|0|0|5740225101824|51638.388550999996|3|0|87899|0|0.0|0|0.0|-23.386563222723403|1|0
5740225102442|758883003882209676|255.06428345881099|63.423771530027203|-0.115307633819335|-0.43227333582221|0.89433993130136202|23.724989|21.302065|19.997641|19.263231|18.852945|0.87428337|4.1572474E-2|0.03822716|0.01962482|4.7976166E-2|0.18884538|0.13895063|0.10077859|7.6417357E-2|5.4180857E-2|6|1|9843|70369012613392|70369155244305|268468240|268435472|268468240|268435472|1331.0038|796.74591|0|0|0|0|0|5740225101824|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167411|5740225167411|255.074368563375|63.323087515647103|-0.115636153771611|-0.43381152757969799|0.89355237030622703|18.103521|17.928371|17.867977|17.544456|17.616674|2.4060918E-2|1.7366853E-2|9.6142003E-3|2.3470366E-2|1.8483303E-2|0.22646327|0.16662952|0.12085363|9.1639645E-2|6.4973652E-2|6|1|26227|268567040|268468224|268468736|268468224|268599296|402686464|833.27008|488.7222|0|1048580|0|4|0|5740225167360|51638.388965600003|3|0|87899|0|0.0|0|0.0|-28.79034203475446|1|0
5740225167447|5740225167447|255.14759948319801|63.422972383238701|-0.11468212409172999|-0.43245260927499202|0.89433369116066497|18.257519|18.16037|18.130976|18.121449|18.141554|2.4666563E-2|1.7527478E-2|1.0039391E-2|2.4060892E-2|2.6318314E-2|0.21587385|0.15883793|0.11520252|8.7354578E-2|6.1935484E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|104.19787|1107.6877|0|4|0|4|0|5740225167360|51638.388965600003|3|0|87899|0|0.0|0|0.0|-26.624221687036062|1|0
5740225167457|758883003882275170|255.31562007454301|63.446465147251303|-0.113320494199303|-0.43243229714835302|0.89451706187049596|21.63619|18.988359|17.700979|17.105459|16.669735|0.16149396|1.8539719E-2|9.4127357E-3|2.3319669E-2|1.0806129E-2|0.23643474|0.17396644|0.12617497|9.5674664E-2|6.7834526E-2|6|1|9843|268435968|427852288|285245440|293634560|427852320|419463168|162.49989|1820.4999|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167483|758883003882209524|254.97182216904801|63.3246968263092|-0.116405884188533|-0.433579630827433|0.89356498021007602|21.854042|19.595331|18.164976|17.017458|16.42174|0.17282817|2.0270513E-2|1.0002445E-2|2.3255335E-2|9.9651795E-3|0.19415252|0.14285558|0.10361078|0.07856492|5.5703506E-2|6|1|9843|70369012744208|70369146994705|276856848|268599312|268468240|402685968|661.83069|106.85681|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167489|758883003882275201|255.39131078881601|63.3899127618145|-0.11297175927788999|-0.43343577850579301|0.89407539252388302|21.833286|19.285349|17.837978|16.971458|16.540737|0.15395017|2.1090738E-2|1.1058998E-2|2.4105869E-2|0.01042507|0.20922935|0.15394896|0.11165663|8.4665842E-2|6.0029138E-2|6|1|9843|70369012744208|70369146994705|276856848|268468240|268468240|268468240|754.00165|1914.5519|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167496|758883003882275204|255.399927027323|63.379594395693204|-0.11294716212926099|-0.43360856970733602|0.89399471298397803|21.430559|19.016359|17.827978|17.302458|17.039722|0.13503636|1.8573856E-2|9.5612323E-3|2.3384145E-2|1.2919427E-2|0.19955708|0.14683221|0.10649496|8.0751911E-2|0.05725411|6|1|9843|268435456|411074560|276856832|276856832|268468224|402685952|853.91187|1912.1799|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167503|758883003882275054|255.149905060338|63.315245796959097|-0.115095475451538|-0.434081806908926|0.89349091570159|20.686775|18.07337|16.70698|15.69946|15.200747|7.4857906E-2|1.7463051E-2|8.7603778E-3|2.3084696E-2|7.5599276E-3|0.23400013|0.17217508|0.12487572|9.4689481E-2|6.7136019E-2|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|1015.3126|747.38068|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167514|758883003882275185|255.39465924301501|63.3361784323709|-0.113157814650647|-0.43425359422578602|0.89365492494892895|21.759087|19.045359|17.763979|17.160458|16.84173|0.17835005|1.8471438E-2|9.4735967E-3|2.3319656E-2|1.1815709E-2|0.18304883|0.13468559|9.7685225E-2|7.4071743E-2|0.05251779|6|1|9843|268566800|310411536|302153744|302022672|302022672|302022672|1212.391|1744.9678|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167526|758883003882209538|255.02911332489401|63.255198616287501|-0.116252190185705|-0.434742571503625|0.893019778504061|21.236452|18.579367|17.145981|16.34746|15.869745|0.11491251|0.01778746|8.9643961E-3|2.3127241E-2|8.4743351E-3|0.18847989|0.13868171|0.10058355|7.6269455E-2|5.4075997E-2|6|1|9843|34628309248|411074816|268603392|268468224|268468224|402685952|1335.182|84.240883|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167533|758883003882275079|255.155737083681|63.4204701056426|-0.114630708906981|-0.43250664724606602|0.89431415099139|22.280256|19.529337|18.199976|17.046459|16.47374|0.28097314|2.0140547E-2|1.0113589E-2|0.02329821|0.01005731|0.22018085|0.16200697|0.11750098|8.9097433E-2|6.3171193E-2|6|1|9843|17592454611712|142639361|268468224|17592454643712|268468224|419463680|137.61395|1129.6564|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167535|758883003882209516|254.92432998316499|63.376974030375102|-0.116553133297999|-0.43269557622149901|0.89397421967121804|22.169897|19.575333|18.347973|17.695456|17.314705|0.20468852|2.0177467E-2|1.0273063E-2|2.3578627E-2|1.5178105E-2|0.17087764|0.12573014|9.1189988E-2|6.9146611E-2|4.9025808E-2|6|1|9843|70403372482576|70369146994705|268468240|268599312|268468240|268468240|148.55307|107.93537|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167543|758883003882275092|255.18439633968501|63.376397054646802|-0.114590230027591|-0.43322885651573001|0.89396970701713196|22.264664|20.045277|18.731966|17.910452|17.517687|0.27732334|2.3142049E-2|1.1579313E-2|2.3818573E-2|1.7186699E-2|0.24145402|0.17765957|0.12885354|9.7705737E-2|6.9274589E-2|6|1|9843|70369012613136|70369146863633|268468240|268468240|268468240|268468240|552.92297|1087.1708|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167550|758883003882275152|255.31063004504901|63.342406292379003|-0.113769930441369|-0.433993206665374|0.89370369781917702|22.437422|20.133261|18.699966|17.410458|16.744734|0.32036945|2.3745593E-2|1.1409966E-2|2.3427224E-2|0.01132574|0.2166464|0.15940636|0.11561479|8.7667197E-2|6.2157135E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|1032.083|1448.1136|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167555|758883003882275119|255.260209942259|63.3055714376803|-0.11429795860446|-0.43444847668951098|0.89341507585277302|21.990187|19.769316|18.579969|18.06745|17.784647|0.21765302|0.02124445|1.1675979E-2|2.3950409E-2|2.0775497E-2|0.2190364|0.16116489|0.11689023|0.08863432|6.2842838E-2|6|1|9843|17592454610944|134266881|268468224|158329942999040|268468224|402685952|1265.8073|1131.9465|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167568|758883003882275109|255.189366177105|63.422596607849698|-0.11436834962714|-0.43254176439179598|0.89433075685699004|23.178688|20.643085|19.317936|18.540436|18.088572|0.59501785|2.9827099E-2|1.4522241E-2|2.4871249E-2|2.5274018E-2|0.2288644|0.16839625|0.12213501|9.2611283E-2|6.5662555E-2|6|1|9843|268436224|134251777|268468224|268435456|268468256|268468736|171.49989|1263.4999|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167571|758883003882275104|255.18847560052399|63.415257356393397|-0.11440435764389401|-0.432650735051679|0.89427343939721804|22.280256|20.361202|19.116951|18.183447|17.744656|0.2804558|2.6056886E-2|1.3293959E-2|2.4149615E-2|1.9785859E-2|0.23367259|0.17193407|0.12470093|9.4556943E-2|6.7042053E-2|6|1|9843|70369012613392|70369146864913|268468240|268468240|268468240|402685968|231.64352|1235.3171|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167580|758883003882275077|255.18752756881801|63.343508960603899|-0.114697723244748|-0.43373113749701298|0.89371233215616896|24.780527|20.581118|19.131948|17.876453|17.210712|1.1866716|2.9042954E-2|1.3355275E-2|2.3774765E-2|1.4362469E-2|0.23877643|0.17568943|0.12742463|9.6622236E-2|6.8506368E-2|6|1|9843|268436224|134251777|268468224|268468224|268468736|402685952|835.00885|986.46307|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167581|758883003882275269|255.31010807768899|63.306729197029398|-0.11391498185436|-0.43453038953908202|0.89342415317481505|24.535231|21.178602|19.681894|18.600433|18.012596|1.1869071|4.1132987E-2|1.7313266E-2|0.02491693|2.4451215E-2|0.20575531|0.1513928|0.10980269|8.3260052E-2|5.9032414E-2|6|1|9843|268435712|142606593|268468224|268435456|268468224|268435456|1332.3232|1324.902|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167583|758883003882275174|255.38209638839999|63.309940542608899|-0.113356296017323|-0.43462471816861997|0.893449329570559|23.023325|20.869936|19.535913|18.43244|17.76965|0.52259105|3.3579577E-2|1.5360226E-2|2.4507681E-2|2.0490551E-2|0.18190339|0.13384278|0.09707395|7.3608242E-2|0.05218916|6|1|9847|268567296|142639361|268468224|268599808|268468224|268468224|1414.7382|1608.4158|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167643|758883003882275265|255.22201442067001|63.439413874965297|-0.114054898245146|-0.43235302698470401|0.89446203957655601|22.829796|21.507959|20.11179|19.049398|18.579313|0.44788429|5.2198689E-2|2.3007851E-2|2.6549628E-2|3.6851071E-2|0.22593948|0.16624412|0.12057411|9.1427691E-2|6.4823374E-2|6|1|9847|70369012744976|70369155219729|268435472|268435472|268599824|268435472|79.109314|1444.3457|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167683|758883003882275310|255.16055967475901|63.408404848595801|-0.114642533545257|-0.43269832681096199|0.89421991002063805|25.91161|22.830107|21.341131|19.66427|18.753151|0.66836715|0.15582488|6.0216118E-2|3.2028485E-2|4.2925682E-2|0.22913255|0.16859356|0.12227811|9.2719786E-2|6.5739483E-2|6|1|9843|70369012613464|70369155219737|8388888|268435480|268435480|268468248|246.7825|1106.4666|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167689|758883003882275356|255.35610912236299|63.441140054152299|-0.113035897581389|-0.432592703323465|0.89447551050281204|23.779341|22.324987|20.831259|19.777227|19.245268|0.90754229|9.9189095E-2|3.9032154E-2|3.3442341E-2|6.4032026E-2|0.23853734|0.17551351|0.12729703|0.09652549|0.06843777|6|1|9843|268435712|142639361|268468224|276856832|268468224|402685952|268.34613|1955.4165|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167696|758883003882275239|255.14724760515301|63.401914614370099|-0.114769027783566|-0.43276958554556599|0.89416919880318702|23.391735|21.577765|20.23674|18.864416|18.182539|0.8859849|5.5246193E-2|2.5178595E-2|0.0259225|2.7305221E-2|0.226667|0.16677943|0.12096235|9.1722086E-2|6.5032102E-2|6|1|9843|268566784|1099654381825|276824064|268435456|268435456|402685952|281.11902|1034.3792|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167718|758883003882275191|255.352835574442|63.426505824547597|-0.113118380011193|-0.432807268454315|0.89436128073433396|25.555677|20.491156|19.266941|18.606434|18.241514|0.85145736|2.7382668E-2|1.4126642E-2|2.4985854E-2|2.8198205E-2|0.24122517|0.17749119|0.12873141|9.7613133E-2|6.9208927E-2|6|1|9843|268566784|1099646010625|268469504|276856832|268468224|402685952|386.88055|1893.4463|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167730|758883003882275305|255.15488195078001|63.3837770123422|-0.114783878559334|-0.43305846337439902|0.89402742045346695|22.958879|22.004837|20.734377|19.688263|19.065685|1.3063675|7.7758774E-2|3.6569823E-2|3.2264765E-2|5.6226414E-2|0.23409376|0.17224395|0.12492569|9.4727367E-2|6.7162886E-2|6|1|9843|268566528|140737622704129|276856832|268435456|268435456|268435456|445.58722|1000.9004|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167734|758883003882209583|255.059931071275|63.364176424027399|-0.115580229427124|-0.43316312644599198|0.89387410548304103|23.079859|20.829967|19.678894|19.089394|18.903959|0.9685685|0.0330601|1.7521916E-2|2.6844407E-2|4.9313296E-2|0.2200086|0.16188024|0.11740905|8.9027725E-2|6.3121766E-2|6|1|9843|268566784|1099654398209|276856832|268468224|268468224|268468224|465.07056|575.42236|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167735|758883003882209713|254.96986548540801|63.347526413286602|-0.116328350487552|-0.43323175892751897|0.89374378763122797|24.149687|22.16165|20.791309|19.858189|19.291138|1.0851171|8.6097449E-2|3.7797641E-2|3.3593904E-2|6.8659484E-2|0.19274481|0.14181979|0.10285954|7.7995278E-2|5.5299625E-2|6|1|9843|268435712|134219009|268435456|268435456|268435456|268468224|466.49661|178.3063|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167738|758883003882275271|255.308896612957|63.404801984731797|-0.113536168663633|-0.43304807320143501|0.89419176058701599|23.697971|21.470055|20.271723|19.649277|19.380848|0.86578113|5.0972834E-2|2.5811732E-2|0.03323105|0.07298997|0.24063663|0.17705815|0.12841733|9.7374976E-2|6.9040075E-2|6|1|9843|17592454611200|134219009|268435456|268435456|158329942966272|268435456|503.30017|1654.012|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167766|758883003882275337|255.317422018168|63.3783864351443|-0.11357621149923899|-0.43346371050639299|0.893985266017013|23.434641|22.056482|20.57453|19.272367|18.569323|0.72322285|8.0921739E-2|3.2184787E-2|0.0279787|3.7124496E-2|0.22620086|0.16643645|0.12071359|9.1533467E-2|6.4898364E-2|6|1|9843|268435712|134227201|268435456|268435456|268435456|268468224|739.01007|1596.251|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167775|758883003882209659|255.01368759358101|63.315917458340401|-0.116124445591961|-0.43379682952637899|0.89349618008630605|23.767447|21.876581|20.379665|19.132389|18.484385|0.89685947|0.06882441|2.7603555E-2|0.02679464|3.5100657E-2|0.20649481|0.15193692|0.11019733|8.3559297E-2|5.9244584E-2|6|1|9843|268435456|134217729|268435456|268435456|268435456|268435456|800.25421|234.79286|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167778|758883003882275285|255.39741924270101|63.384238323501698|-0.112947872225388|-0.43353350497771997|0.89403102754965402|24.860073|21.668472|20.243736|18.975407|18.382446|1.1623675|5.7923965E-2|2.4993449E-2|2.6306711E-2|3.1692989E-2|0.20288759|0.14928277|0.10827231|8.2099617E-2|0.05820965|6|1|9843|268435712|134251777|276857088|276856832|268468224|402685952|811.08569|1918.3284|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167794|758883003882275270|255.28835962474901|63.3527604006864|-0.113897595047306|-0.43379273591226802|0.89378476162451403|22.820484|21.319374|20.056807|19.284367|18.967861|0.44350368|4.5666918E-2|2.2074588E-2|2.8055986E-2|5.2009627E-2|0.22645974|0.16662692|0.12085174|9.1638215E-2|6.4972639E-2|6|1|9843|268435968|134217729|276856832|268435456|268468224|402686464|910.92065|1399.2499|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167802|758883003882209722|255.10627605387299|63.315154627532401|-0.11542634766573499|-0.43399541330323999|0.89349020111935096|23.735188|22.291372|20.991011|19.847195|19.27618|0.88157594|9.8259993E-2|4.4465233E-2|3.3967748E-2|6.8224058E-2|0.23350391|0.17180996|0.12461091|0.09448868|6.6993654E-2|6|1|9843|268435456|134242305|276824064|276824064|268435456|268435456|949.30255|582.23175|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167868|758883003882275334|255.34220509895599|63.324023428134801|-0.113603296132662|-0.43433322094218002|0.89355970382162297|24.082027|22.18742|20.714397|19.527313|18.851032|1.0574248|8.9456454E-2|3.5280611E-2|3.0003667E-2|4.7361426E-2|0.19908407|0.14648417|0.10624254|8.0560498E-2|5.7118401E-2|6|1|9843|70369012613976|70369155219737|276856856|268435480|268468248|402686488|1235.0472|1505.1693|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167887|758883003882275358|255.44697157037001|63.3326146412507|-0.112775251317565|-0.43441052979837302|0.89362701072122797|23.982197|22.30126|21.156664|19.789221|19.025761|1.010473|9.6801236E-2|5.0412316E-2|3.3411156E-2|5.4300167E-2|0.16455746|0.12107981|8.7817177E-2|0.06658911|4.7212508E-2|6|1|9843|268436224|134275073|276857088|268468224|268468224|402686464|1321.9874|1931.1|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167901|758883003882275327|255.27826851648601|63.297012334640797|-0.114194937601913|-0.434613555884379|0.89334795755496699|22.664373|22.597797|21.187588|20.063065|19.433653|0.38777256|0.12680499|5.1626615E-2|3.7788004E-2|7.8471966E-2|0.21358128|0.15715107|0.11397906|8.6426876E-2|6.1277732E-2|6|1|9847|268435712|142606593|276824320|268435456|268468224|268435456|1365.5779|1171.1815|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167903|758883003882275304|255.189053461469|63.279010452286698|-0.114943279545687|-0.43470655218269999|0.89320672633870801|23.089663|22.611525|21.206537|19.858189|19.057701|0.55099344|0.12862378|5.2775867E-2|3.4092735E-2|5.6748856E-2|0.22719468|0.16716769|0.12124395|0.09193562|6.5183498E-2|6|1|9847|268435712|134219009|276824320|268435456|268435456|268435456|1380.807|771.54858|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225167907|758883003882209662|255.05990174643401|63.252453706922303|-0.116029590026771|-0.43484631373702798|0.89299821817713498|25.646755|21.882551|20.57453|19.678267|19.171455|0.80510092|6.9201872E-2|3.2066371E-2|0.03129895|6.1909482E-2|0.19518955|0.14361861|0.1041642|7.8984559E-2|5.6001037E-2|6|1|9847|268435712|142606593|276856832|268435456|268468224|268435456|1405.7537|191.32285|0|0|0|0|0|5740225167360|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225232969|758883003882209578|255.11010843965201|63.243965474007801|-0.11568249553474|-0.43507566875235498|0.89293153303405404|19.769327|18.853701|18.628151|18.608572|18.570406|4.3089002E-2|1.3307617E-2|0.01204736|2.3382604E-2|4.4309448E-2|0.2043476|0.15035701|0.10905145|0.08269041|5.8628533E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|402685952|193.6329|352.40359|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225232974|758883003882209551|255.067034295665|63.233431622681103|-0.11605184817481599|-0.43514719161894799|0.89284874987948104|21.994064|19.24869|17.811161|16.999598|16.452824|0.21762884|1.4443733E-2|1.0464429E-2|2.1743158E-2|2.5334483E-2|0.18394023|0.13534148|0.09816093|7.4432455E-2|5.2773539E-2|6|1|9843|70369012748304|70369155252241|268468240|268603408|268468240|268468240|215.92978|153.02298|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225232988|758883003882275217|255.47978548783701|63.284124567881904|-0.112716018265775|-0.43520702087200802|0.893246857374836|21.664892|19.182693|17.852161|17.343596|17.021809|0.16594665|1.4141113E-2|1.0570973E-2|2.1924067E-2|2.6625073E-2|0.1570565|0.11556068|8.3814248E-2|6.3553803E-2|4.5060441E-2|6|1|9843|34628173824|402685952|268468224|268468224|268468224|268468224|419.83853|1891.1323|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233096|758883003882275209|255.457134142256|63.276525524120601|-0.11291781172878|-0.43527709589564201|0.89318722426098296|22.496157|20.189587|18.858145|17.469595|16.730818|0.33846915|2.0358561E-2|1.2813824E-2|2.1944227E-2|0.0258526|0.16586247|0.12204003|8.8513613E-2|6.7117192E-2|4.7586925E-2|6|1|9843|34628304896|134250497|268468224|268468224|268599296|268468224|449.60526|1779.5618|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233099|758883003882275193|255.439749589672|63.259444043386097|-0.11311681556832701|-0.43550052741255901|0.89305312084951805|23.026876|19.621668|18.358156|17.899591|17.598763|0.52901816|1.6026745E-2|1.1368493E-2|2.2809496E-2|2.9650707E-2|0.17936188|0.13197276|9.5717654E-2|7.2579801E-2|5.1459983E-2|6|1|9843|17592454611200|142639361|268468224|268468224|158329942999040|402685952|567.42914|1655.5612|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233130|758883003882275263|255.30130801818601|63.266121258541197|-0.11414235883003999|-0.43512526381970601|0.89310555182830798|22.934126|20.998159|19.627085|18.476578|17.844721|0.99500149|3.3943642E-2|1.7538592E-2|0.02329698|3.1885315E-2|0.20814356|0.15315005|0.1110772|8.4226474E-2|5.9717618E-2|6|1|9843|34628308992|1099645980673|268435456|268435456|268468224|268468224|300.26437|1153.2507|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233131|758883003882275067|255.213006583896|63.247905245816|-0.11488528094044401|-0.43522335522906203|0.89296248705440795|23.855118|20.50049|19.127132|18.311583|17.841721|0.9514631|2.4538774E-2|1.4049402E-2|2.2893168E-2|3.1856008E-2|0.22285198|0.16397236|0.11892644|9.0178318E-2|6.3937552E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|402685952|318.65964|756.10516|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233133|758883003882275220|255.493177044926|63.268142305427297|-0.11267670594941|-0.43547455792232698|0.89312141914677201|22.824152|20.682404|19.190128|17.642593|16.741817|0.44739407|0.02685138|1.4349992E-2|2.2086089E-2|2.5900243E-2|0.16267072|0.11969157|8.6810306E-2|6.5825626E-2|4.6671189E-2|6|1|9843|70369012744464|70369146864913|276856848|268468240|268599312|268468240|575.10413|1887.9077|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233208|758883003882275095|255.24285560811899|63.282813586398603|-0.114519926393719|-0.43475696123110003|0.89323657063505701|23.12155|20.782341|19.402113|18.753563|18.41951|0.57185912|2.9492874E-2|1.5704632E-2|2.4037205E-2|0.04094388|0.22239399|0.16363539|0.11868203|8.9992985E-2|6.3806154E-2|6|1|9847|268435712|142639361|276856832|268468224|268468224|402685952|70.078476|988.37817|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233265|758883003882275171|255.39694744977299|63.275108714263901|-0.113380557251962|-0.43517961367772701|0.89317610417909099|23.039486|20.790335|19.559095|18.94055|18.707283|0.53359562|2.9168123E-2|1.6904622E-2|0.02496138|4.8483279E-2|0.18000603|0.13244672|9.6061416E-2|0.07284046|5.1644795E-2|6|1|9843|268436224|134251777|268468224|268468224|268468224|402686464|370.22833|1546.3334|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233273|758883003882275354|255.422662484396|63.275719814657101|-0.113182834333601|-0.43522123668295998|0.89318090057522403|23.72559|22.010141|20.492777|18.928551|18.082659|0.88118583|7.4046545E-2|0.03034623|2.4915507E-2|3.4795906E-2|0.17341772|0.12759911|9.2545517E-2|7.0174463E-2|4.9754571E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|404.13141|1645.9193|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233280|758883003882275284|255.446833658305|63.277667058135997|-0.112991591240838|-0.43523956423808102|0.89319618339461604|22.839039|21.359636|20.201937|19.823345|19.579094|0.45230299|4.3643363E-2|2.4719872E-2|3.3440787E-2|9.2428915E-2|0.1673464|0.12313189|8.9305513E-2|6.7717671E-2|0.04801267|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|424.34296|1744.2028|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233283|758883003882275232|255.18866071860299|63.230612455409599|-0.115139095351219|-0.43543503498478497|0.89282658956232996|23.176016|21.791327|20.375853|18.911552|18.031675|0.59377646|5.8889981E-2|2.8039541E-2|2.4641724E-2|3.4162037E-2|0.21385919|0.15735556|0.11412738|8.6539336E-2|6.1357468E-2|6|1|9843|17592454611200|142606593|17592463032320|268435456|268435456|268468224|426.82248|604.53308|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225233329|758883003882275345|255.39668944549399|63.250400815655702|-0.11347961693325601|-0.43555178770260999|0.89298209207673496|23.164654|22.478235|20.947269|20.072197|19.411821|0.59108967|0.11015148|4.3100569E-2|3.8348582E-2|8.1432007E-2|0.19474848|0.14329408|0.10392882|0.07880608|5.5874489E-2|6|1|9843|268435712|142606593|276824320|268435456|268435456|402685952|578.38147|1461.6167|0|0|0|0|0|5740225232896|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225364575|98456813015400448|255.37505908522201|62.958242928563998|-0.114792252093215|-0.43990912127582898|0.89067542004800804|23.765324|23.42498|22.86451|22.162815|21.153133|1.1206772|0.24057549|0.23308142|0.19006613|0.36457577|0.4191913|0.30843696|0.22370422|0.16962813|0.12026846|3|1|26227|87961198788952|228698854950169|70369180419353|70369180419353|444629272|70369180419353|278.83258|382.75516|0|64|0|0|0|5740225363968|51638.3902094|3|0|87897|0|0.0|0|0.0|-19.897038206543215|0|0
5740225364795|99020111964274688|255.38990579720101|62.964501835324697|-0.114653714595758|-0.439844699329346|0.89072507891114805|25.612839|24.357901|22.562843|22.347019|22.575546|0.82291168|2.0664937|0.17862636|0.22407566|0.85858953|0.41853216|0.30795199|0.22335248|0.16936141|0.12007935|3|1|26227|537002240|142770433|140737631125761|671122688|134251777|134251777|258.37775|465.40225|0|64|0|0|0|5740225363968|51638.3902094|3|0|87897|0|0.0|0|0.0|8.7152926328983682|0|0
5740225560777|5740225560777|255.969583686184|62.555630373394202|-0.111736082566294|-0.44713759514797502|0.88745874205960895|23.65807|25.115414|19.452019|17.819281|17.132225|0.88858616|0.58734268|0.12813798|0.1154833|0.15363836|0.2285527|0.16816691|0.12196867|9.2485152E-2|6.5573126E-2|6|1|26227|70369012613392|70369155252497|70369155252529|70369012645905|70369012645905|268468240|519.42682|1334.5543|0|1|1|0|0|5740225560576|51638.391453199998|3|0|87897|0|0.0|0|0.0|4.2644297483768838|1|0
5740225626875|99020112446619648|256.10660151937202|62.428612620836297|-0.11113860306920501|-0.44931225258400798|0.88643483155035696|23.263636|26.117491|22.328796|21.952522|20.881765|0.61660838|0.41286248|0.14496516|0.16495681|0.26756725|0.30013824|0.22083887|0.16017076|0.12145264|8.6111441E-2|3|1|26227|268435712|134251777|142639361|268469504|411074816|134251777|441.47314|1450.2241|0|64|0|0|0|5740225626112|51638.391867899998|3|0|88002|0|0.0|0|0.0|8.3687044981327432|0|0
5740225757533|587725491597607322|256.22602364978599|62.1722126520568|-0.11114521872746|-0.45339115076771502|0.88435468266954598|23.005573|21.066767|20.018456|19.538546|19.425442|0.51808769|3.8718205E-2|2.9726746E-2|3.5251722E-2|9.0110183E-2|0.17916335|0.13182668|9.5611706E-2|7.2499461E-2|5.1403023E-2|6|1|9847|70369012613392|70369155219729|268435472|268435472|268468240|268435472|77.108765|1075.8198|0|0|0|0|0|5740225757184|51638.392697099996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225822870|587725491597672697|256.27802583898199|61.973039630177396|-0.11146223741450099|-0.45647556668122702|0.88272658657910996|19.914625|19.225704|19.134764|19.034773|18.677069|0.05080843|1.5462679E-2|1.6416037E-2|2.6869565E-2|4.9891409E-2|0.13257198|9.7545207E-2|7.0747919E-2|5.3646006E-2|3.8035687E-2|6|1|26227|268435968|268468224|268468736|268468224|268468224|268468224|485.43988|628.33435|0|1048576|0|0|0|5740225822720|51638.393111700003|3|0|88002|0|0.0|0|0.0|0.0|0|0
5740225888386|587725491597738203|256.49457507813401|61.856527237485999|-0.110155180650182|-0.45863804023960397|0.88176923524304296|19.949528|19.242033|19.235937|19.003912|19.048641|0.12099327|1.6629789E-2|1.6071456E-2|1.6952787E-2|5.6178585E-2|0.1280949|9.4251007E-2|0.06835869|5.1834326E-2|3.6751181E-2|3|1|9843|268435472|402685968|268468240|268468240|268468240|402685968|445.16391|1113.1522|0|0|0|0|0|5740225888256|51638.393526499996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225954011|587725491597803902|256.40770360489398|61.6410744058755|-0.111628896150507|-0.46169015235053701|0.87998931400713998|24.29804|21.108707|19.693066|18.512079|18.082581|1.1242007|3.6631353E-2|2.1183703E-2|0.01048252|3.8827501E-2|0.15130357|0.11132773|8.0744155E-2|6.1225846E-2|4.3409888E-2|6|1|9843|17592454615296|134251777|268468224|268468224|268468224|158329943003136|780.31061|62.76659|0|0|0|0|0|5740225953792|51638.393941100003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740225954316|5740225954316|256.69009392072599|61.678757444729001|-0.109218779360573|-0.46167140456185102|0.88030152359567904|24.960117|22.14679|20.184935|19.229017|18.771135|1.1286768|7.8607924E-2|2.6343064E-2|1.6935509E-2|4.7197606E-2|0.13909374|0.10234386|7.4228302E-2|5.6285072E-2|3.9906818E-2|6|1|26227|268435712|134251777|268468224|268468224|268468224|402685952|893.54651|1323.6179|0|5|1|4|0|5740225953792|51638.393941100003|3|0|88002|0|0.0|0|0.0|-27.604147688355155|1|0
5740226019490|5740226019490|256.834112533959|61.507091574729102|-0.10865823979900099|-0.46451057511185501|0.87887616450387196|19.630436|19.243692|19.351286|18.812199|18.497463|3.5611182E-2|9.782468E-3|1.5025607E-2|1.8935256E-2|0.04026562|0.15569983|0.11456246|8.3090253E-2|6.3004822E-2|4.4671204E-2|6|1|26227|268435456|268468224|268468224|276856832|268468224|402685952|1212.4487|1353.9131|0|1048580|0|4|0|5740226019328|51638.394355800003|3|0|88002|0|0.0|0|0.0|-27.540254687859033|1|0
5740226216108|5740226216108|257.12601577595501|61.088247579839702|-0.107718943896985|-0.47130890434677702|0.87536537846156504|18.70624|18.574686|18.392857|18.397621|18.277832|2.6454015E-2|7.728443E-3|1.3185778E-2|0.01349242|3.2706395E-2|0.12354002|9.0899572E-2|6.5927953E-2|4.9991172E-2|3.5444364E-2|6|1|26227|268566544|268468240|268468240|268599312|268468240|268468240|1142.8149|1212.1367|0|4|0|4|0|5740226215936|51638.395599800002|3|0|88002|0|0.0|0|0.0|-26.460187233496335|1|0
5740226281764|587725491598131485|257.02948310777401|60.9857653964294|-0.10886411028361399|-0.47265177005659997|0.87449923370722304|24.043617|22.39278|21.053951|20.2652|20.159168|0.99855721|0.10293893|5.6489084E-2|3.4960207E-2|0.14547981|0.13776062|0.10136296|7.3516876E-2|5.5745617E-2|3.9524339E-2|6|1|9843|70369012744464|70369180386577|301989904|301989904|302153744|436207632|507.29095|488.51715|0|0|0|0|0|5740226281472|51638.396014400001|3|0|0|0|0.0|0|0.0|0.0|0|0
5740226347165|5740226347165|257.30302517791301|60.830580963743301|-0.107126545427652|-0.47547502581765999|0.873182342405315|18.215048|17.921339|18.18821|18.053896|18.143049|5.3078208E-2|6.8314415E-3|1.6014533E-2|2.7830055E-2|3.5868149E-2|0.12882769|0.09479019|6.8749756E-2|5.2130856E-2|3.6961429E-2|3|1|26227|17626814353424|268603408|268603408|17592454643728|268468240|268468240|888.92468|1131.4462|0|4|0|4|0|5740226347008|51638.396429100001|3|0|88000|0|0.0|0|0.0|-18.919751309786946|1|0
5740226543695|5740226543695|257.62587050103599|60.396533745298697|-0.10586020511099301|-0.48251855030458701|0.86946504563772897|18.014727|17.836306|17.616737|17.371298|17.420435|2.2351842E-2|1.0226312E-2|1.1463546E-2|1.2850464E-2|2.0027766E-2|0.13149936|9.6755981E-2|7.0175506E-2|5.3211965E-2|3.7727945E-2|6|1|26227|268567040|285245952|268468224|268599296|268468224|402685952|1006.5172|1126.9249|0|4|0|4|0|5740226543616|51638.3976731|3|0|88000|0|0.0|0|0.0|-28.622378170420376|1|0
5740226543922|587725491598393359|257.66212521758501|60.510598641283003|-0.105184794301448|-0.48089352188974599|0.87044677014291805|19.527643|19.436275|19.402689|19.117231|19.179176|3.4706317E-2|1.3907799E-2|1.6354313E-2|1.8605009E-2|6.5789469E-2|0.14066271|0.10349829|0.07506559|5.6919966E-2|4.0356964E-2|6|1|26231|268435456|268468224|268468224|268468224|268468224|402685952|86.845459|1633.689|0|34603008|0|0|0|5740226543616|51638.3976731|3|0|88000|0|0.0|0|0.0|0.0|0|0
5740226674788|5740226674788|257.93980440544402|60.221839241445899|-0.103768239200169|-0.48568156498123999|0.86795482023586301|18.558487|18.53594|18.405079|18.453543|18.435314|2.5852285E-2|8.4586004E-3|0.01174092|1.8234592E-2|3.9207779E-2|0.12346324|9.0843081E-2|6.5886982E-2|4.9960103E-2|3.5422336E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|257.39127|1917.7338|0|1048580|0|4|0|5740226674688|51638.3985025|3|0|88065|0|0.0|0|0.0|-26.205131842092342|1|0
5740226740577|5740226740577|257.94566427787299|60.073350088039803|-0.104187982843806|-0.48789035520950402|0.86666479421081999|25.520998|22.898783|21.172903|19.966362|19.286131|0.88896954|0.15419526|5.1393345E-2|3.5563853E-2|7.1043268E-2|0.11504978|8.4652536E-2|6.1397079E-2|4.6555545E-2|3.3008464E-2|6|1|26227|70369012613392|70369155252529|8421648|268468240|268468240|268468240|176.77924|1488.0461|0|4|0|4|0|5740226740224|51638.3989172|3|0|88065|0|0.0|0|0.0|-6.8029427909861191|1|0
5740226740668|587725491598590251|258.00726941160701|60.047942150381097|-0.103743184591053|-0.48837798549276901|0.86644347475004502|22.669922|20.42407|20.281998|20.254131|19.971079|0.39404565|2.9424854E-2|2.5480583E-2|4.2502478E-2|0.12702218|0.11881686|8.7424316E-2|6.3407406E-2|4.8079915E-2|0.03408926|6|1|9843|70369012613392|70369155252497|268468240|268468240|268468240|402685968|488.06308|1673.3828|0|0|0|0|0|5740226740224|51638.3989172|3|0|0|0|0.0|0|0.0|0.0|0|0
5740226806116|5740226806116|257.94398168495201|59.909931852023099|-0.10471818445913|-0.49030267666906802|0.86523834120705201|24.341347|22.278717|20.390112|19.326721|18.6623|1.144685|9.2998356E-2|2.8298553E-2|2.9704371E-2|5.6086212E-2|9.8461255E-2|7.2446853E-2|5.2544504E-2|3.9842904E-2|2.8249117E-2|6|1|26227|268436224|142639361|276856832|276856832|276857344|402686464|212.73103|980.18744|0|33554433|1|0|0|5740226805760|51638.399331799999|3|0|88065|0|0.0|0|0.0|5.8245131376591104|1|0
5740226871547|5740226871547|258.14070878246298|59.674044190841897|-0.10376528742827799|-0.49414133742116401|0.86316690377733396|20.091885|19.563856|19.110573|18.72192|18.668373|4.9097613E-2|0.01544724|1.1837062E-2|0.01596879|5.0960921E-2|0.09868636|7.2612487E-2|5.2664634E-2|3.9933998E-2|2.8313702E-2|3|1|26227|34628173824|268468224|268468224|268468224|268468224|402685952|1173.359|1107.7706|0|4|0|4|0|5740226871296|51638.399746499999|3|0|88065|0|0.0|0|0.0|-21.855399119202751|1|0
5740227067916|587725491598917658|258.2866944452|59.326543142209601|-0.103566832610928|-0.49952111669490601|0.86008869609989302|17.313744|18.532829|16.880114|16.777338|16.688107|4.5344297E-2|4.0786713E-2|1.3922693E-2|1.3149903E-2|2.0516397E-2|0.11551442|8.4994413E-2|6.1645035E-2|4.6743564E-2|3.3141769E-2|3|1|9843|34628309520|276857360|268603920|268468752|268468752|268468752|293.73471|690.14734|0|0|0|0|0|5740227067904|51638.400990399998|3|0|0|0|0.0|0|0.0|0.0|0|0
5740227067917|5740227067917|258.28834705029197|59.331831780598698|-0.10353630919425399|-0.499446364592327|0.86013578089388898|23.720278|22.436981|19.554047|18.088329|17.332077|0.97527134|0.35403469|2.8421519E-2|1.6692013E-2|2.4213631E-2|0.115906|8.5282534E-2|6.1854009E-2|4.6902023E-2|3.3254117E-2|6|1|26227|70369012613392|70369188774161|301989904|301989904|302022672|302022672|250.85585|713.26825|0|1|1|0|0|5740227067904|51638.400990399998|3|0|88065|0|0.0|0|0.0|-3.0759663569834146|1|0
5740227067918|587725491598917660|258.28454376438901|59.326865908556499|-0.103584598972994|-0.499512484568709|0.86009156990148405|19.706621|19.75478|19.262075|19.264248|19.295496|8.4647655E-2|0.51295525|0.13148965|8.7993272E-2|0.11597864|0.1155275|8.5004039E-2|0.06165202|4.6748862E-2|3.3145525E-2|6|1|9843|34628173840|302022672|302022672|302022672|302022672|310411280|287.28485|681.55743|0|0|0|0|0|5740227067904|51638.400990399998|3|0|0|0|0.0|0|0.0|0.0|0|0
5740227396211|587725491599246086|258.884425598306|58.577737798101602|-0.100508699059838|-0.511561031014232|0.85334829522355904|24.70414|21.287439|20.502562|20.259407|19.961956|1.1736761|3.7984461E-2|3.2129962E-2|4.4097479E-2|0.12076548|0.12500644|9.1978543E-2|6.6710509E-2|5.0584562E-2|3.5865083E-2|6|1|9843|268436224|142606593|268435456|268435456|268468224|402653696|838.711|1104.6426|0|0|0|0|0|5740227395584|51638.403063600002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740227461378|5740227461378|259.153761900132|58.412576139304498|-9.8565324719070202E-2|-0.51444164876963905|0.85184192593121399|19.915703|18.995674|18.907103|19.043039|18.935749|5.7272475E-2|3.4714457E-2|6.6943198E-2|0.12719655|0.20599046|0.15120026|0.11125171|0.08068902|6.1184045E-2|4.3380249E-2|3|1|26227|268570896|276857104|268603408|268604688|268468240|268603408|1310.4341|1833.0654|0|68|0|4|0|5740227461120|51638.403478200002|3|0|88063|0|0.0|0|0.0|-16.915016335974116|1|0
5740227461482|587725491599311255|259.10045550071101|58.399416513392303|-9.9080896580093794E-2|-0.51454183067741599|0.85172159795089097|20.810938|20.374512|19.438068|19.096033|18.833891|7.8863673E-2|2.1892317E-2|1.4696489E-2|1.8829314E-2|4.7189601E-2|0.14968616|0.11013765|7.9881012E-2|0.06057135|4.2945843E-2|3|1|9843|34628173912|411074584|268468248|268468248|268468248|268468248|1343.2101|1554.4634|0|0|0|0|0|5740227461120|51638.403478200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740227657736|5740227657736|259.34207651545699|58.099688107020299|-9.7732861575207997E-2|-0.51932672342637298|0.84896881103109401|16.439413|16.652599|16.958618|17.074472|17.154783|2.1904014E-2|9.0975324E-3|1.4754456E-2|2.4576642E-2|2.9545059E-2|0.12702097|9.3460828E-2|6.7785583E-2|5.1399756E-2|0.03644307|6|1|26227|268566528|268468224|268468224|268468256|268599296|402685952|210.96458|1779.2413|0|1048580|0|4|0|5740227657728|51638.404721999999|3|0|88224|0|0.0|0|0.0|3.5607077482548135|1|0
5740227657771|5740227657771|259.33110416702198|58.038348702668699|-9.8000521268229807E-2|-0.52020087287695105|0.84840258703590299|22.132559|19.832535|19.620543|19.648291|19.352013|0.22790714|1.5893083E-2|2.0550139E-2|0.03232532|7.5120293E-2|0.12884866|9.4805613E-2|6.8760939E-2|5.2139338E-2|3.6967441E-2|6|1|26227|70369012613904|70369155252497|268468240|268435472|268468240|402686480|723.0813|1552.6514|0|4|0|4|0|5740227657728|51638.404721999999|3|0|88224|0|0.0|0|0.0|-28.441483166313418|1|0
5740227723286|587725491599573033|259.42940459482298|57.923318194625999|-9.7420156503384994E-2|-0.52204159266421302|0.84733811942781601|20.310875|19.661854|20.124588|19.426476|22.826332|5.3631835|3.1310256|4.3527827|1.9770902|0.86569202|0.12259942|9.0207487E-2|6.5425992E-2|4.9610551E-2|3.5174496E-2|3|1|9843|70369013535064|70369013567545|70369013567513|70369013567513|269389880|70369156170041|504.02454|1670.782|0|0|0|0|0|5740227723264|51638.405136699999|3|0|0|0|0.0|0|0.0|0.0|0|0
5740227788913|5740227788913|259.30462704658601|57.776280317972102|-0.0989600539915549|-0.52396321803977497|0.84597249001098795|19.348021|18.83419|18.618935|18.554697|18.533566|4.1768771E-2|1.3149254E-2|9.8646572E-3|1.5750175E-2|4.4681344E-2|0.15265776|0.11232413|8.1466831E-2|6.1773833E-2|4.3798417E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|220.41457|674.3147|0|4|0|4|0|5740227788800|51638.405551199998|3|0|88224|0|0.0|0|0.0|5.0305582884159463|1|0
5740227788919|587725491599638578|259.34937408380699|57.768905380137902|-9.8570941814117297E-2|-0.52414735510049304|0.84590384771026805|18.56307|18.247196|18.270941|18.305706|18.362675|3.6652677E-2|1.2159497E-2|8.8490751E-3|1.4945085E-2|4.0646363E-2|0.15115531|0.11121865|8.0665037E-2|6.1165854E-2|4.3367352E-2|6|1|9843|268435472|268468240|268468240|268468240|268468272|268468240|352.77194|858.90771|0|0|0|0|0|5740227788800|51638.405551199998|3|0|0|0|0.0|0|0.0|0.0|0|0
5740227854510|5740227854510|259.62087190189197|57.572877408445002|-0.0966069996093811|-0.52745223754051196|0.84407418201244599|18.039909|17.845497|17.55411|17.127844|17.013016|0.03074087|9.9935271E-3|8.1454711E-3|1.3468554E-2|1.6736733E-2|0.18014812|0.13255127|9.6137241E-2|7.2897956E-2|0.05168556|3|1|26227|34628173840|268468240|268468240|268468240|268468240|268468240|1098.5699|1548.9103|0|7236|0|4|0|5740227854336|51638.405965899998|3|0|88224|0|0.0|20190|3.9000000804662704E-2|-21.618704955082137|1|0
5740227985450|587725491599835215|259.78124006702001|57.312221142227997|-9.5810557441579403E-2|-0.53149413975145998|0.84162599561360396|17.350567|16.214094|16.189434|16.17609|16.235184|3.0263698E-2|8.3200121E-3|1.8235771E-2|8.1982892E-3|2.3212155E-2|0.19662142|0.14467217|0.10492832|7.9563968E-2|5.6411847E-2|6|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|873.42358|1554.0684|0|1056768|0|0|0|5740227985408|51638.406795000003|3|0|88224|0|0.0|0|0.0|0.0|0|0
5740227985584|587725491599835216|259.76881115126002|57.292362303882399|-9.5977657605413394E-2|-0.53176038246254798|0.84143875884336505|19.365501|18.290091|18.274429|18.278074|18.283937|3.9341107E-2|9.6053025E-3|1.9077195E-2|1.1129851E-2|3.6496237E-2|0.20141976|0.14820273|0.10748899|8.1505641E-2|5.7788517E-2|6|1|26227|268567040|276857344|268468224|268468224|268599296|268468224|1026.0099|1439.8115|0|1048576|0|0|0|5740227985408|51638.406795000003|3|0|88224|0|0.0|0|0.0|0.0|0|0
5740227985659|587725491599835412|259.57630804046698|57.218181697751596|-9.7960747958158997E-2|-0.53250589750153698|0.84073846170230604|20.377142|19.808033|19.52737|19.176012|19.03718|6.3521706E-2|1.5417346E-2|2.2430476E-2|1.6982853E-2|6.0479552E-2|0.19116695|0.14065883|0.10201751|7.7356793E-2|5.4846931E-2|3|1|26231|268566528|268468224|268468224|268599296|268468224|268468224|1371.6749|329.52658|0|33554432|0|0|0|5740227985408|51638.406795000003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740228051113|5740228051113|259.83333680520502|57.130111232410101|-9.5798946074808405E-2|-0.53421138379463395|0.83990520855342798|18.751368|18.735382|18.568584|18.531187|18.482901|3.1658832E-2|8.5366592E-3|0.01197003|2.1902617E-2|3.7786189E-2|0.20644939|0.15190351|0.11017309|8.3540916E-2|5.9231553E-2|6|1|26227|268566544|268468240|268468240|268599312|268468240|402685968|1165.8975|1282.8057|0|4|0|4|0|5740228050944|51638.407209700003|3|0|88224|0|0.0|0|0.0|-27.137258976291989|1|0
5740228051569|5740228051569|259.90952715926898|57.146555366266298|-9.5046244233851301E-2|-0.53410095243238498|0.84006094068695902|22.734171|21.898483|19.942455|18.691179|17.915136|0.46285346|6.5892279E-2|2.0041112E-2|0.020459|2.5938638E-2|0.20258224|0.14905809|0.10810935|8.1976049E-2|5.8122043E-2|6|1|26227|87961198792976|70369155383569|17592454647824|268468240|268468240|268468240|1139.8442|1686.407|0|4|0|4|0|5740228050944|51638.407209700003|3|0|88224|0|0.0|0|0.0|-1.4529269267533955|1|0
5740228182103|5740228182103|259.98166513394602|56.895852050399697|-9.5012255365318696E-2|-0.53783479258946199|0.83767917916744605|17.329021|16.328978|16.234917|16.218452|16.231405|2.1306941E-2|1.0359148E-2|2.0860471E-2|9.430252E-3|2.4194457E-2|0.14237159|0.10475566|7.5977542E-2|5.7611473E-2|4.0847249E-2|6|1|26227|34628173824|268468224|268468224|268468224|268468224|402685952|696.07416|1321.4941|0|1056772|0|4|0|5740228182016|51638.408038900001|3|0|88224|0|0.0|0|0.0|2.6984755400028604|1|0
5740228313337|5740228313337|259.97609211903301|56.5175740347428|-9.6025127667778501E-2|-0.54325988785370904|0.83405507558287895|21.408792|19.510527|19.226198|19.239607|19.252058|0.13309215|1.4603394E-2|1.4549519E-2|1.6982304E-2|7.4202456E-2|0.12209252|8.9834519E-2|6.5155484E-2|4.9405433E-2|3.5029065E-2|6|1|26227|268435968|268468224|268468224|268468224|268468224|268468736|1237.6803|233.5126|0|4|0|4|0|5740228313088|51638.408868099999|3|0|88222|0|0.0|0|0.0|-28.913404433717112|1|0
5740228378738|5740228378738|260.02129683145199|56.461687364520998|-9.5737408383874498E-2|-0.54413645678921996|0.83351656553952902|19.273394|18.212849|18.130388|17.984804|18.085457|0.03970629|1.0797288E-2|1.4822262E-2|1.7175594E-2|4.4580996E-2|0.12109762|8.9102484E-2|6.4624555E-2|4.9002841E-2|3.4743626E-2|6|1|26227|268435456|268468224|276856832|268468224|268468224|402685952|429.62946|292.57715|0|1056772|0|4|0|5740228378624|51638.409282699999|3|0|88222|0|0.0|0|0.0|4.4734351042118448|1|0
5740228444409|5740228444409|260.20098384074299|56.224722457062803|-9.4616352107847898E-2|-0.54782633923857404|0.83122442694513399|18.692232|17.540138|17.435551|17.431929|17.358658|3.1138498E-2|8.906777E-3|9.1562783E-3|1.0987954E-2|1.8282413E-2|0.13320816|9.8013297E-2|0.07108742|5.3903434E-2|3.8218208E-2|6|1|26227|34628305424|268468240|268468240|268468240|268599312|402686480|1396.4567|493.1973|0|4|0|4|0|5740228444160|51638.409697399999|3|0|88222|0|0.0|0|0.0|3.9156596067753213|1|0
5740228444811|5740228444811|260.13118527201601|56.254310002059498|-9.5210069775852293E-2|-0.54728770398665805|0.83151140201339901|23.600559|21.786774|20.600079|19.57777|18.985786|0.55126226|5.9219617E-2|3.2902945E-2|2.3288269E-2|5.2487865E-2|0.12607653|9.2765912E-2|6.7281574E-2|5.1017582E-2|3.6172103E-2|6|1|26227|70369012748560|70369155354897|268435472|268435472|268435472|402685968|1032.9928|240.06218|0|4|0|4|0|5740228444160|51638.409697399999|3|0|88222|0|0.0|0|0.0|6.0643870237675088|1|0
5740228445186|100709104082747392|260.22255239664003|56.236303880623801|-9.4381585258199896E-2|-0.54769632863523299|0.83133678371862996|23.94175|24.752094|23.128632|20.993736|19.437593|0.92665464|0.54960519|0.2788302|7.0841022E-2|7.6400273E-2|0.13269432|9.7635217E-2|7.0813201E-2|5.3695507E-2|3.8070783E-2|6|1|26227|268436224|142606593|134235393|142614785|402653696|268435456|1329.4603|629.16046|0|262144|0|0|0|5740228444160|51638.409697399999|3|0|88222|0|0.0|0|0.0|-3.9205177354232461|0|0
5740228509736|5740228509736|260.39013260464498|56.205837194358097|-9.2853050625399294E-2|-0.54840581290545698|0.83104113939146396|17.935045|17.700426|17.546707|17.560047|17.34173|1.9129917E-2|1.3394346E-2|1.1453009E-2|1.6463356E-2|2.2001514E-2|0.14309494|0.10528789|7.6363564E-2|0.05790418|4.1054785E-2|6|1|26227|34628173824|268468224|285245440|268468224|268468224|268468224|489.23325|1351.7686|0|4|0|4|0|5740228509696|51638.410111999998|3|0|88365|0|0.0|0|0.0|-26.615307403642554|1|0
5740228509984|100709103797534720|260.18904274654898|56.204138434862102|-9.4781402254047201E-2|-0.54810083038976398|0.83102464795745201|19.850889|20.070328|20.487324|20.771593|21.269398|3.8541846E-2|1.9970154E-2|3.0430648E-2|0.05862416|0.37071636|0.13440177|9.8891549E-2|0.0717244|5.4386441E-2|3.8560662E-2|6|1|26227|268571392|268603392|268468224|268468224|402686464|134251777|195.52603|378.59024|0|42991616|0|0|0|5740228509696|51638.410111999998|3|0|88222|0|0.0|0|0.0|-26.326503264799868|0|0
5740228575605|587725491600425378|260.30593746451302|55.940044142311798|-9.4306974060309898E-2|-0.552062983506454|0.82845196413886402|22.099632|20.1366|19.902735|19.868893|19.681538|0.22154887|2.0415779E-2|2.0227296E-2|3.5600904E-2|9.6948676E-2|0.14178152|0.10432149|0.07566265|5.7372697E-2|4.0677957E-2|6|1|9843|87961198789136|70369146880017|158329942999056|268599312|268468240|402686480|1302.0472|211.20213|0|0|0|0|0|5740228575232|51638.410526699998|3|0|0|0|0.0|0|0.0|0.0|0|0
5740228706536|103524643905732608|260.49419439917898|55.785410464533101|-9.2861466104416202E-2|-0.55457303366172905|0.82693742111974|20.570818|20.680973|20.653654|20.170921|20.155056|6.5517351E-2|2.6975647E-2|3.5188407E-2|3.8947288E-2|0.14576501|0.15634988|0.11504076|8.3437152E-2|6.3267872E-2|4.4857707E-2|6|1|26227|268435968|276856832|268468224|268468224|268468224|402686464|210.34564|701.05231|0|35651584|0|0|0|5740228706304|51638.411355900003|3|0|88365|3044|4.820000171661377|0|0.0|-26.154229356998066|0|0
5740228837955|587725491600687519|260.76280615693798|55.455913763565597|-0.0910224022970932|-0.55968696861532297|0.82369012343371995|25.294727|21.833269|20.099297|19.298538|18.669619|0.92361987|6.0910493E-2|2.1891413E-2|2.8603826E-2|4.7645871E-2|0.15823431|0.1164273|8.4442794E-2|6.4030409E-2|4.5398362E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|759.42664|1117.9501|0|0|0|0|0|5740228837376|51638.412185300003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740228968540|103524642534195200|260.98919850433299|55.258636179827299|-8.9253872853952296E-2|-0.56284001201339995|0.82173284409066105|25.519554|23.005854|21.129536|21.997831|20.762785|0.81356752|0.1720608|4.9910769E-2|0.20535466|0.25339633|0.17191294|0.1264919|9.1742486E-2|6.9565549E-2|0.04932284|3|1|26227|105553385357660|70369155449117|70369146930493|269059388|70369147454781|70369147453501|95.85714|1704.0|0|64|0|0|0|5740228968448|51638.413014500002|3|0|88365|0|0.0|0|0.0|-20.005067391736141|0|0
5740228968589|5740228968589|260.75557791804403|55.1653214609983|-9.1762949661851598E-2|-0.563791592061337|0.82080363168683601|19.825396|18.803394|18.767773|18.76483|18.78264|7.0013709E-2|1.0551029E-2|1.3356362E-2|0.01658326|4.7109373E-2|0.17603196|0.12952265|9.3940623E-2|7.1232334E-2|0.05050461|6|1|26227|34628173824|268435456|268468224|268435456|268468224|268435456|548.29944|295.15915|0|1056772|0|4|0|5740228968448|51638.413014500002|3|0|88365|0|0.0|0|0.0|5.2312323454227823|1|0
5740228968630|5740228968630|260.99503913811998|55.168624720915702|-8.9398445081140296E-2|-0.56412344056921704|0.820836562183619|19.500463|19.29738|18.931767|18.952814|19.042253|6.6626295E-2|1.2270579E-2|1.3882823E-2|1.7735848E-2|5.6804866E-2|0.1682778|0.12381721|8.9802571E-2|6.8094566E-2|4.8279896E-2|6|1|26227|268435984|268468240|268468240|268468240|268468240|402686480|886.91522|1491.9396|0|4|0|4|0|5740228968448|51638.413014500002|3|0|88365|0|0.0|0|0.0|-26.72981130564991|1|0
5740229034290|5740229034290|260.84296579595201|55.070504654948998|-9.1118984454849894E-2|-0.56527112985587502|0.81985723173207403|19.557228|19.508646|18.984917|18.863935|18.210121|3.1303614E-2|1.6340399E-2|0.02097447|2.5449345E-2|3.0665934E-2|0.17803748|0.13099828|9.5010884E-2|7.2043873E-2|5.1080007E-2|3|1|26227|17592454610960|268468240|158329942999056|268468240|268599312|268468240|145.27678|472.43289|0|5124|0|4|0|5740229033984|51638.413429200002|3|0|88365|0|0.0|20220|3.1300000846385956E-2|-22.521134200764827|1|0
5740229100184|587725491600950054|261.10204564910498|54.844834125684102|-8.9060804099244897E-2|-0.568863279806887|0.81759570819601801|23.128277|21.727837|20.493704|19.961765|20.042963|0.53334683|5.8273781E-2|2.9902173E-2|2.9497765E-2|0.13945991|0.20031811|0.14739217|0.10690109|8.1059866E-2|5.7472453E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|402685952|1143.0206|1159.5996|0|0|0|0|0|5740229099520|51638.413843800001|3|0|0|0|0.0|0|0.0|0.0|0|0
5740229165293|5740229165293|261.12713636809701|54.664593549255201|-0.0892079507073614|-0.571440614017096|0.81578034187050397|19.326794|19.095217|18.677229|18.558182|18.57505|0.0359127|1.1568581E-2|1.5125094E-2|2.1862235E-2|4.1008979E-2|0.18799669|0.13832617|0.10032568|7.6073922E-2|5.3937361E-2|6|1|26231|268435472|268468240|268468240|268468240|268468240|402685968|1387.6053|804.53528|0|7172|0|4|0|5740229165056|51638.414258500001|3|0|88363|0|0.0|20226|1.4800000004470348E-2|-26.400134413188489|1|0
5740229230658|5740229230658|261.381756077864|54.5730021464557|-8.6862929657626001E-2|-0.57312003327033401|0.81485474712706096|24.420568|20.869072|18.995367|19.843056|20.826|1.2129102|0.46023017|0.13845362|0.23917329|0.58548874|0.16966033|0.12483446|9.0540364E-2|6.8654016E-2|0.04867655|6|1|26227|70369013268752|70369189462289|70369046724625|302546960|70369046724657|70369046724625|1212.0735|1843.9482|0|5|1|4|0|5740229230592|51638.4146731|3|0|88363|0|0.0|0|0.0|6.3120371702518838|1|0
5740229230661|5740229230661|261.39512801960802|54.572515098674401|-0.0867302063841911|-0.57314713886889401|0.814849819602948|24.57181|22.391289|20.210161|20.015959|20.372683|1.1854494|0.24953909|0.15119505|0.13323878|0.20997849|0.16917944|0.12448063|9.0283737E-2|6.8459421E-2|4.8538584E-2|6|1|26227|70369013273360|70369189462321|70369046724625|70369046724625|302546992|70369046860305|1237.0002|1910.2096|0|1|1|0|0|5740229230592|51638.4146731|3|0|88363|0|0.0|0|0.0|-6.1236575273268912|1|0
5740229230877|101272087833870336|261.11881515787201|54.571790986818698|-8.9494818750634406E-2|-0.57273238785779601|0.81484249356271199|20.224295|19.827444|19.828278|19.69412|19.602688|5.5745348E-2|1.6459411E-2|1.9371156E-2|2.5984043E-2|9.5172964E-2|0.19991368|0.14709459|0.10668527|8.0896206E-2|5.7356417E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|820.68903|515.53369|0|34603008|0|0|0|5740229230592|51638.4146731|3|0|88363|0|0.0|0|0.0|-27.433401155010017|0|0
5740229296371|5740229296371|261.31728657447201|54.508362140105703|-8.7646476839428902E-2|-0.57393033490327505|0.81420026146854696|20.566771|19.481747|19.253502|18.906385|18.718058|9.3239896E-2|2.3018729E-2|4.1887742E-2|4.5507438E-2|6.3215092E-2|0.18249924|0.13428122|9.7391941E-2|7.3849358E-2|5.2360114E-2|3|1|26227|34628173840|268468240|268468240|268468240|268468240|268468240|316.13766|1349.0397|0|4|0|4|0|5740229296128|51638.4150878|3|0|88363|0|0.0|0|0.0|-18.477164037054507|1|0
5740229361932|101272087842258944|261.26589821352201|54.367107909058703|-8.8465734377785196E-2|-0.57583376095588201|0.81276644467177805|19.815979|19.702|19.39164|19.263454|19.196333|4.5704838E-2|1.5164522E-2|1.3639972E-2|0.01993461|6.7752697E-2|0.2187629|0.16096365|0.11674427|8.8523649E-2|6.2764369E-2|6|1|26231|268435456|268468224|268468224|268468224|268468224|268468224|105.13876|714.88257|0|34603008|0|0|0|5740229361664|51638.415502399999|3|0|88363|0|0.0|0|0.0|-25.959986657525079|0|0
5740229427520|101272088156831744|261.35459790827099|54.121067493524102|-8.8098012236076495E-2|-0.57941524078096096|0.81025719311265199|19.723753|19.69927|19.348791|19.376545|19.699333|5.5513505E-2|1.6279329E-2|1.6566956E-2|2.2845134E-2|0.10453684|0.29588211|0.21770725|0.15789945|0.11973038|8.4890328E-2|6|1|26227|268435968|268435456|268468224|268435456|268435456|402686464|1022.0613|515.36749|0|34603008|0|0|0|5740229427200|51638.415916899998|3|0|88363|0|0.0|0|0.0|-25.996225951751562|0|0
5740229492958|5740229492958|261.68240516457001|53.997022508148802|-8.5035134809448298E-2|-0.58164418082137004|0.80898644782504003|19.58753|19.295567|18.882965|18.774731|18.687292|3.4482416E-2|1.3616733E-2|2.2871707E-2|1.1902675E-2|5.4958098E-2|0.24706897|0.18179099|0.13184999|9.9977858E-2|7.0885547E-2|6|1|26227|268435968|268468736|268468224|268468224|268468224|402686464|1242.968|1865.6177|0|1048580|0|4|0|5740229492736|51638.416331699998|3|0|88475|0|0.0|0|0.0|-26.528193141678265|1|0
5740229493027|101272088177803264|261.35755637561198|54.031961374872097|-8.8257341044977899E-2|-0.58066488770314395|0.80934475345205403|20.473122|20.082487|20.046814|19.835506|19.834433|6.3102394E-2|1.8499848E-2|2.9808424E-2|2.5836948E-2|0.12283047|0.30664063|0.22562325|0.16364081|0.12408387|8.7977007E-2|6|1|26227|268435456|402685952|268468224|268435456|268435456|402685952|441.12439|295.61813|0|34603008|0|0|0|5740229492736|51638.416331699998|3|0|88475|0|0.0|0|0.0|-26.430978100193791|0|0
5740229558515|5740229558515|261.736229701664|53.885696709700198|-8.4714456717017994E-2|-0.58327824963501596|0.80784277203293198|21.727242|20.318699|20.13393|19.731663|19.292274|0.17536111|2.6518073E-2|2.3827268E-2|2.6103081E-2|7.3708341E-2|0.21720864|0.15982005|0.11591483|8.7894708E-2|6.2318441E-2|6|1|26227|268435712|402687232|268468224|268468224|268468224|402685952|933.73859|1853.3781|0|33554433|1|0|0|5740229558272|51638.416746499999|3|0|88475|0|0.0|0|0.0|-28.134329796653617|1|0
5740229623836|101272088219746304|261.66588917264801|53.7712347304806|-8.5664218694996297E-2|-0.58476945926886503|0.80666369767194501|24.660181|21.083477|20.86351|21.163982|20.359377|3.5874758|11.199709|11.394906|11.54843|12.305715|0.24690372|0.1816694|0.1317618|9.9910989E-2|7.0838138E-2|3|1|26227|70369013534992|70369188942097|70369046200369|70369046335537|277778736|70369046201617|464.375|1192.6875|0|64|0|0|0|5740229623808|51638.417161099998|3|0|88475|0|0.0|0|0.0|7.6017062071171182|0|0
5740229690097|587725491601539990|261.78083566481303|53.656962849619397|-8.4720715316680295E-2|-0.58653127860077803|0.805483370169221|23.202433|23.368004|21.153114|20.093678|19.697613|0.57525092|0.24566332|5.4220676E-2|0.03810082|0.12226757|0.22445586|0.16515249|0.11978237|9.0827338E-2|6.4397715E-2|6|1|9843|268436224|142639361|142639361|268468224|411074560|402686464|274.02103|1491.6447|0|0|0|0|0|5740229689344|51638.417575799998|3|0|0|0|0.0|0|0.0|0.0|0|0
5740229754999|5740229754999|261.893935356724|53.486103246011297|-8.3901085230566094E-2|-0.58907276190167401|0.80371256620925502|18.509571|18.257648|18.358559|18.198193|18.208868|0.0259718|1.1871764E-2|1.4471347E-2|2.2004375E-2|3.8361017E-2|0.20750153|0.15267766|0.11073457|8.3966672E-2|5.9533417E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|575.47858|1636.5088|0|20|0|4|16|5740229754880|51638.417990399998|3|0|88475|3526|3.6099998950958252|0|0.0|-24.909283801764033|1|0
5740229755368|5740229755368|261.63025350559099|53.417541178889302|-8.6751099494630599E-2|-0.58963148723524195|0.80299997260101397|22.664423|20.580395|19.879442|19.288111|19.479807|0.28529805|2.5294157E-2|2.2261769E-2|2.6401112E-2|0.09759032|0.21320467|0.15687397|0.11377808|8.6274475E-2|0.06116968|6|1|26227|70369012744464|70369155383569|268468240|268468240|268468240|268468240|768.35852|90.525002|0|1|1|0|0|5740229754880|51638.417990399998|3|0|88475|0|0.0|0|0.0|5.7394701841678994|1|0
5740229886107|5740229886107|261.91328800871003|53.109534836839103|-8.4443365589114999E-2|-0.59431806814154697|0.79978456592290004|18.934011|18.948162|18.886833|18.726387|18.582783|3.2725394E-2|2.1662446E-2|2.2433551E-2|1.4617291E-2|0.04538282|0.19111785|0.14062271|0.10199131|7.7336922E-2|5.4832842E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|402685968|1167.9222|770.11847|0|4|0|4|0|5740229885952|51638.418819699997|3|0|88475|0|0.0|0|0.0|-27.997319162347672|1|0
5740229886187|101272086386835456|261.78753995346301|53.188914281689698|-8.5589161090608296E-2|-0.59303405290641598|0.80061545550732105|20.092791|20.061077|20.062677|19.725208|19.550621|5.2610401E-2|1.7312678E-2|2.7159592E-2|2.4427895E-2|9.4000757E-2|0.18711284|0.13767585|9.9854015E-2|7.5716272E-2|5.3683784E-2|6|1|26227|268435456|276856832|268468224|276856832|268468224|402685952|282.07724|316.91724|0|34603008|0|0|0|5740229885952|51638.418819699997|3|0|88475|0|0.0|0|0.0|-26.745702137976558|0|0
5740229951610|5740229951610|261.91263824869901|53.0414397341087|-8.4583769149029001E-2|-0.59525776817647302|0.79907056973843604|18.55575|18.41943|18.15799|18.066519|18.124098|3.3581886E-2|1.4338863E-2|7.836069E-3|2.1169569E-2|3.5769798E-2|0.18864019|0.13879965|0.10066909|0.07633432|5.4121986E-2|6|1|26227|268435968|268468736|268468224|268468224|268468224|268468224|400.14749|591.56464|0|1048580|0|4|0|5740229951488|51638.419234300003|3|0|88475|0|0.0|0|0.0|-27.741636726201968|1|0
5740229952117|587725491601801959|261.99069731932798|52.950093412402502|-8.3950117325976903E-2|-0.59663322106356798|0.79811100564035897|24.257505|21.402269|20.404667|20.15406|20.209511|1.1098303|4.4243172E-2|2.8141987E-2|0.04135213|0.16360778|0.1760518|0.12953724|0.09395121|7.1240358E-2|5.0510302E-2|6|1|9843|268435712|134243585|268435456|268435456|268435456|268435456|1317.0144|767.4314|0|0|0|0|0|5740229951488|51638.419234300003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740761579637|5740761579637|255.20644899077701|64.533160255274595|-0.10979198332463599|-0.415735442516529|0.90283429389519099|18.515142|18.753345|18.589888|18.61764|18.684811|2.3040891E-2|7.3125069E-3|1.8184707E-2|2.0178463E-2|4.4021275E-2|0.12724084|9.3622595E-2|6.7902915E-2|5.1488724E-2|3.6506146E-2|6|1|26227|34628305408|268468736|268468736|268468224|268468224|268599296|363.79056|1310.9631|0|1048580|0|4|0|5740761579520|51638.386063400001|3|0|87899|0|0.0|0|0.0|-26.765320766790474|1|0
5740761710598|758883004956082277|255.25257804107301|64.202512338736497|-0.110781698214097|-0.42085527506312198|0.90033785480359796|16.708096|16.078056|16.04328|15.892953|15.773512|4.6657749E-2|8.8822702E-3|1.0188822E-2|1.3456247E-2|2.1425033E-2|0.12722129|9.3608215E-2|6.7892484E-2|5.1480815E-2|0.03650054|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|497.58133|350.1048|0|1054720|0|0|0|5740761710592|51638.3868926|3|0|87899|0|0.0|20089|0.0348999984562397|-31.783960233028715|0|0
5740761710799|5740761710799|255.277100788464|64.234436067409803|-0.11047405340192799|-0.42041741195202897|0.90058019257171396|19.944904|19.09804|18.964256|18.670923|18.648022|6.0192466E-2|1.2147199E-2|1.3591726E-2|1.7142665E-2|3.8733076E-2|0.13225622|9.7312868E-2|0.07057941|5.3518228E-2|3.7945092E-2|3|1|26227|268566544|268468240|268599312|268468240|268468240|268468240|264.85767|548.60779|0|68|0|4|0|5740761710592|51638.3868926|3|0|87899|0|0.0|0|0.0|-19.782190195805612|1|0
5740761907779|5740761907779|255.824182327106|63.730506059228198|-0.10839042702193601|-0.42911629731211398|0.89672220821787596|23.331026|20.947599|19.403793|19.844116|17.254738|0.61995792|3.0251898E-2|1.5150482E-2|8.5252203E-2|0.0177042|0.13598837|0.10005895|7.2571091E-2|5.5028465E-2|3.9015867E-2|6|1|26227|19971866497024|142622721|268603392|268435456|158329943003137|268468224|1245.6224|875.28699|0|1|1|0|0|5740761907200|51638.388136399997|3|0|87899|0|0.0|0|0.0|6.3267218473759073|1|0
5740761972773|587725492133822538|255.88483426764199|63.663675745607897|-0.108191117029309|-0.43024486932885297|0.89620535292540404|22.684664|21.029863|19.427979|18.728489|18.330589|0.37853408|5.0070718E-2|0.02482326|1.4166485E-2|2.9584119E-2|0.16593683|0.12209474|8.8553295E-2|6.7147277E-2|0.04760826|6|1|9843|70369012744720|70369155260433|276856848|268468240|268468752|268468240|539.49213|879.75049|0|0|0|0|0|5740761972736|51638.388550999996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038286|758883003882405943|255.851661255441|63.493381359039603|-0.109090817920626|-0.43276315224245099|0.89488281216402099|18.173903|16.865795|16.47822|16.272665|16.234945|0.0148765|4.3663615E-3|1.2886168E-2|7.7005671E-3|1.3381813E-2|0.1534054|0.11287424|0.08186581|6.2076367E-2|4.4012919E-2|6|1|9843|268435968|285245440|285245440|293634560|427852288|419463168|570.94427|187.78455|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038306|758883003882406028|256.02935669381202|63.485342569240302|-0.10777844760159|-0.43322123829493703|0.89482018580427203|17.485909|15.773796|15.13722|14.895664|14.84895|0.01173045|3.820529E-3|0.01273281|7.3947618E-3|1.2385785E-2|0.13910002|0.10234847|7.4231647E-2|5.6287613E-2|3.9908618E-2|6|1|9843|268435456|276856832|268468224|268468224|268468224|268468224|901.42853|832.25177|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038328|758883003882471475|256.21650478901103|63.466763901588003|-0.10643194731994|-0.433852743890698|0.89467538091097498|16.150909|15.262796|14.99822|14.941665|14.91695|9.0891449E-3|3.695932E-3|0.01273281|7.3947613E-3|1.2408618E-2|0.12511897|9.2061348E-2|6.6770568E-2|0.0506301|0.03589737|6|1|9843|268435472|268468240|268468240|268468240|268468240|268468240|1333.6841|1479.318|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038333|758883003882471432|256.11857261637198|63.449197824343003|-0.107239151418257|-0.43393645609464898|0.894538381778618|17.077909|16.143797|15.77522|15.662664|15.629949|1.0368566E-2|3.9131171E-3|1.2779804E-2|7.5045344E-3|1.2767948E-2|0.12840404|9.4478473E-2|6.8523668E-2|5.1959421E-2|3.6839876E-2|6|1|9843|268570640|302153744|302157840|302022672|302022672|302022672|1338.9784|1050.5267|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038399|758883003882406186|255.94879382345499|63.500485043084502|-0.10833006718090001|-0.43283983652598401|0.89493813890164498|20.465408|17.992794|16.914219|16.416664|16.174946|5.8836434E-2|5.8304616E-3|0.01299341|7.7575087E-3|1.3320358E-2|0.15056904|0.11078726|8.0352165E-2|6.0928613E-2|4.3199144E-2|6|1|9843|34628173824|268468224|268468224|268468224|268468224|268468224|654.48395|578.11664|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038401|758883003882406140|255.86044740658801|63.484890305266603|-0.109056849111414|-0.432908472118535|0.89481666190895504|21.357317|18.820786|17.765217|17.283663|17.160919|0.12110369|8.2275579E-3|0.0134437|8.4823389E-3|1.6221128E-2|0.15046202|0.11070852|8.0295056E-2|0.06088531|4.3168444E-2|6|1|9843|17626814353920|419463168|285261824|293634560|419463680|17592605643264|655.85132|192.5721|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038420|758883003882471650|256.16248333450602|63.471449644474902|-0.10682345908544499|-0.433681155483092|0.89471191115792703|21.528355|18.971783|17.583218|16.306664|15.638948|0.13714603|8.8728312E-3|1.3283738E-2|7.7005662E-3|1.2732715E-2|0.12824583|9.4362065E-2|6.8439245E-2|5.1895406E-2|3.6794487E-2|6|1|9843|268566544|411074576|268468240|268468240|268468240|268599312|1214.7764|1290.1469|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038424|758883003882471527|256.295856149592|63.492301984571299|-0.10573649997018|-0.43361226124896002|0.89487440429851395|18.603893|17.581795|17.189219|17.101664|16.952929|0.01760692|5.1346589E-3|1.3077428E-2|8.1830975E-3|1.5222753E-2|0.12249845|0.09013319|6.5372109E-2|4.9569689E-2|3.5145529E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1232.9619|1863.4944|0|0|0|0|0|5740762038272|51638.388965600003|3|0|87899|0|0.0|0|0.0|0.0|0|0
5740762038444|758883003882406131|255.83593275384601|63.492171933990399|-0.109214235658687|-0.43275150419437602|0.89487339123866805|22.786282|19.835732|18.487211|17.67766|17.272911|0.41150805|1.4776826E-2|1.4444589E-2|9.1476217E-3|1.6537581E-2|0.15370727|0.11309634|8.2026899E-2|6.2198516E-2|4.4099521E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|557.79346|124.42966|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038445|758883003882406160|255.89909921634199|63.4930008388503|-0.10873392286512799|-0.43285908961657399|0.89487984811072296|23.012819|20.37862|18.954197|17.873657|17.350904|0.496847|2.1590712E-2|1.5648875E-2|9.5697977E-3|1.7063392E-2|0.1509667|0.11107986|8.0564387E-2|6.1089534E-2|4.3313239E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|644.39386|365.63828|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038446|758883003882406171|255.92028141334299|63.487989103715798|-0.108592929818932|-0.43297518193350698|0.89484080563136303|24.241091|20.328634|18.960197|17.60466|16.927929|1.070927|2.0829638E-2|1.5663279E-2|8.972425E-3|0.01508323|0.14822131|0.10905983|7.9099283E-2|5.9978593E-2|4.2525571E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|268468224|718.17572|429.12222|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038450|758883003882406162|255.90921069008101|63.475368830035499|-0.10872457123953801|-0.43314535278112698|0.89474246069631203|22.486958|19.766739|18.403212|17.620661|17.208916|0.31813157|1.4125072E-2|1.4233367E-2|9.0055345E-3|1.6280856E-2|0.14468278|0.10645621|7.7210926E-2|5.8546707E-2|4.1510344E-2|6|1|9843|268435456|142639105|268468224|268468224|268468224|268468224|808.5918|345.14368|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038452|758883003882406219|255.993868831383|63.485887582129997|-0.108044695428058|-0.43314614064702001|0.89482443229521302|22.270882|19.65275|18.246214|17.281662|16.802935|0.2630648|1.3122139E-2|1.3947986E-2|8.4589329E-3|1.4699413E-2|0.14199497|0.10447855|7.5776555E-2|5.7459068E-2|4.0739194E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|402685952|844.61859|699.95123|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038453|758883003882471719|256.28428500050097|63.533568260260502|-0.10567122231435699|-0.43296464748262897|0.89519562488030102|21.852442|20.092691|18.974197|18.521641|18.204733|0.17768687|1.7601015E-2|0.01566324|1.1947363E-2|2.6176011E-2|0.12964247|9.5389694E-2|6.9184564E-2|5.2460559E-2|3.7195191E-2|6|1|9843|268435712|402687232|268468224|268468224|268468224|268468224|865.74884|1954.6998|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038454|758883003882471655|256.16055149501|63.5010569268591|-0.106727475102456|-0.43322857982207902|0.89494259239551199|21.729753|19.75374|18.379211|17.65266|17.28491|0.16304399|1.3995621E-2|1.4141915E-2|9.0304343E-3|0.01681402|0.13294165|9.7817205E-2|7.0945196E-2|5.3795595E-2|3.8141746E-2|6|1|9843|268435712|411074816|268468224|268468224|276856832|268468224|960.84558|1380.1951|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038456|758883003882471644|256.13676348608197|63.491337988255601|-0.106943705505654|-0.43333161002294102|0.89486689491099503|22.186903|19.945717|18.674206|18.084654|17.748856|0.24169074|1.5891472E-2|1.4740017E-2|1.0113348E-2|2.0380547E-2|0.13294394|9.7818889E-2|7.0946418E-2|5.3796519E-2|3.8142402E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|268468224|1008.4189|1258.1888|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038458|758883003882406144|255.89671459142599|63.433094385283098|-0.10897987030794801|-0.433761779471449|0.89441271599716499|22.11343|19.75174|18.50621|17.958656|17.648872|0.22765192|0.01400854|1.4391446E-2|9.7746197E-3|1.9196877E-2|0.13439818|9.8888904E-2|7.1722478E-2|5.4384984E-2|3.8559634E-2|6|1|9843|268435712|34049|268468224|268468224|268468224|268468224|1147.7795|157.33484|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038460|758883003882471625|256.11133167438601|63.465124481954803|-0.107234299873054|-0.43368149574397402|0.89466259851410201|22.950083|19.84273|18.389212|17.329662|16.749935|0.46281224|1.4844998E-2|1.4141906E-2|8.5136322E-3|1.4537912E-2|0.13071601|9.6179597E-2|6.9757469E-2|5.2894976E-2|3.7503198E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|1193.4457|1075.6361|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038473|758883003882406348|255.98565558712801|63.4636627919365|-0.108190831950275|-0.43346738285747399|0.894651201240237|22.634338|21.105124|19.773117|18.516642|17.921822|0.35761899|3.7935212E-2|2.0529656E-2|1.1958387E-2|2.2160636E-2|0.13546443|9.9673443E-2|7.2291493E-2|5.4816451E-2|3.8865548E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|1020.8003|595.38684|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038475|758883003882406220|256.02195462491102|63.428066554137402|-0.108050430170314|-0.43407511768858698|0.89437346603287005|23.019144|20.671494|19.26318|18.170652|17.574883|0.49034819|0.02694972|1.6828949E-2|1.0454217E-2|1.8656962E-2|0.12884039|9.4799533E-2|6.8756528E-2|5.2135993E-2|3.6965068E-2|6|1|9847|34628174592|134219009|268468224|268435456|268468224|268468736|1375.9832|614.9115|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038763|758883003882406334|255.93430021129799|63.489540723208002|-0.108481099213843|-0.432978232197545|0.89485289380794097|23.411541|21.348742|20.280958|19.75844|19.434851|0.67558032|4.6294581E-2|2.7253812E-2|2.5578326E-2|6.5761872E-2|0.14797468|0.10887837|7.8967676E-2|5.9878796E-2|4.2454813E-2|6|1|9843|268435712|134219009|276856832|268435456|268468224|268435456|725.85046|486.96576|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038766|758883003882406370|256.05922693695902|63.509737790869501|-0.107460781662137|-0.43290755700106298|0.89501018290069401|23.641319|21.841181|22.199203|19.076601|18.370655|0.78696305|6.9931298E-2|3.034862|1.5981609E-2|2.9257499E-2|0.14164299|0.10421957|7.5588726E-2|5.7316642E-2|4.0638212E-2|6|1|9843|17592454611200|134219009|276856832|158329942966272|268468224|268435456|738.8172|1025.9279|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038797|758883003882471788|256.13996038992201|63.509289413906998|-0.106852358304701|-0.43306534646615302|0.89500669227379204|24.605902|21.177027|19.769117|18.763628|18.279701|1.1187541|4.0157214E-2|2.0435352E-2|1.3404591E-2|2.7636072E-2|0.13584465|9.9953204E-2|7.2494403E-2|5.4970309E-2|3.8974635E-2|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|861.07178|1329.4363|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038798|758883003882471873|256.21282957408198|63.520586458148401|-0.106259438959666|-0.43302949882881597|0.89509462336450296|23.429298|22.317499|20.815517|19.92136|19.637896|0.66835052|0.10551838|3.8926762E-2|2.8668411E-2|7.9070099E-2|0.13297634|9.7842731E-2|7.0963711E-2|5.3809632E-2|0.0381517|6|1|9843|268435712|134219009|276824320|268435456|268435456|268435456|871.78638|1641.9792|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038810|758883003882406341|255.961767674914|63.472365704022103|-0.10833858032622901|-0.433290398955957|0.89471905209707303|23.788065|21.49342|20.034054|18.741631|18.032791|1.5194286|0.05219977|2.3480998E-2|1.3318517E-2|2.3548076E-2|0.13978401|0.10285175|7.4596666E-2|5.6564394E-2|4.0104859E-2|6|1|9843|268567296|140737622738177|268435456|268435456|268468224|268468736|911.82166|533.81104|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038851|758883003882406319|255.87717452790801|63.443080678101403|-0.109089754258996|-0.43357340265008198|0.89449065396466898|23.469187|21.247921|19.98107|19.015608|18.481588|0.69523388|4.2586889E-2|2.2905111E-2|1.5474919E-2|3.1029802E-2|0.13797656|0.10152183|7.3632106E-2|5.5832993E-2|3.9586291E-2|6|1|9843|268436224|142647553|268468224|268468224|268468224|268468736|1034.5081|116.6843|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038859|758883003882406340|255.967944466853|63.4574047427285|-0.108348511349804|-0.43352871703727702|0.89460239860638302|23.032673|21.881977|20.661692|19.15559|18.32168|0.49817914|7.2662242E-2|3.4929648E-2|1.6827136E-2|2.8122775E-2|0.13468386|0.0990991|7.1874931E-2|5.4500587E-2|3.8641594E-2|6|1|9843|268435712|134219009|276856832|268435456|268468224|268435456|1047.6978|507.61462|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038862|758883003882471671|256.22232371072698|63.499544394169597|-0.10626596351178701|-0.43336633933454599|0.89493081348821901|23.760334|21.044195|19.718126|18.708632|18.132759|1.3726332|3.6033049E-2|1.9878872E-2|1.2907954E-2|2.5184169E-2|0.12853777|9.4576873E-2|6.8595037E-2|5.2013539E-2|3.6878247E-2|6|1|9843|268567040|140737622704129|268468224|268435456|268468224|268468736|1064.1821|1608.88|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038873|758883003882471792|256.16642029296702|63.484572210138602|-0.106744660213224|-0.43348950937328001|0.89481418338070395|23.212|21.593142|20.448862|19.23358|18.648457|0.43920922|5.6681801E-2|2.9822169E-2|1.7442027E-2|3.5651106E-2|0.12990607|9.5583647E-2|6.9325238E-2|5.2567229E-2|3.7270818E-2|6|1|9843|268566784|134350081|268435456|268435456|268468224|268435456|1109.4817|1348.2223|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038889|758883003882471878|256.26726293157299|63.498557628326402|-0.105929684319891|-0.43346452651074902|0.89492312867458101|24.82551|22.47241|21.175856|19.363556|18.245716|1.0819546|0.12102282|5.0687708E-2|1.8619655E-2|2.6982931E-2|0.12543622|9.2294775E-2|6.6939868E-2|5.0758474E-2|0.03598839|6|1|9843|268435712|134219009|276824320|268435456|268468224|402685952|1137.9235|1775.5868|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038909|758883003882471799|256.20405360659799|63.478976574237301|-0.10648074918832|-0.43364439487458201|0.894770578889444|25.273876|22.114468|20.624725|19.183586|18.466599|0.93757576|8.8491023E-2|3.3482686E-2|1.6734144E-2|3.1288829E-2|0.12678677|9.3288504E-2|6.7660607E-2|5.1304989E-2|3.6375877E-2|6|1|9843|268435456|134250497|268468224|268468224|268468224|402685952|1211.889|1472.0941|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038917|758883003882406327|255.91764041009401|63.425437648174601|-0.108850524083795|-0.43391748177523998|0.89435294063167103|23.483381|21.998302|20.442867|19.239578|18.517563|0.69985121|8.0383815E-2|2.9877465E-2|0.01765212|0.03183892|0.13181423|0.09698765|7.0343532E-2|5.3339373E-2|3.7818279E-2|6|1|9843|268435712|142663937|268468224|276856832|268468224|402685952|1243.9901|211.10016|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038939|758883003882471811|256.29400133739699|63.476130965139703|-0.105810376073876|-0.43385419590722601|0.89474840095347397|23.097107|21.101128|19.724127|18.805626|18.088774|0.51385826|3.7726451E-2|1.9624054E-2|1.3075116E-2|2.4430951E-2|0.12103625|8.9057319E-2|6.4591803E-2|4.8978005E-2|3.4726016E-2|6|1|9847|268435456|134258689|268468224|268468224|268468224|402685952|1367.399|1803.4948|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762038952|758883003882406366|256.07034756473399|63.430638180661497|-0.10767410120297299|-0.43412726157929299|0.89439354239830904|23.750956|21.366705|19.962074|19.153591|18.691416|0.84678984|4.7065403E-2|2.2342693E-2|1.6811656E-2|3.6344454E-2|0.12744118|9.3770012E-2|6.8009831E-2|5.1569797E-2|3.6563631E-2|6|1|9847|268566528|134381569|268468224|268468224|268468224|268468224|1425.4331|806.50732|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762039102|758883003882406410|255.92764190450899|63.435597705899802|-0.10873621522256|-0.43378263619062901|0.89443225570111295|24.443739|23.003353|21.229713|19.916363|19.156693|1.1061308|0.19220681|5.3850751E-2|2.8721483E-2|5.1981669E-2|0.13347813|9.8211944E-2|7.1231492E-2|5.4012682E-2|3.8295664E-2|6|1|9843|268435712|134219009|8421633|268435456|268435456|268435456|1172.5055|282.77509|0|0|0|0|0|5740762038272|51638.388965600003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103830|758883003882471490|256.26243728373998|63.454420504464203|-0.10612987408713299|-0.43412514691144899|0.89457912262994499|23.731289|21.186359|19.876282|18.823767|18.282785|0.96138394|4.3830279E-2|1.8261336E-2|2.8033763E-2|4.2024475E-2|0.12177572|0.08960142|6.4986423E-2|4.9277239E-2|3.4938175E-2|6|1|9843|70369013268752|70369146995985|268468240|277381136|277381136|268468240|144.60556|1612.8892|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103832|758883003882471495|256.25765221952599|63.453481393143001|-0.106169612927554|-0.43413052482764503|0.89457179740012305|22.449329|20.789764|19.67832|19.296709|19.112877|0.30347061|7.5963169E-2|8.0399223E-2|8.9463279E-2|0.12155838|0.12196983|8.9744247E-2|6.5090016E-2|4.9355786E-2|3.4993868E-2|6|1|9843|70369013269264|70369155252497|268468240|268992528|268993040|402685968|145.54622|1591.6584|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103846|758883003882471535|256.36154842297401|63.446826845734499|-0.105406714612924|-0.43442329797158702|0.89451988390085502|17.455864|15.810142|15.191407|15.016806|14.946036|1.4713566E-2|1.8781239E-2|5.3373305E-3|2.4781313E-2|3.4176204E-2|0.11683277|8.5964441E-2|6.2348586E-2|4.7277045E-2|3.3520013E-2|6|1|9843|34628833296|268603408|268992528|268992528|268992528|268599312|353.53244|1963.9185|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103859|758883003882406036|256.09115086571597|63.369592818939402|-0.107745469624491|-0.43509106591021002|0.89391648275469004|16.822865|15.573142|15.131407|15.019806|14.947037|1.3820448E-2|1.8763952E-2|5.3275083E-3|2.4804145E-2|3.4176204E-2|0.12675475|0.09326493|6.7643508E-2|5.1292025E-2|3.6366686E-2|6|1|9843|34628173840|268468240|268468240|268468240|268468240|268468240|612.47882|684.01953|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103879|758883003882471523|256.33651816304399|63.387442679930103|-0.105815434434179|-0.435277861718252|0.89405608153711102|18.109859|17.105141|16.785406|16.709805|16.628025|1.7128024E-2|1.9007439E-2|5.8253352E-3|0.02496453|3.4874931E-2|0.12085194|8.8921711E-2|0.06449344|4.8903424E-2|3.4673136E-2|6|1|9843|17626814349824|285245952|158329942999040|268468224|268468224|402685952|821.07037|1674.9536|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103887|758883003882471467|256.25689252805302|63.356139605893503|-0.106536277656508|-0.43560479746736502|0.89381121159141397|17.825861|16.741142|16.373407|16.291805|16.193031|1.6073603E-2|1.8885303E-2|5.614649E-3|2.4872754E-2|3.4523863E-2|0.12416016|9.1355868E-2|6.6258892E-2|5.0242115E-2|3.5622284E-2|6|1|26227|34628173824|268468224|268468224|268468224|268468224|268468256|970.22797|1269.4866|0|0|0|0|0|5740762103808|51638.389380200002|3|0|87899|0|0.0|0|0.0|0.0|0|0
5740762103889|758883003882471508|256.326005905035|63.358823624652103|-0.10600085118576801|-0.43569230626941902|0.89383221792768597|17.068865|15.877142|15.465407|15.373806|15.281036|1.4168407E-2|1.8781239E-2|5.3768014E-3|2.4804143E-2|3.4207661E-2|0.12277126|9.0333931E-2|6.5517701E-2|4.9680088E-2|3.5223801E-2|6|1|9843|268435456|276856832|268468224|268468224|268468224|402685952|1048.6056|1541.1641|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103893|758883003882471486|256.284382978812|63.327506963159898|-0.10643315566963001|-0.43608973970703402|0.89358699760932903|18.214857|16.996141|16.585407|16.490805|16.39403|1.7770704E-2|1.8920114E-2|5.7084984E-3|2.4918603E-2|3.4683045E-2|0.12467262|9.1732927E-2|6.6532373E-2|5.0449483E-2|3.5769314E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|1253.4318|1280.2281|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103913|758883003882406247|256.05935367349002|63.425086849484103|-0.10777827596766699|-0.434190695580283|0.89435020159943401|21.452774|18.992128|17.627405|16.787806|16.27803|0.12940614|2.0441053E-2|6.5964684E-3|2.4964523E-2|3.4523796E-2|0.12763847|9.3915179E-2|6.8115123E-2|5.1649634E-2|3.6620233E-2|6|1|9843|268566544|268468240|268468240|268468240|268468240|268599312|95.258438|746.57898|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103916|758883003882471465|256.21534949579097|63.448090101522098|-0.106510168283419|-0.43413376827688999|0.89452973974817895|19.266811|16.816141|15.655407|15.249806|15.010036|2.7166931E-2|1.8885301E-2|5.4115769E-3|2.4804143E-2|3.4176201E-2|0.12391628|9.1176413E-2|6.6128746E-2|5.0143424E-2|3.5552312E-2|6|1|9843|268435456|293634048|268468224|268468224|268468224|268468224|129.38393|1413.6143|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103920|758883003882405980|255.93370911445101|63.398741009766603|-0.108830096166112|-0.43435216828118001|0.89414439777807297|18.840841|17.119141|16.477407|16.301805|16.184032|2.2165475E-2|1.8954994E-2|5.624997E-3|2.4895675E-2|3.4492087E-2|0.12836637|9.4450757E-2|6.8503566E-2|5.1944178E-2|3.6829069E-2|6|1|9847|34628304912|276856848|268468240|268599312|268468240|268468240|132.72708|183.2296|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103924|758883003882471674|256.24849567207599|63.451234145121099|-0.106247331242909|-0.434147632833778|0.89455426750342404|19.423792|17.799141|17.083406|16.841805|16.701023|2.9540692E-2|1.9183233E-2|6.0383575E-3|2.4987519E-2|3.4906939E-2|0.12231202|8.9996025E-2|6.5272622E-2|4.9494252E-2|3.5092041E-2|6|1|9843|34628174336|268468224|268468224|268468736|268468736|402685952|151.1835|1549.6663|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103926|758883003882406212|256.02781010472597|63.400261743107798|-0.10811085162093501|-0.43450729171347302|0.89415628231848798|20.896757|18.789133|17.765404|17.357803|17.084009|8.1950031E-2|2.0516813E-2|6.793736E-3|2.5149031E-2|3.5489429E-2|0.12750934|9.3820162E-2|6.8046212E-2|5.1597379E-2|3.6583185E-2|6|1|9843|17626814349312|402685952|158329959776256|268468224|268468224|268468224|259.05573|545.05267|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103931|758883003882471479|256.23381412028198|63.431342976160501|-0.106432468697552|-0.43442200577533502|0.89439904433372397|18.484852|17.563141|17.179407|17.055805|16.973015|1.9323925E-2|1.9077552E-2|6.1110789E-3|2.5056625E-2|3.5164434E-2|0.1225417|9.0165019E-2|6.5395191E-2|4.9587194E-2|3.5157938E-2|6|1|9843|268570640|276856848|268468240|268468240|268468240|268603408|298.47913|1428.6678|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103943|758883003882406286|256.12458416871698|63.395340505329699|-0.107395220921242|-0.43476383189415901|0.894117820535965|20.727055|18.205139|17.043406|16.609806|16.32403|7.1877286E-2|1.9611878E-2|5.9885145E-3|2.4918595E-2|3.4587409E-2|0.12537098|9.2246771E-2|6.6905051E-2|5.0732076E-2|3.5969675E-2|6|1|9843|17626814349568|293634304|158329942999040|268468224|268468224|268468224|443.4631|895.84937|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103952|5740762103952|256.038101885934|63.341722087402303|-0.10825316749288801|-0.43541305528935798|0.89369834005180004|19.493782|18.692133|18.585396|18.33279|18.17783|2.9978359E-2|1.9939393E-2|8.6631747E-3|2.6115978E-2|4.0882774E-2|0.12642804|9.3024552E-2|6.7469165E-2|5.1159825E-2|3.6272954E-2|3|1|26227|34628304896|276987904|268468224|268599296|268468224|268468224|770.41962|389.96774|0|4|0|4|0|5740762103808|51638.389380200002|3|0|87899|0|0.0|0|0.0|-19.956875984315325|1|0
5740762103956|758883003882471484|256.27325631750301|63.351498730102797|-0.106429042661861|-0.43570553488844399|0.89377488538538297|18.84984|17.69014|17.282406|17.196804|17.08301|2.2226769E-2|1.9130323E-2|6.2017855E-3|2.5102792E-2|3.5522133E-2|0.1241121|0.0913205|6.6233248E-2|5.0222665E-2|3.5608497E-2|6|1|9843|268435456|268468224|268468224|268468224|268468224|268468224|1033.5782|1316.4989|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103958|758883003882471712|256.352693720518|63.363885132857597|-0.105779267607579|-0.43566489969022498|0.89387182622695405|21.817799|19.27212|18.075403|17.676802|17.376989|0.17265342|2.1902377E-2|7.9451669E-3|2.5616445E-2|3.6381543E-2|0.12172934|8.9567289E-2|6.4961672E-2|4.9258467E-2|3.4924868E-2|6|1|9843|268566544|268468240|268599312|268468240|268468240|268468240|1044.6367|1659.3397|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103967|758883003882471531|256.38447547760802|63.350355838646003|-0.10558727386785199|-0.43592863482446798|0.89376593856402398|19.553772|18.510136|18.142403|18.069796|17.936905|3.1419497E-2|1.9720383E-2|7.5317863E-3|2.5781792E-2|3.9048575E-2|0.12182797|8.9639865E-2|0.06501431|4.9298383E-2|0.03495317|6|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|1205.7621|1736.178|0|0|0|0|0|5740762103808|51638.389380200002|3|0|87899|0|0.0|0|0.0|0.0|0|0
5740762103985|758883003882406174|255.970083252894|63.401369106952501|-0.108544383493851|-0.43438138090906497|0.89416493597740299|23.32424|20.450939|19.175373|18.704773|18.387732|0.90742034|2.9072996E-2|1.1620753E-2|2.6995361E-2|4.3157499E-2|0.12853126|9.4572082E-2|6.8591565E-2|5.2010905E-2|0.03687638|6|1|9843|268566784|1099646010625|268468224|268468224|268468224|268468224|164.49466|329.68112|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103988|758883003882471730|256.36059542710302|63.426549981716803|-0.10548858398067799|-0.43472915877210599|0.89436162549778997|22.484028|20.000053|18.515396|17.751801|17.291996|0.30163738|2.4570236E-2|8.6314259E-3|2.5451772E-2|0.03594904|0.11793371|8.6774506E-2|6.2936112E-2|4.7722545E-2|0.03383588|6|1|9843|268435712|142639361|268468224|268468224|268468224|268468224|524.28656|1893.9575|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103990|758883003882471622|256.133429873181|63.385967480953902|-0.10736315149801801|-0.43492240735139198|0.89404454770670305|21.732681|19.313116|17.927404|16.772804|16.097033|0.16424179|2.1226948E-2|7.0681307E-3|2.4987528E-2|3.4428664E-2|0.12545319|9.2307262E-2|6.6948928E-2|5.0765343E-2|3.5993263E-2|6|1|9843|34628305152|411074816|276987904|268468224|268468224|268599296|535.92798|898.45972|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103991|758883003882406237|256.07512047888002|63.374685075632897|-0.107848076880878|-0.43498378833131601|0.89395631671913001|22.782497|19.993055|18.565395|17.7108|17.212002|0.40121228|2.4547696E-2|8.7032029E-3|2.5358204E-2|3.5751339E-2|0.1268014|9.3299262E-2|6.7668408E-2|5.1310904E-2|3.6380071E-2|6|1|9843|34628174080|142639361|268468224|268468224|268468224|268468224|545.66492|639.98401|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103994|758883003882406364|256.10001777401902|63.361833582654903|-0.107707215546393|-0.43522524399734802|0.89385577287764495|23.66|21.378029|19.854288|18.443787|17.665956|0.79753089|5.0107006E-2|1.7617067E-2|0.02633312|0.03732942|0.12667248|9.3204409E-2|6.7599609E-2|5.1258739E-2|3.6343083E-2|6|1|9843|70403372486928|70369155354897|268435472|268435472|268435472|268468240|691.24042|692.08411|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103996|758883003882406250|256.090760720552|63.360434219274403|-0.10778277959299599|-0.43522902730458501|0.89384482222291395|22.416487|19.984056|18.633394|17.704802|17.131006|0.29473162|2.4480054E-2|8.9387177E-3|2.5381574E-2|3.5620231E-2|0.12680462|9.3301639E-2|6.7670129E-2|5.1312212E-2|3.6380995E-2|6|1|9843|34628174592|134251777|268468224|268468224|268468224|402686464|689.57635|652.18176|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762103997|758883003882471697|256.32108460940202|63.400133822862998|-0.105885845659359|-0.43505691375565098|0.89415528264525201|22.835684|20.13003|18.643394|17.504803|16.850019|0.41116786|2.5094621E-2|9.0463888E-3|2.5265059E-2|3.5132397E-2|0.12063307|8.8760659E-2|6.4376637E-2|4.8814856E-2|3.4610339E-2|6|1|9843|34628305152|134251777|268599296|268468224|268468224|268468224|690.76984|1657.7432|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104014|758883003882406195|256.033809681599|63.334753582203803|-0.108312017892345|-0.43551042266597201|0.89364376489146702|21.919544|19.330116|17.951403|17.019804|16.41803|0.19132826|2.1285633E-2|7.1203928E-3|0.02505663|3.4651086E-2|0.12628071|9.2916138E-2|6.7390539E-2|5.1100202E-2|0.03623068|6|1|9843|34628174592|151028993|293634048|293634560|285245952|419463680|822.89868|351.02881|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104019|758883003882406203|256.05316636925102|63.330752381323997|-0.108179920894089|-0.43560755572593801|0.89361242275934305|22.854258|19.918066|18.481398|17.285803|16.532026|0.42513081|0.02401174|8.4349709E-3|0.0251259|3.4746822E-2|0.12608437|9.2771679E-2|6.7285761E-2|5.1020756E-2|3.6174353E-2|6|1|9843|268435456|134250497|268468224|276856832|268468224|402685952|885.5116|411.20703|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104020|758883003882406216|256.06181479763302|63.327755231953702|-0.108125427056131|-0.435669247854578|0.89358894268995703|22.029888|19.374113|18.105402|17.615801|17.205002|0.21050464|2.1423163E-2|7.435312E-3|2.5311591E-2|3.5784315E-2|0.12595597|9.2677206E-2|6.7217238E-2|5.0968796E-2|0.03613751|6|1|9843|268435456|134250497|268468224|268468224|268468224|268468224|923.63098|434.19897|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104035|758883003882471653|256.23509917766597|63.328687820491098|-0.106803843142046|-0.43598014049620598|0.89359624897545198|21.79406|19.825077|18.538397|17.998796|17.506977|0.17257856|2.3422744E-2|8.6155022E-3|2.5663417E-2|3.6751039E-2|0.12462756|9.1699772E-2|6.6508323E-2|5.0431248E-2|3.5756383E-2|6|1|9843|268435456|8421377|268468224|268468224|268468256|268468224|1171.4999|1096.4999|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104038|758883003882471657|256.24201425075398|63.320742424707902|-0.106780692874743|-0.43611338598617599|0.89353399386529297|22.468616|19.947062|18.535397|17.149805|16.30303|0.30842939|2.4189046E-2|8.6075738E-3|2.5079694E-2|3.4619298E-2|0.12483184|0.09185008|0.06661734|5.0513912E-2|3.5814993E-2|6|1|9843|34628174080|142640385|268468224|268468224|268468224|268468224|1248.473|1096.8911|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104039|758883003882471684|256.31526872852601|63.331495253269502|-0.10618334670021699|-0.43608661318494601|0.89361824213946395|21.731691|19.43611|18.165401|17.381804|16.899017|0.16288823|2.1621162E-2|7.5665349E-3|2.5195392E-2|3.5229485E-2|0.12421153|9.1393664E-2|6.6286311E-2|5.0262902E-2|3.5637025E-2|6|1|9843|268435712|402687232|268468224|268435456|268468224|402685952|1264.7505|1411.0151|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104050|758883003882471654|256.21788047136903|63.370160196272401|-0.10678074231858101|-0.43531972086249698|0.89392092138963297|22.532078|20.607872|19.23037|18.58378|18.158836|0.32326719|3.1204995E-2|1.1957174E-2|2.6674483E-2|4.0845729E-2|0.12458611|9.1669276E-2|0.06648621|5.0414477E-2|3.5744492E-2|6|1|9843|34628173824|142639105|276856832|268435456|268468224|268435456|794.21588|1167.2898|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104052|758883003882471813|256.36871696007199|63.369622369547798|-0.105636331360231|-0.43560747703312802|0.89391671393345395|23.980692|21.004581|19.643326|18.145794|17.238001|0.91888702|3.8901258E-2|1.5444561E-2|2.5900699E-2|3.5685416E-2|0.12088007|8.8942409E-2|6.4508453E-2|4.8914809E-2|3.4681208E-2|6|1|9843|34628305152|134219009|268435456|268435456|268468224|402817024|1019.4323|1739.1671|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104054|758883003882471825|256.42238788664002|63.339360725880802|-0.105339061582729|-0.43616511922790502|0.89367984808530698|25.195005|21.068512|19.698317|18.259792|17.355991|0.95293039|4.0541861E-2|1.5964881E-2|2.6092071E-2|3.6247894E-2|0.12147096|0.08937718|6.4823784E-2|4.9153913E-2|3.4850735E-2|6|1|9843|70369012613464|70369155219737|268468248|268435480|268468248|268468248|1354.5043|1844.5529|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104102|758883003882471731|256.39798977330202|63.346706288506802|-0.105497837246564|-0.43600885975676401|0.89373736665191805|21.812855|20.275995|19.581335|19.416685|19.149796|0.17140304|2.6986457E-2|1.4804201E-2|3.1333055E-2|6.2098902E-2|0.12176798|0.08959572|6.4982288E-2|4.9274102E-2|3.4935951E-2|6|1|9843|268436224|268469504|268468224|268435456|268435456|268468736|1256.6074|1775.6365|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104130|758883003882471492|256.26990736128897|63.459622231199901|-0.106053996041009|-0.434060082780102|0.89461969264076902|22.942726|22.039373|20.539984|19.209724|18.47368|0.4603954|7.7218562E-2|3.0512242E-2|2.9733039E-2|4.4731375E-2|0.12171632|8.9557707E-2|0.06495472|4.9253199E-2|3.4921132E-2|6|1|26227|70369012744464|70369146864913|276988176|276856848|268468240|268468240|111.29096|1658.2626|0|33554432|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104136|758883003882406357|256.05121925160898|63.418570907292299|-0.107864434860054|-0.43427409725584798|0.89429931910123905|22.458012|21.0795|19.61433|18.820766|18.293781|0.3052575|4.0953726E-2|1.5051475E-2|2.7345199E-2|4.2101528E-2|0.12767829|9.3944468E-2|6.8136364E-2|5.1665742E-2|3.6631655E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|138.58842|694.23749|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104157|758883003882471796|256.22051648608698|63.432126717666002|-0.10653037568573499|-0.43438541013099402|0.894405162396542|23.016396|21.101473|19.810297|18.944756|18.392729|0.48610213|4.1406639E-2|1.7216476E-2|2.7929977E-2|0.04343643|0.12311707|9.0588376E-2|6.5702245E-2|4.9820025E-2|3.5323016E-2|6|1|9843|70369012613392|70369155252497|268468240|268468240|268468240|268468240|272.35272|1380.7189|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104160|758883003882406379|256.11918749918101|63.4136542177555|-0.107367603113888|-0.43447624725843798|0.89426091738921698|23.998831|21.944975|20.542982|19.52066|18.892263|0.49206117|7.7380821E-2|2.9326644E-2|0.0317964|5.3145457E-2|0.12583853|9.2590794E-2|6.7154571E-2|5.0921276E-2|3.6103819E-2|6|1|9843|268566784|134350081|268435456|268435456|268435456|402685952|280.3952|935.72211|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104203|758883003882471676|256.26705486965199|63.414731664262497|-0.106241970248629|-0.43473555551147097|0.89426933332851199|25.195957|20.745794|19.448351|18.740772|18.317768|0.86787099|3.3492818E-2|1.3664829E-2|2.7194865E-2|4.2490128E-2|0.12156243|8.9444481E-2|0.0648726|4.9190927E-2|0.03487698|6|1|9843|87961198788880|87961341436177|268468240|268468240|268468240|268468240|488.04929|1500.2803|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104205|758883003882471820|256.35924947885502|63.429995096910801|-0.10548611374035299|-0.43467441994669898|0.89438852209314401|25.087563|21.173378|19.970259|19.394691|18.934202|0.98573601|4.3429993E-2|1.9512365E-2|3.1218164E-2|5.3977735E-2|0.11780543|8.6680114E-2|6.2867649E-2|4.7670636E-2|3.3799075E-2|6|1|9843|268435712|134219009|268435456|268435456|268468224|268435456|493.04849|1900.0095|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104220|758883003882406355|256.060420651887|63.372874617566801|-0.10796647769741601|-0.43498352000818802|0.89394215529580001|23.412313|21.896248|20.555971|19.197725|18.386732|0.66182137|7.4688464E-2|2.9597392E-2|2.9244253E-2|0.04331686|0.12686889|0.09334892|6.7704424E-2|5.1338214E-2|3.6399435E-2|6|1|9843|268435712|142606593|268435456|268435456|268468224|268435456|539.24689|578.11719|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104222|758883003882471794|256.21786764302101|63.3964694311465|-0.106683041282288|-0.434920996075425|0.894126644204009|23.044331|20.916666|19.92927|19.533657|19.231592|0.49521565|3.6883887E-2|1.8600155E-2|3.2060839E-2|6.4583108E-2|0.12322278|9.0666153E-2|0.06575866|4.9862798E-2|3.5353348E-2|6|1|9843|268435968|134217729|268435456|268435456|268468224|268468736|570.93927|1253.5648|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104322|758883003882406421|256.15113398427098|63.337339463323097|-0.107410344702878|-0.43569213940368801|0.89366401824883102|24.999752|22.205025|20.771759|19.7096|19.028044|1.0548786|9.5470555E-2|3.5146069E-2|3.4128927E-2|5.7608537E-2|0.1252196|9.2135392E-2|6.6824272E-2|5.0670821E-2|3.5926245E-2|6|1|9843|268567296|134382849|268468224|268468224|268468224|402686464|974.31952|805.49286|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104332|758883003882471784|256.18681279442001|63.340204580125203|-0.107128343081786|-0.435715544267813|0.89368645653380896|23.410694|21.516705|20.023245|18.642776|17.772938|0.36003736|5.5262566E-2|1.9819431E-2|0.02687156|3.7987061E-2|0.12475795|9.1795713E-2|6.6577911E-2|5.0484013E-2|3.5793796E-2|6|1|9843|34628305152|142754049|276856832|268435456|268468224|402685952|1002.4177|950.69824|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104333|758883003882406420|256.14670092081099|63.332728920664401|-0.10746127267823501|-0.43575364677747203|0.89362790589512597|25.74349|22.482597|21.187016|19.661617|18.690504|0.70314145|0.12065254|4.9530305E-2|3.3538103E-2|5.2877411E-2|0.12518388|9.2109114E-2|6.6805214E-2|5.0656367E-2|3.5915997E-2|6|1|9843|17592454611200|142606593|276824320|268435456|268468224|158329942999040|1007.0064|773.57202|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104334|758883003882406359|256.10976078175702|63.325908650511401|-0.10776772816222401|-0.43578753332911402|0.89357447510639998|23.588356|21.433908|20.006248|19.189728|18.677517|0.74955195|5.2071288E-2|1.9601809E-2|2.9271286E-2|4.8447985E-2|0.1256002|9.2415437E-2|6.7027383E-2|5.0824836E-2|3.6035441E-2|6|1|9843|268435712|134219009|268435456|268435456|268435456|402685952|1010.065|610.49542|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104336|758883003882471883|256.39611755752998|63.3748456676431|-0.105408830250403|-0.43557873741466002|0.89395757282853905|23.642733|22.126715|20.730806|19.891518|19.278463|0.74949688|8.9540735E-2|0.03450796|0.03772695|6.6560023E-2|0.11972695|8.8093951E-2|0.06389308|0.04844819|3.4350369E-2|6|1|9843|268436224|142606593|268435456|268435456|268468224|268435968|1014.9548|1860.2455|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104341|758883003882471778|256.15751681917601|63.332669542835902|-0.107379233797119|-0.43577482400841699|0.89362744077695899|22.67322|21.57155|20.29114|19.122736|18.438702|1.0287158|5.7584576E-2|2.4132216E-2|2.8870275E-2|4.3274298E-2|0.12503345|9.1998421E-2|6.6724934E-2|5.0595496E-2|3.5872836E-2|6|1|26227|87961198792976|89060844668177|268468240|268468240|268468240|268603408|1023.2735|814.4118|0|33554432|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104354|758883003882471804|256.31224536357001|63.358032669225899|-0.106108406745302|-0.43567882450070999|0.89382602775912301|23.137774|21.793747|20.53199|19.721596|19.20566|0.53070498|6.8305068E-2|2.9192444E-2|3.4603428E-2|6.3999161E-2|0.12319911|9.0648741E-2|6.5746024E-2|4.9853221E-2|3.5346556E-2|6|1|9843|268435712|134217729|268469504|268435456|268468224|268435456|1035.2047|1486.2618|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104388|758883003882471793|256.24506438057699|63.332368926130002|-0.106714362551179|-0.43594294414024098|0.893625085972655|22.66279|21.350084|19.853289|18.987751|18.380735|0.36261436|4.8971549E-2|1.7617078E-2|2.8188139E-2|4.3677751E-2|0.12453324|9.1630377E-2|6.6457994E-2|5.0393086E-2|3.5729326E-2|6|1|9843|268435712|134251777|268468224|268468224|268468224|268468224|1154.4742|1146.4541|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104402|758883003882471800|256.28532850536698|63.334205498422399|-0.10640118972364999|-0.43599000111340502|0.89363947190940796|22.108482|21.128439|19.939268|19.532658|19.154783|0.22518833|4.2134803E-2|1.8703109E-2|0.03223855|6.2441718E-2|0.12448534|9.1595128E-2|6.6432431E-2|0.0503737|0.03571558|6|1|9843|268436224|134251777|268468224|268468224|268468224|402686464|1198.0107|1305.772|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104445|758882832083517906|256.112506701923|63.281536940889602|-0.107912904747442|-0.43646435162971398|0.89322655286630503|22.692152|21.17238|19.779303|19.39369|19.089924|0.37511957|0.04347017|1.6886937E-2|3.0903459E-2|5.9977662E-2|0.12599541|9.2706226E-2|6.7238286E-2|5.0984759E-2|3.6148828E-2|3|1|9847|268435712|134251777|268468224|268468224|268468224|402685952|1390.3291|474.61032|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762104499|758883003882471881|256.32908964847201|63.4513864062856|-0.105635979293026|-0.43429434409659201|0.89455545527625802|24.128748|23.127838|21.767347|19.849539|18.643549|0.99211961|0.209883|8.3702691E-2|3.6801878E-2|4.7304384E-2|0.11811454|8.6907551E-2|6.3032605E-2|4.7795717E-2|3.3887759E-2|6|1|9843|268435712|134242305|8388865|268435456|268468224|268468224|267.57114|1855.479|0|0|0|0|0|5740762103808|51638.389380200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762169496|5740762169496|256.44544599296|63.183085168902799|-0.105734418068151|-0.43857549131218299|0.89245267171770304|18.739799|18.503481|18.297586|17.86994|17.781023|2.3082713E-2|1.2181711E-2|1.2638874E-2|2.1444485E-2|3.0649891E-2|0.12347535|9.0851992E-2|6.5893441E-2|4.9965002E-2|3.5425808E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|1354.4078|1423.2747|0|4|0|4|0|5740762169344|51638.3897947|3|0|87899|0|0.0|0|0.0|-21.250616452273498|1|0
5740762169616|5740762169616|256.34255669499601|63.167857229681402|-0.10657782382066|-0.43861538274124101|0.89233273698346804|20.352413|19.458454|19.236555|18.854904|18.692589|0.05558132|1.5151483E-2|1.5447352E-2|2.3904223E-2|4.3899119E-2|0.12368894|9.1009147E-2|0.06600742|5.0051432E-2|3.5487089E-2|3|1|26227|268435456|276856832|268468224|268468224|268468224|268468224|1332.8062|979.53595|0|4|0|4|0|5740762169344|51638.3897947|3|0|87899|0|0.0|0|0.0|-20.035950606116863|1|0
5740762300582|587725492134150455|256.48271578948601|62.860501110691303|-0.10662188747368501|-0.44352265919241801|0.88989854696725701|22.717516|20.976643|19.596891|18.41321|17.7542|0.41212061|4.6518337E-2|5.1198564E-2|2.8767653E-2|2.4503332E-2|0.12426811|9.1435298E-2|6.6316508E-2|5.0285798E-2|0.03565326|6|1|9847|70369012748560|70369155252497|268603408|268468240|268468240|268603408|1427.3591|517.39984|0|0|0|0|0|5740762300416|51638.390623899999|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762431601|5740762431601|256.878022072215|62.765659333229102|-0.103893612566605|-0.44568170188189299|0.88914224839196498|19.449535|17.782854|17.033335|17.004507|16.903446|2.9485999E-2|5.1015923E-3|1.0629733E-2|1.9503944E-2|2.2228112E-2|0.12755232|9.3851782E-2|6.8069138E-2|5.1614769E-2|3.6595516E-2|6|1|26231|268567040|285311488|285310976|285311488|285311488|285458944|92.545151|1746.3593|0|1|1|0|0|5740762431488|51638.391453099997|3|0|87998|0|0.0|0|0.0|3.4905268553104776|1|0
5740762431869|587725492134281571|256.786971312334|62.731089367340999|-0.104724333426847|-0.44603822760088901|0.88886597049665494|23.585924|21.436617|19.956192|19.842245|18.257227|0.77087659|4.8414037E-2|2.1376232E-2|3.5210297E-2|3.1528048E-2|0.12537023|0.09224622|6.6904657E-2|5.0731774E-2|3.5969459E-2|6|1|9843|87961198793048|70369146864921|268468248|268468248|228698687180825|402685976|254.82372|1281.1317|0|0|0|0|0|5740762431488|51638.391453099997|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762497125|587725492134346882|256.83765831824701|62.475912446865301|-0.10523010912672601|-0.44998098252766799|0.88681663239736996|21.360943|18.965183|18.619509|19.82839|20.923483|0.43694812|0.21903512|0.21622923|0.62333149|1.1325358|0.12524408|0.0921534|6.6837333E-2|5.0680727E-2|3.5933267E-2|6|1|9843|70369013268496|70369046724625|70369046724625|302546992|70369046724625|70369046724625|1138.9414|660.97656|0|0|0|0|0|5740762497024|51638.391867799997|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762562580|587725492134412321|257.07202683454898|62.474136078488101|-0.103394736825249|-0.45043445800191001|0.886802304598586|22.746496|20.935043|19.646622|18.922737|18.646147|9.7661495|2.0143297|2.0401361|2.4665256|0.52982366|0.1246018|9.1680817E-2|6.6494577E-2|5.0420824E-2|3.5748992E-2|6|1|9843|70369013531408|70369146863633|276857104|269385744|276857104|268468752|137.36519|1576.9952|0|0|0|0|0|5740762562560|51638.392282399996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762628161|587725492134477922|257.22458940942897|62.2683495498393|-0.102898648458447|-0.45381149510778301|0.88513670981010795|25.165461|22.105616|20.794212|19.455795|18.758118|0.98520237|8.4050633E-2|4.1984599E-2|2.3854693E-2|3.9589975E-2|0.12045923|8.8632755E-2|0.06428387|4.8744511E-2|3.4560468E-2|6|1|9843|70369012744536|70369146864921|268484632|268468248|276856856|402685976|754.53137|1528.9358|0|0|0|0|0|5740762628096|51638.392697099996|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762628294|5740762628294|257.25437331811003|62.207509918769297|-0.10287003309220299|-0.45478139181647098|0.88464209822339002|19.292374|19.223854|18.913866|18.87388|18.889952|4.5212999E-2|1.9538473E-2|1.8471073E-2|1.7916793E-2|4.2997971E-2|0.11831978|8.7058567E-2|6.3142136E-2|4.7878768E-2|3.3946645E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|1317.0052|1454.9482|0|1048580|0|4|0|5740762628096|51638.392697099996|3|0|88002|0|0.0|0|0.0|-26.357887518048031|1|0
5740762628327|5740762628327|257.20384186586398|62.234322755389599|-0.103179380382477|-0.45428673370585199|0.88486020310711|21.922075|19.475842|18.36088|19.914625|17.743629|0.16847007|2.0345712E-2|1.7398508E-2|0.05212678|2.0990308E-2|0.11961811|8.8013873E-2|6.3835002E-2|4.8404146E-2|3.4319144E-2|6|1|26227|17592454615040|134381569|268468224|268468224|158329943003136|268468224|1014.4799|1337.8555|0|5|1|4|0|5740762628096|51638.392697099996|3|0|88002|0|0.0|0|0.0|6.4038550260868448|1|0
5740762759333|5740762759333|257.32166248272802|61.889572520761902|-0.103411676324851|-0.45968409797457999|0.88204113014585706|19.21225|19.15453|18.821236|18.693169|18.142696|0.06824626|9.639373E-3|1.4351217E-2|1.5677331E-2|3.6269981E-2|0.12633024|9.2952587E-2|6.7416973E-2|5.1120248E-2|3.6244892E-2|3|1|26231|268435472|268468240|268468240|268468240|268468240|402685968|1407.4885|724.51453|0|5124|0|4|0|5740762759168|51638.393526300002|3|0|88002|0|0.0|20119|2.7000000700354576E-2|-22.651137567574516|1|0
5740762759359|5740762759359|257.47636366036102|61.971548143613198|-0.101896378963047|-0.45872921896998697|0.88271435448700197|19.569202|19.409519|19.204216|18.990147|19.000946|7.0345648E-2|1.0915029E-2|1.5561761E-2|1.7204499E-2|5.2640431E-2|0.11755366|8.6494863E-2|6.2733293E-2|4.7568753E-2|3.3726841E-2|6|1|26227|268435456|285245440|268468224|268468224|268468224|268468224|934.5943|1602.1212|0|4|0|4|0|5740762759168|51638.393526300002|3|0|88002|0|0.0|0|0.0|-27.516263086033298|1|0
5740762824873|5740762824873|257.34429432677501|61.814237321585999|-0.103484095422675|-0.46085608437213899|0.88142084811498|19.402159|19.140867|19.030409|18.895292|19.083876|4.0072348E-2|1.2719671E-2|1.1514755E-2|0.0151791|0.04839227|0.13220122|9.7272396E-2|7.0550062E-2|5.3495973E-2|3.7929311E-2|3|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|722.87549|578.88342|0|4|0|4|0|5740762824704|51638.393941100003|3|0|88002|0|0.0|0|0.0|-21.234776810718415|1|0
5740762890516|5740762890516|257.62882674628599|61.683033038607199|-0.101626370459051|-0.463334632841642|0.88033692347692705|20.398712|19.506184|19.328571|18.984421|18.867321|9.3184374E-2|0.01499851|1.2566586E-2|2.6672585E-2|4.6119358E-2|0.13884984|0.10216439|0.07409814|5.6186374E-2|3.9836839E-2|3|1|26227|268435456|276856832|268468224|268468224|268468224|268468224|901.44934|1319.1179|0|4|0|4|0|5740762890240|51638.394355700002|3|0|88002|0|0.0|0|0.0|-19.279805567280597|1|0
5740762890823|587725492134740357|257.58136373412202|61.646459339765997|-0.10213098293341601|-0.46379899215454801|0.88003395230041004|22.527559|21.670311|20.267361|19.575315|19.184734|0.37821874|5.8943041E-2|2.4088584E-2|3.1853903E-2|0.05447533|0.14040883|0.10331148|7.4930102E-2|0.05681723|4.0284123E-2|6|1|9843|87961198788624|228698829750289|268435472|268435472|268468240|17592454610960|1144.4478|1012.7647|0|0|0|0|0|5740762890240|51638.394355700002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740762955996|5740762955996|257.81308690489101|61.564269847039398|-0.10052078450940399|-0.46544171121603201|0.87935179839578803|19.41301|18.432549|18.37779|18.338596|18.30588|3.2811932E-2|9.7387834E-3|9.1389185E-3|0.01634174|2.7788475E-2|0.13419464|0.09873914|7.1613863E-2|5.4302622E-2|3.8501237E-2|6|1|26227|268435456|268468224|268468224|268468224|268468256|268468224|826.49988|1700.4999|0|1048580|0|4|0|5740762955776|51638.394770400002|3|0|88002|0|0.0|0|0.0|-6.3180216426685831|1|0
5740762956050|587725492134805756|257.79269810625902|61.624376578440597|-0.10049129040338101|-0.46450402074255698|0.87985084830729199|24.205578|20.117443|18.853779|17.600609|17.119114|1.0040236|8.4339753E-2|7.6578774E-2|7.7005327E-2|9.6582912E-2|0.13360022|9.8301776E-2|7.1296647E-2|5.4062087E-2|3.8330693E-2|6|1|9843|70369012613392|70369155252497|70369012645905|268468240|70369012645905|268468240|281.9252|1802.9373|0|0|0|0|0|5740762955776|51638.394770400002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740763021433|5740763021433|257.82794192370199|61.459057626146098|-0.100740404764966|-0.46704542370964702|0.87847592058044899|18.81798|18.56488|18.468969|18.456728|18.336948|3.3673946E-2|8.2811685E-3|1.0967252E-2|1.2002683E-2|4.1522026E-2|0.13051848|9.6034266E-2|6.9652058E-2|5.2815046E-2|3.7446525E-2|6|1|26227|17626814349312|268468224|268468224|268468224|268468224|158330077216768|387.3042|1437.1318|0|1048580|0|4|0|5740763021312|51638.395185100002|3|0|88002|0|0.0|0|0.0|-26.244486831369791|1|0
5740763152566|587725492135002225|258.17482447800501|61.154431399740801|-9.8866713184668095E-2|-0.472211633538412|0.87592325358734802|19.405767|19.310524|19.095308|19.070957|18.842688|3.0537112E-2|1.6386142E-2|1.6476842E-2|2.0288102E-2|3.9764453E-2|0.12055847|8.8705778E-2|6.4336829E-2|4.8784669E-2|3.4588937E-2|6|1|26227|268566528|268599296|268468224|268435456|268435456|268435456|782.21393|1932.9867|0|33554432|0|0|0|5740763152384|51638.396014400001|3|0|0|0|0.0|0|0.0|0.0|0|0
5740763152703|5740763152703|257.80492352467797|61.1630460832138|-0.101885403637647|-0.47143478219965002|0.87599578232886599|20.183542|19.577507|18.959314|18.744986|18.288139|4.9274508E-2|1.7412119E-2|1.6281134E-2|1.8183375E-2|2.5933787E-2|0.12973326|9.5456511E-2|6.9233023E-2|5.2497305E-2|3.7221242E-2|3|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|165.15553|431.24997|0|4|0|4|0|5740763152384|51638.396014400001|3|0|88002|0|0.0|0|0.0|-22.441638782271141|1|0
5740763283511|587725492135133290|258.38777595885199|60.834673578912202|-9.8093411951069007E-2|-0.47735676761464002|0.87321715451787896|16.030664|15.051207|15.058696|15.170291|15.209557|3.1111728E-2|7.6019368E-3|1.5809724E-2|1.3744351E-2|0.01452523|0.10816584|7.9587393E-2|5.7723418E-2|4.3769918E-2|3.1033417E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1114.4991|1853.5642|0|1056768|0|0|0|5740763283456|51638.396843800001|3|0|87999|0|0.0|0|0.0|0.0|0|0
5740763283664|5740763283664|258.05157942642802|60.891373080391602|-0.100713759857955|-0.47592732590514902|0.87369898651197297|19.50058|19.341181|19.183661|18.68326|18.564135|0.03996034|1.2860431E-2|1.8900471E-2|1.7301265E-2|3.3153582E-2|0.12962952|9.5380172E-2|6.9177657E-2|5.2455321E-2|3.7191477E-2|6|1|26227|268566544|268599312|268468240|268468240|268468240|402685968|134.3661|621.70941|0|4|0|4|0|5740763283456|51638.396843800001|3|0|88000|0|0.0|0|0.0|-27.561151387587181|1|0
5740763283707|5740763283707|258.19875436234298|60.767575596754803|-9.9876771375454101E-2|-0.47803122101077|0.87264585157930397|20.728851|19.941128|19.043669|18.461269|18.007406|0.07554391|1.8449772E-2|1.8710442E-2|1.6507907E-2|2.4074929E-2|0.13206685|9.7173527E-2|7.0478342E-2|5.3441595E-2|3.7890758E-2|6|1|26231|268435472|268468240|276856848|268468240|268468240|268468240|1413.1041|860.08441|0|4|0|4|0|5740763283456|51638.396843800001|3|0|88000|0|0.0|0|0.0|-8.7521705742460725|1|0
5740763545890|99864587976835072|258.67134770678803|60.228605954343401|-9.7538708888943199E-2|-0.48686632545931302|0.86801346844506|19.981079|19.782454|19.733309|19.688629|19.818621|4.3441456E-2|1.4111977E-2|1.9805601E-2|2.5439128E-2|9.3035355E-2|0.10812736|0.07955908|5.7702884E-2|0.04375435|3.1022379E-2|6|1|26227|268435456|268468224|276856832|268468224|268468224|402685952|1292.4109|1240.5891|0|34603008|0|0|0|5740763545600|51638.3985025|3|0|88061|0|0.0|0|0.0|-26.11597049584261|0|0
5740763676833|587725492135526671|258.87418176620298|60.076651162419999|-9.6258414165583894E-2|-0.489465659719859|0.86669353618065603|19.502991|18.469152|18.526747|18.50107|18.537645|3.5190154E-2|0.02719681|1.0967178E-2|1.1903481E-2|3.4654032E-2|0.10678598|7.8572109E-2|5.6987047E-2|4.3211553E-2|3.0637529E-2|6|1|9843|34628304896|268468224|268599296|268468224|268468224|268468224|175.33565|1659.386|0|0|0|0|0|5740763676672|51638.399331799999|3|0|0|0|0.0|0|0.0|0.0|0|0
5740763676913|587725492135526611|258.75157688023597|59.936591840255502|-9.7718556167845597E-2|-0.49133502762155601|0.86547153298799895|19.526987|19.210138|19.21372|19.116022|18.869307|3.5450064E-2|2.8138444E-2|1.3869096E-2|1.6936325E-2|4.3558694E-2|9.8666303E-2|7.2597727E-2|5.2653927E-2|3.9925881E-2|2.8307946E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|1199.6273|718.58368|0|34603008|0|0|0|5740763676672|51638.399331799999|3|0|88065|0|0.0|0|0.0|0.0|0|0
5740763742474|5740763742474|258.73176546203001|59.774051483731597|-9.8367803950813501E-2|-0.49370712583461202|0.86404690211007695|21.176111|19.630436|18.91291|18.407206|18.039967|0.10245889|0.01714127|1.6492574E-2|0.01465856|3.6608182E-2|0.11569376|8.5126363E-2|6.1740741E-2|4.6816133E-2|3.3193223E-2|6|1|26227|34628173824|268468224|268468224|276856832|268468224|402685952|1206.8297|151.52698|0|1|1|0|0|5740763742208|51638.399746499999|3|0|88065|0|0.0|0|0.0|4.8980242613163369|1|0
5740763807753|5740763807753|259.10886425126603|59.808998626759703|-9.5016711892141795E-2|-0.493826228799845|0.86435379342635399|18.09885|17.156799|17.122105|17.225353|17.219173|1.8084614E-2|7.8220693E-3|1.6029609E-2|1.1730578E-2|2.3533504E-2|0.10059392|0.07401605|5.3682614E-2|4.0705901E-2|2.8860992E-2|6|1|26227|17592454610960|268468240|268468240|268468240|268468240|158330077216784|100.59503|1887.2581|0|4|0|4|0|5740763807744|51638.400161199999|3|0|88065|0|0.0|0|0.0|3.7222811582889932|1|0
5740763873392|99582731960188928|258.96039534632899|59.596877860537397|-0.0969081307535824|-0.49671576681771001|0.86248609333051895|19.325682|18.353115|17.833277|17.351484|17.094259|3.7055485E-2|1.0076469E-2|9.4040297E-3|2.3427242E-2|0.01416711|0.11346368|8.3485492E-2|6.0550645E-2|4.5913719E-2|3.2553401E-2|3|1|26227|268566544|268599312|268468240|268468240|268468240|268468240|348.2641|622.40356|0|96|0|0|0|5740763873280|51638.400575799998|3|0|88065|0|0.0|0|0.0|-20.376230832368677|0|0
5740764004477|5740764004477|259.17131202620698|59.315906166025101|-9.5872441369800096E-2|-0.50121735974001902|0.85999397281669299|18.697487|17.952753|17.764622|17.424746|17.320406|3.1629995E-2|1.2685832E-2|0.01328369|2.9820926E-2|2.8528731E-2|0.14897925|0.10961752|7.9503767E-2|6.0285296E-2|4.2743027E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|358.43149|724.59106|0|68|0|4|0|5740764004352|51638.401405099998|3|0|88065|0|0.0|0|0.0|-19.945652673831269|1|0
5740764135555|5740764135555|259.21813216607597|59.033380940682399|-9.6254963886836797E-2|-0.50545518918208698|0.857467220164156|19.551167|19.027372|18.745953|18.736973|18.540203|3.5515074E-2|1.0657953E-2|2.1033103E-2|1.4563419E-2|3.3400141E-2|0.16898124|0.12433479|9.0177961E-2|6.8379216E-2|4.8481718E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|402685952|140.75342|111.16636|0|1048580|0|4|0|5740764135424|51638.402234399997|3|0|88065|0|0.0|0|0.0|-28.530868890406893|1|0
5740764135639|5740764135639|259.29532986407003|58.957754450398902|-9.5783994045786497E-2|-0.50669608097531604|0.85678731783850104|23.226965|20.325226|18.40196|17.407003|18.119421|0.64298129|0.39191869|0.15897092|9.0307094E-2|0.27490023|0.16011323|0.11780979|8.5445486E-2|6.4790726E-2|4.5937434E-2|6|1|26227|70369012613392|70369155252497|70369012645905|268468240|268468240|70369012645905|907.60016|234.89111|0|1|1|0|0|5740764135424|51638.402234399997|3|0|88063|0|0.0|0|0.0|3.6636645640443852|1|0
5740764201139|587725492136050974|259.40741435256803|58.800106191359703|-9.5225584527360504E-2|-0.50919782797380198|0.85536522026452799|20.811182|18.467695|17.566137|18.110125|17.01866|7.8575835E-2|1.2921435E-2|1.6103536E-2|1.7175447E-2|0.02626029|0.15825598|0.11644325|8.4454358E-2|6.4039186E-2|4.5404579E-2|6|1|9843|87961198792792|268468248|276856856|268468248|228698687180825|268468248|1071.7994|279.33084|0|0|0|0|0|5740764200960|51638.402649000003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740764201152|5740764201152|259.57562756408697|58.818132738255997|-9.3681537381069505E-2|-0.50921050290077097|0.85552816043042301|19.016094|18.661694|18.711124|18.608109|18.69215|2.5660787E-2|1.3295529E-2|1.7366042E-2|0.01810029|4.2545509E-2|0.14752889|0.10855035|7.8729771E-2|5.9698399E-2|4.2326909E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|1166.0961|1083.0145|0|4|0|4|0|5740764200960|51638.402649000003|3|0|88062|0|0.0|0|0.0|-24.826029875375625|1|0
5740764266622|5740764266622|259.56651633019101|58.770474791605203|-9.3891348636608599E-2|-0.509895274996231|0.85509720101735598|19.162952|19.152994|18.984285|18.943214|19.043741|2.4914436E-2|9.8096132E-3|1.3844407E-2|2.0420162E-2|4.4877995E-2|0.1517785|0.11167718|8.0997601E-2|0.06141803|4.3546148E-2|6|1|26227|17592454610944|268468224|268468224|268468224|268468224|17592588861440|203.10715|906.1239|0|1048580|0|4|0|5740764266496|51638.403063700003|3|0|88063|0|0.0|0|0.0|-26.791446909510917|1|0
5740764267043|587725492136116491|259.81321435254603|58.705552910307297|-9.1866333247919305E-2|-0.51124812442363698|0.85450917612913602|24.883322|20.585754|19.761209|19.664076|19.508358|1.0923667|2.3712611E-2|1.8313458E-2|2.8152911E-2|6.7565523E-2|0.1436547|0.10569976|7.6662287E-2|5.8130693E-2|4.1215386E-2|6|1|9843|70369012613464|70369146864921|268468248|268468248|268468248|268468248|1126.3192|1827.2855|0|0|0|0|0|5740764266496|51638.403063700003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740764332040|587725492136181770|259.49141215992199|58.612623670231798|-9.4988946498487797E-2|-0.51208612400072495|0.85366556780100999|19.398794|18.468319|18.377472|18.515369|18.384539|3.0201565E-2|7.9523465E-3|1.1915287E-2|3.1601038E-2|2.8988723E-2|0.14741974|0.10847004|7.8671515E-2|5.9654228E-2|4.2295594E-2|6|1|9843|269090832|268468272|268468272|277381136|268992528|268468240|93.812965|117.69361|0|0|0|0|0|5740764332032|51638.403478200002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740764332091|5740764332091|259.62422953390399|58.536569702847601|-9.4005626303287196E-2|-0.51341910959374304|0.85297348149124497|17.557861|16.542324|16.312479|16.325392|16.236835|1.8001916E-2|5.7507278E-3|1.0207603E-2|2.9958766E-2|1.4945688E-2|0.15201446|0.1118508|8.1123531E-2|6.1513517E-2|4.3613851E-2|6|1|26227|34628173840|268468240|268468240|268468240|268468240|268468240|947.43048|497.66699|0|4|0|4|0|5740764332032|51638.403478200002|3|0|88062|0|0.0|0|0.0|-7.7168449527575689|1|0
5740764397784|587725492136247472|259.77057547261199|58.368196428512|-9.3138684151302303E-2|-0.51612208621505395|0.85143595040119402|19.541634|19.215614|19.110619|19.084455|19.028925|3.1652313E-2|1.4903207E-2|1.7237531E-2|1.6612055E-2|4.7606412E-2|0.1456138|0.10714125|7.7707767E-2|5.8923449E-2|4.1777462E-2|6|1|9843|268570640|276856848|268603440|268468240|268468240|402821136|1257.9647|681.07007|0|0|0|0|0|5740764397568|51638.403892900002|3|0|0|0|0.0|0|0.0|0.0|0|0
5740764397854|5740764397854|259.78375476871997|58.484399641606402|-9.2713495471474006E-2|-0.51444299263063797|0.85249786808571804|20.667|19.579596|19.150616|19.191441|18.869179|6.7214429E-2|1.6582411E-2|1.7063603E-2|1.7203048E-2|4.0800653E-2|0.15541241|0.11435097|8.2936868E-2|6.2888511E-2|4.4588741E-2|6|1|26227|268570640|268468240|268468240|268468240|268603408|402685968|273.52054|1069.7107|0|1|1|0|0|5740764397568|51638.403892900002|3|0|88220|0|0.0|0|0.0|5.6661860349979776|1|0
5740764397889|103243254111141888|259.86670431380298|58.372150583375003|-0.0922622835951242|-0.51621977972837496|0.85147214284614203|20.55913|20.322475|20.330362|20.286924|19.979185|6.0029536E-2|2.3030687E-2|2.9772507E-2|3.9479159E-2|0.101922|0.15263222|0.11230534|8.1453204E-2|6.1763495E-2|4.3791089E-2|6|1|26231|268435456|411074560|268435456|268435456|268435456|268435456|1365.7427|1128.0254|0|34603008|0|0|0|5740764397568|51638.403892900002|3|0|88220|0|0.0|0|0.0|-27.073995430078341|0|0
5740764463248|5740764463248|259.76779286113299|58.317356048786401|-9.3297919798157603E-2|-0.51686084971498303|0.85097024636190499|20.265238|17.031944|15.950817|15.444648|15.209996|9.4673321E-2|0.02459936|2.0013554E-2|1.5635947E-2|1.7738758E-2|0.14355665|0.10562762|7.6609962E-2|5.8091015E-2|4.1187253E-2|6|1|26227|70403372482576|70369012776977|268468240|268468240|268468240|268468240|332.33521|524.4884|0|4|0|4|0|5740764463104|51638.404307500001|3|0|88220|0|0.0|0|0.0|1.9241911772098916|1|0
5740764528689|5740764528689|260.14009020097302|58.141549572561502|-9.0384211265189904E-2|-0.52002627757945696|0.84935467561014999|18.057434|18.074251|17.787983|17.439772|17.263037|1.6769072E-2|3.2637853E-2|9.7032068E-3|1.2442785E-2|2.1581497E-2|0.15939149|0.11727874|8.5060328E-2|0.06449867|0.04573036|3|1|26227|2379680448512|276856832|268468224|268468224|268468224|268599297|1040.854|1726.2589|0|7236|0|4|0|5740764528640|51638.4047221|3|0|88220|0|0.0|20202|2.9699999839067459E-2|-22.400095835540654|1|0
5740764528853|5740764528853|259.95108829506597|58.1622070691487|-0.0920456907144762|-0.51942373445104395|0.84954492224356604|22.501896|19.830189|18.462976|19.016718|16.931053|0.23728245|3.5225514E-2|1.0876719E-2|3.3579003E-2|2.0611068E-2|0.15149459|0.11146829|8.0846101E-2|0.06130315|4.3464698E-2|6|1|26227|19937506758912|142770433|268468224|268468224|158329943003137|268468224|583.97321|920.90656|0|1|1|0|0|5740764528640|51638.4047221|3|0|88220|0|0.0|0|0.0|5.4930483702030557|1|0
5740764528910|100146046855806976|259.93236213944999|58.186779231215397|-9.2151751634140994E-2|-0.51903484526714005|0.84977107744925995|19.622335|19.714201|19.556917|19.558619|18.931244|3.2180168E-2|3.4807265E-2|1.6263172E-2|2.3852989E-2|4.7054984E-2|0.15068899|0.11087552|0.08041618|6.0977153E-2|4.3233562E-2|6|1|26227|17592454610944|276856832|268468224|268468224|268468224|158330077216768|343.72284|904.44684|0|34610176|0|0|0|5740764528640|51638.4047221|3|0|88220|0|0.0|20195|1.2199999764561653E-2|-22.269510322584559|0|0
5740764594416|5740764594416|259.92662251891699|57.977138491309901|-9.2746963018450396E-2|-0.52208344521085703|0.84783658631107395|21.279049|17.987558|16.807152|16.4809|16.138147|0.11853592|2.4039282E-2|1.5970686E-2|1.2159707E-2|1.8218739E-2|0.15373848|0.11311932|8.2043566E-2|6.2211148E-2|0.04410848|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|787.5766|288.89151|0|4|0|4|0|5740764594176|51638.405136699999|3|0|88224|0|0.0|0|0.0|2.956322372278251|1|0
5740764594605|5740764594605|259.902656623594|58.047346533040802|-0.0927831220151729|-0.52102139831278604|0.84848570687390301|20.733473|19.186541|18.511143|19.658712|18.064983|8.5233629E-2|0.0160874|1.2396534E-2|2.1811863E-2|2.6324142E-2|0.14640011|0.10771981|7.8127392E-2|5.9241634E-2|4.2003058E-2|6|1|26227|19937506758656|268468224|268468224|268468224|17592588865537|402685952|144.74355|376.75287|0|5|1|4|0|5740764594176|51638.405136699999|3|0|88224|0|0.0|0|0.0|6.1371046903934854|1|0
5740764596066|587725492136445178|259.90192637260299|57.9697958768433|-9.2991037231757404E-2|-0.52215038529148305|0.84776862535394504|23.521849|23.173725|20.86838|19.570742|18.938311|0.68427938|0.22931087|4.2403363E-2|2.1873979E-2|4.6365459E-2|0.15426858|0.11350936|8.2326449E-2|6.2425654E-2|4.4260569E-2|6|1|9843|268435712|142606593|8388865|268435456|268435456|268435456|814.38794|155.22334|0|0|0|0|0|5740764594176|51638.405136699999|3|0|0|0|0.0|0|0.0|0.0|0|0
5740764659872|5740764659872|260.34513879914101|57.841528263099498|-8.9267270321875605E-2|-0.52472378887805005|0.84657917517190595|18.084137|18.031864|18.031315|17.84202|17.807123|5.6042608E-2|2.7372943E-2|1.1698053E-2|1.4103021E-2|2.4300473E-2|0.14091101|0.10368099|7.5198099E-2|5.7020444E-2|4.0428206E-2|6|1|26227|268435968|268468224|268468224|268468224|268468224|268468736|1217.6937|1835.3782|0|1048580|0|4|0|5740764659712|51638.405551199998|3|0|88220|0|0.0|0|0.0|-28.627012748647942|1|0
5740764660085|5740764660085|259.99023313017199|57.8348462448009|-9.2532979473740201E-2|-0.52425800444398696|0.84651709521197505|18.969112|17.717865|16.46632|16.182026|15.775226|5.8249764E-2|2.7272362E-2|1.0797511E-2|1.2933726E-2|1.7576044E-2|0.137803|0.10139414|7.3539488E-2|5.5762768E-2|3.9536498E-2|6|1|26227|268571136|268468224|268468224|268468224|402821120|402686464|751.97778|181.77414|0|7172|0|4|0|5740764659712|51638.405551199998|3|0|88224|0|0.0|20197|2.9500000178813934E-2|2.6638972166386026|1|0
5740764660879|5740764660879|260.15479889683098|57.815626084141002|-0.0910753681888717|-0.52480137321131604|0.84633846420021497|20.481627|19.855799|19.364271|18.993971|18.785593|7.8789756E-2|3.0258566E-2|1.5704988E-2|1.8401217E-2|4.1453637E-2|0.12635212|9.2968687E-2|6.7428648E-2|5.1129103E-2|3.6251172E-2|3|1|26227|268566544|276856848|268599312|268468240|268468240|268468240|1162.2406|886.11499|0|4|0|4|0|5740764659712|51638.405551199998|3|0|88224|0|0.0|0|0.0|-20.386842642910096|1|0
5740764661031|587725492136509975|260.06154950079502|57.918861877258898|-9.1666028041013897E-2|-0.52314954859086205|0.84729681287749603|23.013027|20.984327|20.437969|20.166548|19.940886|0.4657976|4.2934436E-2|2.8743574E-2|3.6113217E-2|0.10134079|0.13959225|0.10271064|7.4494325E-2|5.6486793E-2|0.04004984|6|1|9843|70369012744464|70369155252497|268468240|268468240|268468240|402817040|130.59393|745.19006|0|0|0|0|0|5740764659712|51638.405551199998|3|0|0|0|0.0|0|0.0|0.0|0|0
5740764790954|5740764790954|260.47926689360003|57.617341894677097|-8.8585885455863697E-2|-0.52819415679697101|0.84449006721425501|19.413761|18.518469|18.365644|18.405258|18.379082|2.8630095E-2|9.9655772E-3|1.0415997E-2|2.6724156E-2|3.0777827E-2|0.14122565|0.1039125|7.5366013E-2|5.7147764E-2|4.0518478E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|635.6319|1840.0255|0|4|0|4|0|5740764790784|51638.406380400003|3|0|88224|0|0.0|0|0.0|4.8857447508182901|1|0
5740764790989|5740764790989|260.42315731042999|57.555258163709901|-8.9255288281065506E-2|-0.529009148891181|0.84390924506329001|19.104792|18.688467|18.60964|18.630249|18.402069|2.4640992E-2|1.0329898E-2|1.0997407E-2|2.7295681E-2|3.1147752E-2|0.13967019|0.102768|7.4535929E-2|5.6518339E-2|4.0072206E-2|6|1|26227|34628173824|268468224|276856832|268468224|268468224|268468224|1091.807|1408.9841|0|1048580|0|4|0|5740764790784|51638.406380400003|3|0|88224|0|0.0|0|0.0|-28.80570796357302|1|0
5740764921949|5740764921949|260.51050077967398|57.263675543082002|-8.9155655221780095E-2|-0.53337367663778301|0.84116811055333596|22.737103|22.351374|20.364676|18.771488|17.9354|0.32511544|0.16854115|0.10061718|0.17033142|0.03995822|0.15138179|0.11138528|8.0785893E-2|0.0612575|4.3432329E-2|6|1|26227|87961198789392|70369155383569|276857104|268599312|268468752|158329942999056|1026.9685|1016.5349|0|4|0|4|0|5740764921856|51638.407209700003|3|0|88224|0|0.0|0|0.0|5.2478644255009073|1|0
5740765053145|5740765053145|260.52516369374399|56.914338266441803|-8.9861747254680102E-2|-0.53844523850331305|0.83785535238097397|18.646158|18.347673|18.2623|18.065762|17.927553|0.10917158|0.01018847|1.1970393E-2|1.4050956E-2|2.5048945E-2|0.13303275|9.7884238E-2|7.0993811E-2|0.05383246|3.8167886E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|1356.1727|129.0972|0|3153428|0|4|16|5740765052928|51638.408038900001|3|0|88224|3050|36.909999847412109|20212|8.1100001931190491E-2|-24.268064052012157|1|0
5740765118629|5740765118629|260.78516162996902|56.811697357200799|-8.7657680195276005E-2|-0.54032818664832005|0.83687608510228095|19.172956|18.486969|18.252464|18.933846|18.022602|5.3960923E-2|1.0113562E-2|1.1431617E-2|2.1620367E-2|2.4703735E-2|0.14212316|0.10457288|7.5844973E-2|5.7510946E-2|4.0775977E-2|6|1|26227|17592454615040|268468224|268468224|268468224|158329943003136|268468224|1270.1163|1082.7673|0|4|0|4|0|5740765118464|51638.408453600001|3|0|88221|0|0.0|0|0.0|5.4139696958866494|1|0
5740765184274|5740765184274|261.00935477137801|56.737279641722601|-8.5712550816324007E-2|-0.54174019814062102|0.83616440748881404|23.261719|22.051418|22.185837|19.808769|18.196617|0.58164454|7.6357365E-2|0.12353113|3.1065162E-2|3.6068551E-2|0.17893168|0.13165623|9.5488086E-2|7.2405726E-2|0.05133656|6|1|26227|70369012613392|70369180386577|310378768|301989904|301989904|302022672|885.51471|1949.3545|0|33554433|1|0|0|5740765184000|51638.408868099999|3|0|88221|0|0.0|0|0.0|6.2739989164677041|1|0
5740765184335|5740765184335|260.83621955746798|56.7302905858107|-8.7365419547934794E-2|-0.54157941198381998|0.83609749669669098|19.609722|19.594231|19.239594|19.059954|18.566408|4.2541541E-2|1.3305185E-2|1.8266922E-2|2.1940567E-2|4.1547935E-2|0.1606192|0.11818209|8.5715503E-2|6.4995475E-2|4.6082601E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|692.31427|1105.7932|0|4|0|4|0|5740765184000|51638.408868099999|3|0|88221|0|0.0|0|0.0|-22.08029941963494|1|0
5740765249543|5740765249543|261.01261303861003|56.669865225042798|-0.0858353755551549|-0.54271645152853598|0.83551848665578898|16.795647|15.704567|15.662793|15.670138|15.753904|1.2815104E-2|9.8293358E-3|1.1182121E-2|1.0877374E-2|2.8557617E-2|0.17347877|0.12764403|9.2578098E-2|7.0199169E-2|4.9772084E-2|6|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|115.79697|1784.5613|0|4|0|4|0|5740765249536|51638.409282799999|3|0|88221|0|0.0|0|0.0|2.1375738981571573|1|0
5740765315249|5740765315249|261.15631559119902|56.477172514067099|-8.4905450475196903E-2|-0.545703495468014|0.83366585603201704|18.759443|17.898859|17.86195|17.657255|17.582911|4.4555534E-2|2.4463689E-2|2.1663086E-2|2.3622118E-2|2.7520454E-2|0.15347005|0.1129218|8.1900313E-2|6.2102526E-2|4.4031467E-2|3|1|26227|34628304912|268468240|268468240|268468240|268468240|268599312|640.69873|1959.1545|0|68|0|4|0|5740765315072|51638.409697399999|3|0|88361|0|0.0|0|0.0|-18.185978118360794|1|0
5740765315379|587725492137165131|261.01330455812501|56.425433373752199|-8.6384826261163006E-2|-0.54623322263332896|0.83316680699811696|23.021446|25.113003|23.083208|18.739225|17.28694|0.5242458|0.61701381|1.5006734|3.2217357E-2|2.2186065E-2|0.13785098|0.10142944|7.3565088E-2|0.05578218|0.03955026|3|1|9843|70369012748560|70369155260689|70369155252529|70369012645905|268603408|268468240|880.02521|1133.6599|0|0|0|0|0|5740765315072|51638.409697399999|3|0|0|0|0.0|0|0.0|0.0|0|0
5740765380625|5740765380625|261.025589275973|56.334189626471598|-8.6474572879592898E-2|-0.54756161703609796|0.83228506161897797|15.640278|16.008154|16.405113|16.575378|16.518044|1.6074006E-2|1.3518364E-2|5.1300577E-3|1.4605727E-2|0.02990301|0.12300504|9.0505943E-2|6.5642454E-2|4.9774688E-2|3.5290875E-2|6|1|26227|34628305408|285376512|268468224|268468736|268468224|402685952|330.47366|948.61554|0|9437188|0|4|0|5740765380608|51638.410111899997|3|0|88361|0|0.0|0|0.0|-10.951237444059117|1|0
5740765446248|5740765446248|261.27722353594402|56.123564291319397|-8.4532366013035001E-2|-0.55095658876805997|0.83024160121575497|18.778067|18.572439|18.700258|18.730467|18.528732|2.3751277E-2|7.1660946E-3|1.3076534E-2|2.6673952E-2|3.5889156E-2|0.15618369|0.11491848|8.3348468E-2|6.3200615E-2|4.4810027E-2|6|1|26227|268567056|276987920|276856848|268468240|268468240|268468752|1171.9739|1605.0889|0|20|0|4|16|5740765446144|51638.410526599997|3|0|88361|3296|1.0800000429153442|0|0.0|-25.032471263203981|1|0
5740765511944|587725492137361741|261.40332384776002|55.970708282834899|-8.3650370542033697E-2|-0.55332940210423998|0.82875158417655204|21.875151|19.446705|18.067427|17.192617|16.495192|0.17371389|1.7622543E-2|1.9414129E-2|2.7830578E-2|2.8688988E-2|0.17392264|0.12797064|9.2814974E-2|7.0378788E-2|4.9899437E-2|6|1|9843|17592454615808|402687232|268468224|268468224|17592454647808|411075072|1326.2307|1814.9294|0|0|0|0|0|5740765511680|51638.410941200003|3|0|0|0|0.0|0|0.0|0.0|0|0
5740765511970|100990599573798912|261.30206119858298|56.077124854134098|-8.4395255012785206E-2|-0.55165818982787995|0.82978954110494396|20.253557|20.164618|20.32015|20.303005|19.947788|0.05767706|2.1976365E-2|3.1349391E-2|4.8705645E-2|0.10484165|0.16143215|0.11878023|8.6149335E-2|6.5324433E-2|4.6315838E-2|6|1|26227|268435456|276856832|276856832|268468224|268468224|402685952|251.62268|1602.9309|0|34603008|0|0|0|5740765511680|51638.410941200003|3|0|88361|0|0.0|0|0.0|-26.648224382362656|0|0
5740765577365|587725492137426992|261.331198833646|55.899666790677799|-8.4501659568850501E-2|-0.55423907428970998|0.828057074156483|18.890673|17.785025|17.774588|17.823732|17.906147|3.2306463E-2|6.2648673E-3|0.02410578|1.6676867E-2|2.1897053E-2|0.17903356|0.1317312|9.5542453E-2|0.07244695|5.1365789E-2|6|1|26227|34628174336|276856832|268468224|268468224|268468736|268468224|477.62854|1276.3395|0|1056768|0|0|0|5740765577216|51638.411355900003|3|0|88361|0|0.0|0|0.0|0.0|0|0
5740765643037|100990599456358400|261.46339086337002|55.783377578115797|-8.3472009260205607E-2|-0.55609344657507298|0.82691747009379402|20.067261|20.103207|20.06657|19.866583|19.90534|5.0522622E-2|1.9034969E-2|2.2381919E-2|0.02859137|9.4286285E-2|0.1568339|0.11539689|8.3695449E-2|6.3463725E-2|4.4996575E-2|6|1|26227|268435456|276856832|268468224|268435456|268435456|402653184|323.68564|1616.8225|0|34603008|0|0|0|5740765642752|51638.411770500003|3|0|88361|0|0.0|0|0.0|-26.286623672047796|0|0
5740765708480|5740765708480|261.51469554598702|55.606908265271898|-8.3349442797255702E-2|-0.55868432811464197|0.82518161146772895|18.763277|17.621599|17.121902|18.902929|16.840399|3.3705249E-2|0.01137944|8.0857584E-3|3.5065435E-2|1.9147107E-2|0.15385938|0.11320827|0.08210808|6.2260073E-2|4.4143166E-2|6|1|26227|19971866497024|402685952|268468224|268468224|158329943003137|402685952|575.3905|1406.2113|0|5|1|4|0|5740765708288|51638.412185200003|3|0|88365|0|0.0|0|0.0|5.3783041838016885|1|0
5740765839664|5740765839664|261.76998593773601|55.262252639872798|-8.1568402037027504E-2|-0.56395267075906397|0.821768812338875|19.702759|19.414139|18.926193|18.601183|18.358271|0.04450367|1.8470323E-2|1.1600268E-2|1.6954452E-2|2.9555961E-2|0.17806599|0.13101925|9.5026091E-2|7.2055407E-2|5.1088184E-2|3|1|26227|34628173840|268468240|268468240|268468240|268468240|268468240|1231.9053|1772.1565|0|4|0|4|0|5740765839360|51638.413014500002|3|0|88365|0|0.0|0|0.0|-22.339033256838121|1|0
5740765905280|587725588775305587|261.847872995351|55.184137212955598|-8.0960494063449198E-2|-0.56517156274278102|0.820991171126636|22.564463|21.38732|20.191147|19.664137|19.160364|0.33702573|4.8470348E-2|0.0331969|3.4067415E-2|5.4131344E-2|0.17648889|0.12985885|9.4184473E-2|7.1417235E-2|0.05063571|3|1|26227|70369012613648|70369146863633|276856848|276857360|276857360|402685968|666.19769|1957.899|0|4096|0|0|0|5740765904896|51638.413429100001|3|0|88365|0|0.0|20246|8.0799996852874756E-2|0.0|0|0
5740766036025|5740766036025|262.00278853832799|54.8841104039575|-8.0029114746857699E-2|-0.56963790006513404|0.81799022219230699|18.223225|18.487009|18.25267|18.04455|17.875654|6.4642325E-2|1.9593669E-2|1.6539173E-2|2.3600059E-2|2.9242136E-2|0.15737537|0.11579529|8.3984405E-2|6.3682832E-2|4.5151923E-2|3|1|26227|268435456|268468224|268468224|276856832|268468224|402685952|789.16046|1963.1517|0|7172|0|4|0|5740766035968|51638.414258500001|3|0|88364|0|0.0|20254|2.5100000202655792E-2|-22.86673400247556|1|0
5740766101898|587725492137951599|261.72158299396199|54.727699856403397|-8.3145109255995706E-2|-0.57144588378123296|0.81641686209698905|23.162481|21.702269|19.965683|19.499535|19.146608|0.53049415|6.6737898E-2|2.1258285E-2|2.1674603E-2|5.5498179E-2|0.16802172|0.12362879|8.9665905E-2|6.7990944E-2|4.8206426E-2|3|1|9843|17596749578512|134251793|158329942999056|268468240|268468240|268468240|377.35101|146.91461|0|0|0|0|0|5740766101504|51638.4146731|3|0|0|0|0.0|0|0.0|0.0|0|0
5740766167243|587725492138016922|261.88623214498898|54.540502923376899|-8.1878660189998495E-2|-0.57432009781351501|0.81452581926723799|23.613472|22.56168|20.917135|19.547636|19.009953|0.76751912|10.622934|3.9431839|1.2189952|0.65728891|0.17763385|0.1307013|9.4795488E-2|7.1880549E-2|5.0964203E-2|6|1|9843|70369012613976|70369155252505|70369021034777|70369021034521|268468248|276857368|893.43555|494.96707|0|0|0|0|0|5740766167040|51638.4150878|3|0|0|0|0.0|0|0.0|0.0|0|0
5740766167384|587725588775568109|262.12009072946802|54.5340487830752|-0.0795464170356978|-0.57474039214108696|0.81446046507997705|21.285509|20.554327|20.308706|20.111357|20.174681|0.1171193|2.6559925E-2|3.0777469E-2|3.5229571E-2|0.13228063|0.19449896|0.14311048|0.10379566|0.07870511|5.5802904E-2|6|1|9843|268435968|268468224|268468224|276856832|402686464|402702336|1295.302|1662.646|0|0|0|0|0|5740766167040|51638.4150878|3|0|0|0|0.0|0|0.0|0.0|0|0
5740766232880|5740766232880|261.996452245542|54.363067261250599|-8.1124512128090007E-2|-0.57697166981541304|0.81272535690871195|20.005335|19.474813|19.083105|18.660873|18.534582|0.06199057|1.6690223E-2|1.2637392E-2|0.01518007|0.03920728|0.19945295|0.14675558|0.10643939|8.0709763E-2|5.7224229E-2|3|1|26227|268435472|268468240|268468240|268468240|268468240|268468240|1244.6986|598.55731|0|5124|0|4|0|5740766232576|51638.415502399999|3|0|88362|0|0.0|20253|1.7400000244379044E-2|-20.063162719409242|1|0
5740766363977|5740766363977|262.162652083257|54.160594632674801|-7.9841667293700902E-2|-0.58004614600367699|0.81066132057107698|20.151796|19.411366|19.173401|18.781092|18.729548|8.2239285E-2|1.5348407E-2|1.6860405E-2|2.0159312E-2|4.0514983E-2|0.23083147|0.1698436|0.12318475|9.3407266E-2|6.6226915E-2|3|1|26227|268566544|276987920|268468240|268468240|268468240|268468240|536.83264|929.64532|0|4|0|4|0|5740766363648|51638.416331699998|3|0|88474|0|0.0|0|0.0|-21.356648743382095|1|0
5740766363990|5740766363990|262.053690395133|54.074603588462097|-8.1112725687516804E-2|-0.58109758547641899|0.80978165074606201|20.272726|19.776339|19.341387|18.973076|18.734543|8.5313939E-2|1.7267128E-2|1.7834123E-2|2.1225488E-2|4.0701598E-2|0.25381833|0.18675712|0.13545184|0.10270903|7.2821982E-2|3|1|26227|34628304896|276856832|268599296|268468224|268468224|268468224|1126.3733|153.05173|0|4|0|4|0|5740766363648|51638.416331699998|3|0|88474|0|0.0|0|0.0|-21.809706381969065|1|0
5740766363992|101272088307826688|262.06422569284501|54.058961517231701|-8.1036393877989402E-2|-0.58133142647495295|0.80962143959992094|19.802931|19.63735|19.208397|19.181051|19.153868|7.7766806E-2|1.6766444E-2|1.6906917E-2|2.2784067E-2|5.5752613E-2|0.25279358|0.18600312|0.13490498|0.10229436|7.2527975E-2|6|1|26227|17592454611456|268468736|268468224|17592454643712|268468224|268468224|1278.5033|167.3853|0|34603008|0|0|0|5740766363648|51638.416331699998|3|0|88474|0|0.0|0|0.0|-25.721644676217927|0|0
5740766429411|5740766429411|262.29365945754301|54.075642809349297|-7.8676269714184094E-2|-0.58141765311872595|0.80979229264409203|20.392399|19.14765|18.557571|18.364225|17.897064|5.8845505E-2|1.1504531E-2|1.5491894E-2|1.0001726E-2|2.6375437E-2|0.25255969|0.18583103|0.13478015|0.10219971|7.2460875E-2|6|1|26231|34628174336|268468736|268468224|268468224|268468224|402685952|111.49387|1385.7666|0|1|1|0|0|5740766429184|51638.416746499999|3|0|88474|0|0.0|0|0.0|4.7996603849735635|1|0
5740766560521|5740766560521|262.50906597693|53.694157350074697|-7.7191065263623196E-2|-0.587042122534427|0.80586790841535705|18.239334|17.443209|17.233879|18.431446|17.011301|5.5682201E-2|9.9476688E-3|8.6880131E-3|2.1983678E-2|2.0648893E-2|0.19361007|0.14245646|0.1033213|7.8345411E-2|5.5547874E-2|6|1|26227|19937506758656|268468224|268468224|268468224|158329943003137|268468224|1041.2186|1538.1083|0|4|0|4|0|5740766560256|51638.417575699998|3|0|88474|0|0.0|0|0.0|4.8907343748417276|1|0
5740766560564|587725492138410043|262.27338728560801|53.740000643548001|-7.9518411421138704E-2|-0.58608052001873701|0.80634139562571505|19.101303|19.20719|18.951857|19.090399|19.014357|5.8087956E-2|0.01325787|0.01212464|0.02357476|5.1156022E-2|0.20421508|0.15025951|0.10898074|8.2636788E-2|5.8590516E-2|6|1|26227|268435968|268468736|268468224|268468224|268468224|268468224|292.0752|434.35287|0|34603008|0|0|0|5740766560256|51638.417575699998|3|0|88474|0|0.0|0|0.0|-26.421352108100109|0|0
5740766560602|587725588775960736|262.479200072754|53.797000788958997|-7.7307604155910994E-2|-0.585566807131496|0.80692939513039097|20.220024|19.413179|19.110849|18.832424|18.54192|7.1819045E-2|1.3767468E-2|0.01273077|2.2226678E-2|3.6860127E-2|0.23226385|0.17089754|0.12394915|9.3986884E-2|6.6637874E-2|3|1|26231|34628304896|268599296|268599296|268468224|268468224|268468224|98.48278|1640.4989|0|64|0|0|0|5740766560256|51638.417575699998|3|0|88474|0|0.0|0|0.0|0.0|0|0
5740766560614|101272088249106432|262.29138795119297|53.722917718095097|-0.0793665224160848|-0.58634368814962901|0.80616501690824305|19.691223|19.530172|19.429825|19.256376|19.162054|6.2634461E-2|1.4943277E-2|0.01509463|2.4935799E-2|5.7154711E-2|0.2027837|0.14920633|0.10821687|8.2057573E-2|5.8179844E-2|6|1|26227|268435456|268468224|268468224|268468224|268468224|268468224|468.0589|484.2605|0|34603008|0|0|0|5740766560256|51638.417575699998|3|0|88474|0|0.0|0|0.0|-26.802469702282984|0|0
5740766691418|5740766691418|262.65422818552599|53.483887949597303|-7.6081133399128198E-2|-0.59016502162326401|0.80368955971389699|19.084795|18.35774|18.02417|17.592682|17.435406|0.0320682|1.6417848E-2|1.4051285E-2|2.7448576E-2|1.8882547E-2|0.18184268|0.13379812|9.7041562E-2|7.3583677E-2|5.2171744E-2|3|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|372.40811|1769.0983|0|68|0|4|0|5740766691328|51638.418404999997|3|0|88474|0|0.0|0|0.0|-20.380399031913392|1|0
5740766691592|101272086579773440|262.407971921615|53.379993246759398|-7.8809353271849195E-2|-0.59127616471416999|0.80260923423405395|20.652128|20.170626|20.16996|19.939371|19.765593|7.4181847E-2|2.3461925E-2|2.5934417E-2|4.0311873E-2|9.2591539E-2|0.17974439|0.13225421|9.5921792E-2|7.2734587E-2|0.05156973|6|1|26227|268435456|402685952|268468224|268468224|268468224|268468224|916.67505|227.13737|0|34603008|0|0|0|5740766691328|51638.418404999997|3|0|88475|0|0.0|0|0.0|-23.465112201835353|0|0
5740766756928|5740766756928|262.78709104214499|53.2650745113014|-0.0750972256565548|-0.59338055974627801|0.80141120407309097|8.4077908E-45|16.403011|16.160318|16.243795|15.947522|5.6051939E-44|1.5853461E-2|7.6864124E-3|1.0797505E-2|2.3212433E-2|0.19895871|0.14639193|0.10617564|8.0509774E-2|5.7082433E-2|6|1|26227|34628173824|268468224|268468224|268468224|268468224|268468224|1121.4584|1922.182|0|8193|1|0|0|5740766756864|51638.418819699997|3|0|88475|0|0.0|0|0.0|0.0|1|0

drop table QsoTarget;
