CREATE TABLE Algorithm(
	key varchar(128)  NOT NULL,
	name varchar(128)  NOT NULL,
	ucd varchar(128)  NOT NULL,
	"text" text  NOT NULL,
 CONSTRAINT pk_Algorithm_key PRIMARY KEY  
(
	key 
)
); 

CREATE TABLE Ap7Mag(
	objID bigint NOT NULL,
	rowc real NOT NULL,
	colc real NOT NULL,
	psfMag_r real NOT NULL,
	psfMagErr_r real NOT NULL,
	apMag_r real NOT NULL,
	apMagErr_r real NOT NULL,
 CONSTRAINT pk_Ap7Mag_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE BestTarget2Sector(
	objID bigint NOT NULL,
	regionID bigint NOT NULL,
	status int NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	petroMag_r real NOT NULL,
	extinction_r real NOT NULL,
 CONSTRAINT pk_BestTarget2Sector_objid_regio PRIMARY KEY  
(
	objID ,
	regionID 
)
);

CREATE TABLE Chunk(
	chunkID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	targetVersion varchar(32)  NOT NULL,
	startMu int NOT NULL,
	endMu int NOT NULL,
	stripe int NOT NULL,
	exportVersion varchar(32)  NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_Chunk_chunkID PRIMARY KEY  
(
	chunkID 
)
);

CREATE TABLE DataConstants(
	field varchar(128)  NOT NULL,
	name varchar(128)  NOT NULL,
	value bigint, --NOT NULL,
	description varchar(2000)  NOT NULL,
 CONSTRAINT pk_DataConstants_field_name PRIMARY KEY  
(
	field ,
	name 
)
);

CREATE TABLE DBColumns(
	tablename varchar(128)  NOT NULL,
	name varchar(64)  NOT NULL,
	unit varchar(64)  NOT NULL,
	ucd varchar(128)  NOT NULL,
	enum varchar(64)  NOT NULL,
	description varchar(2000)  NOT NULL,
	rank int NOT NULL DEFAULT (0),
 CONSTRAINT pk_DBColumns_tableName_name PRIMARY KEY  
(
	tablename ,
	name 
)
);

CREATE TABLE DBObjects(
	name varchar(128)  NOT NULL,
	"type" varchar(64)  NOT NULL,
	access varchar(8)  NOT NULL,
	description varchar(256)  NOT NULL,
	"text" varchar(7200)  NOT NULL,
	rank int NOT NULL,
 CONSTRAINT pk_DBObjects_name PRIMARY KEY  
(
	name 
)
);

CREATE TABLE DBViewCols(
	name varchar(64)  NOT NULL,
	viewname varchar(128)  NOT NULL,
	parent varchar(128)  NOT NULL,
 CONSTRAINT pk_DBViewCols_viewName_name PRIMARY KEY  
(
	viewname ,
	name 
)
);

CREATE TABLE Dependency(
	filename varchar(128)  NOT NULL,
	parent varchar(128)  NOT NULL,
	child varchar(128)  NOT NULL,
 CONSTRAINT pk_Dependency_parent_child PRIMARY KEY  
(
	parent ,
	child 
)
);

CREATE TABLE Diagnostics(
	name varchar(64)  NOT NULL,
	"type" varchar(8)  NOT NULL,
	count bigint NULL,
 CONSTRAINT pk_Diagnostics_name PRIMARY KEY  
(
	name 
)
);

CREATE TABLE DR3QuasarCatalog(
	SDSSName varchar(64)  NOT NULL,
	RA float NOT NULL,
	"dec" float NOT NULL,
	z real NOT NULL,
	psfmag_u real NOT NULL,
	psfmagerr_u real NOT NULL,
	psfmag_g real NOT NULL,
	psfmagerr_g real NOT NULL,
	psfmag_r real NOT NULL,
	psfmagerr_r real NOT NULL,
	psfmag_i real NOT NULL,
	psfmagerr_i real NOT NULL,
	psfmag_z real NOT NULL,
	psfmagerr_z real NOT NULL,
	A_u real NOT NULL,
	lgNH real NOT NULL,
	FIRSTmag real NOT NULL,
	FIRST_sn real NOT NULL,
	FIRST_sep real NOT NULL,
	FIRST_flux_at_opt smallint NOT NULL,
	FIRST_extmatch smallint NOT NULL,
	lg_RASS_rate real NOT NULL,
	RASS_sn real NOT NULL,
	RASS_sep real NOT NULL,
	TWOMASSmag_J real NOT NULL,
	TWOMASSmagerr_J real NOT NULL,
	TWOMASSmag_H real NOT NULL,
	TWOMASSmagerr_H real NOT NULL,
	TWOMASSmag_K real NOT NULL,
	TWOMASSmagerr_K real NOT NULL,
	TWOMASS_sep real NOT NULL,
	M_i real NOT NULL,
	morphology smallint NOT NULL,
	scienceprimary smallint NOT NULL,
	"mode" smallint NOT NULL,
	bestprimtarget int NOT NULL,
	ts_b_qso smallint NOT NULL,
	ts_b_hiz smallint NOT NULL,
	ts_b_FIRST smallint NOT NULL,
	ts_b_ROSAT smallint NOT NULL,
	ts_b_serendip smallint NOT NULL,
	ts_b_star smallint NOT NULL,
	ts_b_gal smallint NOT NULL,
	run_best smallint NOT NULL,
	mjd_best int NOT NULL,
	mjd_spec int NOT NULL,
	plate smallint NOT NULL,
	fiberid smallint NOT NULL,
	rerun_best smallint NOT NULL,
	camcol_best smallint NOT NULL,
	field_best smallint NOT NULL,
	obj_best smallint NOT NULL,
	tilingchunk smallint NOT NULL,
	targprimtarget int NOT NULL,
	t_psfmag_u real NOT NULL,
	t_psfmagerr_u real NOT NULL,
	t_psfmag_g real NOT NULL,
	t_psfmagerr_g real NOT NULL,
	t_psfmag_r real NOT NULL,
	t_psfmagerr_r real NOT NULL,
	t_psfmag_i real NOT NULL,
	t_psfmagerr_i real NOT NULL,
	t_psfmag_z real NOT NULL,
	t_psfmagerr_z real NOT NULL,
	object_name varchar(64)  NULL,
	specObjId bigint NOT NULL,
 CONSTRAINT pk_DR3QuasarCatalog_SpecObjID PRIMARY KEY  
(
	specObjId 
)
);

CREATE TABLE DR5QuasarCatalog(
	specObjId bigint NOT NULL,
	SDSSName varchar(64)  NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	z real NOT NULL,
	psfmag_u real NOT NULL,
	psfmagerr_u real NOT NULL,
	psfmag_g real NOT NULL,
	psfmagerr_g real NOT NULL,
	psfmag_r real NOT NULL,
	psfmagerr_r real NOT NULL,
	psfmag_i real NOT NULL,
	psfmagerr_i real NOT NULL,
	psfmag_z real NOT NULL,
	psfmagerr_z real NOT NULL,
	A_u real NOT NULL,
	A_g real NOT NULL,
	A_r real NOT NULL,
	A_i real NOT NULL,
	A_z real NOT NULL,
	lgNH real NOT NULL,
	FIRSTmag real NOT NULL,
	FIRST_sn real NOT NULL,
	FIRST_sep real NOT NULL,
	FIRST_flux_at_opt int NOT NULL,
	FIRST_extmatch int NOT NULL,
	lg_RASS_rate real NOT NULL,
	RASS_sn real NOT NULL,
	RASS_sep real NOT NULL,
	TWOMASSmag_J real NOT NULL,
	TWOMASSmagerr_J real NOT NULL,
	TWOMASSmag_H real NOT NULL,
	TWOMASSmagerr_H real NOT NULL,
	TWOMASSmag_K real NOT NULL,
	TWOMASSmagerr_K real NOT NULL,
	TWOMASS_sep real NOT NULL,
	M_i real NOT NULL,
	delgi real NOT NULL,
	morphology int NOT NULL,
	scienceprimary int NOT NULL,
	"mode" int NOT NULL,
	uniform int NOT NULL,
	bestprimtarget int NOT NULL,
	ts_b_lowz int NOT NULL,
	ts_b_hiz int NOT NULL,
	ts_b_FIRST int NOT NULL,
	ts_b_ROSAT int NOT NULL,
	ts_b_serendip int NOT NULL,
	ts_b_star int NOT NULL,
	ts_b_gal int NOT NULL,
	run_best int NOT NULL,
	mjd_best int NOT NULL,
	mjd_spec int NOT NULL,
	plate int NOT NULL,
	fiberid int NOT NULL,
	rerun_best int NOT NULL,
	camcol_best int NOT NULL,
	field_best int NOT NULL,
	obj_best int NOT NULL,
	targprimtarget int NOT NULL,
	ts_t_lowz int NOT NULL,
	ts_t_hiz int NOT NULL,
	ts_t_first int NOT NULL,
	ts_t_rosat int NOT NULL,
	ts_t_serendip int NOT NULL,
	ts_t_star int NOT NULL,
	ts_t_gal int NOT NULL,
	t_psfmag_u real NOT NULL,
	t_psfmagerr_u real NOT NULL,
	t_psfmag_g real NOT NULL,
	t_psfmagerr_g real NOT NULL,
	t_psfmag_r real NOT NULL,
	t_psfmagerr_r real NOT NULL,
	t_psfmag_i real NOT NULL,
	t_psfmagerr_i real NOT NULL,
	t_psfmag_z real NOT NULL,
	t_psfmagerr_z real NOT NULL,
 CONSTRAINT pk_DR5QuasarCatalog_SpecObjID PRIMARY KEY  
(
	specObjId 
)
);

CREATE TABLE ELRedShift(
	elRedShiftID bigint NOT NULL,
	z real NOT NULL,
	zErr real NOT NULL,
	zConf real NOT NULL,
	nFit int NOT NULL,
	wtFit real NOT NULL,
	specObjID bigint NOT NULL,
 CONSTRAINT pk_ELRedShift_elRedShiftID PRIMARY KEY  
(
	elRedShiftID 
)
);

CREATE TABLE Field(
	fieldID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	nObjects smallint NOT NULL,
	nChild int NOT NULL,
	nGalaxy int NOT NULL,
	nStars int NOT NULL,
	numStars_u int NOT NULL,
	numStars_g int NOT NULL,
	numStars_r int NOT NULL,
	numStars_i int NOT NULL,
	numStars_z int NOT NULL,
	nCR_u int NOT NULL,
	nCR_g int NOT NULL,
	nCR_r int NOT NULL,
	nCR_i int NOT NULL,
	nCR_z int NOT NULL,
	nBrightObj_u int NOT NULL,
	nBrightObj_g int NOT NULL,
	nBrightObj_r int NOT NULL,
	nBrightObj_i int NOT NULL,
	nBrightObj_z int NOT NULL,
	nFaintObj_u int NOT NULL,
	nFaintObj_g int NOT NULL,
	nFaintObj_r int NOT NULL,
	nFaintObj_i int NOT NULL,
	nFaintObj_z int NOT NULL,
	quality int NOT NULL,
	mjd_u float NOT NULL,
	mjd_g float NOT NULL,
	mjd_r float NOT NULL,
	mjd_i float NOT NULL,
	mjd_z float NOT NULL,
	a_u float NOT NULL,
	a_g float NOT NULL,
	a_r float NOT NULL,
	a_i float NOT NULL,
	a_z float NOT NULL,
	b_u float NOT NULL,
	b_g float NOT NULL,
	b_r float NOT NULL,
	b_i float NOT NULL,
	b_z float NOT NULL,
	c_u float NOT NULL,
	c_g float NOT NULL,
	c_r float NOT NULL,
	c_i float NOT NULL,
	c_z float NOT NULL,
	d_u float NOT NULL,
	d_g float NOT NULL,
	d_r float NOT NULL,
	d_i float NOT NULL,
	d_z float NOT NULL,
	e_u float NOT NULL,
	e_g float NOT NULL,
	e_r float NOT NULL,
	e_i float NOT NULL,
	e_z float NOT NULL,
	f_u float NOT NULL,
	f_g float NOT NULL,
	f_r float NOT NULL,
	f_i float NOT NULL,
	f_z float NOT NULL,
	dRow0_u float NOT NULL,
	dRow0_g float NOT NULL,
	dRow0_r float NOT NULL,
	dRow0_i float NOT NULL,
	dRow0_z float NOT NULL,
	dRow1_u float NOT NULL,
	dRow1_g float NOT NULL,
	dRow1_r float NOT NULL,
	dRow1_i float NOT NULL,
	dRow1_z float NOT NULL,
	dRow2_u float NOT NULL,
	dRow2_g float NOT NULL,
	dRow2_r float NOT NULL,
	dRow2_i float NOT NULL,
	dRow2_z float NOT NULL,
	dRow3_u float NOT NULL,
	dRow3_g float NOT NULL,
	dRow3_r float NOT NULL,
	dRow3_i float NOT NULL,
	dRow3_z float NOT NULL,
	dCol0_u float NOT NULL,
	dCol0_g float NOT NULL,
	dCol0_r float NOT NULL,
	dCol0_i float NOT NULL,
	dCol0_z float NOT NULL,
	dCol1_u float NOT NULL,
	dCol1_g float NOT NULL,
	dCol1_r float NOT NULL,
	dCol1_i float NOT NULL,
	dCol1_z float NOT NULL,
	dCol2_u float NOT NULL,
	dCol2_g float NOT NULL,
	dCol2_r float NOT NULL,
	dCol2_i float NOT NULL,
	dCol2_z float NOT NULL,
	dCol3_u float NOT NULL,
	dCol3_g float NOT NULL,
	dCol3_r float NOT NULL,
	dCol3_i float NOT NULL,
	dCol3_z float NOT NULL,
	csRow_u float NOT NULL,
	csRow_g float NOT NULL,
	csRow_r float NOT NULL,
	csRow_i float NOT NULL,
	csRow_z float NOT NULL,
	csCol_u float NOT NULL,
	csCol_g float NOT NULL,
	csCol_r float NOT NULL,
	csCol_i float NOT NULL,
	csCol_z float NOT NULL,
	ccRow_u float NOT NULL,
	ccRow_g float NOT NULL,
	ccRow_r float NOT NULL,
	ccRow_i float NOT NULL,
	ccRow_z float NOT NULL,
	ccCol_u float NOT NULL,
	ccCol_g float NOT NULL,
	ccCol_r float NOT NULL,
	ccCol_i float NOT NULL,
	ccCol_z float NOT NULL,
	riCut_u float NOT NULL,
	riCut_g float NOT NULL,
	riCut_r float NOT NULL,
	riCut_i float NOT NULL,
	riCut_z float NOT NULL,
	airmass_u float NOT NULL,
	airmass_g float NOT NULL,
	airmass_r float NOT NULL,
	airmass_i float NOT NULL,
	airmass_z float NOT NULL,
	muErr_u float NOT NULL,
	muErr_g float NOT NULL,
	muErr_r float NOT NULL,
	muErr_i float NOT NULL,
	muErr_z float NOT NULL,
	nuErr_u float NOT NULL,
	nuErr_g float NOT NULL,
	nuErr_r float NOT NULL,
	nuErr_i float NOT NULL,
	nuErr_z float NOT NULL,
	raMin float NOT NULL,
	raMax float NOT NULL,
	decMin float NOT NULL,
	decMax float NOT NULL,
	scanlineArea real NOT NULL,
	stripeArea real NOT NULL,
	seqId int NOT NULL,
	aa_u real NOT NULL,
	aa_g real NOT NULL,
	aa_r real NOT NULL,
	aa_i real NOT NULL,
	aa_z real NOT NULL,
	aaErr_u real NOT NULL,
	aaErr_g real NOT NULL,
	aaErr_r real NOT NULL,
	aaErr_i real NOT NULL,
	aaErr_z real NOT NULL,
	bb_u real NOT NULL,
	bb_g real NOT NULL,
	bb_r real NOT NULL,
	bb_i real NOT NULL,
	bb_z real NOT NULL,
	bbErr_u real NOT NULL,
	bbErr_g real NOT NULL,
	bbErr_r real NOT NULL,
	bbErr_i real NOT NULL,
	bbErr_z real NOT NULL,
	cc_u real NOT NULL,
	cc_g real NOT NULL,
	cc_r real NOT NULL,
	cc_i real NOT NULL,
	cc_z real NOT NULL,
	ccErr_u real NOT NULL,
	ccErr_g real NOT NULL,
	ccErr_r real NOT NULL,
	ccErr_i real NOT NULL,
	ccErr_z real NOT NULL,
	kk_u real NOT NULL,
	kk_g real NOT NULL,
	kk_r real NOT NULL,
	kk_i real NOT NULL,
	kk_z real NOT NULL,
	kkErr_u real NOT NULL,
	kkErr_g real NOT NULL,
	kkErr_r real NOT NULL,
	kkErr_i real NOT NULL,
	kkErr_z real NOT NULL,
	framesStatus int NOT NULL,
	rowOffset_u real NOT NULL,
	rowOffset_g real NOT NULL,
	rowOffset_r real NOT NULL,
	rowOffset_i real NOT NULL,
	rowOffset_z real NOT NULL,
	colOffset_u real NOT NULL,
	colOffset_g real NOT NULL,
	colOffset_r real NOT NULL,
	colOffset_i real NOT NULL,
	colOffset_z real NOT NULL,
	saturationLevel_u int NOT NULL,
	saturationLevel_g int NOT NULL,
	saturationLevel_r int NOT NULL,
	saturationLevel_i int NOT NULL,
	saturationLevel_z int NOT NULL,
	nEffPsf_u real NOT NULL,
	nEffPsf_g real NOT NULL,
	nEffPsf_r real NOT NULL,
	nEffPsf_i real NOT NULL,
	nEffPsf_z real NOT NULL,
	skyPsp_u real NOT NULL,
	skyPsp_g real NOT NULL,
	skyPsp_r real NOT NULL,
	skyPsp_i real NOT NULL,
	skyPsp_z real NOT NULL,
	skyFrames_u real NOT NULL,
	skyFrames_g real NOT NULL,
	skyFrames_r real NOT NULL,
	skyFrames_i real NOT NULL,
	skyFrames_z real NOT NULL,
	skyFramesSub_u real NOT NULL,
	skyFramesSub_g real NOT NULL,
	skyFramesSub_r real NOT NULL,
	skyFramesSub_i real NOT NULL,
	skyFramesSub_z real NOT NULL,
	sigPix_u real NOT NULL,
	sigPix_g real NOT NULL,
	sigPix_r real NOT NULL,
	sigPix_i real NOT NULL,
	sigPix_z real NOT NULL,
	deVApCorrection_u real NOT NULL,
	deVApCorrection_g real NOT NULL,
	deVApCorrection_r real NOT NULL,
	deVApCorrection_i real NOT NULL,
	deVApCorrection_z real NOT NULL,
	deVApCorrectionErr_u real NOT NULL,
	deVApCorrectionErr_g real NOT NULL,
	deVApCorrectionErr_r real NOT NULL,
	deVApCorrectionErr_i real NOT NULL,
	deVApCorrectionErr_z real NOT NULL,
	expApCorrection_u real NOT NULL,
	expApCorrection_g real NOT NULL,
	expApCorrection_r real NOT NULL,
	expApCorrection_i real NOT NULL,
	expApCorrection_z real NOT NULL,
	expApCorrectionErr_u real NOT NULL,
	expApCorrectionErr_g real NOT NULL,
	expApCorrectionErr_r real NOT NULL,
	expApCorrectionErr_i real NOT NULL,
	expApCorrectionErr_z real NOT NULL,
	deVModelApCorrection_u real NOT NULL,
	deVModelApCorrection_g real NOT NULL,
	deVModelApCorrection_r real NOT NULL,
	deVModelApCorrection_i real NOT NULL,
	deVModelApCorrection_z real NOT NULL,
	deVModelApCorrectionErr_u real NOT NULL,
	deVModelApCorrectionErr_g real NOT NULL,
	deVModelApCorrectionErr_r real NOT NULL,
	deVModelApCorrectionErr_i real NOT NULL,
	deVModelApCorrectionErr_z real NOT NULL,
	expModelApCorrection_u real NOT NULL,
	expModelApCorrection_g real NOT NULL,
	expModelApCorrection_r real NOT NULL,
	expModelApCorrection_i real NOT NULL,
	expModelApCorrection_z real NOT NULL,
	expModelApCorrectionErr_u real NOT NULL,
	expModelApCorrectionErr_g real NOT NULL,
	expModelApCorrectionErr_r real NOT NULL,
	expModelApCorrectionErr_i real NOT NULL,
	expModelApCorrectionErr_z real NOT NULL,
	medianFiberColor_u real NOT NULL,
	medianFiberColor_g real NOT NULL,
	medianFiberColor_r real NOT NULL,
	medianFiberColor_i real NOT NULL,
	medianFiberColor_z real NOT NULL,
	medianPsfColor_u real NOT NULL,
	medianPsfColor_g real NOT NULL,
	medianPsfColor_r real NOT NULL,
	medianPsfColor_i real NOT NULL,
	medianPsfColor_z real NOT NULL,
	q_u real NOT NULL,
	q_g real NOT NULL,
	q_r real NOT NULL,
	q_i real NOT NULL,
	q_z real NOT NULL,
	u_u real NOT NULL,
	u_g real NOT NULL,
	u_r real NOT NULL,
	u_i real NOT NULL,
	u_z real NOT NULL,
	pspStatus smallint NOT NULL,
	culled int NOT NULL,
	badMask int NOT NULL,
	acceptableMask int NOT NULL,
	goodMask int NOT NULL,
	holeMask int NOT NULL,
	status_u int NOT NULL,
	status_g int NOT NULL,
	status_r int NOT NULL,
	status_i int NOT NULL,
	status_z int NOT NULL,
	sky_u real NOT NULL,
	sky_g real NOT NULL,
	sky_r real NOT NULL,
	sky_i real NOT NULL,
	sky_z real NOT NULL,
	skySig_u real NOT NULL,
	skySig_g real NOT NULL,
	skySig_r real NOT NULL,
	skySig_i real NOT NULL,
	skySig_z real NOT NULL,
	skyErr_u real NOT NULL,
	skyErr_g real NOT NULL,
	skyErr_r real NOT NULL,
	skyErr_i real NOT NULL,
	skyErr_z real NOT NULL,
	skySlope_u real NOT NULL,
	skySlope_g real NOT NULL,
	skySlope_r real NOT NULL,
	skySlope_i real NOT NULL,
	skySlope_z real NOT NULL,
	lbias_u real NOT NULL,
	lbias_g real NOT NULL,
	lbias_r real NOT NULL,
	lbias_i real NOT NULL,
	lbias_z real NOT NULL,
	rbias_u real NOT NULL,
	rbias_g real NOT NULL,
	rbias_r real NOT NULL,
	rbias_i real NOT NULL,
	rbias_z real NOT NULL,
	psfNStar_u int NOT NULL,
	psfNStar_g int NOT NULL,
	psfNStar_r int NOT NULL,
	psfNStar_i int NOT NULL,
	psfNStar_z int NOT NULL,
	psfApCorrectionErr_u real NOT NULL,
	psfApCorrectionErr_g real NOT NULL,
	psfApCorrectionErr_r real NOT NULL,
	psfApCorrectionErr_i real NOT NULL,
	psfApCorrectionErr_z real NOT NULL,
	psfSigma1_u real NOT NULL,
	psfSigma1_g real NOT NULL,
	psfSigma1_r real NOT NULL,
	psfSigma1_i real NOT NULL,
	psfSigma1_z real NOT NULL,
	psfSigma2_u real NOT NULL,
	psfSigma2_g real NOT NULL,
	psfSigma2_r real NOT NULL,
	psfSigma2_i real NOT NULL,
	psfSigma2_z real NOT NULL,
	psfB_u real NOT NULL,
	psfB_g real NOT NULL,
	psfB_r real NOT NULL,
	psfB_i real NOT NULL,
	psfB_z real NOT NULL,
	psfP0_u real NOT NULL,
	psfP0_g real NOT NULL,
	psfP0_r real NOT NULL,
	psfP0_i real NOT NULL,
	psfP0_z real NOT NULL,
	psfBeta_u real NOT NULL,
	psfBeta_g real NOT NULL,
	psfBeta_r real NOT NULL,
	psfBeta_i real NOT NULL,
	psfBeta_z real NOT NULL,
	psfSigmaP_u real NOT NULL,
	psfSigmaP_g real NOT NULL,
	psfSigmaP_r real NOT NULL,
	psfSigmaP_i real NOT NULL,
	psfSigmaP_z real NOT NULL,
	psfWidth_u real NOT NULL,
	psfWidth_g real NOT NULL,
	psfWidth_r real NOT NULL,
	psfWidth_i real NOT NULL,
	psfWidth_z real NOT NULL,
	psfPsfCounts_u real NOT NULL,
	psfPsfCounts_g real NOT NULL,
	psfPsfCounts_r real NOT NULL,
	psfPsfCounts_i real NOT NULL,
	psfPsfCounts_z real NOT NULL,
	psf2GSigma1_u real NOT NULL,
	psf2GSigma1_g real NOT NULL,
	psf2GSigma1_r real NOT NULL,
	psf2GSigma1_i real NOT NULL,
	psf2GSigma1_z real NOT NULL,
	psf2GSigma2_u real NOT NULL,
	psf2GSigma2_g real NOT NULL,
	psf2GSigma2_r real NOT NULL,
	psf2GSigma2_i real NOT NULL,
	psf2GSigma2_z real NOT NULL,
	psf2GB_u real NOT NULL,
	psf2GB_g real NOT NULL,
	psf2GB_r real NOT NULL,
	psf2GB_i real NOT NULL,
	psf2GB_z real NOT NULL,
	psfCounts_u real NOT NULL,
	psfCounts_g real NOT NULL,
	psfCounts_r real NOT NULL,
	psfCounts_i real NOT NULL,
	psfCounts_z real NOT NULL,
	gain_u real NOT NULL,
	gain_g real NOT NULL,
	gain_r real NOT NULL,
	gain_i real NOT NULL,
	gain_z real NOT NULL,
	darkVariance_u real NOT NULL,
	darkVariance_g real NOT NULL,
	darkVariance_r real NOT NULL,
	darkVariance_i real NOT NULL,
	darkVariance_z real NOT NULL,
	nProf_u int NOT NULL,
	nProf_g int NOT NULL,
	nProf_r int NOT NULL,
	nProf_i int NOT NULL,
	nProf_z int NOT NULL,
	loadVersion int NOT NULL,
	segmentID bigint NOT NULL,
 CONSTRAINT pk_Field_fieldID PRIMARY KEY  
(
	fieldID 
)
);

CREATE TABLE FieldProfile(
	bin tinyint NOT NULL,
	band tinyint NOT NULL,
	profMean real NOT NULL,
	profMed real NOT NULL,
	profSig real NOT NULL,
	fieldID bigint NOT NULL,
 CONSTRAINT pk_FieldProfile_fieldID_bin_band PRIMARY KEY  
(
	fieldID ,
	bin ,
	band 
)
);

CREATE TABLE FileGroupMap(
	tableName varchar(128)  NOT NULL,
	tableFileGroup varchar(100)  NOT NULL,
	indexFileGroup varchar(100)  NOT NULL,
	comment varchar(4000)  NULL,
 CONSTRAINT pk_FileGroupMap_tableName PRIMARY KEY  
(
	tableName 
)
);

CREATE TABLE First(
	delta real NOT NULL,
	match int NOT NULL,
	peak real NOT NULL,
	integr real NOT NULL,
	rms real NOT NULL,
	major real NOT NULL,
	minor real NOT NULL,
	pa real NOT NULL,
	id int NOT NULL,
	lambda float NOT NULL,
	eta float NOT NULL,
	objID bigint NOT NULL,
 CONSTRAINT pk_First_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE Frame(
	fieldID bigint NOT NULL,
	zoom int NOT NULL,
	run int NOT NULL,
	rerun int NOT NULL,
	camcol int NOT NULL,
	field int NOT NULL,
	stripe int NOT NULL,
	strip int NOT NULL,
	a float NOT NULL,
	b float NOT NULL,
	c float NOT NULL,
	d float NOT NULL,
	e float NOT NULL,
	f float NOT NULL,
	node float NOT NULL,
	incl float NOT NULL,
	raMin float NOT NULL,
	raMax float NOT NULL,
	decMin float NOT NULL,
	decMax float NOT NULL,
	mu float NOT NULL DEFAULT (0),
	nu float NOT NULL DEFAULT (0),
	ra float NOT NULL DEFAULT (0),
	"dec" float NOT NULL DEFAULT (0),
	cx float NOT NULL DEFAULT (0),
	cy float NOT NULL DEFAULT (0),
	cz float NOT NULL DEFAULT (0),
	htmID bigint NOT NULL DEFAULT (0),
--	img image NOT NULL DEFAULT (0x1111),
 CONSTRAINT pk_Frame_fieldID_zoom PRIMARY KEY  
(
	fieldID ,
	zoom 
)
); 

CREATE TABLE Glossary(
	key varchar(128)  NOT NULL,
	name varchar(128)  NOT NULL,
	ucd varchar(128)  NOT NULL,
	"text" varchar(7200)  NOT NULL,
 CONSTRAINT pk_Glossary_key PRIMARY KEY  
(
	key 
)
);

CREATE TABLE HalfSpace(
	constraintid bigint GENERATED ALWAYS AS IDENTITY NOT NULL,
	regionid bigint NOT NULL,
	convexid bigint NOT NULL,
	x float NOT NULL,
	y float NOT NULL,
	z float NOT NULL,
	c float NOT NULL,
 CONSTRAINT pk_HalfSpace_constraintid PRIMARY KEY  
(
	constraintid 
)
);

CREATE TABLE History(
	id int GENERATED ALWAYS AS IDENTITY NOT NULL,
	filename varchar(128)  NOT NULL,
	date varchar(64)  NOT NULL,
	name varchar(64)  NOT NULL,
	description varchar(7200)  NOT NULL,
 CONSTRAINT pk_History_id PRIMARY KEY  
(
	id 
)
);

CREATE TABLE HoleObj(
	holeID bigint NOT NULL,
	plateID bigint NOT NULL,
	holeType int NOT NULL,
	objType int NOT NULL,
	targetID bigint NOT NULL,
	fiberID smallint NOT NULL,
	xFocal float NOT NULL,
	yFocal float NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_HoleObj_HoleID PRIMARY KEY  
(
	holeID 
)
);

CREATE TABLE IndexMap(
	indexmapid int GENERATED ALWAYS AS IDENTITY NOT NULL,
	code varchar(2)  NOT NULL,
	"type" varchar(32)  NOT NULL,
	tableName varchar(128)  NOT NULL,
	fieldList varchar(1000)  NOT NULL,
	foreignKey varchar(1000)  NOT NULL,
	indexgroup varchar(128)  NOT NULL,
 CONSTRAINT pk_IndexMap_indexmapid PRIMARY KEY  
(
	indexmapid 
)
);

CREATE TABLE Inventory(
	filename varchar(128)  NOT NULL,
	name varchar(128)  NOT NULL,
	"type" varchar(2)  NOT NULL,
 CONSTRAINT pk_Inventory_filename_name PRIMARY KEY  
(
	filename ,
	name 
)
);

CREATE TABLE LoadHistory(
	loadversion int NOT NULL,
	tstart timestamp NOT NULL,
	tend timestamp NOT NULL,
	dbname varchar(64)  NOT NULL,
 CONSTRAINT pk_LoadHistory_loadVersion_tStar PRIMARY KEY  
(
	loadversion ,
	tstart 
)
);

CREATE TABLE Mask(
	maskID bigint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	mask smallint NOT NULL,
	filter tinyint NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	radius float NOT NULL,
	area varchar(4096)  NOT NULL,
	"type" int NOT NULL,
	seeing real NOT NULL,
	cx float NOT NULL DEFAULT (0),
	cy float NOT NULL DEFAULT (0),
	cz float NOT NULL DEFAULT (0),
	htmID bigint NOT NULL DEFAULT (0),
 CONSTRAINT pk_Mask_maskID PRIMARY KEY  
(
	maskID 
)
);

CREATE TABLE MaskedObject(
	objid bigint NOT NULL,
	maskID bigint NOT NULL,
	maskType int NOT NULL,
 CONSTRAINT pk_MaskedObject_objid_maskid PRIMARY KEY  
(
	objid ,
	maskID 
)
);

CREATE TABLE Match(
	objID1 bigint NOT NULL,
	objID2 bigint NOT NULL,
	run1 smallint NOT NULL,
	run2 smallint NOT NULL,
	type1 tinyint NOT NULL,
	type2 tinyint NOT NULL,
	mode1 tinyint NOT NULL,
	mode2 tinyint NOT NULL,
	distance float NOT NULL,
	miss char(1)  NOT NULL,
	matchHead bigint NOT NULL,
 CONSTRAINT pk_Match_objID1_objID2 PRIMARY KEY  
(
	objID1 ,
	objID2 
)
);

CREATE TABLE MatchHead(
	objID bigint NOT NULL,
	averageRa float NOT NULL DEFAULT (0),
	averageDec float NOT NULL DEFAULT (0),
	varRa float NOT NULL DEFAULT (0),
	varDec float NOT NULL DEFAULT (0),
	matchCount tinyint NOT NULL DEFAULT (0),
	missCount tinyint NOT NULL DEFAULT (0),
 CONSTRAINT pk_MatchHead_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE Neighbors(
	objID bigint NOT NULL,
	neighborObjID bigint NOT NULL,
	distance float NOT NULL,
	"type" tinyint NOT NULL,
	neighborType tinyint NOT NULL,
	"mode" tinyint NOT NULL,
	neighborMode tinyint NOT NULL,
 CONSTRAINT pk_Neighbors_objID_NeighborObjID PRIMARY KEY  
(
	objID ,
	neighborObjID 
)
);

CREATE TABLE ObjMask(
	objID bigint NOT NULL,
	size int NOT NULL,
	nspan int NOT NULL,
	row0 int NOT NULL,
	col0 int NOT NULL,
	rmin int NOT NULL,
	rmax int NOT NULL,
	cmin int NOT NULL,
	cmax int NOT NULL,
	npix int NOT NULL,
	span text  NOT NULL,
 CONSTRAINT pk_ObjMask_objID PRIMARY KEY  
(
	objID 
)
); 

CREATE TABLE PartitionMap(
	fileGroupName varchar(100)  NOT NULL,
	size real NOT NULL,
	comment varchar(4000)  NULL,
 CONSTRAINT pk_PartitionMap_fileGroupName PRIMARY KEY  
(
	fileGroupName 
)
);

CREATE TABLE PhotoObjAll(
	objID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	obj smallint NOT NULL,
	"mode" tinyint NOT NULL,
	nChild smallint NOT NULL,
	"type" smallint NOT NULL,
	clean int NOT NULL,
	probPSF real NOT NULL,
	insideMask tinyint NOT NULL,
	flags bigint NOT NULL,
	rowc real NOT NULL,
	rowcErr real NOT NULL,
	colc real NOT NULL,
	colcErr real NOT NULL,
	rowv real NOT NULL,
	rowvErr real NOT NULL,
	colv real NOT NULL,
	colvErr real NOT NULL,
	rowc_u real NOT NULL,
	rowc_g real NOT NULL,
	rowc_r real NOT NULL,
	rowc_i real NOT NULL,
	rowc_z real NOT NULL,
	rowcErr_u real NOT NULL,
	rowcErr_g real NOT NULL,
	rowcErr_r real NOT NULL,
	rowcErr_i real NOT NULL,
	rowcErr_z real NOT NULL,
	colc_u real NOT NULL,
	colc_g real NOT NULL,
	colc_r real NOT NULL,
	colc_i real NOT NULL,
	colc_z real NOT NULL,
	colcErr_u real NOT NULL,
	colcErr_g real NOT NULL,
	colcErr_r real NOT NULL,
	colcErr_i real NOT NULL,
	colcErr_z real NOT NULL,
	sky_u real NOT NULL,
	sky_g real NOT NULL,
	sky_r real NOT NULL,
	sky_i real NOT NULL,
	sky_z real NOT NULL,
	skyErr_u real NOT NULL,
	skyErr_g real NOT NULL,
	skyErr_r real NOT NULL,
	skyErr_i real NOT NULL,
	skyErr_z real NOT NULL,
	psfMag_u real NOT NULL,
	psfMag_g real NOT NULL,
	psfMag_r real NOT NULL,
	psfMag_i real NOT NULL,
	psfMag_z real NOT NULL,
	psfMagErr_u real NOT NULL,
	psfMagErr_g real NOT NULL,
	psfMagErr_r real NOT NULL,
	psfMagErr_i real NOT NULL,
	psfMagErr_z real NOT NULL,
	fiberMag_u real NOT NULL,
	fiberMag_g real NOT NULL,
	fiberMag_r real NOT NULL,
	fiberMag_i real NOT NULL,
	fiberMag_z real NOT NULL,
	fiberMagErr_u real NOT NULL,
	fiberMagErr_g real NOT NULL,
	fiberMagErr_r real NOT NULL,
	fiberMagErr_i real NOT NULL,
	fiberMagErr_z real NOT NULL,
	petroMag_u real NOT NULL,
	petroMag_g real NOT NULL,
	petroMag_r real NOT NULL,
	petroMag_i real NOT NULL,
	petroMag_z real NOT NULL,
	petroMagErr_u real NOT NULL,
	petroMagErr_g real NOT NULL,
	petroMagErr_r real NOT NULL,
	petroMagErr_i real NOT NULL,
	petroMagErr_z real NOT NULL,
	petroRad_u real NOT NULL,
	petroRad_g real NOT NULL,
	petroRad_r real NOT NULL,
	petroRad_i real NOT NULL,
	petroRad_z real NOT NULL,
	petroRadErr_u real NOT NULL,
	petroRadErr_g real NOT NULL,
	petroRadErr_r real NOT NULL,
	petroRadErr_i real NOT NULL,
	petroRadErr_z real NOT NULL,
	petroR50_u real NOT NULL,
	petroR50_g real NOT NULL,
	petroR50_r real NOT NULL,
	petroR50_i real NOT NULL,
	petroR50_z real NOT NULL,
	petroR50Err_u real NOT NULL,
	petroR50Err_g real NOT NULL,
	petroR50Err_r real NOT NULL,
	petroR50Err_i real NOT NULL,
	petroR50Err_z real NOT NULL,
	petroR90_u real NOT NULL,
	petroR90_g real NOT NULL,
	petroR90_r real NOT NULL,
	petroR90_i real NOT NULL,
	petroR90_z real NOT NULL,
	petroR90Err_u real NOT NULL,
	petroR90Err_g real NOT NULL,
	petroR90Err_r real NOT NULL,
	petroR90Err_i real NOT NULL,
	petroR90Err_z real NOT NULL,
	q_u real NOT NULL,
	q_g real NOT NULL,
	q_r real NOT NULL,
	q_i real NOT NULL,
	q_z real NOT NULL,
	qErr_u real NOT NULL,
	qErr_g real NOT NULL,
	qErr_r real NOT NULL,
	qErr_i real NOT NULL,
	qErr_z real NOT NULL,
	u_u real NOT NULL,
	u_g real NOT NULL,
	u_r real NOT NULL,
	u_i real NOT NULL,
	u_z real NOT NULL,
	uErr_u real NOT NULL,
	uErr_g real NOT NULL,
	uErr_r real NOT NULL,
	uErr_i real NOT NULL,
	uErr_z real NOT NULL,
	mE1_u real NOT NULL,
	mE1_g real NOT NULL,
	mE1_r real NOT NULL,
	mE1_i real NOT NULL,
	mE1_z real NOT NULL,
	mE2_u real NOT NULL,
	mE2_g real NOT NULL,
	mE2_r real NOT NULL,
	mE2_i real NOT NULL,
	mE2_z real NOT NULL,
	mE1E1Err_u real NOT NULL,
	mE1E1Err_g real NOT NULL,
	mE1E1Err_r real NOT NULL,
	mE1E1Err_i real NOT NULL,
	mE1E1Err_z real NOT NULL,
	mE1E2Err_u real NOT NULL,
	mE1E2Err_g real NOT NULL,
	mE1E2Err_r real NOT NULL,
	mE1E2Err_i real NOT NULL,
	mE1E2Err_z real NOT NULL,
	mE2E2Err_u real NOT NULL,
	mE2E2Err_g real NOT NULL,
	mE2E2Err_r real NOT NULL,
	mE2E2Err_i real NOT NULL,
	mE2E2Err_z real NOT NULL,
	mRrCc_u real NOT NULL,
	mRrCc_g real NOT NULL,
	mRrCc_r real NOT NULL,
	mRrCc_i real NOT NULL,
	mRrCc_z real NOT NULL,
	mRrCcErr_u real NOT NULL,
	mRrCcErr_g real NOT NULL,
	mRrCcErr_r real NOT NULL,
	mRrCcErr_i real NOT NULL,
	mRrCcErr_z real NOT NULL,
	mCr4_u real NOT NULL,
	mCr4_g real NOT NULL,
	mCr4_r real NOT NULL,
	mCr4_i real NOT NULL,
	mCr4_z real NOT NULL,
	mE1PSF_u real NOT NULL,
	mE1PSF_g real NOT NULL,
	mE1PSF_r real NOT NULL,
	mE1PSF_i real NOT NULL,
	mE1PSF_z real NOT NULL,
	mE2PSF_u real NOT NULL,
	mE2PSF_g real NOT NULL,
	mE2PSF_r real NOT NULL,
	mE2PSF_i real NOT NULL,
	mE2PSF_z real NOT NULL,
	mRrCcPSF_u real NOT NULL,
	mRrCcPSF_g real NOT NULL,
	mRrCcPSF_r real NOT NULL,
	mRrCcPSF_i real NOT NULL,
	mRrCcPSF_z real NOT NULL,
	mCr4PSF_u real NOT NULL,
	mCr4PSF_g real NOT NULL,
	mCr4PSF_r real NOT NULL,
	mCr4PSF_i real NOT NULL,
	mCr4PSF_z real NOT NULL,
	isoRowc_u real NOT NULL,
	isoRowc_g real NOT NULL,
	isoRowc_r real NOT NULL,
	isoRowc_i real NOT NULL,
	isoRowc_z real NOT NULL,
	isoRowcErr_u real NOT NULL,
	isoRowcErr_g real NOT NULL,
	isoRowcErr_r real NOT NULL,
	isoRowcErr_i real NOT NULL,
	isoRowcErr_z real NOT NULL,
	isoRowcGrad_u real NOT NULL,
	isoRowcGrad_g real NOT NULL,
	isoRowcGrad_r real NOT NULL,
	isoRowcGrad_i real NOT NULL,
	isoRowcGrad_z real NOT NULL,
	isoColc_u real NOT NULL,
	isoColc_g real NOT NULL,
	isoColc_r real NOT NULL,
	isoColc_i real NOT NULL,
	isoColc_z real NOT NULL,
	isoColcErr_u real NOT NULL,
	isoColcErr_g real NOT NULL,
	isoColcErr_r real NOT NULL,
	isoColcErr_i real NOT NULL,
	isoColcErr_z real NOT NULL,
	isoColcGrad_u real NOT NULL,
	isoColcGrad_g real NOT NULL,
	isoColcGrad_r real NOT NULL,
	isoColcGrad_i real NOT NULL,
	isoColcGrad_z real NOT NULL,
	isoA_u real NOT NULL,
	isoA_g real NOT NULL,
	isoA_r real NOT NULL,
	isoA_i real NOT NULL,
	isoA_z real NOT NULL,
	isoAErr_u real NOT NULL,
	isoAErr_g real NOT NULL,
	isoAErr_r real NOT NULL,
	isoAErr_i real NOT NULL,
	isoAErr_z real NOT NULL,
	isoB_u real NOT NULL,
	isoB_g real NOT NULL,
	isoB_r real NOT NULL,
	isoB_i real NOT NULL,
	isoB_z real NOT NULL,
	isoBErr_u real NOT NULL,
	isoBErr_g real NOT NULL,
	isoBErr_r real NOT NULL,
	isoBErr_i real NOT NULL,
	isoBErr_z real NOT NULL,
	isoAGrad_u real NOT NULL,
	isoAGrad_g real NOT NULL,
	isoAGrad_r real NOT NULL,
	isoAGrad_i real NOT NULL,
	isoAGrad_z real NOT NULL,
	isoBGrad_u real NOT NULL,
	isoBGrad_g real NOT NULL,
	isoBGrad_r real NOT NULL,
	isoBGrad_i real NOT NULL,
	isoBGrad_z real NOT NULL,
	isoPhi_u real NOT NULL,
	isoPhi_g real NOT NULL,
	isoPhi_r real NOT NULL,
	isoPhi_i real NOT NULL,
	isoPhi_z real NOT NULL,
	isoPhiErr_u real NOT NULL,
	isoPhiErr_g real NOT NULL,
	isoPhiErr_r real NOT NULL,
	isoPhiErr_i real NOT NULL,
	isoPhiErr_z real NOT NULL,
	isoPhiGrad_u real NOT NULL,
	isoPhiGrad_g real NOT NULL,
	isoPhiGrad_r real NOT NULL,
	isoPhiGrad_i real NOT NULL,
	isoPhiGrad_z real NOT NULL,
	deVRad_u real NOT NULL,
	deVRad_g real NOT NULL,
	deVRad_r real NOT NULL,
	deVRad_i real NOT NULL,
	deVRad_z real NOT NULL,
	deVRadErr_u real NOT NULL,
	deVRadErr_g real NOT NULL,
	deVRadErr_r real NOT NULL,
	deVRadErr_i real NOT NULL,
	deVRadErr_z real NOT NULL,
	deVAB_u real NOT NULL,
	deVAB_g real NOT NULL,
	deVAB_r real NOT NULL,
	deVAB_i real NOT NULL,
	deVAB_z real NOT NULL,
	deVABErr_u real NOT NULL,
	deVABErr_g real NOT NULL,
	deVABErr_r real NOT NULL,
	deVABErr_i real NOT NULL,
	deVABErr_z real NOT NULL,
	deVPhi_u real NOT NULL,
	deVPhi_g real NOT NULL,
	deVPhi_r real NOT NULL,
	deVPhi_i real NOT NULL,
	deVPhi_z real NOT NULL,
	deVPhiErr_u real NOT NULL,
	deVPhiErr_g real NOT NULL,
	deVPhiErr_r real NOT NULL,
	deVPhiErr_i real NOT NULL,
	deVPhiErr_z real NOT NULL,
	deVMag_u real NOT NULL,
	deVMag_g real NOT NULL,
	deVMag_r real NOT NULL,
	deVMag_i real NOT NULL,
	deVMag_z real NOT NULL,
	deVMagErr_u real NOT NULL,
	deVMagErr_g real NOT NULL,
	deVMagErr_r real NOT NULL,
	deVMagErr_i real NOT NULL,
	deVMagErr_z real NOT NULL,
	expRad_u real NOT NULL,
	expRad_g real NOT NULL,
	expRad_r real NOT NULL,
	expRad_i real NOT NULL,
	expRad_z real NOT NULL,
	expRadErr_u real NOT NULL,
	expRadErr_g real NOT NULL,
	expRadErr_r real NOT NULL,
	expRadErr_i real NOT NULL,
	expRadErr_z real NOT NULL,
	expAB_u real NOT NULL,
	expAB_g real NOT NULL,
	expAB_r real NOT NULL,
	expAB_i real NOT NULL,
	expAB_z real NOT NULL,
	expABErr_u real NOT NULL,
	expABErr_g real NOT NULL,
	expABErr_r real NOT NULL,
	expABErr_i real NOT NULL,
	expABErr_z real NOT NULL,
	expPhi_u real NOT NULL,
	expPhi_g real NOT NULL,
	expPhi_r real NOT NULL,
	expPhi_i real NOT NULL,
	expPhi_z real NOT NULL,
	expPhiErr_u real NOT NULL,
	expPhiErr_g real NOT NULL,
	expPhiErr_r real NOT NULL,
	expPhiErr_i real NOT NULL,
	expPhiErr_z real NOT NULL,
	expMag_u real NOT NULL,
	expMag_g real NOT NULL,
	expMag_r real NOT NULL,
	expMag_i real NOT NULL,
	expMag_z real NOT NULL,
	expMagErr_u real NOT NULL,
	expMagErr_g real NOT NULL,
	expMagErr_r real NOT NULL,
	expMagErr_i real NOT NULL,
	expMagErr_z real NOT NULL,
	modelMag_u real NOT NULL,
	modelMag_g real NOT NULL,
	modelMag_r real NOT NULL,
	modelMag_i real NOT NULL,
	modelMag_z real NOT NULL,
	modelMagErr_u real NOT NULL,
	modelMagErr_g real NOT NULL,
	modelMagErr_r real NOT NULL,
	modelMagErr_i real NOT NULL,
	modelMagErr_z real NOT NULL,
	texture_u real NOT NULL,
	texture_g real NOT NULL,
	texture_r real NOT NULL,
	texture_i real NOT NULL,
	texture_z real NOT NULL,
	lnLStar_u real NOT NULL,
	lnLStar_g real NOT NULL,
	lnLStar_r real NOT NULL,
	lnLStar_i real NOT NULL,
	lnLStar_z real NOT NULL,
	lnLExp_u real NOT NULL,
	lnLExp_g real NOT NULL,
	lnLExp_r real NOT NULL,
	lnLExp_i real NOT NULL,
	lnLExp_z real NOT NULL,
	lnLDeV_u real NOT NULL,
	lnLDeV_g real NOT NULL,
	lnLDeV_r real NOT NULL,
	lnLDeV_i real NOT NULL,
	lnLDeV_z real NOT NULL,
	fracDeV_u real NOT NULL,
	fracDeV_g real NOT NULL,
	fracDeV_r real NOT NULL,
	fracDeV_i real NOT NULL,
	fracDeV_z real NOT NULL,
	flags_u bigint NOT NULL,
	flags_g bigint NOT NULL,
	flags_r bigint NOT NULL,
	flags_i bigint NOT NULL,
	flags_z bigint NOT NULL,
	type_u int NOT NULL,
	type_g int NOT NULL,
	type_r int NOT NULL,
	type_i int NOT NULL,
	type_z int NOT NULL,
	probPSF_u real NOT NULL,
	probPSF_g real NOT NULL,
	probPSF_r real NOT NULL,
	probPSF_i real NOT NULL,
	probPSF_z real NOT NULL,
	status int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	raErr float NOT NULL,
	decErr float NOT NULL,
	raDecCorr float NOT NULL,
	b float NOT NULL,
	l float NOT NULL,
	offsetRa_u real NOT NULL,
	offsetRa_g real NOT NULL,
	offsetRa_r real NOT NULL,
	offsetRa_i real NOT NULL,
	offsetRa_z real NOT NULL,
	offsetDec_u real NOT NULL,
	offsetDec_g real NOT NULL,
	offsetDec_r real NOT NULL,
	offsetDec_i real NOT NULL,
	offsetDec_z real NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	seguePrimTarget int NOT NULL,
	segueSecTarget int NOT NULL,
	extinction_u real NOT NULL,
	extinction_g real NOT NULL,
	extinction_r real NOT NULL,
	extinction_i real NOT NULL,
	extinction_z real NOT NULL,
	priority int NOT NULL,
	rho real NOT NULL,
	nProf_u int NOT NULL,
	nProf_g int NOT NULL,
	nProf_r int NOT NULL,
	nProf_i int NOT NULL,
	nProf_z int NOT NULL,
	loadVersion int NOT NULL,
	htmID bigint NOT NULL,
	fieldID bigint NOT NULL,
	parentID bigint NOT NULL DEFAULT (0),
	specObjID bigint NOT NULL DEFAULT (0),
	u real NOT NULL DEFAULT (-9999),
	g real NOT NULL DEFAULT (-9999),
	r real NOT NULL DEFAULT (-9999),
	i real NOT NULL DEFAULT (-9999),
	z real NOT NULL DEFAULT (-9999),
	err_u real NOT NULL DEFAULT (-9999),
	err_g real NOT NULL DEFAULT (-9999),
	err_r real NOT NULL DEFAULT (-9999),
	err_i real NOT NULL DEFAULT (-9999),
	err_z real NOT NULL DEFAULT (-9999),
	dered_u real NOT NULL DEFAULT (-9999),
	dered_g real NOT NULL DEFAULT (-9999),
	dered_r real NOT NULL DEFAULT (-9999),
	dered_i real NOT NULL DEFAULT (-9999),
	dered_z real NOT NULL DEFAULT (-9999),
 CONSTRAINT pk_PhotoObjAll_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE PhotoProfile(
	bin tinyint NOT NULL,
	band tinyint NOT NULL,
	profMean real NOT NULL,
	profErr real NOT NULL,
	objID bigint NOT NULL,
 CONSTRAINT pk_PhotoProfile_objID_bin_band PRIMARY KEY  
(
	objID ,
	bin ,
	band 
)
);

CREATE TABLE Photoz(
	pId int NOT NULL,
	rank int NOT NULL,
	version varchar(6)  NOT NULL,
	class int NOT NULL,
	objID bigint NOT NULL,
	chiSq real NOT NULL,
	z real NOT NULL,
	zErr real NOT NULL,
	t real NOT NULL,
	tErr real NOT NULL,
	c_tt real NOT NULL,
	c_tz real NOT NULL,
	c_zz real NOT NULL,
	fitRadius int NOT NULL,
	fitThreshold real NOT NULL,
	quality int NOT NULL,
	dmod real NOT NULL,
	rest_ug real NOT NULL,
	rest_gr real NOT NULL,
	rest_ri real NOT NULL,
	rest_iz real NOT NULL,
	kcorr_u real NOT NULL,
	kcorr_g real NOT NULL,
	kcorr_r real NOT NULL,
	kcorr_i real NOT NULL,
	kcorr_z real NOT NULL,
	absMag_u real NOT NULL,
	absMag_g real NOT NULL,
	absMag_r real NOT NULL,
	absMag_i real NOT NULL,
	absMag_z real NOT NULL,
 CONSTRAINT pk_Photoz_objID_rank_pId PRIMARY KEY  
(
	objID ,
	rank ,
	pId 
)
);

CREATE TABLE Photoz2(
	objid bigint NOT NULL,
	photozcc2 float NOT NULL,
	photozerrcc2 float NOT NULL,
	photozd1 float NOT NULL,
	photozerrd1 float NOT NULL,
	flag tinyint NOT NULL,
 CONSTRAINT pk_Photoz2_objID PRIMARY KEY  
(
	objid 
)
);

CREATE TABLE PlateX(
	plateID bigint NOT NULL,
	spRerun int NOT NULL,
	mjd int NOT NULL,
	plate smallint NOT NULL,
	tile smallint NOT NULL,
	mapMjd int NOT NULL,
	nExp smallint NOT NULL,
	tai real NOT NULL,
	raBoresight float NOT NULL,
	decBoresight float NOT NULL,
	taiHMS varchar(64)  NOT NULL,
	expTime real NOT NULL,
	expTimeB1 real NOT NULL,
	expTimeB2 real NOT NULL,
	expTimeR1 real NOT NULL,
	expTimeR2 real NOT NULL,
	helioRV real NOT NULL,
	ra real NOT NULL,
	"dec" real NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	htmID bigint NOT NULL,
	sn1_0 real NOT NULL,
	sn1_1 real NOT NULL,
	sn1_2 real NOT NULL,
	sn2_0 real NOT NULL,
	sn2_1 real NOT NULL,
	sn2_2 real NOT NULL,
	dateObs varchar(12)  NOT NULL,
	timeSys varchar(8)  NOT NULL,
	quality varchar(12)  NOT NULL,
	name varchar(32)  NOT NULL,
	program varchar(16)  NOT NULL,
	version varchar(64)  NOT NULL,
	observer varchar(64)  NOT NULL,
	camVer varchar(64)  NOT NULL,
	spec2DVer varchar(64)  NOT NULL,
	utilsVer varchar(64)  NOT NULL,
	spec1DVer varchar(64)  NOT NULL,
	readVer varchar(64)  NOT NULL,
	combVer varchar(64)  NOT NULL,
	extinction_u real NOT NULL,
	extinction_g real NOT NULL,
	extinction_r real NOT NULL,
	extinction_i real NOT NULL,
	extinction_z real NOT NULL,
	rOffset1 real NOT NULL,
	rSigma1 real NOT NULL,
	grOff1 real NOT NULL,
	grSigma1 real NOT NULL,
	rOffset2 real NOT NULL,
	rSigma2 real NOT NULL,
	grOff2 real NOT NULL,
	grSigma2 real NOT NULL,
	sfd_used tinyint NOT NULL,
	xygrSig1 real NOT NULL,
	xygrSig2 real NOT NULL,
	mpgrSig1 real NOT NULL,
	mpgrSig2 real NOT NULL,
	mpgrOff1 real NOT NULL,
	mpgrOff2 real NOT NULL,
	isPrimary tinyint NOT NULL,
	cartridgeID smallint NOT NULL,
	plateVersion varchar(32)  NOT NULL,
	haMin real NOT NULL,
	haMax real NOT NULL,
	mjdDesign int NOT NULL,
	theta real NOT NULL,
	fscanVersion varchar(32)  NOT NULL,
	fmapVersion varchar(32)  NOT NULL,
	fscanMode varchar(32)  NOT NULL,
	fscanSpeed int NOT NULL,
	programType int NOT NULL,
	programName varchar(32)  NOT NULL,
	loadVersion int NOT NULL,
	expID blob NULL,
 CONSTRAINT pk_PlateX_plateID PRIMARY KEY  
(
	plateID 
)
);

CREATE TABLE ProfileDefs(
	bin int NOT NULL,
	cell int NOT NULL,
	sinc int NOT NULL,
	rInner float NOT NULL,
	rOuter float NOT NULL,
	aAnn float NOT NULL,
	aDisk float NOT NULL,
 CONSTRAINT pk_ProfileDefs_bin PRIMARY KEY  
(
	bin 
)
);

CREATE TABLE ProperMotions(
	raErr float NOT NULL,
	decErr float NOT NULL,
	raDecCorr float NOT NULL,
	delta real NOT NULL,
	match int NOT NULL,
	pmL real NOT NULL,
	pmB real NOT NULL,
	pmRa real NOT NULL,
	pmDec real NOT NULL,
	pmRaErr real NOT NULL,
	pmDecErr real NOT NULL,
	sigRa real NOT NULL,
	sigDec real NOT NULL,
	nFit int NOT NULL,
	O real NOT NULL,
	E real NOT NULL,
	J real NOT NULL,
	F real NOT NULL,
	N real NOT NULL,
	dist20 real NOT NULL,
	dist22 real NOT NULL,
	objid bigint NOT NULL,
 CONSTRAINT pk_ProperMotions_objID PRIMARY KEY  
(
	objid 
)
);

CREATE TABLE PubHistory(
	name varchar(64)  NOT NULL,
	nrows int NOT NULL,
	tend timestamp NOT NULL,
	loadversion int NOT NULL,
 CONSTRAINT pk_PubHistory_name_loadversion PRIMARY KEY  
(
	name ,
	loadversion 
)
);

CREATE TABLE QsoBest(
	bestObjID bigint NOT NULL,
	headObjID bigint NOT NULL,
	bestRa float NOT NULL,
	bestDec float NOT NULL,
	bestCx float NOT NULL,
	bestCy float NOT NULL,
	bestCz float NOT NULL,
	bestPsfMag_u real NOT NULL,
	bestPsfMag_g real NOT NULL,
	bestPsfMag_r real NOT NULL,
	bestPsfMag_i real NOT NULL,
	bestPsfMag_z real NOT NULL,
	bestPsfMagErr_u real NOT NULL,
	bestPsfMagErr_g real NOT NULL,
	bestPsfMagErr_r real NOT NULL,
	bestPsfMagErr_i real NOT NULL,
	bestPsfMagErr_z real NOT NULL,
	bestExtinction_u real NOT NULL,
	bestExtinction_g real NOT NULL,
	bestExtinction_r real NOT NULL,
	bestExtinction_i real NOT NULL,
	bestExtinction_z real NOT NULL,
	bestType int NOT NULL,
	bestMode int NOT NULL,
	bestFlags bigint NOT NULL,
	bestFlags_u bigint NOT NULL,
	bestFlags_g bigint NOT NULL,
	bestFlags_r bigint NOT NULL,
	bestFlags_i bigint NOT NULL,
	bestFlags_z bigint NOT NULL,
	bestRowC_i real NOT NULL,
	bestColC_i real NOT NULL,
	bestInsideMask int NOT NULL,
	bestPrimTarget int NOT NULL,
	bestPriTargHiZ int NOT NULL,
	bestPriTargLowZ int NOT NULL,
	bestPriTargFirst int NOT NULL,
	bestFieldID bigint NOT NULL,
	bestFieldMjd float NOT NULL,
	bestFieldQuality int NOT NULL,
	bestFieldCulled int NOT NULL,
	bestFirstID int NOT NULL,
	bestFirstPeak float NOT NULL,
	bestRosatID int NOT NULL,
	bestRosatCps float NOT NULL,
	bestMi float NOT NULL,
	BestQsoTargeted tinyint NOT NULL,
 CONSTRAINT pk_QsoBest_bestObjID PRIMARY KEY  
(
	bestObjID 
)
);

CREATE TABLE QsoBunch(
	HeadObjID bigint NOT NULL,
	HeadObjType char(6)  NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	targetObjs int NOT NULL,
	specObjs int NOT NULL,
	bestObjs int NOT NULL,
	targetPrimaries int NOT NULL,
	specPrimaries int NOT NULL,
	bestPrimaries int NOT NULL,
 CONSTRAINT pk_QsoBunch_headObjID PRIMARY KEY  
(
	HeadObjID 
)
);

CREATE TABLE QsoCatalogAll(
	HeadObjID bigint NOT NULL,
	tripleID int GENERATED ALWAYS AS IDENTITY NOT NULL,
	QsoPrimary tinyint NOT NULL DEFAULT (0),
	HeadObjType char(6)  NOT NULL,
	TargetObjID bigint NOT NULL DEFAULT (0),
	SpecObjID bigint NOT NULL DEFAULT (0),
	BestObjID bigint NOT NULL DEFAULT (0),
	TargetQsoTargeted tinyint NOT NULL DEFAULT (0),
	SpecQsoConfirmed tinyint NOT NULL DEFAULT (0),
	SpecQsoUnknown tinyint NOT NULL DEFAULT (0),
	SpecQsoLargeZ tinyint NOT NULL DEFAULT (0),
	SpecQsoTargeted tinyint NOT NULL DEFAULT (0),
	BestQsoTargeted tinyint NOT NULL DEFAULT (0),
	dist_Target_Best float NOT NULL DEFAULT (9999),
	dist_Target_Spec float NOT NULL DEFAULT (9999),
	dist_Best_Spec float NOT NULL DEFAULT (9999),
	psfmag_i_diff float NOT NULL DEFAULT (9999),
	psfmag_g_i_diff float NOT NULL DEFAULT (9999),
 CONSTRAINT pk_QsoCatalogAll_tripleID PRIMARY KEY  
(
	tripleID 
)
);

CREATE TABLE QsoConcordanceAll(
	HeadObjID bigint NOT NULL,
	tripleID int GENERATED ALWAYS AS IDENTITY NOT NULL,
	QsoPrimary tinyint NOT NULL DEFAULT (0),
	TargetObjID bigint NOT NULL DEFAULT (0),
	SpecObjID bigint NOT NULL DEFAULT (0),
	BestObjID bigint NOT NULL DEFAULT (0),
	TargetQsoTargeted tinyint NOT NULL DEFAULT (0),
	SpecQsoConfirmed tinyint NOT NULL DEFAULT (0),
	SpecQsoUnknown tinyint NOT NULL DEFAULT (0),
	SpecQsoLargeZ tinyint NOT NULL DEFAULT (0),
	SpecQsoTargeted tinyint NOT NULL DEFAULT (0),
	BestQsoTargeted tinyint NOT NULL DEFAULT (0),
	dist_Target_Best float NOT NULL DEFAULT (9999),
	dist_Target_Spec float NOT NULL DEFAULT (9999),
	dist_Best_Spec float NOT NULL DEFAULT (9999),
	psfmag_i_diff float NOT NULL DEFAULT (9999),
	psfmag_g_i_diff float NOT NULL DEFAULT (9999),
	SpecRa float NOT NULL,
	SpecDec float NOT NULL,
	SpecCx float NOT NULL,
	SpecCy float NOT NULL,
	SpecCz float NOT NULL,
	SpecZ float NOT NULL,
	SpecZerr real NOT NULL,
	SpecZConf real NOT NULL,
	SpecZStatus smallint NOT NULL,
	SpecZWarning int NOT NULL,
	SpecClass smallint NOT NULL,
	SpecPlate smallint NOT NULL,
	SpecFiberID smallint NOT NULL,
	SpecMjd int NOT NULL,
	SpecSciencePrimary smallint NOT NULL,
	SpecPrimTarget int NOT NULL,
	SpecTargetID bigint NOT NULL,
	SpecTargetObjID bigint NOT NULL,
	SpecBestObjID bigint NOT NULL,
	SpecLineID bigint NOT NULL,
	SpecMaxVelocity real NOT NULL,
	SpecPlateSn1_i float NOT NULL,
	SpecPlateSn2_i float NOT NULL,
	targetRa float NOT NULL,
	targetDec float NOT NULL,
	targetCx float NOT NULL,
	targetCy float NOT NULL,
	targetCz float NOT NULL,
	targetPsfMag_u real NOT NULL,
	targetPsfMag_g real NOT NULL,
	targetPsfMag_r real NOT NULL,
	targetPsfMag_i real NOT NULL,
	targetPsfMag_z real NOT NULL,
	targetPsfMagErr_u real NOT NULL,
	targetPsfMagErr_g real NOT NULL,
	targetPsfMagErr_r real NOT NULL,
	targetPsfMagErr_i real NOT NULL,
	targetPsfMagErr_z real NOT NULL,
	targetExtinction_u real NOT NULL,
	targetExtinction_g real NOT NULL,
	targetExtinction_r real NOT NULL,
	targetExtinction_i real NOT NULL,
	targetExtinction_z real NOT NULL,
	targetType int NOT NULL,
	targetMode int NOT NULL,
	targetStatus int NOT NULL,
	targetFlags bigint NOT NULL,
	targetFlags_u bigint NOT NULL,
	targetFlags_g bigint NOT NULL,
	targetFlags_r bigint NOT NULL,
	targetFlags_i bigint NOT NULL,
	targetFlags_z bigint NOT NULL,
	targetRowC_i real NOT NULL,
	targetColC_i real NOT NULL,
	targetInsideMask int NOT NULL,
	targetPrimTarget int NOT NULL,
	targetPriTargHiZ int NOT NULL,
	targetPriTargLowZ int NOT NULL,
	targetPriTargFirst int NOT NULL,
	targetFieldID bigint NOT NULL,
	targetFieldMjd float NOT NULL,
	targetFieldQuality int NOT NULL,
	targetFieldCulled int NOT NULL,
	targetSectorID bigint NOT NULL,
	targetFirstID int NOT NULL,
	targetFirstPeak float NOT NULL,
	targetRosatID int NOT NULL,
	targetRosatCps float NOT NULL,
	targetMi float NOT NULL,
	targetUniform tinyint NOT NULL,
	bestRa float NOT NULL,
	bestDec float NOT NULL,
	bestCx float NOT NULL,
	bestCy float NOT NULL,
	bestCz float NOT NULL,
	bestPsfMag_u real NOT NULL,
	bestPsfMag_g real NOT NULL,
	bestPsfMag_r real NOT NULL,
	bestPsfMag_i real NOT NULL,
	bestPsfMag_z real NOT NULL,
	bestPsfMagErr_u real NOT NULL,
	bestPsfMagErr_g real NOT NULL,
	bestPsfMagErr_r real NOT NULL,
	bestPsfMagErr_i real NOT NULL,
	bestPsfMagErr_z real NOT NULL,
	bestExtinction_u real NOT NULL,
	bestExtinction_g real NOT NULL,
	bestExtinction_r real NOT NULL,
	bestExtinction_i real NOT NULL,
	bestExtinction_z real NOT NULL,
	bestType int NOT NULL,
	bestMode int NOT NULL,
	bestFlags bigint NOT NULL,
	bestFlags_u bigint NOT NULL,
	bestFlags_g bigint NOT NULL,
	bestFlags_r bigint NOT NULL,
	bestFlags_i bigint NOT NULL,
	bestFlags_z bigint NOT NULL,
	bestRowC_i real NOT NULL,
	bestColC_i real NOT NULL,
	bestInsideMask int NOT NULL,
	bestPrimTarget int NOT NULL,
	bestPriTargHiZ int NOT NULL,
	bestPriTargLowZ int NOT NULL,
	bestPriTargFirst int NOT NULL,
	bestFieldID bigint NOT NULL,
	bestFieldMjd float NOT NULL,
	bestFieldQuality int NOT NULL,
	bestFieldCulled int NOT NULL,
	bestFirstID int NOT NULL,
	bestFirstPeak float NOT NULL,
	bestRosatID int NOT NULL,
	bestRosatCps float NOT NULL,
	bestMi float NOT NULL,
 CONSTRAINT pk_QsoConcordanceAll_tripleID PRIMARY KEY  
(
	tripleID 
)
);

CREATE TABLE QsoSpec(
	SpecObjID bigint NOT NULL,
	HeadObjID bigint NOT NULL,
	SpecRa float NOT NULL,
	SpecDec float NOT NULL,
	SpecCx float NOT NULL,
	SpecCy float NOT NULL,
	SpecCz float NOT NULL,
	SpecZ float NOT NULL,
	SpecZerr real NOT NULL,
	SpecZConf real NOT NULL,
	SpecZStatus smallint NOT NULL,
	SpecZWarning int NOT NULL,
	SpecClass smallint NOT NULL,
	SpecPlate smallint NOT NULL,
	SpecFiberID smallint NOT NULL,
	SpecMjd int NOT NULL,
	SpecSciencePrimary smallint NOT NULL,
	SpecPrimTarget int NOT NULL,
	SpecLineID bigint NOT NULL,
	SpecMaxVelocity real NOT NULL,
	SpecQsoConfirmed tinyint NOT NULL,
	SpecBestObjID bigint NOT NULL,
	SpecTargetObjID bigint NOT NULL,
	SpecTargetID bigint NOT NULL,
	SpecPlateSn1_i float NOT NULL,
	SpecPlateSn2_i float NOT NULL,
 CONSTRAINT pk_QsoSpec_specObjID PRIMARY KEY  
(
	SpecObjID 
)
);

CREATE TABLE QsoTarget(
	targetObjID bigint NOT NULL,
	headObjID bigint NOT NULL,
	targetRa float NOT NULL,
	targetDec float NOT NULL,
	targetCx float NOT NULL,
	targetCy float NOT NULL,
	targetCz float NOT NULL,
	targetPsfMag_u real NOT NULL,
	targetPsfMag_g real NOT NULL,
	targetPsfMag_r real NOT NULL,
	targetPsfMag_i real NOT NULL,
	targetPsfMag_z real NOT NULL,
	targetPsfMagErr_u real NOT NULL,
	targetPsfMagErr_g real NOT NULL,
	targetPsfMagErr_r real NOT NULL,
	targetPsfMagErr_i real NOT NULL,
	targetPsfMagErr_z real NOT NULL,
	targetExtinction_u real NOT NULL,
	targetExtinction_g real NOT NULL,
	targetExtinction_r real NOT NULL,
	targetExtinction_i real NOT NULL,
	targetExtinction_z real NOT NULL,
	targetType int NOT NULL,
	targetMode int NOT NULL,
	targetStatus int NOT NULL,
	targetFlags bigint NOT NULL,
	targetFlags_u bigint NOT NULL,
	targetFlags_g bigint NOT NULL,
	targetFlags_r bigint NOT NULL,
	targetFlags_i bigint NOT NULL,
	targetFlags_z bigint NOT NULL,
	targetRowC_i real NOT NULL,
	targetColC_i real NOT NULL,
	targetInsideMask int NOT NULL,
	targetPrimTarget int NOT NULL,
	targetPriTargHiZ int NOT NULL,
	targetPriTargLowZ int NOT NULL,
	targetPriTargFirst int NOT NULL,
	targetFieldID bigint NOT NULL,
	targetFieldMjd float NOT NULL,
	targetFieldQuality int NOT NULL,
	targetFieldCulled int NOT NULL,
	targetSectorID bigint NOT NULL,
	targetFirstID int NOT NULL,
	targetFirstPeak float NOT NULL,
	targetRosatID int NOT NULL,
	targetRosatCps float NOT NULL,
	targetMi float NOT NULL,
	TargetQsoTargeted tinyint NOT NULL,
	targetUniform tinyint NOT NULL,
 CONSTRAINT pk_QsoTarget_targetObjID PRIMARY KEY  
(
	targetObjID 
)
);

CREATE TABLE QueryResults(
	query varchar(10)  NOT NULL,
	cpu_sec float NOT NULL,
	elapsed_time float NOT NULL,
	physical_IO float NOT NULL,
	row_count bigint NOT NULL,
	time timestamp NOT NULL DEFAULT (localtimestamp),
	comment varchar(100)  NULL DEFAULT (''),
 CONSTRAINT pk_QueryResults_query_time PRIMARY KEY  
(
	query ,
	time 
)
);

CREATE TABLE RC3(
	name varchar(20)  NOT NULL,
	aliases varchar(20)  NULL,
	PGC_name varchar(10)  NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	good_position int NOT NULL,
	galactic_l float NULL,
	galactic_b float NULL,
	superGalactic_l float NULL,
	superGalactic_b float NULL,
	PosAngle float NULL,
	rc2_type char(7)  NULL,
	rc2_typeSource char(6)  NULL,
	T_type float NULL,
	T_typeErr float NULL,
	LC_rc2 float NULL,
	LC_rc2Err float NULL,
	n_L float NULL,
	B_T float NULL,
	B_TErr float NULL,
	B_Tsource char(1)  NULL,
	B_T0 float NULL,
	M_B float NULL,
	M_BErr float NULL,
	M_FIR float NULL,
	M_21cm float NULL,
	M_21cmErr float NULL,
	BV_T float NULL,
	BV_TErr float NULL,
	BV_T0 float NULL,
	BV_e float NULL,
	BV_eErr float NULL,
	UB_T float NULL,
	UB_TErr float NULL,
	UB_T0 float NULL,
	UB_e float NULL,
	UB_eErr float NULL,
	lgD_25 float NULL,
	lgD_25Err float NULL,
	lgD_0 float NULL,
	lgR_25 float NULL,
	lgR_25Err float NULL,
	logA_e float NULL,
	logA_eErr float NULL,
	m_e float NULL,
	m_eErr float NULL,
	m_25 float NULL,
	m_25Err float NULL,
	A_B float NULL,
	A_HI_self float NULL,
	A_B_int float NULL,
	W_20 float NULL,
	W_20Err float NULL,
	W_50 float NULL,
	W_50Err float NULL,
	HI float NULL,
	V_21cm float NULL,
	V_21cmErr float NULL,
	V_opt float NULL,
	V_optErr float NULL,
	V_GSR float NULL,
	V_3K float NULL,
	htmID bigint NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	objId bigint NOT NULL,
 CONSTRAINT pk_RC3_objID PRIMARY KEY  
(
	objId 
)
);

CREATE TABLE RecentQueries(
	ipAddr varchar(30)  NOT NULL,
	lastQueryTime timestamp NOT NULL,
 CONSTRAINT pk_RecentQueries_ipAddr_lastQuer PRIMARY KEY  
(
	ipAddr ,
	lastQueryTime 
)
);

CREATE TABLE Region(
	regionid bigint GENERATED ALWAYS AS IDENTITY NOT NULL,
	id bigint NOT NULL,
	"type" varchar(16)  NOT NULL,
	comment varchar(1024)  NOT NULL,
	ismask tinyint NOT NULL,
	area float NOT NULL,
	regionString text  NULL,
	regionBinary blob NULL,
 CONSTRAINT pk_Region_regionId PRIMARY KEY  
(
	regionid 
)
);

CREATE TABLE Region2Box(
	regionType varchar(16)  NOT NULL,
	id bigint NOT NULL,
	boxType varchar(16)  NOT NULL,
	boxid bigint NOT NULL,
 CONSTRAINT pk_Region2Box_regionType_id_boxI PRIMARY KEY  
(
	regionType ,
	id ,
	boxid 
)
);

CREATE TABLE RegionArcs(
	arcid int GENERATED ALWAYS AS IDENTITY NOT NULL,
	regionid bigint NOT NULL,
	convexid bigint NOT NULL,
	constraintid bigint NOT NULL,
	patch int NOT NULL,
	state int NOT NULL,
	draw int NOT NULL,
	ra1 float NOT NULL,
	dec1 float NOT NULL,
	ra2 float NOT NULL,
	dec2 float NOT NULL,
	x float NOT NULL,
	y float NOT NULL,
	z float NOT NULL,
	c float NOT NULL,
	length float NOT NULL DEFAULT (0.0),
 CONSTRAINT pk_RegionArcs_regionId_convexid_ PRIMARY KEY  
(
	regionid ,
	convexid ,
	arcid 
)
);

CREATE TABLE RegionPatch(
	regionid bigint NOT NULL,
	convexid bigint NOT NULL,
	patchid int NOT NULL,
	"type" varchar(16)  NOT NULL,
	radius float NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	x float NOT NULL,
	y float NOT NULL,
	z float NOT NULL,
	c float NOT NULL,
	htmid bigint NOT NULL,
	area float NOT NULL,
	convexString text  NULL,
 CONSTRAINT pk_RegionPatch_regionid_convexid PRIMARY KEY  
(
	regionid ,
	convexid ,
	patchid 
)
);

CREATE TABLE Rmatrix(
	"mode" varchar(16)  NOT NULL,
	row smallint NOT NULL,
	x float NOT NULL,
	y float NOT NULL,
	z float NOT NULL,
 CONSTRAINT pk_RMatrix_mode_row PRIMARY KEY  
(
	"mode" ,
	row 
)
);

CREATE TABLE Rosat(
	delta real NOT NULL,
	match int NOT NULL,
	cps real NOT NULL,
	hard1 real NOT NULL,
	hard2 real NOT NULL,
	extent real NOT NULL,
	exposure real NOT NULL,
	posErr real NOT NULL,
	cpsErr real NOT NULL,
	hard1Err real NOT NULL,
	hard2Err real NOT NULL,
	extentLike real NOT NULL,
	detectLike real NOT NULL,
	objID bigint NOT NULL,
 CONSTRAINT pk_Rosat_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE RunQA(
	fieldID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	first tinyint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	fieldQall tinyint NOT NULL,
	opdbq tinyint NOT NULL,
	appsfq tinyint NOT NULL,
	pcmedq tinyint NOT NULL,
	pcrmsq tinyint NOT NULL,
	PSFwcondq tinyint NOT NULL,
	pc_s real NOT NULL,
	pc_w real NOT NULL,
	pc_x real NOT NULL,
	pc_y real NOT NULL,
	rmsPC_s real NOT NULL,
	rmsPC_w real NOT NULL,
	rmsPC_x real NOT NULL,
	rmsPC_y real NOT NULL,
	medAp7mPSF_u real NOT NULL,
	medAp7mPSF_g real NOT NULL,
	medAp7mPSF_r real NOT NULL,
	medAp7mPSF_i real NOT NULL,
	medAp7mPSF_z real NOT NULL,
	rmsAp7mPSF_u real NOT NULL,
	rmsAp7mPSF_g real NOT NULL,
	rmsAp7mPSF_r real NOT NULL,
	rmsAp7mPSF_i real NOT NULL,
	rmsAp7mPSF_z real NOT NULL,
	seeing_u real NOT NULL,
	seeing_g real NOT NULL,
	seeing_r real NOT NULL,
	seeing_i real NOT NULL,
	seeing_z real NOT NULL,
 CONSTRAINT pk_RunQA_fieldID PRIMARY KEY  
(
	fieldID 
)
);

CREATE TABLE RunShift(
	run int NOT NULL,
	shift float NOT NULL,
 CONSTRAINT pk_RunShift_run PRIMARY KEY  
(
	run 
)
);

CREATE TABLE SDSSConstants(
	name varchar(32)  NOT NULL,
	value float NOT NULL,
	unit varchar(32)  NOT NULL,
	description varchar(2000)  NOT NULL,
 CONSTRAINT pk_SDSSConstants_name PRIMARY KEY  
(
	name 
)
);

CREATE TABLE Sector(
	regionID bigint NOT NULL,
	nTiles int NOT NULL,
	tiles varchar(256)  NOT NULL,
	targetVersion varchar(64)  NOT NULL,
	area real NOT NULL,
 CONSTRAINT pk_Sector_regionId PRIMARY KEY  
(
	regionID 
)
);

CREATE TABLE Sector2Tile(
	regionID bigint NOT NULL,
	"type" varchar(16)  NOT NULL,
	tile smallint NOT NULL,
	isMask int NOT NULL,
 CONSTRAINT pk_Sector2Tile_regionId_tile PRIMARY KEY  
(
	regionID ,
	tile 
)
);

CREATE TABLE Segment(
	segmentID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	run smallint NOT NULL,
	camCol tinyint NOT NULL,
	rerun smallint NOT NULL,
	field0 int NOT NULL,
	nFields int NOT NULL,
	dscale int NOT NULL,
	chunkID bigint NOT NULL,
	startMu int NOT NULL,
	endMu int NOT NULL,
	stripe int NOT NULL,
	strip smallint NOT NULL,
	status smallint NOT NULL,
	resolved smallint NOT NULL,
	exported smallint NOT NULL,
	families smallint NOT NULL,
	equinox float NOT NULL,
	node float NOT NULL,
	incl float NOT NULL,
	cObs float NOT NULL,
	tracking float NOT NULL,
	raMin float NOT NULL,
	raMax float NOT NULL,
	decMin float NOT NULL,
	decMax float NOT NULL,
	lMin float NOT NULL,
	lMax float NOT NULL,
	bMin float NOT NULL,
	bMax float NOT NULL,
	lambdaMin float NOT NULL,
	lambdaMax float NOT NULL,
	etaMin float NOT NULL,
	etaMax float NOT NULL,
	photoId varchar(32)  NOT NULL,
	photoVersion varchar(32)  NOT NULL,
	targetAstroId varchar(32)  NOT NULL,
	targetAstroVersion varchar(32)  NOT NULL,
	exportAstroId varchar(32)  NOT NULL,
	exportAstroVersion varchar(32)  NOT NULL,
	targetFCalibId varchar(32)  NOT NULL,
	targetFCalibVersion varchar(32)  NOT NULL,
	exportFCalibID varchar(32)  NOT NULL,
	exportFCalibVersion varchar(32)  NOT NULL,
	loaderVersion varchar(32)  NOT NULL,
	objectSource varchar(32)  NOT NULL,
	targetSource varchar(32)  NOT NULL,
	targetVersion varchar(32)  NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_Segment_segmentID PRIMARY KEY  
(
	segmentID 
)
);

CREATE TABLE SiteConstants(
	name varchar(64)  NOT NULL,
	value varchar(64)  NOT NULL,
	comment varchar(256)  NOT NULL,
 CONSTRAINT pk_SiteConstants_name PRIMARY KEY  
(
	name 
)
);

CREATE TABLE SiteDBs(
	dbname varchar(64)  NOT NULL,
	description varchar(128)  NOT NULL,
	active char(1)  NOT NULL
);

CREATE TABLE SiteDiagnostics(
	name varchar(64)  NOT NULL,
	"type" varchar(8)  NOT NULL,
	count bigint NULL,
 CONSTRAINT pk_SiteDiagnostics_name PRIMARY KEY  
(
	name 
)
);

CREATE TABLE SpecLineAll(
	specLineID bigint NOT NULL,
	wave real NOT NULL,
	waveErr real NOT NULL,
	waveMin real NOT NULL,
	waveMax real NOT NULL,
	sigma real NOT NULL,
	sigmaErr real NOT NULL,
	sigmaMin real NOT NULL,
	sigmaMax real NOT NULL,
	height real NOT NULL,
	heightErr real NOT NULL,
	continuum real NOT NULL,
	ew real NOT NULL,
	ewErr real NOT NULL,
	ewMin real NOT NULL,
	specIndex real NOT NULL,
	nSigma real NOT NULL,
	chisq real NOT NULL,
	nu smallint NOT NULL,
	restWave real NOT NULL,
	lineID int NOT NULL,
	weight real NOT NULL,
	z real NOT NULL,
	zErr real NOT NULL,
	lineMask int NOT NULL,
	category smallint NOT NULL,
	specobjID bigint NOT NULL,
 CONSTRAINT pk_SpecLineAll_specLineID PRIMARY KEY  
(
	specLineID 
)
);

CREATE TABLE SpecLineIndex(
	specLineIndexID bigint NOT NULL,
	name varchar(16)  NOT NULL,
	ew real NOT NULL,
	ewErr real NOT NULL,
	mag real NOT NULL,
	magErr real NOT NULL,
	waveMin real NOT NULL,
	waveMax real NOT NULL,
	z real NOT NULL,
	sn real NOT NULL,
	specobjID bigint NOT NULL,
 CONSTRAINT pk_SpecLineIndex_specLineIndexID PRIMARY KEY  
(
	specLineIndexID 
)
);

CREATE TABLE SpecObjAll(
	specObjID bigint NOT NULL,
	mjd int NOT NULL,
	plate smallint NOT NULL,
	tile smallint NOT NULL,
	xFocal float NOT NULL,
	yFocal float NOT NULL,
	fiberID smallint NOT NULL,
	z real NOT NULL,
	zErr real NOT NULL,
	zConf real NOT NULL,
	zStatus smallint NOT NULL,
	specClass smallint NOT NULL,
	zWarning int NOT NULL,
	velDisp real NOT NULL,
	velDispErr real NOT NULL,
	eCoeff_0 real NOT NULL,
	eCoeff_1 real NOT NULL,
	eCoeff_2 real NOT NULL,
	eCoeff_3 real NOT NULL,
	eCoeff_4 real NOT NULL,
	eClass real NOT NULL,
	nGood int NOT NULL,
	sn_0 real NOT NULL,
	sn_1 real NOT NULL,
	sn_2 real NOT NULL,
	mag_0 real NOT NULL,
	mag_1 real NOT NULL,
	mag_2 real NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	htmID bigint NOT NULL,
	fiberMag_u real NOT NULL,
	fiberMag_g real NOT NULL,
	fiberMag_r real NOT NULL,
	fiberMag_i real NOT NULL,
	fiberMag_z real NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	seguePrimTarget int NOT NULL,
	segueSecTarget int NOT NULL,
	otherPrimTarget int NOT NULL,
	otherSecTarget int NOT NULL,
	pixMin smallint NOT NULL,
	pixMax smallint NOT NULL,
	sci_sn real NOT NULL,
	smear_sn real NOT NULL,
	sm_leg_0 real NOT NULL,
	sm_leg_1 real NOT NULL,
	sm_leg_2 real NOT NULL,
	sciencePrimary smallint NOT NULL,
	loadVersion int NOT NULL,
	plateID bigint NOT NULL,
	spectrographID smallint NOT NULL,
	throughput int NOT NULL,
	objType int NOT NULL,
	objTypeName varchar(32)  NOT NULL,
	targetID bigint NOT NULL,
	targetObjID bigint NOT NULL,
	bestObjID bigint NOT NULL,
--	img image NOT NULL,
 CONSTRAINT pk_SpecObjAll_specObjID PRIMARY KEY  
(
	specObjID 
)
); 

CREATE TABLE SpecPhotoAll(
	specObjID bigint NOT NULL,
	mjd int NOT NULL,
	plate smallint NOT NULL,
	tile smallint NOT NULL,
	fiberID smallint NOT NULL,
	z real NOT NULL,
	zErr real NOT NULL,
	zConf real NOT NULL,
	zStatus smallint NOT NULL,
	specClass smallint NOT NULL,
	zWarning int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	htmID bigint NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	sciencePrimary smallint NOT NULL,
	plateID bigint NOT NULL,
	objType int NOT NULL,
	targetID bigint NOT NULL,
	targetObjID bigint NOT NULL,
	targetMode tinyint NOT NULL,
	objID bigint NULL,
	skyVersion int NULL,
	run int NULL,
	rerun int NULL,
	camcol int NULL,
	field int NULL,
	obj int NULL,
	"mode" int NULL,
	nChild int NULL,
	"type" int NULL,
	flags bigint NULL,
	psfMag_u real NULL,
	psfMag_g real NULL,
	psfMag_r real NULL,
	psfMag_i real NULL,
	psfMag_z real NULL,
	psfMagErr_u real NULL,
	psfMagErr_g real NULL,
	psfMagErr_r real NULL,
	psfMagErr_i real NULL,
	psfMagErr_z real NULL,
	fiberMag_u real NULL,
	fiberMag_g real NULL,
	fiberMag_r real NULL,
	fiberMag_i real NULL,
	fiberMag_z real NULL,
	fiberMagErr_u real NULL,
	fiberMagErr_g real NULL,
	fiberMagErr_r real NULL,
	fiberMagErr_i real NULL,
	fiberMagErr_z real NULL,
	petroMag_u real NULL,
	petroMag_g real NULL,
	petroMag_r real NULL,
	petroMag_i real NULL,
	petroMag_z real NULL,
	petroMagErr_u real NULL,
	petroMagErr_g real NULL,
	petroMagErr_r real NULL,
	petroMagErr_i real NULL,
	petroMagErr_z real NULL,
	modelMag_u real NULL,
	modelMag_g real NULL,
	modelMag_r real NULL,
	modelMag_i real NULL,
	modelMag_z real NULL,
	modelMagErr_u real NULL,
	modelMagErr_g real NULL,
	modelMagErr_r real NULL,
	modelMagErr_i real NULL,
	modelMagErr_z real NULL,
	mRrCc_r real NULL,
	mRrCcErr_r real NULL,
	status int NULL,
	photoRa float NULL,
	photoDec float NULL,
	extinction_u real NULL,
	extinction_g real NULL,
	extinction_r real NULL,
	extinction_i real NULL,
	extinction_z real NULL,
	bestPrimTarget int NULL,
	bestSecTarget int NULL,
	priority int NULL,
	fieldID bigint NULL,
	dered_u real NULL,
	dered_g real NULL,
	dered_r real NULL,
	dered_i real NULL,
	dered_z real NULL,
	size real NULL,
	tileRun smallint NULL,
	tiPriority int NULL,
	tiMask int NULL,
	collisionGroupID int NULL,
 CONSTRAINT pk_SpecPhotoAll_specObjID PRIMARY KEY  
(
	specObjID 
)
);

CREATE TABLE sppLines(
	specobjid bigint NOT NULL,
	plate int NULL,
	mjd int NULL,
	fiberid int NULL,
	H8w3 real NULL,
	H8w3cont real NULL,
	H8w3err real NULL,
	H8w3mask tinyint NULL,
	H8w12 real NULL,
	H8w12cont real NULL,
	H8w12err real NULL,
	H8w12mask tinyint NULL,
	H8w24 real NULL,
	H8w24cont real NULL,
	H8w24err real NULL,
	H8w24mask tinyint NULL,
	H8w48 real NULL,
	H8w48cont real NULL,
	H8w48err real NULL,
	H8w48mask tinyint NULL,
	KPw12 real NULL,
	KPw12cont real NULL,
	KPw12err real NULL,
	KPw12mask tinyint NULL,
	KPw18 real NULL,
	KPw18cont real NULL,
	KPw18err real NULL,
	KPw18mask tinyint NULL,
	KPw6 real NULL,
	KPw6cont real NULL,
	KPw6err real NULL,
	KPw6mask tinyint NULL,
	CaIIK real NULL,
	CaIIKcont real NULL,
	CaIIKerr real NULL,
	CaIIKmask tinyint NULL,
	CaIIHKp real NULL,
	CaIIHKpcont real NULL,
	CaIIHKperr real NULL,
	CaIIHKpmask tinyint NULL,
	Heps real NULL,
	Hepscont real NULL,
	Hepserr real NULL,
	Hepsmask tinyint NULL,
	KPw16 real NULL,
	KPw16cont real NULL,
	KPw16err real NULL,
	KPw16mask tinyint NULL,
	Sr real NULL,
	Srcont real NULL,
	Srerr real NULL,
	Srmask tinyint NULL,
	HeI real NULL,
	HeIcont real NULL,
	HeIerr real NULL,
	HeImask tinyint NULL,
	Hdeltaw12 real NULL,
	Hdeltaw12cont real NULL,
	Hdeltaw12err real NULL,
	Hdeltaw12mask tinyint NULL,
	Hdeltaw24 real NULL,
	Hdeltaw24cont real NULL,
	Hdeltaw24err real NULL,
	Hdeltaw24mask tinyint NULL,
	Hdeltaw48 real NULL,
	Hdeltaw48cont real NULL,
	Hdeltaw48err real NULL,
	Hdeltaw48mask tinyint NULL,
	Hdelta real NULL,
	Hdeltacont real NULL,
	Hdeltaerr real NULL,
	Hdeltamask tinyint NULL,
	CaI real NULL,
	CaIcont real NULL,
	CaIerr real NULL,
	CaImask tinyint NULL,
	CaIw12 real NULL,
	CaIw12cont real NULL,
	CaIw12err real NULL,
	CaIw12mask tinyint NULL,
	CaIw24 real NULL,
	CaIw24cont real NULL,
	CaIw24err real NULL,
	CaIw24mask tinyint NULL,
	CaIw6 real NULL,
	CaIw6cont real NULL,
	CaIw6err real NULL,
	CaIw6mask tinyint NULL,
	G real NULL,
	Gcont real NULL,
	Gerr real NULL,
	Gmask tinyint NULL,
	Hgammaw12 real NULL,
	Hgammaw12cont real NULL,
	Hgammaw12err real NULL,
	Hgammaw12mask tinyint NULL,
	Hgammaw24 real NULL,
	Hgammaw24cont real NULL,
	Hgammaw24err real NULL,
	Hgammaw24mask tinyint NULL,
	Hgammaw48 real NULL,
	Hgammaw48cont real NULL,
	Hgammaw48err real NULL,
	Hgammaw48mask tinyint NULL,
	Hgamma real NULL,
	Hgammacont real NULL,
	Hgammaerr real NULL,
	Hgammamask tinyint NULL,
	HeIa real NULL,
	HeIacont real NULL,
	HeIaerr real NULL,
	HeIamask tinyint NULL,
	G_blue real NULL,
	G_bluecont real NULL,
	G_blueerr real NULL,
	G_bluemask tinyint NULL,
	G_whole real NULL,
	G_wholecont real NULL,
	G_wholeerr real NULL,
	G_wholemask tinyint NULL,
	Ba real NULL,
	Bacont real NULL,
	Baerr real NULL,
	Bamask tinyint NULL,
	C12C13C real NULL,
	C12C13Ccont real NULL,
	C12C13Cerr real NULL,
	C12C13Cmask tinyint NULL,
	CC12 real NULL,
	CC12cont real NULL,
	CC12err real NULL,
	CC12mask tinyint NULL,
	metal1 real NULL,
	metal1cont real NULL,
	metal1err real NULL,
	metal1mask tinyint NULL,
	Hbetaw12 real NULL,
	Hbetaw12cont real NULL,
	Hbetaw12err real NULL,
	Hbetaw12mask tinyint NULL,
	Hbetaw24 real NULL,
	Hbetaw24cont real NULL,
	Hbetaw24err real NULL,
	Hbetaw24mask tinyint NULL,
	Hbetaw48 real NULL,
	Hbetaw48cont real NULL,
	Hbetaw48err real NULL,
	Hbetaw48mask tinyint NULL,
	Hbeta real NULL,
	Hbetacont real NULL,
	Hbetaerr real NULL,
	Hbetamask tinyint NULL,
	C2 real NULL,
	C2cont real NULL,
	C2err real NULL,
	C2mask tinyint NULL,
	C2pMgI real NULL,
	C2pMgIcont real NULL,
	C2pMgIerr real NULL,
	C2pMgImask tinyint NULL,
	MgHpMgIpC2 real NULL,
	MgHpMgIpC2cont real NULL,
	MgHpMgIpC2err real NULL,
	MgHpMgIpC2mask tinyint NULL,
	MgHpMgI real NULL,
	MgHpMgIcont real NULL,
	MgHpMgIerr real NULL,
	MgHpMgImask tinyint NULL,
	MgH real NULL,
	MgHcont real NULL,
	MgHerr real NULL,
	MgHmask tinyint NULL,
	CrI real NULL,
	CrIcont real NULL,
	CrIerr real NULL,
	CrImask tinyint NULL,
	MgIpFeII real NULL,
	MgIpFeIIcont real NULL,
	MgIpFeIIerr real NULL,
	MgIpFeIImask tinyint NULL,
	MgI real NULL,
	MgIcont real NULL,
	MgIerr real NULL,
	MgImask tinyint NULL,
	MgIa real NULL,
	MgIacont real NULL,
	MgIaerr real NULL,
	MgIamask tinyint NULL,
	MgIb real NULL,
	MgIbcont real NULL,
	MgIberr real NULL,
	MgIbmask tinyint NULL,
	MgIc real NULL,
	MgIccont real NULL,
	MgIcerr real NULL,
	MgIcmask tinyint NULL,
	NaI real NULL,
	NaIcont real NULL,
	NaIerr real NULL,
	NaImask tinyint NULL,
	Naw12 real NULL,
	Naw12cont real NULL,
	Naw12err real NULL,
	Naw12mask tinyint NULL,
	Naw24 real NULL,
	Naw24cont real NULL,
	Naw24err real NULL,
	Naw24mask tinyint NULL,
	Halphaw12 real NULL,
	Halphaw12cont real NULL,
	Halphaw12err real NULL,
	Halphaw12mask tinyint NULL,
	Halphaw24 real NULL,
	Halphaw24cont real NULL,
	Halphaw24err real NULL,
	Halphaw24mask tinyint NULL,
	Halphaw48 real NULL,
	Halphaw48cont real NULL,
	Halphaw48err real NULL,
	Halphaw48mask tinyint NULL,
	Halphaw70 real NULL,
	Halphaw70cont real NULL,
	Halphaw70err real NULL,
	Halphaw70mask tinyint NULL,
	CaH real NULL,
	CaHcont real NULL,
	CaHerr real NULL,
	CaHmask tinyint NULL,
	TiO real NULL,
	TiOcont real NULL,
	TiOerr real NULL,
	TiOmask tinyint NULL,
	CN real NULL,
	CNcont real NULL,
	CNerr real NULL,
	CNmask tinyint NULL,
	OItrip real NULL,
	OItripcont real NULL,
	OItriperr real NULL,
	OItripmask tinyint NULL,
	KI real NULL,
	KIcont real NULL,
	KIerr real NULL,
	KImask tinyint NULL,
	KIa real NULL,
	KIacont real NULL,
	KIaerr real NULL,
	KIamask tinyint NULL,
	NaIa real NULL,
	NaIacont real NULL,
	NaIaerr real NULL,
	NaIamask tinyint NULL,
	NaIred real NULL,
	NaIredcont real NULL,
	NaIrederr real NULL,
	NaIredmask tinyint NULL,
	CaIIw26 real NULL,
	CaIIw26cont real NULL,
	CaIIw26err real NULL,
	CaIIw26mask tinyint NULL,
	Paschenw13 real NULL,
	Paschenw13cont real NULL,
	Paschenw13err real NULL,
	Paschenw13mask tinyint NULL,
	CaII real NULL,
	CaIIcont real NULL,
	CaIIerr real NULL,
	CaIImask tinyint NULL,
	CaIIw40 real NULL,
	CaIIw40cont real NULL,
	CaIIw40err real NULL,
	CaIIw40mask tinyint NULL,
	CaIIa real NULL,
	CaIIacont real NULL,
	CaIIaerr real NULL,
	CaIIamask tinyint NULL,
	Paschenw42 real NULL,
	Paschenw42cont real NULL,
	Paschenw42err real NULL,
	Paschenw42mask tinyint NULL,
	CaIIb real NULL,
	CaIIbcont real NULL,
	CaIIberr real NULL,
	CaIIbmask tinyint NULL,
	CaIIaw40 real NULL,
	CaIIaw40cont real NULL,
	CaIIaw40err real NULL,
	CaIIaw40mask tinyint NULL,
	Paschenaw42 real NULL,
	Paschenaw42cont real NULL,
	Paschenaw42err real NULL,
	Paschenaw42mask tinyint NULL,
	TiO5 real NULL,
	TiO5cont real NULL,
	TiO5err real NULL,
	TiO5mask tinyint NULL,
	TiO8 real NULL,
	TiO8cont real NULL,
	TiO8err real NULL,
	TiO8mask tinyint NULL,
	CaH1 real NULL,
	CaH1cont real NULL,
	CaH1err real NULL,
	CaH1mask tinyint NULL,
	CaH2 real NULL,
	CaH2cont real NULL,
	CaH2err real NULL,
	CaH2mask tinyint NULL,
	CaH3 real NULL,
	CaH3cont real NULL,
	CaH3err real NULL,
	CaH3mask tinyint NULL,
	SN real NULL,
	lineindexstatus varchar(32)  NULL,
 CONSTRAINT pk_sppLines_specObjID PRIMARY KEY  
(
	specobjid 
)
);

CREATE TABLE sppParams(
	specobjid bigint NOT NULL,
	plate int NOT NULL,
	mjd int NOT NULL,
	fiberid int NOT NULL,
	fehspectype varchar(32)  NOT NULL,
	hammersptype varchar(32)  NOT NULL,
	sptypea varchar(32)  NOT NULL,
	flag varchar(32)  NOT NULL,
	feha real NOT NULL,
	fehan int NOT NULL,
	fehaerr real NOT NULL,
	fehw real NOT NULL,
	fehwn int NOT NULL,
	fehwerr real NOT NULL,
	fehr real NOT NULL,
	fehrn int NOT NULL,
	fehrerr real NOT NULL,
	feh1 real NOT NULL,
	feh1n int NOT NULL,
	feh1err real NOT NULL,
	feh2 real NOT NULL,
	feh2n int NOT NULL,
	feh2err real NOT NULL,
	feh3 real NOT NULL,
	feh3n int NOT NULL,
	feh3err real NOT NULL,
	feh4 real NOT NULL,
	feh4n int NOT NULL,
	feh4err real NOT NULL,
	feh5 real NOT NULL,
	feh5n int NOT NULL,
	feh5err real NOT NULL,
	feh6 real NOT NULL,
	feh6n int NOT NULL,
	feh6err real NOT NULL,
	feh7 real NOT NULL,
	feh7n int NOT NULL,
	feh7err real NOT NULL,
	feh8 real NOT NULL,
	feh8n int NOT NULL,
	feh8err real NOT NULL,
	feh9 real NOT NULL,
	feh9n int NOT NULL,
	feh9err real NOT NULL,
	teffa real NOT NULL,
	teffan int NOT NULL,
	teffaerr real NOT NULL,
	teff1 real NOT NULL,
	teff1n int NOT NULL,
	teff1err real NOT NULL,
	teff2 real NOT NULL,
	teff2n int NOT NULL,
	teff2err real NOT NULL,
	teff3 real NOT NULL,
	teff3n int NOT NULL,
	teff3err real NOT NULL,
	teff4 real NOT NULL,
	teff4n int NOT NULL,
	teff4err real NOT NULL,
	teff5 real NOT NULL,
	teff5n int NOT NULL,
	teff5err real NOT NULL,
	teff6 real NOT NULL,
	teff6n int NOT NULL,
	teff6err real NOT NULL,
	teff7 real NOT NULL,
	teff7n int NOT NULL,
	teff7err real NOT NULL,
	teff8 real NOT NULL,
	teff8n int NOT NULL,
	teff8err real NOT NULL,
	teff9 real NOT NULL,
	teff9n int NOT NULL,
	teff9err real NOT NULL,
	teff10 real NOT NULL,
	teff10n int NOT NULL,
	teff10err real NOT NULL,
	logga real NOT NULL,
	loggan int NOT NULL,
	loggaerr real NOT NULL,
	logg1 real NOT NULL,
	logg1n int NOT NULL,
	logg1err real NOT NULL,
	logg2 real NOT NULL,
	logg2n int NOT NULL,
	logg2err real NOT NULL,
	logg3 real NOT NULL,
	logg3n int NOT NULL,
	logg3err real NOT NULL,
	logg4 real NOT NULL,
	logg4n int NOT NULL,
	logg4err real NOT NULL,
	logg5 real NOT NULL,
	logg5n int NOT NULL,
	logg5err real NOT NULL,
	logg6 real NOT NULL,
	logg6n int NOT NULL,
	logg6err real NOT NULL,
	logg7 real NOT NULL,
	logg7n int NOT NULL,
	logg7err real NOT NULL,
	logg8 real NOT NULL,
	logg8n int NOT NULL,
	logg8err real NOT NULL,
	alphafe real NOT NULL,
	alphafen int NOT NULL,
	alphafeerr real NOT NULL,
	distV real NOT NULL,
	distTO real NOT NULL,
	distIII real NOT NULL,
	distAGB real NOT NULL,
	distHB real NOT NULL,
	distCAP real NOT NULL,
	unused1 real NOT NULL,
	distZ real NOT NULL,
	KPindex real NOT NULL,
	GPindex real NOT NULL,
	unused2 real NOT NULL,
	RVflag varchar(32)  NOT NULL,
	rva real NOT NULL,
	rvaerr real NOT NULL,
	calcrv real NOT NULL,
	calcrverr real NOT NULL,
	bsrv real NOT NULL,
	bsrverr real NOT NULL,
	elodierv real NOT NULL,
	elodierverr real NOT NULL,
	unused3 real NOT NULL,
	unused4 real NOT NULL,
	velgal real NOT NULL,
	g0 real NOT NULL,
	V0 real NOT NULL,
	gmr0 real NOT NULL,
	grhbaa real NOT NULL,
	grbha real NOT NULL,
	grbhd real NOT NULL,
	grhp real NOT NULL,
	BmV0 real NOT NULL,
	BmVBalmer0 real NOT NULL,
	umg0 real NOT NULL,
	rmi0 real NOT NULL,
	imz0 real NOT NULL,
	uerr real NOT NULL,
	gerr real NOT NULL,
	rerr real NOT NULL,
	ierr real NOT NULL,
	zerr real NOT NULL,
	ebv real NOT NULL,
	sna real NOT NULL,
	qualitycheck int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	l float NOT NULL,
	b float NOT NULL,
	chiHK real NOT NULL,
	chiGband real NOT NULL,
	chiMg real NOT NULL,
	pmepoch float NOT NULL,
	pmmatch real NOT NULL,
	pmdelta real NOT NULL,
	pml real NOT NULL,
	pmb real NOT NULL,
	pmra real NOT NULL,
	pmdec real NOT NULL,
	pmraerr real NOT NULL,
	pmdecerr real NOT NULL,
	pmsigra real NOT NULL,
	pmsigdec real NOT NULL,
	pmnfit int NOT NULL,
	usnomag_u real NOT NULL,
	usnomag_g real NOT NULL,
	usnomag_r real NOT NULL,
	usnomag_i real NOT NULL,
	usnomag_z real NOT NULL,
	pmdist20 real NOT NULL,
	pmdist22 real NOT NULL,
	brun int NOT NULL,
	brerun int NOT NULL,
	bcamcol int NOT NULL,
	bfield int NOT NULL,
	bobj int NOT NULL,
	zbsubclass varchar(32)  NOT NULL,
	zbelodiesptype varchar(32)  NOT NULL,
	lpar real NOT NULL,
	spar real NOT NULL,
	wpar real NOT NULL,
	p1spar real NOT NULL,
	zbclass varchar(32)  NOT NULL,
	zbrchi2 real NOT NULL,
	zbdof real NOT NULL,
	zbvdisp real NOT NULL,
	zbvdisperr real NOT NULL,
	zbzwarning real NOT NULL,
	spec_cln int NOT NULL,
	sprv real NOT NULL,
	sprverr real NOT NULL,
	vel_dis real NOT NULL,
	vel_disperr real NOT NULL,
	spz_conf real NOT NULL,
	spz_status int NOT NULL,
	spz_warning int NOT NULL,
	eclass real NOT NULL,
	ecoeff1 real NOT NULL,
	ecoeff2 real NOT NULL,
	ecoeff3 real NOT NULL,
	ecoeff4 real NOT NULL,
	ecoeff5 real NOT NULL,
	inspect int NOT NULL,
 CONSTRAINT pk_sppParams_specObjID PRIMARY KEY  
(
	specobjid 
)
);

CREATE TABLE Stetson(
	name varchar(20)  NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	B float NULL,
	BErr float NULL,
	nB_tot int NULL,
	nB int NULL,
	V float NULL,
	VErr float NULL,
	nV_tot int NULL,
	nV int NULL,
	R float NULL,
	RErr float NULL,
	nR_tot int NULL,
	nR int NULL,
	I float NULL,
	IErr float NULL,
	nI_tot int NULL,
	nI int NULL,
	vary float NULL,
	objid bigint NULL,
 CONSTRAINT pk_Stetson_name PRIMARY KEY  
(
	name 
)
);

CREATE TABLE StripeDefs(
	stripe int NOT NULL,
	hemisphere varchar(64)  NOT NULL,
	eta float NOT NULL,
	lambdaMin float NOT NULL,
	lambdaMax float NOT NULL,
	htmArea varchar(1024)  NOT NULL,
 CONSTRAINT pk_StripeDefs_stripe PRIMARY KEY  
(
	stripe 
)
);

CREATE TABLE TableDesc(
	key varchar(128)  NOT NULL,
	"type" varchar(128)  NOT NULL,
	ucd varchar(128)  NOT NULL,
	"text" varchar(7200)  NOT NULL,
 CONSTRAINT pk_TableDesc_key PRIMARY KEY  
(
	key 
)
);

CREATE TABLE Target(
	targetID bigint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field int NOT NULL,
	obj int NOT NULL,
	regionID int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	duplicate tinyint NOT NULL,
	htmID bigint NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	bestObjID bigint NOT NULL,
	specObjID bigint NOT NULL,
	bestMode tinyint NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_Target_targetID PRIMARY KEY  
(
	targetID 
)
);

CREATE TABLE TargetInfo(
	targetObjID bigint NOT NULL,
	targetID bigint NOT NULL,
	skyVersion int NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	priority int NOT NULL,
	programType int NOT NULL,
	programName varchar(32)  NOT NULL,
	targetMode tinyint NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_TargetInfo_skyVersion_targetI PRIMARY KEY  
(
	skyVersion ,
	targetID 
)
);

CREATE TABLE TargetParam(
	targetVersion varchar(32)  NOT NULL,
	name varchar(32)  NOT NULL,
	value varchar(32)  NOT NULL,
 CONSTRAINT pk_TargetParam_targetVersion_nam PRIMARY KEY  
(
	targetVersion ,
	name 
)
);

CREATE TABLE TargPhotoObjAll(
	objID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	obj smallint NOT NULL,
	"mode" tinyint NOT NULL,
	nChild smallint NOT NULL,
	"type" smallint NOT NULL,
	probPSF real NOT NULL,
	insideMask tinyint NOT NULL,
	flags bigint NOT NULL,
	rowc real NOT NULL,
	rowcErr real NOT NULL,
	colc real NOT NULL,
	colcErr real NOT NULL,
	rowv real NOT NULL,
	rowvErr real NOT NULL,
	colv real NOT NULL,
	colvErr real NOT NULL,
	rowc_u real NOT NULL,
	rowc_g real NOT NULL,
	rowc_r real NOT NULL,
	rowc_i real NOT NULL,
	rowc_z real NOT NULL,
	rowcErr_u real NOT NULL,
	rowcErr_g real NOT NULL,
	rowcErr_r real NOT NULL,
	rowcErr_i real NOT NULL,
	rowcErr_z real NOT NULL,
	colc_u real NOT NULL,
	colc_g real NOT NULL,
	colc_r real NOT NULL,
	colc_i real NOT NULL,
	colc_z real NOT NULL,
	colcErr_u real NOT NULL,
	colcErr_g real NOT NULL,
	colcErr_r real NOT NULL,
	colcErr_i real NOT NULL,
	colcErr_z real NOT NULL,
	sky_u real NOT NULL,
	sky_g real NOT NULL,
	sky_r real NOT NULL,
	sky_i real NOT NULL,
	sky_z real NOT NULL,
	skyErr_u real NOT NULL,
	skyErr_g real NOT NULL,
	skyErr_r real NOT NULL,
	skyErr_i real NOT NULL,
	skyErr_z real NOT NULL,
	psfMag_u real NOT NULL,
	psfMag_g real NOT NULL,
	psfMag_r real NOT NULL,
	psfMag_i real NOT NULL,
	psfMag_z real NOT NULL,
	psfMagErr_u real NOT NULL,
	psfMagErr_g real NOT NULL,
	psfMagErr_r real NOT NULL,
	psfMagErr_i real NOT NULL,
	psfMagErr_z real NOT NULL,
	fiberMag_u real NOT NULL,
	fiberMag_g real NOT NULL,
	fiberMag_r real NOT NULL,
	fiberMag_i real NOT NULL,
	fiberMag_z real NOT NULL,
	fiberMagErr_u real NOT NULL,
	fiberMagErr_g real NOT NULL,
	fiberMagErr_r real NOT NULL,
	fiberMagErr_i real NOT NULL,
	fiberMagErr_z real NOT NULL,
	petroMag_u real NOT NULL,
	petroMag_g real NOT NULL,
	petroMag_r real NOT NULL,
	petroMag_i real NOT NULL,
	petroMag_z real NOT NULL,
	petroMagErr_u real NOT NULL,
	petroMagErr_g real NOT NULL,
	petroMagErr_r real NOT NULL,
	petroMagErr_i real NOT NULL,
	petroMagErr_z real NOT NULL,
	petroRad_u real NOT NULL,
	petroRad_g real NOT NULL,
	petroRad_r real NOT NULL,
	petroRad_i real NOT NULL,
	petroRad_z real NOT NULL,
	petroRadErr_u real NOT NULL,
	petroRadErr_g real NOT NULL,
	petroRadErr_r real NOT NULL,
	petroRadErr_i real NOT NULL,
	petroRadErr_z real NOT NULL,
	petroR50_u real NOT NULL,
	petroR50_g real NOT NULL,
	petroR50_r real NOT NULL,
	petroR50_i real NOT NULL,
	petroR50_z real NOT NULL,
	petroR50Err_u real NOT NULL,
	petroR50Err_g real NOT NULL,
	petroR50Err_r real NOT NULL,
	petroR50Err_i real NOT NULL,
	petroR50Err_z real NOT NULL,
	petroR90_u real NOT NULL,
	petroR90_g real NOT NULL,
	petroR90_r real NOT NULL,
	petroR90_i real NOT NULL,
	petroR90_z real NOT NULL,
	petroR90Err_u real NOT NULL,
	petroR90Err_g real NOT NULL,
	petroR90Err_r real NOT NULL,
	petroR90Err_i real NOT NULL,
	petroR90Err_z real NOT NULL,
	q_u real NOT NULL,
	q_g real NOT NULL,
	q_r real NOT NULL,
	q_i real NOT NULL,
	q_z real NOT NULL,
	qErr_u real NOT NULL,
	qErr_g real NOT NULL,
	qErr_r real NOT NULL,
	qErr_i real NOT NULL,
	qErr_z real NOT NULL,
	u_u real NOT NULL,
	u_g real NOT NULL,
	u_r real NOT NULL,
	u_i real NOT NULL,
	u_z real NOT NULL,
	uErr_u real NOT NULL,
	uErr_g real NOT NULL,
	uErr_r real NOT NULL,
	uErr_i real NOT NULL,
	uErr_z real NOT NULL,
	mE1_u real NOT NULL,
	mE1_g real NOT NULL,
	mE1_r real NOT NULL,
	mE1_i real NOT NULL,
	mE1_z real NOT NULL,
	mE2_u real NOT NULL,
	mE2_g real NOT NULL,
	mE2_r real NOT NULL,
	mE2_i real NOT NULL,
	mE2_z real NOT NULL,
	mE1E1Err_u real NOT NULL,
	mE1E1Err_g real NOT NULL,
	mE1E1Err_r real NOT NULL,
	mE1E1Err_i real NOT NULL,
	mE1E1Err_z real NOT NULL,
	mE1E2Err_u real NOT NULL,
	mE1E2Err_g real NOT NULL,
	mE1E2Err_r real NOT NULL,
	mE1E2Err_i real NOT NULL,
	mE1E2Err_z real NOT NULL,
	mE2E2Err_u real NOT NULL,
	mE2E2Err_g real NOT NULL,
	mE2E2Err_r real NOT NULL,
	mE2E2Err_i real NOT NULL,
	mE2E2Err_z real NOT NULL,
	mRrCc_u real NOT NULL,
	mRrCc_g real NOT NULL,
	mRrCc_r real NOT NULL,
	mRrCc_i real NOT NULL,
	mRrCc_z real NOT NULL,
	mRrCcErr_u real NOT NULL,
	mRrCcErr_g real NOT NULL,
	mRrCcErr_r real NOT NULL,
	mRrCcErr_i real NOT NULL,
	mRrCcErr_z real NOT NULL,
	mCr4_u real NOT NULL,
	mCr4_g real NOT NULL,
	mCr4_r real NOT NULL,
	mCr4_i real NOT NULL,
	mCr4_z real NOT NULL,
	mE1PSF_u real NOT NULL,
	mE1PSF_g real NOT NULL,
	mE1PSF_r real NOT NULL,
	mE1PSF_i real NOT NULL,
	mE1PSF_z real NOT NULL,
	mE2PSF_u real NOT NULL,
	mE2PSF_g real NOT NULL,
	mE2PSF_r real NOT NULL,
	mE2PSF_i real NOT NULL,
	mE2PSF_z real NOT NULL,
	mRrCcPSF_u real NOT NULL,
	mRrCcPSF_g real NOT NULL,
	mRrCcPSF_r real NOT NULL,
	mRrCcPSF_i real NOT NULL,
	mRrCcPSF_z real NOT NULL,
	mCr4PSF_u real NOT NULL,
	mCr4PSF_g real NOT NULL,
	mCr4PSF_r real NOT NULL,
	mCr4PSF_i real NOT NULL,
	mCr4PSF_z real NOT NULL,
	isoRowc_u real NOT NULL,
	isoRowc_g real NOT NULL,
	isoRowc_r real NOT NULL,
	isoRowc_i real NOT NULL,
	isoRowc_z real NOT NULL,
	isoRowcErr_u real NOT NULL,
	isoRowcErr_g real NOT NULL,
	isoRowcErr_r real NOT NULL,
	isoRowcErr_i real NOT NULL,
	isoRowcErr_z real NOT NULL,
	isoRowcGrad_u real NOT NULL,
	isoRowcGrad_g real NOT NULL,
	isoRowcGrad_r real NOT NULL,
	isoRowcGrad_i real NOT NULL,
	isoRowcGrad_z real NOT NULL,
	isoColc_u real NOT NULL,
	isoColc_g real NOT NULL,
	isoColc_r real NOT NULL,
	isoColc_i real NOT NULL,
	isoColc_z real NOT NULL,
	isoColcErr_u real NOT NULL,
	isoColcErr_g real NOT NULL,
	isoColcErr_r real NOT NULL,
	isoColcErr_i real NOT NULL,
	isoColcErr_z real NOT NULL,
	isoColcGrad_u real NOT NULL,
	isoColcGrad_g real NOT NULL,
	isoColcGrad_r real NOT NULL,
	isoColcGrad_i real NOT NULL,
	isoColcGrad_z real NOT NULL,
	isoA_u real NOT NULL,
	isoA_g real NOT NULL,
	isoA_r real NOT NULL,
	isoA_i real NOT NULL,
	isoA_z real NOT NULL,
	isoAErr_u real NOT NULL,
	isoAErr_g real NOT NULL,
	isoAErr_r real NOT NULL,
	isoAErr_i real NOT NULL,
	isoAErr_z real NOT NULL,
	isoB_u real NOT NULL,
	isoB_g real NOT NULL,
	isoB_r real NOT NULL,
	isoB_i real NOT NULL,
	isoB_z real NOT NULL,
	isoBErr_u real NOT NULL,
	isoBErr_g real NOT NULL,
	isoBErr_r real NOT NULL,
	isoBErr_i real NOT NULL,
	isoBErr_z real NOT NULL,
	isoAGrad_u real NOT NULL,
	isoAGrad_g real NOT NULL,
	isoAGrad_r real NOT NULL,
	isoAGrad_i real NOT NULL,
	isoAGrad_z real NOT NULL,
	isoBGrad_u real NOT NULL,
	isoBGrad_g real NOT NULL,
	isoBGrad_r real NOT NULL,
	isoBGrad_i real NOT NULL,
	isoBGrad_z real NOT NULL,
	isoPhi_u real NOT NULL,
	isoPhi_g real NOT NULL,
	isoPhi_r real NOT NULL,
	isoPhi_i real NOT NULL,
	isoPhi_z real NOT NULL,
	isoPhiErr_u real NOT NULL,
	isoPhiErr_g real NOT NULL,
	isoPhiErr_r real NOT NULL,
	isoPhiErr_i real NOT NULL,
	isoPhiErr_z real NOT NULL,
	isoPhiGrad_u real NOT NULL,
	isoPhiGrad_g real NOT NULL,
	isoPhiGrad_r real NOT NULL,
	isoPhiGrad_i real NOT NULL,
	isoPhiGrad_z real NOT NULL,
	deVRad_u real NOT NULL,
	deVRad_g real NOT NULL,
	deVRad_r real NOT NULL,
	deVRad_i real NOT NULL,
	deVRad_z real NOT NULL,
	deVRadErr_u real NOT NULL,
	deVRadErr_g real NOT NULL,
	deVRadErr_r real NOT NULL,
	deVRadErr_i real NOT NULL,
	deVRadErr_z real NOT NULL,
	deVAB_u real NOT NULL,
	deVAB_g real NOT NULL,
	deVAB_r real NOT NULL,
	deVAB_i real NOT NULL,
	deVAB_z real NOT NULL,
	deVABErr_u real NOT NULL,
	deVABErr_g real NOT NULL,
	deVABErr_r real NOT NULL,
	deVABErr_i real NOT NULL,
	deVABErr_z real NOT NULL,
	deVPhi_u real NOT NULL,
	deVPhi_g real NOT NULL,
	deVPhi_r real NOT NULL,
	deVPhi_i real NOT NULL,
	deVPhi_z real NOT NULL,
	deVPhiErr_u real NOT NULL,
	deVPhiErr_g real NOT NULL,
	deVPhiErr_r real NOT NULL,
	deVPhiErr_i real NOT NULL,
	deVPhiErr_z real NOT NULL,
	deVMag_u real NOT NULL,
	deVMag_g real NOT NULL,
	deVMag_r real NOT NULL,
	deVMag_i real NOT NULL,
	deVMag_z real NOT NULL,
	deVMagErr_u real NOT NULL,
	deVMagErr_g real NOT NULL,
	deVMagErr_r real NOT NULL,
	deVMagErr_i real NOT NULL,
	deVMagErr_z real NOT NULL,
	expRad_u real NOT NULL,
	expRad_g real NOT NULL,
	expRad_r real NOT NULL,
	expRad_i real NOT NULL,
	expRad_z real NOT NULL,
	expRadErr_u real NOT NULL,
	expRadErr_g real NOT NULL,
	expRadErr_r real NOT NULL,
	expRadErr_i real NOT NULL,
	expRadErr_z real NOT NULL,
	expAB_u real NOT NULL,
	expAB_g real NOT NULL,
	expAB_r real NOT NULL,
	expAB_i real NOT NULL,
	expAB_z real NOT NULL,
	expABErr_u real NOT NULL,
	expABErr_g real NOT NULL,
	expABErr_r real NOT NULL,
	expABErr_i real NOT NULL,
	expABErr_z real NOT NULL,
	expPhi_u real NOT NULL,
	expPhi_g real NOT NULL,
	expPhi_r real NOT NULL,
	expPhi_i real NOT NULL,
	expPhi_z real NOT NULL,
	expPhiErr_u real NOT NULL,
	expPhiErr_g real NOT NULL,
	expPhiErr_r real NOT NULL,
	expPhiErr_i real NOT NULL,
	expPhiErr_z real NOT NULL,
	expMag_u real NOT NULL,
	expMag_g real NOT NULL,
	expMag_r real NOT NULL,
	expMag_i real NOT NULL,
	expMag_z real NOT NULL,
	expMagErr_u real NOT NULL,
	expMagErr_g real NOT NULL,
	expMagErr_r real NOT NULL,
	expMagErr_i real NOT NULL,
	expMagErr_z real NOT NULL,
	modelMag_u real NOT NULL,
	modelMag_g real NOT NULL,
	modelMag_r real NOT NULL,
	modelMag_i real NOT NULL,
	modelMag_z real NOT NULL,
	modelMagErr_u real NOT NULL,
	modelMagErr_g real NOT NULL,
	modelMagErr_r real NOT NULL,
	modelMagErr_i real NOT NULL,
	modelMagErr_z real NOT NULL,
	texture_u real NOT NULL,
	texture_g real NOT NULL,
	texture_r real NOT NULL,
	texture_i real NOT NULL,
	texture_z real NOT NULL,
	lnLStar_u real NOT NULL,
	lnLStar_g real NOT NULL,
	lnLStar_r real NOT NULL,
	lnLStar_i real NOT NULL,
	lnLStar_z real NOT NULL,
	lnLExp_u real NOT NULL,
	lnLExp_g real NOT NULL,
	lnLExp_r real NOT NULL,
	lnLExp_i real NOT NULL,
	lnLExp_z real NOT NULL,
	lnLDeV_u real NOT NULL,
	lnLDeV_g real NOT NULL,
	lnLDeV_r real NOT NULL,
	lnLDeV_i real NOT NULL,
	lnLDeV_z real NOT NULL,
	fracDeV_u real NOT NULL,
	fracDeV_g real NOT NULL,
	fracDeV_r real NOT NULL,
	fracDeV_i real NOT NULL,
	fracDeV_z real NOT NULL,
	flags_u bigint NOT NULL,
	flags_g bigint NOT NULL,
	flags_r bigint NOT NULL,
	flags_i bigint NOT NULL,
	flags_z bigint NOT NULL,
	type_u int NOT NULL,
	type_g int NOT NULL,
	type_r int NOT NULL,
	type_i int NOT NULL,
	type_z int NOT NULL,
	probPSF_u real NOT NULL,
	probPSF_g real NOT NULL,
	probPSF_r real NOT NULL,
	probPSF_i real NOT NULL,
	probPSF_z real NOT NULL,
	status int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	offsetRa_u real NOT NULL,
	offsetRa_g real NOT NULL,
	offsetRa_r real NOT NULL,
	offsetRa_i real NOT NULL,
	offsetRa_z real NOT NULL,
	offsetDec_u real NOT NULL,
	offsetDec_g real NOT NULL,
	offsetDec_r real NOT NULL,
	offsetDec_i real NOT NULL,
	offsetDec_z real NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	extinction_u real NOT NULL,
	extinction_g real NOT NULL,
	extinction_r real NOT NULL,
	extinction_i real NOT NULL,
	extinction_z real NOT NULL,
	priority int NOT NULL,
	rho real NOT NULL,
	nProf_u int NOT NULL,
	nProf_g int NOT NULL,
	nProf_r int NOT NULL,
	nProf_i int NOT NULL,
	nProf_z int NOT NULL,
	loadVersion int NOT NULL,
	htmID bigint NOT NULL,
	fieldID bigint NOT NULL,
	parentID bigint NOT NULL DEFAULT (0),
	specObjID bigint NOT NULL DEFAULT (0),
	u real NOT NULL DEFAULT (-9999),
	g real NOT NULL DEFAULT (-9999),
	r real NOT NULL DEFAULT (-9999),
	i real NOT NULL DEFAULT (-9999),
	z real NOT NULL DEFAULT (-9999),
	err_u real NOT NULL DEFAULT (-9999),
	err_g real NOT NULL DEFAULT (-9999),
	err_r real NOT NULL DEFAULT (-9999),
	err_i real NOT NULL DEFAULT (-9999),
	err_z real NOT NULL DEFAULT (-9999),
	dered_u real NOT NULL DEFAULT (-9999),
	dered_g real NOT NULL DEFAULT (-9999),
	dered_r real NOT NULL DEFAULT (-9999),
	dered_i real NOT NULL DEFAULT (-9999),
	dered_z real NOT NULL DEFAULT (-9999)
);

CREATE TABLE TargPhotoTag(
	objID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	obj smallint NOT NULL,
	"mode" tinyint NOT NULL,
	nChild smallint NOT NULL,
	"type" smallint NOT NULL,
	probPSF real NOT NULL,
	insideMask tinyint NOT NULL,
	flags bigint NOT NULL,
	psfMag_u real NOT NULL,
	psfMag_g real NOT NULL,
	psfMag_r real NOT NULL,
	psfMag_i real NOT NULL,
	psfMag_z real NOT NULL,
	psfMagErr_u real NOT NULL,
	psfMagErr_g real NOT NULL,
	psfMagErr_r real NOT NULL,
	psfMagErr_i real NOT NULL,
	psfMagErr_z real NOT NULL,
	petroMag_u real NOT NULL,
	petroMag_g real NOT NULL,
	petroMag_r real NOT NULL,
	petroMag_i real NOT NULL,
	petroMag_z real NOT NULL,
	petroMagErr_u real NOT NULL,
	petroMagErr_g real NOT NULL,
	petroMagErr_r real NOT NULL,
	petroMagErr_i real NOT NULL,
	petroMagErr_z real NOT NULL,
	petroR50_r real NOT NULL,
	petroR90_r real NOT NULL,
	modelMag_u real NOT NULL,
	modelMag_g real NOT NULL,
	modelMag_r real NOT NULL,
	modelMag_i real NOT NULL,
	modelMag_z real NOT NULL,
	modelMagErr_u real NOT NULL,
	modelMagErr_g real NOT NULL,
	modelMagErr_r real NOT NULL,
	modelMagErr_i real NOT NULL,
	modelMagErr_z real NOT NULL,
	mRrCc_r real NOT NULL,
	mRrCcErr_r real NOT NULL,
	lnLStar_r real NOT NULL,
	lnLExp_r real NOT NULL,
	lnLDeV_r real NOT NULL,
	status int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	primTarget int NOT NULL,
	secTarget int NOT NULL,
	extinction_u real NOT NULL,
	extinction_g real NOT NULL,
	extinction_r real NOT NULL,
	extinction_i real NOT NULL,
	extinction_z real NOT NULL,
	htmID bigint NOT NULL,
	fieldID bigint NOT NULL,
	specObjID bigint NOT NULL DEFAULT (0),
	size real NOT NULL DEFAULT (-9999)
);

CREATE TABLE TargRunQA(
	fieldID bigint NOT NULL,
	skyVersion tinyint NOT NULL,
	first tinyint NOT NULL,
	run smallint NOT NULL,
	rerun smallint NOT NULL,
	camcol tinyint NOT NULL,
	field smallint NOT NULL,
	fieldQall tinyint NOT NULL,
	opdbq tinyint NOT NULL,
	appsfq tinyint NOT NULL,
	pcmedq tinyint NOT NULL,
	pcrmsq tinyint NOT NULL,
	PSFwcondq tinyint NOT NULL,
	pc_s real NOT NULL,
	pc_w real NOT NULL,
	pc_x real NOT NULL,
	pc_y real NOT NULL,
	rmsPC_s real NOT NULL,
	rmsPC_w real NOT NULL,
	rmsPC_x real NOT NULL,
	rmsPC_y real NOT NULL,
	medAp7mPSF_u real NOT NULL,
	medAp7mPSF_g real NOT NULL,
	medAp7mPSF_r real NOT NULL,
	medAp7mPSF_i real NOT NULL,
	medAp7mPSF_z real NOT NULL,
	rmsAp7mPSF_u real NOT NULL,
	rmsAp7mPSF_g real NOT NULL,
	rmsAp7mPSF_r real NOT NULL,
	rmsAp7mPSF_i real NOT NULL,
	rmsAp7mPSF_z real NOT NULL,
	seeing_u real NOT NULL,
	seeing_g real NOT NULL,
	seeing_r real NOT NULL,
	seeing_i real NOT NULL,
	seeing_z real NOT NULL,
 CONSTRAINT pk_TargRunQA_fieldID PRIMARY KEY  
(
	fieldID 
)
);

CREATE TABLE TileAll(
	tile smallint NOT NULL,
	tileRun smallint NOT NULL,
	raCen float NOT NULL,
	decCen float NOT NULL,
	htmID bigint NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	untiled tinyint NOT NULL,
	nTargets int NOT NULL,
	programType int NOT NULL,
	programName varchar(32)  NOT NULL,
	extinction_u real NOT NULL,
	extinction_g real NOT NULL,
	extinction_r real NOT NULL,
	extinction_i real NOT NULL,
	extinction_z real NOT NULL,
	completeTileVersion varchar(32)  NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_TileAll_tile PRIMARY KEY  
(
	tile 
)
);

CREATE TABLE TiledTargetAll(
	tile smallint NOT NULL,
	targetID bigint NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	htmID bigint NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	objType int NOT NULL,
	duplicate tinyint NOT NULL,
	untiled tinyint NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_TiledTargetAll_targetID_tile PRIMARY KEY  
(
	targetID ,
	tile 
)
);

CREATE TABLE TilingGeometry(
	tilingGeometryID int NOT NULL,
	tileRun smallint NOT NULL,
	stripe int NOT NULL,
	nsbx varchar(1)  NOT NULL,
	isMask tinyint NOT NULL,
	coordType int NOT NULL,
	lambdamu_0 float NOT NULL,
	lambdamu_1 float NOT NULL,
	etanu_0 float NOT NULL,
	etanu_1 float NOT NULL,
	lambdaLimit_0 float NOT NULL,
	lambdaLimit_1 float NOT NULL,
	targetVersion varchar(32)  NOT NULL,
	firstArea float NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_TilingGeometry_tilingGeometry PRIMARY KEY  
(
	tilingGeometryID 
)
);

CREATE TABLE TilingInfo(
	tileRun smallint NOT NULL,
	tid int NOT NULL,
	tile smallint NOT NULL,
	tiPriority int NOT NULL,
	tiMask int NOT NULL,
	collisionGroupID int NOT NULL,
	targetID bigint NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_TilingInfo_tileRun_targetID PRIMARY KEY  
(
	tileRun ,
	targetID 
)
);

CREATE TABLE TilingNote(
	tilingNoteID int NOT NULL,
	tileRun smallint NOT NULL,
	tilingNote text  NOT NULL,
 CONSTRAINT pk_TilingNote_tilingNoteID PRIMARY KEY  
(
	tilingNoteID 
)
); 

CREATE TABLE TilingRun(
	tileRun smallint NOT NULL,
	tileVersion varchar(32)  NOT NULL,
	tilepId varchar(32)  NOT NULL,
	programType int NOT NULL,
	programName varchar(32)  NOT NULL,
	primTargetMask int NOT NULL,
	secTargetMask int NOT NULL,
	loadVersion int NOT NULL,
 CONSTRAINT pk_TilingRun_tileRun PRIMARY KEY  
(
	tileRun 
)
);

CREATE TABLE UberCal(
	objID bigint NOT NULL,
	conv_u real NOT NULL,
	conv_g real NOT NULL,
	conv_r real NOT NULL,
	conv_i real NOT NULL,
	conv_z real NOT NULL,
	psfMag_u real NOT NULL,
	psfMag_g real NOT NULL,
	psfMag_r real NOT NULL,
	psfMag_i real NOT NULL,
	psfMag_z real NOT NULL,
	petroMag_u real NOT NULL,
	petroMag_g real NOT NULL,
	petroMag_r real NOT NULL,
	petroMag_i real NOT NULL,
	petroMag_z real NOT NULL,
	modelMag_u real NOT NULL,
	modelMag_g real NOT NULL,
	modelMag_r real NOT NULL,
	modelMag_i real NOT NULL,
	modelMag_z real NOT NULL,
	calibStatus_u smallint NOT NULL,
	calibStatus_g smallint NOT NULL,
	calibStatus_r smallint NOT NULL,
	calibStatus_i smallint NOT NULL,
	calibStatus_z smallint NOT NULL,
 CONSTRAINT pk_UberCal_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE USNO(
	delta real NOT NULL,
	match int NOT NULL,
	propermotion real NOT NULL,
	angle real NOT NULL,
	blue real NOT NULL,
	red real NOT NULL,
	objID bigint NOT NULL,
 CONSTRAINT pk_USNO_objID PRIMARY KEY  
(
	objID 
)
);

CREATE TABLE Versions(
	event varchar(256)  NOT NULL,
	previous varchar(64)  NOT NULL,
	checksum varchar(64)  NOT NULL,
	version varchar(64)  NOT NULL,
	description varchar(256)  NOT NULL,
	"text" varchar(2000)  NOT NULL,
	who varchar(256)  NOT NULL,
	"when" varchar(256)  NOT NULL,
 CONSTRAINT pk_Versions_version PRIMARY KEY  
(
	version 
)
);

CREATE TABLE XCRedshift(
	xcRedShiftID bigint NOT NULL,
	tempNo int NOT NULL,
	peakNo int NOT NULL,
	shift real NOT NULL,
	z real NOT NULL,
	zErr real NOT NULL,
	r real NOT NULL,
	zConf real NOT NULL,
	height real NOT NULL,
	width real NOT NULL,
	widthErr real NOT NULL,
	delta real NOT NULL,
	rms real NOT NULL,
	specObjID bigint NOT NULL,
 CONSTRAINT pk_XCRedshift_xcRedshiftID PRIMARY KEY  
(
	xcRedShiftID 
)
);

CREATE TABLE Zone(
	zoneID int NOT NULL,
	ra float NOT NULL,
	"dec" float NOT NULL,
	objID bigint NOT NULL,
	"type" tinyint NOT NULL,
	"mode" tinyint NOT NULL,
	cx float NOT NULL,
	cy float NOT NULL,
	cz float NOT NULL,
	native tinyint NOT NULL,
 CONSTRAINT pk_Zone_zoneID_ra_objID PRIMARY KEY  
(
	zoneID ,
	ra ,
	objID 
)
);

---- Additional one to make the functions load working ----
CREATE TABLE sysobjects(
	id int, 
	uid int,
	nme char(100)
);

CREATE TABLE sysusers(
	id int, 
	uid int,
	nme char(100)
);

CREATE TABLE systypes(
	id int, 
	uid int,
	nme char(100),
	xtype char(100)
);

CREATE TABLE syscolumns(
	id int, 
	colid int, 
	isoutparam int,
	length int,
	uid int,
	nme char(100),
	xtype char(100)
);

CREATE TABLE spt_datatype_info(
	length int,
        ss_dtype varchar(100),
        "AUTO_INCREMENT" varchar(100)
);

