START TRANSACTION;
CREATE SEQUENCE "seq_3310" AS INTEGER;
CREATE SEQUENCE "seq_3320" AS INTEGER;
CREATE SEQUENCE "seq_3330" AS INTEGER;
CREATE SEQUENCE "seq_3361" AS INTEGER;
CREATE TABLE "sys"."video" (
	"video_id" int NOT NULL DEFAULT next value for "sys"."seq_3310",
	"filename" varchar(50) NOT NULL,
	"media_uri" varchar(50) NOT NULL,
	"media_time_point" varchar(50) NOT NULL,
	"media_duration" varchar(50) NOT NULL,
	"shot" int NOT NULL,
	"framecount" int NOT NULL,
	CONSTRAINT "video_video_id_pkey" PRIMARY KEY ("video_id")
);
COPY 1 RECORDS INTO "video" FROM stdin USING DELIMITERS '\t', '\n', '"';
1	"20050407_mocky.mpg"	"20050407_mocky.mpg"	"T00:00:00:0F25"	"PT00H47M34S19N25F"	0	71369
CREATE TABLE "sys"."video_segment" (
	"video_segment_id" int NOT NULL DEFAULT next value for "sys"."seq_3320",
	"video_id" int NOT NULL,
	"segment" varchar(50) NOT NULL,
	"shot" varchar(50) NOT NULL,
	"framecount" varchar(50) NOT NULL,
	"framenumber" int NOT NULL,
	"framelength" int NOT NULL,
	CONSTRAINT "video_segment_video_segment_id_pkey" PRIMARY KEY ("video_segment_id"),
	CONSTRAINT "unq_shot_frame" UNIQUE ("framenumber", "framelength"),
	CONSTRAINT "fk_video_segment_video_id" FOREIGN KEY ("video_id") REFERENCES "video" ("video_id")
);
COPY 71 RECORDS INTO "video_segment" FROM stdin USING DELIMITERS '\t', '\n', '"';
1	1	"frame_0"	"T00:00:00:0F25"	"PT00H00M00S01N25F"	0	1
2	1	"frame_10"	"T00:00:00:10F25"	"PT00H00M00S01N25F"	10	1
3	1	"frame_11"	"T00:00:00:11F25"	"PT00H00M00S01N25F"	11	1
4	1	"frame_12"	"T00:00:00:12F25"	"PT00H00M00S01N25F"	12	1
5	1	"frame_13"	"T00:00:00:13F25"	"PT00H00M00S01N25F"	13	1
6	1	"frame_14"	"T00:00:00:14F25"	"PT00H00M00S01N25F"	14	1
7	1	"frame_15"	"T00:00:00:15F25"	"PT00H00M00S01N25F"	15	1
8	1	"frame_16"	"T00:00:00:16F25"	"PT00H00M00S01N25F"	16	1
9	1	"frame_17"	"T00:00:00:17F25"	"PT00H00M00S01N25F"	17	1
10	1	"frame_18"	"T00:00:00:18F25"	"PT00H00M00S01N25F"	18	1
11	1	"frame_19"	"T00:00:00:19F25"	"PT00H00M00S01N25F"	19	1
12	1	"frame_1"	"T00:00:00:1F25"	"PT00H00M00S01N25F"	1	1
13	1	"frame_20"	"T00:00:00:20F25"	"PT00H00M00S01N25F"	20	1
14	1	"frame_21"	"T00:00:00:21F25"	"PT00H00M00S01N25F"	21	1
15	1	"frame_22"	"T00:00:00:22F25"	"PT00H00M00S01N25F"	22	1
16	1	"frame_23"	"T00:00:00:23F25"	"PT00H00M00S01N25F"	23	1
17	1	"frame_24"	"T00:00:00:24F25"	"PT00H00M00S01N25F"	24	1
18	1	"frame_2"	"T00:00:00:2F25"	"PT00H00M00S01N25F"	2	1
19	1	"frame_3"	"T00:00:00:3F25"	"PT00H00M00S01N25F"	3	1
20	1	"frame_4"	"T00:00:00:4F25"	"PT00H00M00S01N25F"	4	1
21	1	"frame_5"	"T00:00:00:5F25"	"PT00H00M00S01N25F"	5	1
22	1	"frame_6"	"T00:00:00:6F25"	"PT00H00M00S01N25F"	6	1
23	1	"frame_7"	"T00:00:00:7F25"	"PT00H00M00S01N25F"	7	1
24	1	"frame_8"	"T00:00:00:8F25"	"PT00H00M00S01N25F"	8	1
25	1	"frame_9"	"T00:00:00:9F25"	"PT00H00M00S01N25F"	9	1
26	1	"frame_25"	"T00:00:01:0F25"	"PT00H00M00S01N25F"	25	1
27	1	"frame_35"	"T00:00:01:10F25"	"PT00H00M00S01N25F"	35	1
28	1	"frame_36"	"T00:00:01:11F25"	"PT00H00M00S01N25F"	36	1
29	1	"frame_37"	"T00:00:01:12F25"	"PT00H00M00S01N25F"	37	1
30	1	"frame_38"	"T00:00:01:13F25"	"PT00H00M00S01N25F"	38	1
31	1	"frame_39"	"T00:00:01:14F25"	"PT00H00M00S01N25F"	39	1
32	1	"frame_40"	"T00:00:01:15F25"	"PT00H00M00S01N25F"	40	1
33	1	"frame_41"	"T00:00:01:16F25"	"PT00H00M00S01N25F"	41	1
34	1	"frame_42"	"T00:00:01:17F25"	"PT00H00M00S01N25F"	42	1
35	1	"frame_43"	"T00:00:01:18F25"	"PT00H00M00S01N25F"	43	1
36	1	"frame_44"	"T00:00:01:19F25"	"PT00H00M00S01N25F"	44	1
37	1	"frame_26"	"T00:00:01:1F25"	"PT00H00M00S01N25F"	26	1
38	1	"frame_45"	"T00:00:01:20F25"	"PT00H00M00S01N25F"	45	1
39	1	"frame_46"	"T00:00:01:21F25"	"PT00H00M00S01N25F"	46	1
40	1	"frame_47"	"T00:00:01:22F25"	"PT00H00M00S01N25F"	47	1
41	1	"frame_48"	"T00:00:01:23F25"	"PT00H00M00S01N25F"	48	1
42	1	"frame_49"	"T00:00:01:24F25"	"PT00H00M00S01N25F"	49	1
43	1	"frame_27"	"T00:00:01:2F25"	"PT00H00M00S01N25F"	27	1
44	1	"frame_28"	"T00:00:01:3F25"	"PT00H00M00S01N25F"	28	1
45	1	"frame_29"	"T00:00:01:4F25"	"PT00H00M00S01N25F"	29	1
46	1	"frame_30"	"T00:00:01:5F25"	"PT00H00M00S01N25F"	30	1
47	1	"frame_31"	"T00:00:01:6F25"	"PT00H00M00S01N25F"	31	1
48	1	"frame_32"	"T00:00:01:7F25"	"PT00H00M00S01N25F"	32	1
49	1	"frame_33"	"T00:00:01:8F25"	"PT00H00M00S01N25F"	33	1
50	1	"frame_34"	"T00:00:01:9F25"	"PT00H00M00S01N25F"	34	1
51	1	"frame_50"	"T00:00:02:0F25"	"PT00H00M00S01N25F"	50	1
52	1	"frame_60"	"T00:00:02:10F25"	"PT00H00M00S01N25F"	60	1
53	1	"frame_61"	"T00:00:02:11F25"	"PT00H00M00S01N25F"	61	1
54	1	"frame_62"	"T00:00:02:12F25"	"PT00H00M00S01N25F"	62	1
55	1	"frame_63"	"T00:00:02:13F25"	"PT00H00M00S01N25F"	63	1
56	1	"frame_64"	"T00:00:02:14F25"	"PT00H00M00S01N25F"	64	1
57	1	"frame_65"	"T00:00:02:15F25"	"PT00H00M00S01N25F"	65	1
58	1	"frame_66"	"T00:00:02:16F25"	"PT00H00M00S01N25F"	66	1
59	1	"frame_67"	"T00:00:02:17F25"	"PT00H00M00S01N25F"	67	1
60	1	"frame_68"	"T00:00:02:18F25"	"PT00H00M00S01N25F"	68	1
61	1	"frame_69"	"T00:00:02:19F25"	"PT00H00M00S01N25F"	69	1
62	1	"frame_51"	"T00:00:02:1F25"	"PT00H00M00S01N25F"	51	1
63	1	"frame_70"	"T00:00:02:20F25"	"PT00H00M00S01N25F"	70	1
64	1	"frame_71"	"T00:00:02:21F25"	"PT00H00M00S01N25F"	71	1
65	1	"frame_72"	"T00:00:02:22F25"	"PT00H00M00S01N25F"	72	1
66	1	"frame_73"	"T00:00:02:23F25"	"PT00H00M00S01N25F"	73	1
67	1	"frame_74"	"T00:00:02:24F25"	"PT00H00M00S01N25F"	74	1
68	1	"frame_52"	"T00:00:02:2F25"	"PT00H00M00S01N25F"	52	1
69	1	"frame_53"	"T00:00:02:3F25"	"PT00H00M00S01N25F"	53	1
70	1	"frame_54"	"T00:00:02:4F25"	"PT00H00M00S01N25F"	54	1
71	1	"frame_55"	"T00:00:02:5F25"	"PT00H00M00S01N25F"	55	1
CREATE TABLE "sys"."concepts" (
	"concepts_id" int NOT NULL DEFAULT next value for "sys"."seq_3330",
	"video_segment_id" int NOT NULL,
	"_2personshot_c" real,
	"_2personshot_r" real,
	"closeup_c" real,
	"closeup_r" real,
	"complete_podium_c" real,
	"complete_podium_r" real,
	"draaitafel_c" real,
	"draaitafel_r" real,
	"drummer_c" real,
	"drummer_r" real,
	"gitarist_c" real,
	"gitarist_r" real,
	"instrument_closup_c" real,
	"instrument_closup_r" real,
	"medium_podium_c" real,
	"medium_podium_r" real,
	"mediumshot_c" real,
	"mediumshot_r" real,
	"piano_c" real,
	"piano_r" real,
	"publiek_c" real,
	"publiek_r" real,
	"rug_artiesten_c" real,
	"rug_artiesten_r" real,
	"zanger_c" real,
	"zanger_r" real,
	CONSTRAINT "concepts_concepts_id_pkey" PRIMARY KEY ("concepts_id"),
	CONSTRAINT "fk_concepts_video_segment_id" FOREIGN KEY ("video_segment_id") REFERENCES "video_segment" ("video_segment_id")
);
COPY 71 RECORDS INTO "concepts" FROM stdin USING DELIMITERS '\t';
1	1	0.00577295991	1	0.0256887991	1	0.0251864996	1	1.00000001e-07	1	0.000110772002	1	0.0902884007	1	0.00199038	1	7.84385975e-06	1	0.40575701	1	3.89837987e-05	1	0.0656920969	1	1.00000001e-07	1	1.00000001e-07	1
2	2	0.0952574983	1	0.140557006	1	0.0421635993	1	0.000323351007	1	0.253017992	1	0.280176997	1	0.0607924014	1	0.0470448993	1	0.233169004	1	0.0635539964	1	0.201076001	1	0.120879002	1	0.386848986	1
3	3	0.0790096968	1	0.137465999	1	0.0346813984	1	0.000540950976	1	0.245244995	1	0.258863986	1	0.0831305012	1	0.0242940001	1	0.264544994	1	0.0712976977	1	0.215578005	1	0.130468994	1	0.527327001	1
4	4	0.0841102973	1	0.142049998	1	0.0417498015	1	0.00100302999	1	0.271340013	1	0.315530986	1	0.101349004	1	0.0592386983	1	0.237665996	1	0.0680632964	1	0.246245995	1	0.156362996	1	0.48476699	1
5	5	0.070411101	1	0.149678007	1	0.0370187983	1	0.00195237994	1	0.28125599	1	0.382878989	1	0.085155502	1	0.0626412034	1	0.225749001	1	0.0652256012	1	0.214241996	1	0.100818999	1	0.488608986	1
6	6	0.0719609037	1	0.149237007	1	0.0414503999	1	0.00280688005	1	0.274637014	1	0.406637013	1	0.0935321003	1	0.0719977021	1	0.272044003	1	0.0642592981	1	0.237369001	1	0.129892007	1	0.479274005	1
7	7	0.0828465	1	0.162799001	1	0.187095001	1	0.00414224016	1	0.5	1	0.383165002	1	0.102586001	1	0.156698003	1	0.299703985	1	0.117555	1	0.440057009	1	0.122532003	1	0.53866899	1
8	8	0.074969098	1	0.157142997	1	0.0498046987	1	0.00705278991	1	0.329392999	1	0.384792	1	0.0962759033	1	0.0854066014	1	0.291101992	1	0.0822703019	1	0.315064996	1	0.120885	1	0.469657987	1
9	9	0.0724885985	1	0.153227001	1	0.0466770008	1	0.00544539001	1	0.278115004	1	0.338528007	1	0.0771453977	1	0.115672	1	0.256446004	1	0.0712499991	1	0.270413995	1	0.0947107002	1	0.522566974	1
10	10	0.081720002	1	0.161504999	1	0.0734426975	1	0.00646595005	1	0.302794009	1	0.37254101	1	0.0938225016	1	0.128168002	1	0.233254001	1	0.0674567968	1	0.287146002	1	0.0877496004	1	0.5	1
11	11	0.0911543965	1	0.156646997	1	0.0368360989	1	0.00459728995	1	0.27165699	1	0.29122901	1	0.0923343003	1	0.107697003	1	0.224704996	1	0.0731853023	1	0.260123014	1	0.100167997	1	0.367857009	1
12	12	0.0841128007	1	0.0760563016	1	0.0149950003	1	1.00000001e-07	1	0.0254382007	1	0.203295007	1	0.0607420988	1	0.000439438998	1	0.312267005	1	0.00236821012	1	0.0290670004	1	0.000164140001	1	7.2188901e-05	1
13	13	0.0851256996	1	0.154547006	1	0.0229732003	1	0.00233610999	1	0.249107003	1	0.287519991	1	0.117652997	1	0.0714422017	1	0.270801008	1	0.0824334025	1	0.308227003	1	0.106619999	1	0.33287701	1
14	14	0.0931534991	1	0.157067999	1	0.0201834999	1	0.00457614986	1	0.261240989	1	0.329151005	1	0.122962996	1	0.0821183994	1	0.266977012	1	0.0695452988	1	0.219632	1	0.0845846981	1	0.391205996	1
15	15	0.0955151021	1	0.163448006	1	0.0182006005	1	0.00562814996	1	0.285993993	1	0.328963995	1	0.149347007	1	0.118827999	1	0.273948997	1	0.0774085	1	0.225714996	1	0.0745306015	1	0.336807996	1
16	16	0.0927359015	1	0.162839994	1	0.0192604996	1	0.00413165987	1	0.275959015	1	0.377664	1	0.174959004	1	0.0825425982	1	0.285762995	1	0.0759183988	1	0.192822993	1	0.0937002003	1	0.332432002	1
17	17	0.109195001	1	0.162346005	1	0.0176644009	1	0.00463763997	1	0.295244992	1	0.354294002	1	0.146540999	1	0.0701586977	1	0.274581999	1	0.0719664991	1	0.205089003	1	0.102743	1	0.290711999	1
18	18	0.117899999	1	0.110747002	1	0.00729322992	1	1.00000001e-07	1	0.0614842996	1	0.142361999	1	0.0221445002	1	0.000249262986	1	0.160044998	1	0.0090220198	1	0.0307951998	1	0.000522542978	1	0.0138448002	1
19	19	0.108537003	1	0.121731997	1	0.0164297	1	9.56423946e-07	1	0.231969997	1	0.209230006	1	0.0817081034	1	0.00245836005	1	0.236664996	1	0.0383477993	1	0.0422131009	1	0.00215581991	1	0.0115911001	1
20	20	0.113652997	1	0.128654003	1	0.0164282992	1	2.95165992e-05	1	0.278849006	1	0.172609001	1	0.0646663979	1	0.00535142003	1	0.249954	1	0.0562034994	1	0.0860837027	1	0.0125879003	1	0.0394737013	1
21	21	0.127221003	1	0.130709007	1	0.0166848991	1	4.44297002e-05	1	0.244342998	1	0.151878998	1	0.0442733988	1	0.00454025017	1	0.273066014	1	0.0557442009	1	0.125646994	1	0.0252857003	1	0.0810817033	1
22	22	0.129130006	1	0.132137001	1	0.0199287999	1	0.000102643004	1	0.274369001	1	0.167080998	1	0.0430991985	1	0.00423202012	1	0.231846005	1	0.0585112013	1	0.128269002	1	0.0449936986	1	0.100980997	1
23	23	0.108175002	1	0.141501993	1	0.0330095999	1	9.54674033e-05	1	0.244739994	1	0.179841995	1	0.0634327978	1	0.0103874002	1	0.192807004	1	0.0808669999	1	0.145649999	1	0.0818085	1	0.165287003	1
24	24	0.110334001	1	0.142885998	1	0.0411285013	1	0.000136382994	1	0.257770985	1	0.331355006	1	0.0741555989	1	0.0239176992	1	0.242873996	1	0.0921771005	1	0.199310005	1	0.0782983974	1	0.203346997	1
25	25	0.0998556018	1	0.144534007	1	0.0506590009	1	0.00054466998	1	0.314336985	1	0.291575998	1	0.0584669001	1	0.043366801	1	0.243007004	1	0.0966558009	1	0.250831991	1	0.084977001	1	0.306235999	1
26	26	0.113104999	1	0.161210999	1	0.0176972002	1	0.00212375005	1	0.306501001	1	0.417447001	1	0.140016004	1	0.189533994	1	0.295237005	1	0.0636307001	1	0.258028001	1	0.110166997	1	0.342240006	1
27	27	0.127331004	1	0.145863995	1	0.0108764004	1	0.000652850023	1	0.363968998	1	0.443186998	1	0.0895498022	1	0.216187999	1	0.393846005	1	0.0883321017	1	0.208498999	1	0.0618130006	1	0.440952986	1
28	28	0.111126997	1	0.146241993	1	0.0130765	1	0.000226151999	1	0.297086	1	0.436085999	1	0.0688387007	1	0.157009006	1	0.362515002	1	0.0808238983	1	0.161577001	1	0.0577808991	1	0.469020993	1
29	29	0.110060997	1	0.149977997	1	0.0190062001	1	0.000111570997	1	0.316139996	1	0.478148013	1	0.0559240989	1	0.164499998	1	0.333346009	1	0.0784775019	1	0.229776993	1	0.0598451011	1	0.535085976	1
30	30	0.117136002	1	0.144251004	1	0.0158450995	1	0.000196035995	1	0.283912987	1	0.429199994	1	0.0613063984	1	0.149389997	1	0.352640986	1	0.0628262982	1	0.157605007	1	0.077171199	1	0.435241997	1
31	31	0.107063003	1	0.142380998	1	0.0205348004	1	0.000169248	1	0.301447988	1	0.371257007	1	0.0378432013	1	0.303326011	1	0.343356013	1	0.0672561973	1	0.198642001	1	0.0698983967	1	0.454035997	1
32	32	0.119292997	1	0.146209002	1	0.0141342999	1	0.000356530014	1	0.278715014	1	0.384256005	1	0.065748997	1	0.061333999	1	0.306708008	1	0.0613097996	1	0.204403996	1	0.129706994	1	0.332066	1
33	33	0.123016998	1	0.144135997	1	0.0138210999	1	0.00093711901	1	0.294167012	1	0.253995001	1	0.0596023016	1	0.0752779022	1	0.345302999	1	0.0619575009	1	0.128456995	1	0.105003998	1	0.362836003	1
34	34	0.105777003	1	0.145245001	1	0.0140137002	1	0.000959304976	1	0.297484994	1	0.197889	1	0.0597144999	1	0.0594570003	1	0.294676989	1	0.0630078986	1	0.161813006	1	0.108194001	1	0.281251997	1
35	35	0.0945864022	1	0.146836996	1	0.0127216	1	0.000884309004	1	0.267551005	1	0.206861004	1	0.0921121985	1	0.127572998	1	0.337179989	1	0.0591550991	1	0.217494994	1	0.100373	1	0.273281008	1
36	36	0.109283	1	0.147681996	1	0.0142360004	1	0.00166297005	1	0.222495005	1	0.189826995	1	0.0876991972	1	0.0772288963	1	0.341722012	1	0.0613696016	1	0.202252999	1	0.108395003	1	0.311838001	1
37	37	0.113705002	1	0.157368004	1	0.0169210993	1	0.00286671007	1	0.329807997	1	0.349426001	1	0.119586997	1	0.154606998	1	0.30182299	1	0.0668295026	1	0.220624	1	0.124638997	1	0.277859986	1
38	38	0.097557798	1	0.157334	1	0.0351147987	1	0.00163199997	1	0.332468003	1	0.295686007	1	0.132350996	1	0.084157601	1	0.31961599	1	0.0725933015	1	0.225951999	1	0.129485995	1	0.38587901	1
39	39	0.100406997	1	0.143547997	1	0.0230768006	1	0.00292760995	1	0.285317987	1	0.215706006	1	0.0714517012	1	0.0519845001	1	0.230986997	1	0.0569562018	1	0.286105007	1	0.152310997	1	0.318940997	1
40	40	0.103596002	1	0.156461	1	0.0219915994	1	0.00174307998	1	0.323293	1	0.203645006	1	0.0573663004	1	0.0513761006	1	0.226391003	1	0.0640119985	1	0.317438006	1	0.123857997	1	0.295592993	1
41	41	0.108171001	1	0.156620994	1	0.0318673998	1	0.00410652999	1	0.380966008	1	0.195545003	1	0.0621206015	1	0.100749001	1	0.254070014	1	0.0669322014	1	0.285409987	1	0.105039001	1	0.363151997	1
42	42	0.120600998	1	0.163077995	1	0.0222942997	1	0.00655581988	1	0.385895997	1	0.187686995	1	0.0629535019	1	0.0446148999	1	0.285928011	1	0.0860605985	1	0.203163996	1	0.0893455967	1	0.305830985	1
43	43	0.111968003	1	0.158950999	1	0.0146794003	1	0.00197039009	1	0.345090985	1	0.311657012	1	0.111530997	1	0.114147998	1	0.283342987	1	0.0736624002	1	0.186850995	1	0.0970716998	1	0.286206007	1
44	44	0.108709	1	0.153512999	1	0.0075823199	1	0.00401702989	1	0.289119989	1	0.257692009	1	0.140232995	1	0.0485641994	1	0.351581007	1	0.0594297983	1	0.0799368992	1	0.0719266981	1	0.269421011	1
45	45	0.101263002	1	0.161936998	1	0.0135402	1	0.00153632998	1	0.278530985	1	0.434314996	1	0.151295006	1	0.0964578986	1	0.343235999	1	0.0734876022	1	0.116807997	1	0.0596458986	1	0.367354006	1
46	46	0.0998276025	1	0.160780996	1	0.0157067999	1	0.00296803005	1	0.284112006	1	0.442564011	1	0.164472997	1	0.115960002	1	0.375041991	1	0.0843252987	1	0.226680994	1	0.0894797966	1	0.423615009	1
47	47	0.112538002	1	0.159720004	1	0.0146992002	1	0.00184107001	1	0.291709989	1	0.413127005	1	0.130983993	1	0.173924997	1	0.356114	1	0.085273698	1	0.133126006	1	0.0744175985	1	0.40396601	1
48	48	0.120439	1	0.153025001	1	0.00884808041	1	0.000897937978	1	0.277608991	1	0.450446993	1	0.114422999	1	0.213561997	1	0.385791004	1	0.0711733028	1	0.166686997	1	0.0834273025	1	0.423009008	1
49	49	0.119039997	1	0.151280999	1	0.0103951003	1	0.000560595014	1	0.308443993	1	0.395779997	1	0.111781999	1	0.206215993	1	0.360249996	1	0.0777323022	1	0.127335995	1	0.0812345967	1	0.424789995	1
50	50	0.135130003	1	0.145355999	1	0.0102140997	1	0.000874418998	1	0.346266001	1	0.379682004	1	0.0878430009	1	0.171268001	1	0.368698001	1	0.0814979002	1	0.188858002	1	0.0769127011	1	0.402644008	1
51	51	0.112604998	1	0.163611993	1	0.0201631002	1	0.0106236003	1	0.366638988	1	0.190695003	1	0.0768984035	1	0.0689804032	1	0.305231988	1	0.136502996	1	0.40901801	1	0.0806121007	1	0.242184997	1
52	52	0.106494002	1	0.143570006	1	0.0206535999	1	0.00359222991	1	0.235228002	1	0.187472001	1	0.0532540008	1	0.00200975011	1	0.277637988	1	0.0587761998	1	0.307639003	1	0.0985537991	1	0.0713236034	1
53	53	0.0965946987	1	0.148199007	1	0.0183285996	1	0.00102442002	1	0.238668993	1	0.144969001	1	0.0384070985	1	0.0030344401	1	0.234597996	1	0.0521055982	1	0.352750987	1	0.0913678035	1	0.0791070014	1
54	54	0.121218003	1	0.157362998	1	0.152667999	1	0.0911213011	1	0.462841004	1	0.238517001	1	0.276975006	1	0.106587999	1	0.219249994	1	0.169318005	1	0.820958972	1	0.115227997	1	0.384954989	1
55	55	0.108846001	1	0.164449006	1	0.170459002	1	0.152232006	1	0.523061991	1	0.198177993	1	0.273259997	1	0.0547177009	1	0.175842002	1	0.178204998	1	0.624134004	1	0.0639531985	1	0.299656004	1
56	56	0.102352999	1	0.164371997	1	0.179436997	1	0.155618995	1	0.507836998	1	0.141047001	1	0.279601008	1	0.0357787013	1	0.160433993	1	0.152592003	1	0.665102005	1	0.0636330992	1	0.381276995	1
57	57	0.107290998	1	0.166043997	1	0.210427001	1	0.186863005	1	0.553686976	1	0.185569003	1	0.344626993	1	0.0509698987	1	0.158427998	1	0.157670006	1	0.626721978	1	0.0499113984	1	0.320300996	1
58	58	0.119983003	1	0.162876993	1	0.218145996	1	0.201226994	1	0.57101202	1	0.165527999	1	0.30467099	1	0.118472002	1	0.153755993	1	0.128986001	1	0.517545998	1	0.0398157015	1	0.328382999	1
59	59	0.113776997	1	0.162879005	1	0.209937006	1	0.196897998	1	0.56190598	1	0.185589999	1	0.356454015	1	0.112066999	1	0.150000006	1	0.148542002	1	0.556998014	1	0.0299459994	1	0.252261013	1
60	60	0.113789	1	0.163294002	1	0.223538995	1	0.203299001	1	0.556414008	1	0.167460993	1	0.336549014	1	0.130649999	1	0.141506001	1	0.163056999	1	0.581059992	1	0.0292856004	1	0.244017005	1
61	61	0.106307998	1	0.162055001	1	0.217801005	1	0.184786007	1	0.565634012	1	0.209720001	1	0.346096009	1	0.204100996	1	0.151137993	1	0.170081005	1	0.711768985	1	0.0275715999	1	0.246021003	1
62	62	0.117358997	1	0.160463005	1	0.0302387998	1	0.0137882	1	0.417407006	1	0.246465996	1	0.0910137966	1	0.159614995	1	0.334610999	1	0.141840994	1	0.354310989	1	0.0806619003	1	0.268902004	1
63	63	0.106385	1	0.165926993	1	0.238146007	1	0.125153005	1	0.558318973	1	0.176717997	1	0.375892997	1	0.115492001	1	0.135343	1	0.172879994	1	0.65673399	1	0.0276816003	1	0.282326996	1
64	64	0.113282003	1	0.162691996	1	0.225462005	1	0.0799171999	1	0.532783985	1	0.184450001	1	0.383125007	1	0.110039003	1	0.147763997	1	0.189288005	1	0.634625971	1	0.0211204998	1	0.290021986	1
65	65	0.119388998	1	0.161454007	1	0.217197999	1	0.0614693016	1	0.526073992	1	0.188241005	1	0.393018991	1	0.114362001	1	0.147358999	1	0.180492997	1	0.686486006	1	0.0306800008	1	0.351179987	1
66	66	0.111679003	1	0.161553994	1	0.208118007	1	0.050229799	1	0.483352005	1	0.190641001	1	0.370617002	1	0.0903863981	1	0.150909007	1	0.192574993	1	0.659556985	1	0.0258872006	1	0.358646005	1
67	67	0.125202	1	0.160506994	1	0.172801003	1	0.0615750998	1	0.490833998	1	0.201640993	1	0.312620014	1	0.105301999	1	0.179545999	1	0.209171996	1	0.65376699	1	0.0460115001	1	0.362046987	1
68	68	0.116345003	1	0.164198995	1	0.0350904018	1	0.00858194008	1	0.406679988	1	0.333204001	1	0.0798711032	1	0.0716157034	1	0.349997997	1	0.118492998	1	0.315492988	1	0.0613449998	1	0.190516993	1
69	69	0.0982810035	1	0.160534993	1	0.0237364005	1	0.0052448702	1	0.348978013	1	0.287712008	1	0.0759966001	1	0.066895999	1	0.352274001	1	0.123607002	1	0.373457998	1	0.0806872025	1	0.106220998	1
70	70	0.0901105031	1	0.157350004	1	0.0273953993	1	0.0054450999	1	0.338535994	1	0.182765007	1	0.0456617996	1	0.0203674007	1	0.303187013	1	0.103239	1	0.479562998	1	0.0736161992	1	0.0915225968	1
71	71	0.0822703019	1	0.155111998	1	0.0279753003	1	0.00525086001	1	0.311325997	1	0.144057006	1	0.0365982018	1	0.00548268016	1	0.249999002	1	0.0979698971	1	0.50572902	1	0.073838301	1	0.0851543024	1
COMMIT;
