/*
 * The contents of this file are subject to the MonetDB Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.monetdb.org/Legal/MonetDBLicense
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is the MonetDB Database System.
 *
 * The Initial Developer of the Original Code is CWI.
 * Portions created by CWI are Copyright (C) 1997-July 2008 CWI.
 * Copyright August 2008-2015 MonetDB B.V.
 * All Rights Reserved.
 */

#ifndef _DATACELLS_
#define _DATACELLS_

#include "mal.h"
#include "mal_interpreter.h"
#include "sql.h"
#include "sql_scenario.h"
#include "basket.h"
#include "receptor.h"
#include "emitter.h"
#include "petrinet.h"

#ifdef WIN32
#ifndef LIBDATACELL
#define datacell_export extern __declspec(dllimport)
#else
#define datacell_export extern __declspec(dllexport)
#endif
#else
#define datacell_export extern
#endif


/* #define _DEBUG_DATACELL     debug this module */

datacell_export str DCprelude(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCinitialize(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCbasket(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCreceptor(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCemitter(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCpauseObject(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCresumeObject(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCstopObject(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCquery(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCdump(void *ret);
datacell_export str DCthreshold(bit *ret, str *bskt, int *mi);
datacell_export str DCwindow(bit *ret, str *bskt, lng *sz, lng *slide);
datacell_export str DCwindowBte(bit *ret, str *bskt, bte *sz, bte *slide);
datacell_export str DCwindowInt(bit *ret, str *bskt, int *sz, int *slide);
datacell_export str DCwindowSht(bit *ret, str *bskt, sht *sz, sht *slide);
datacell_export str DCtimewindow(bit *ret, str *bskt, lng *sz, lng *slide);
datacell_export str DCbeatBte(bit *ret, str *bskt, bte *t);
datacell_export str DCbeatSht(bit *ret, str *bskt, sht *t);
datacell_export str DCbeatInt(bit *ret, str *bskt, int *t);
datacell_export str DCbeat(bit *ret, str *bskt, lng *t);

datacell_export str DCpauseScheduler(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCresumeScheduler(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCstopScheduler(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);
datacell_export str DCpostlude(Client cntxt, MalBlkPtr mb, MalStkPtr stk, InstrPtr pci);


#endif
