/*
 * The contents of this file are subject to the MonetDB Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.monetdb.org/Legal/MonetDBLicense
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is the MonetDB Database System.
 *
 * The Initial Developer of the Original Code is CWI.
 * Portions created by CWI are Copyright (C) 1997-July 2008 CWI.
 * Copyright August 2008-2015 MonetDB B.V.
 * All Rights Reserved.
 */

/*
 * This code was created by Peter Harvey (mostly during Christmas 98/99).
 * This code is LGPL. Please ensure that this message remains in future
 * distributions and uses of this code (thats about all I get out of it).
 * - Peter Harvey pharvey@codebydesign.com
 *
 * This file has been modified for the MonetDB project.  See the file
 * Copyright in this directory for more information.
 */

/**********************************************************************
 * SQLBulkOperations()
 * CLI Compliance: ODBC (Microsoft)
 *
 * Author: Martin van Dinther, Sjoerd Mullender
 * Date  : 30 Aug 2002
 *
 **********************************************************************/

#include "ODBCGlobal.h"
#include "ODBCStmt.h"


#ifdef ODBCDEBUG
static char *
translateOperation(SQLSMALLINT Operation)
{
	switch (Operation) {
	case SQL_ADD:
		return "SQL_ADD";
	case SQL_UPDATE_BY_BOOKMARK:
		return "SQL_UPDATE_BY_BOOKMARK";
	case SQL_DELETE_BY_BOOKMARK:
		return "SQL_DELETE_BY_BOOKMARK";
	case SQL_FETCH_BY_BOOKMARK:
		return "SQL_FETCH_BY_BOOKMARK";
	default:
		return "invalid";
	}
}
#endif

SQLRETURN SQL_API
SQLBulkOperations(SQLHSTMT StatementHandle,
		  SQLSMALLINT Operation)
{
	ODBCStmt *stmt = (ODBCStmt *) StatementHandle;

#ifdef ODBCDEBUG
	ODBCLOG("SQLBulkOperations " PTRFMT " %s\n",
		PTRFMTCAST StatementHandle, translateOperation(Operation));
#endif

	if (!isValidStmt(stmt))
		 return SQL_INVALID_HANDLE;

	clearStmtErrors(stmt);

	if (stmt->State < EXECUTED0 || stmt->State == EXTENDEDFETCHED) {
		/* Function sequence error */
		addStmtError(stmt, "HY010", NULL, 0);
		return SQL_ERROR;
	}
	if (stmt->State == EXECUTED0) {
		/* Invalid cursor state */
		addStmtError(stmt, "24000", NULL, 0);
		return SQL_ERROR;
	}

	/* check Operation code */
	switch (Operation) {
	case SQL_ADD:
	case SQL_UPDATE_BY_BOOKMARK:
	case SQL_DELETE_BY_BOOKMARK:
	case SQL_FETCH_BY_BOOKMARK:
		break;
	default:
		/* Invalid attribute/option identifier */
		addStmtError(stmt, "HY092", NULL, 0);
		return SQL_ERROR;
	}

	/* TODO: finish implementation */

	/* Driver does not support this function */
	addStmtError(stmt, "IM001", NULL, 0);
	return SQL_ERROR;
}
