/* Copyright (c) 2006-2008 MetaCarta, Inc., published under the Clear BSD
 * license.  See http://svn.openlayers.org/trunk/openlayers/license.txt for the
 * full text of the license. */

/**
 * @requires OpenLayers/Lang.js
 */

/**
 * Namespace: OpenLayers.Lang["da-DK"]
 * Dictionary for Danish.  Keys for entries are used in calls to
 *     <OpenLayers.Lang.translate>.  Entry bodies are normal strings or
 *     strings formatted for use with <OpenLayers.String.format> calls.
 */
OpenLayers.Lang['da-DK'] = {

    'unhandledRequest': "En ikke hndteret foresprgsel returnerede ${statusText}",

    'permalink': "Permalink",

    'overlays': "Kortlag",

    'baseLayer': "Baggrundslag",

    'sameProjection':
        "Oversigtskortet fungerer kun nr det har samme projektion som hovedkortet",

    'readNotImplemented': "Lsning er ikke implementeret.",

    'writeNotImplemented': "Skrivning er ikke implementeret.",

    'noFID': "Kan ikke opdateret en feature (et objekt) der ikke har et FID.",

    'errorLoadingGML': "Fejlede under indlsning af GML fil ${url}",

    'browserNotSupported':
        "Din browser understtter ikke vektor visning. Flgende vektor visninger understttes:\n${renderers}",

    'componentShouldBe': "addFeatures : komponenten skal vre en ${geomType}",

    // console message
    'getFeatureError':
        "getFeatureFromEvent blev kaldt p et lag uden en visning. Dette betyder som regel at du " +
        "har destrueret et lag, men ikke de hndteringer der var tilknyttet.",

    // console message
    'minZoomLevelError':
        "Egenskaben minZoomLevel er kun beregnet til brug " +
        "med FixedZoomLevels. At dette WFS lag kontrollerer " +
        "minZoomLevel egenskaben, er et levn fra en tidligere " +
        "version. Vi kan desvrre ikke fjerne dette uden at risikere " +
        "at delgge eksisterende OL baserede programmer der " +
        " benytter denne funktionalitet. " +
        "Egenskaben br derfor ikke anvendes, og minZoomLevel " +
        "kontrollen herunder vil blive fjernet i version 3.0. " +
        "Benyt istedet min/max oplsnings indstillingerne, som " +
        "er beskrevet her: " +
        "http://trac.openlayers.org/wiki/SettingZoomLevels",

    'commitSuccess': "WFS transaktion: LYKKEDES ${response}",

    'commitFailed': "WFS transaktion: MISLYKKEDES ${response}",

    'googleWarning':
        "Google laget kunne ikke indlses.<br><br>" +
        "For at fjerne denne besked, vlg et nyt bagrundskort i " +
        "lagskifteren i verste hjre hjrne.<br><br>" +
        "Fejlen skyldes formentlig at Google Maps bibliotekts " +
        "scriptet ikke er inkluderet, eller ikke indeholder den " +
        "korrkte API ngle for dit site.<br><br>" +
        "Udviklere: For hjlp til at f dette til at fungere, " +
        "<a href='http://trac.openlayers.org/wiki/Google' " +
        "target='_blank'>klik her</a>",

    'getLayerWarning':
        "${layerType}-laget kunne ikke indlses.<br><br>" +
        "For at fjerne denne besked, vlg et nyt bagrundskort i " +
        "lagskifteren i verste hjre hjrne.<br><br>" +
        "Fejlen skyldes formentlig at ${layerLib} bibliotekts " +
        "scriptet ikke er inkluderet.<br><br>" +
        "Udviklere: For hjlp til at f dette til at fungere, " +
        "<a href='http://trac.openlayers.org/wiki/${layerLib}' " +
        "target='_blank'>klik her</a>",

    'scale': "Mlforhold = 1 : ${scaleDenom}",

    // console message
    'layerAlreadyAdded':
        "Du har forsgt at tilfje laget: ${layerName} til kortet, men det er allerede tilfjet",

    // console message
    'reprojectDeprecated':
        "Du anvender indstillingen 'reproject' p laget ${layerName}." + 
        "Denne indstilling br ikke lngere anvendes. Den var beregnet " +
        "til at vise data ovenp kommercielle grundkort, men den funktionalitet " +
        "br nu opns ved at anvende Spherical Mercator understttelsen. " +
        "Mere information er tilgngelig her: " +
        "http://trac.openlayers.org/wiki/SphericalMercator.",

    // console message
    'methodDeprecated':
        "Denne funktion br ikke lngere anvendes, og vil blive fjernet i version 3.0. " +
        "Anvend venligst funktionen ${newMethod} istedet.",

    // console message
    'boundsAddError': "Du skal angive bde x og y vrdier i kaldet til add funktionen.",

    // console message
    'lonlatAddError': "Du skal angive bde lon og lat vrdier i kaldet til add funktionen.",

    // console message
    'pixelAddError': "Du skal angive bde x og y vrdier i kaldet til add funktionen.",

    // console message
    'unsupportedGeometryType': "Geometri typen: ${geomType} er ikke understttet.",

    // console message
    'pagePositionFailed':
        "OpenLayers.Util.pagePosition fejlede: elementet med id ${elemId} er mske placeret forkert.",

    // console message
    'filterEvaluateNotImplemented': "evaluering er ikke implementeret for denne filter type."
};
