-- Convert schema 'kddart_v2_3_2_empty_pure_mysql.sql' to 'kddart_v2_4_empty_pure_mysql.sql':;

BEGIN;

SET foreign_key_checks=0;

DROP TABLE IF EXISTS `smgroup`;
CREATE TABLE smgroup (
  SMGroupId integer(11) NOT NULL comment 'internal group id' auto_increment,
  SMGroupName varchar(254) NOT NULL comment 'group name - has to be unique',
  TrialId integer(11) NOT NULL comment 'trial id measurements belong to - this is a constrain that grouping measurements between trials is not possible',
  OperatorId integer(11) NOT NULL comment 'user - owner of the group',
  SMGroupStatus varchar(20) NULL DEFAULT NULL comment 'status of the group',
  SMGroupDateTime datetime NOT NULL comment 'date and time of the group - possibly creation time or last update',
  SMGroupNote text NULL comment 'general comments for the group',
  INDEX smg_TrialId (TrialId),
  INDEX smg_OperatorId (OperatorId),
  INDEX smg_SMGroupDateTime (SMGroupDateTime),
  INDEX smg_SMGroupStatus (SMGroupStatus),
  PRIMARY KEY (SMGroupId),
  UNIQUE smg_SMGroupName (SMGroupName),
  CONSTRAINT smgroup_ibfk_1 FOREIGN KEY (TrialId) REFERENCES trial (TrialId) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT smgroup_ibfk_2 FOREIGN KEY (OperatorId) REFERENCES systemuser (UserId) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='Sample measurements for some portions of the trials may be grouped to distinct them from the same measurements, which were done before, but need to be retained or to have two sets which can be compared. It can also be used as means to keep several versions of the same dataset';

DROP TABLE IF EXISTS `traitgroup`;
CREATE TABLE traitgroup (
  TraitGroupId integer(11) NOT NULL comment 'trait group id' auto_increment,
  TraitGroupName varchar(254) NOT NULL comment 'name of the group',
  OperatorId integer(11) NULL DEFAULT NULL comment 'optional operator id - if defined than group may belong to this particular user',
  INDEX trg_OperatorId (OperatorId),
  PRIMARY KEY (TraitGroupId),
  UNIQUE trg_TraitGroupName (TraitGroupName, OperatorId),
  CONSTRAINT traitgroup_ibfk_1 FOREIGN KEY (OperatorId) REFERENCES systemuser (UserId) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='Group of traits. Can be used for various arbitrary purposes.';

DROP TABLE IF EXISTS `traitgroupentry`;
CREATE TABLE traitgroupentry (
  TraitGroupEntryId integer(11) NOT NULL comment 'trait group entry internal id' auto_increment,
  TraitId integer(11) NOT NULL comment 'trait id belonging to the group',
  TraitGroupId integer(11) NOT NULL comment 'trait group id',
  INDEX tge_TraitId (TraitId),
  INDEX tge_TraitGroupId (TraitGroupId),
  PRIMARY KEY (TraitGroupEntryId),
  CONSTRAINT traitgroupentry_ibfk_1 FOREIGN KEY (TraitGroupId) REFERENCES traitgroup (TraitGroupId) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT traitgroupentry_ibfk_2 FOREIGN KEY (TraitId) REFERENCES trait (TraitId) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='List of trait group members';

DROP TABLE IF EXISTS `uniquenumber`;
CREATE TABLE uniquenumber (
  UniqueNumberId integer(11) NOT NULL comment 'sytem wide unique number' auto_increment,
  PRIMARY KEY (UniqueNumberId)
) ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='Just to assure that every number provided in REST interface is always truly system wide unique.';

SET foreign_key_checks=1;

ALTER TABLE activitylog ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='A log of system user activities';

ALTER TABLE authorisedsystemgroup ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='List of users in system group.';

ALTER TABLE barcodeconf ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='Table to store the configuration for barcodes used in the system. DAL should accept any barcode string in any table as long as it is unique.  This table is an optional storage of information on how to generate barcode string automatically.  Conventions for definitions are a subject for separate documentation.';


ALTER TABLE contact ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='List of general contacts (not only system users, but also collaborators, material providers, site managers, etc). Links with organisation.';

ALTER TABLE crossing ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='A table which stores crossing information for nursery management';

ALTER TABLE designtype ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Each trial (experiment) has a design (layout/method) describing how the genotypes have been planted, the number of replicates, etc. Design type identifies the type of a trial design. For example: - Randomised Block using DiGGer - The trial design of this design type is generated by the DiGGer. - Unknown Design Type. ';

ALTER TABLE deviceregister ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Register of devices, which have access to the database to supply data. Devices to include those that supply environmental data or seed inventory data (e.g. scales) and extend to those that supply for phenotypic measurements.  One device can record more than one data type / parameter to more than one environment layer.';

ALTER TABLE factor ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Main database table containing the definitions of all virtual columns.  A uniform mechanism across the database where all tables with the suffix factor relate to this table.';

ALTER TABLE generaltype CHANGE COLUMN Class Class set('site', 'item', 'container', 'deviceregister', 'trial', 'trialevent', 'sample', 'specimengroup', 'specimengroupstatus', 'state', 'parent', 'itemparent', 'genotypespecimen', 'markerdataset', 'workflow', 'project', 'itemlog', 'plate', 'genmap', 'multimedia', 'tissue', 'genotypealias', 'genparent', 'genotypealiasstatus', 'traitgroup', 'unittype', 'trialgroup', 'breedingmethod', 'traitdatatype') NOT NULL comment 'class of type - possible values (site, item, container, deviceregister, trial, operation, sample, specimengroup, specimengroupstatus, state, parent, itemparent, genotypespecimen, markerdataset, workflow, project, itemlog, plate, genmap, multimedia, tissue, genotypealias, genparent, genotypealiasstatus, traitgroup, unittype, trialgroup, breedingmethod, traitdatatype)',
                        ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Contains global vocabularies of types to support classification. The class column lists the possible classes of types.  It also spans to types in Marker Module. With one exception of designtype table for trial all columns named *type refer to particular class of the types in this table. There are also some *status classifications contained here. Classes are: site, item, container, deviceregister, trial, operation, sample, specimengroup, specimengroupstatus, state, parent, itemparent, genotypespecimen, markerdataset, workflow, project, itemlog, plate, genmap, multimedia, tissue, genotypealias, genparent, genotypealiasstatus, traitgroup, unittype, multilocation';

ALTER TABLE generalunit ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Defines the units used in various places in the system';

ALTER TABLE genotype ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='List of genotypes available for trial units.  Direct relation to the trial unit maybe sometimes problematic, especially in horticulture when one plant can be a single trial unit and can be a hybrid of a few genotypes.  This is why specimen is established as a subunit of the genotype. In this case one genotype can have more than one specimen (plants, plant groups), which may grow in various locations.  Synonym for genotype can be variety or gemplams and should be used as a generic category. Specimen permission fields are only inherited from this table, using trigger and DAL mechanism.';

ALTER TABLE genotypealias ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='One genotype may have many historical names (aliases) under which it has been known.';

ALTER TABLE genotypespecimen ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Maintains the many to many relationship between genotype and specimen. In situations such as with horticulture it may be necessary to define the specimen (individual plant) using many genotypes (hybrid or chimera plants, e.g. trees which have a different root stock and scion).  Enables the definition of more common cases where multiple specimens from a genotype (e.g. individuals grown in different environments) need to be distinguished.  Type can be added, but is not mandatory.';

ALTER TABLE genotypetrait ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Table to store known characteristics for the genotype as a whole e.g. Average Flowing Dates, known disease resistance, observational traits like colour, etc. Useful if there have not been many (or any) trials on a particular genotype and at the same time there is some publicly known data.';

ALTER TABLE genpedigree ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='This is the same as pedigree table for specimen, but allows to keep pedigree at genotype level if needed - e.g. some generalization is required, while specimen pedigree can be utilized for e.g. selection history only. Gives flexibility to users to select one or use both constructs to track parent/child relationships.';

ALTER TABLE genus ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Logical group of genotypes, but not necessary strictly botanically related. Also referred to as crop or organism. ';

ALTER TABLE item ADD COLUMN LastUpdateTimeStamp datetime NOT NULL comment 'last update time',
                 ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Items, such as seed bags, stored in the inventory. A generic term and may be used for as inventory for a variety of material. ';

ALTER TABLE itemgroup ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Arbitrary Grouping of inventory items which may assist future retrieval, e.g. to group bags to be later sown in a trial. ';

ALTER TABLE itemparent ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='This is a bit complex, but allows full flexibility of splitting one item into many as well as grouping many items into one. Full trace of how the inventory items has been rearranged.';

ALTER TABLE keyword ADD COLUMN OperatorId integer(11) NULL DEFAULT NULL comment 'optional owner of the keyword',
                    ADD INDEX kw_OperatorId (OperatorId),
                    ADD UNIQUE kw_KeywordNameOperator (KeywordName, OperatorId),
                    ADD CONSTRAINT keyword_ibfk_1 FOREIGN KEY (OperatorId) REFERENCES systemuser (UserId) ON DELETE NO ACTION ON UPDATE NO ACTION,
                    ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='System wide collection of keywords';

ALTER TABLE keywordgroup DROP INDEX kwg_KeywordGroupName,
                         ADD COLUMN OperatorId integer(11) NULL DEFAULT NULL comment 'optional operator id - if defined than group may belong to this particular user',
                         ADD INDEX kwg_OperatorId (OperatorId),
                         ADD UNIQUE kwg_KeywordGroupName (KeywordGroupName, OperatorId),
                         ADD CONSTRAINT keywordgroup_ibfk_1 FOREIGN KEY (OperatorId) REFERENCES systemuser (UserId) ON DELETE NO ACTION ON UPDATE NO ACTION,
                         ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Arbitrary groups of keywords for easy search or other purpose.';

ALTER TABLE keywordgroupentry ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='list of keywords in the keyword group(s)';

ALTER TABLE multimedia ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='This table stores references for multimedia files stored in KDDart system. Files will be attached to particular records in other tables, to e.g. illustrate processes, events or document.';

ALTER TABLE organisation ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='List of collaborating and internal and/or external organisations. ';

ALTER TABLE pedigree ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Table, which defines specimen (genotype) pedigrees (genealogy). This design assumes that one specimen may have more than 2 parents, which is never a case in reality, but in some scenarios (e.g. bulk pollination)  this kind of information may need to be preserved.';

ALTER TABLE project ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='A very generic table to enable the grouping of trials according to some organisational distinction.  Projects may have very different requirements therefore it maybe more appropriate to use the factor column to standardise data within the organisation.';

ALTER TABLE samplemeasurement DROP PRIMARY KEY,
                              DROP FOREIGN KEY samplemeasurement_ibfk_5,
                              ADD COLUMN SMGroupId integer(11) NOT NULL DEFAULT 0 comment 'sample measurement group the measurement if part of - if any',
                              ADD COLUMN StateReason varchar(30) NULL DEFAULT NULL comment 'optional value state e.g. reason for rejection',
                              CHANGE COLUMN MeasureDateTime MeasureDateTime datetime NOT NULL comment 'date / time of the measurement',
                              CHANGE COLUMN TrialUnitSpecimenId TrialUnitSpecimenId integer(11) NOT NULL DEFAULT 0 comment 'optional value of trial unit specimen link if measurement is at the level of sub-trialunit',
                              ADD INDEX xsm_SMGroupId (SMGroupId),
                              ADD PRIMARY KEY (TrialUnitId, TraitId, OperatorId, InstanceNumber, SampleTypeId, TrialUnitSpecimenId, SMGroupId);

ALTER TABLE specimen ADD COLUMN SpecimenNote text NULL comment 'Comments about specimen if applicable',
                     ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Record for a specimen, i.e. individual plants or their representative groups. May appear to be artificial (i.e. if it is a representation of the whole genotype) however, provides consistency and allows the sampling of more plants (specimens) from the trial unit, as well as composing plant (specimen) from more than one genotype (e.g. in horticulture). Permissions to records are governed by (inherited from) genotype permissions. Relevant db trigger and DAL code takes care for this feature.';

ALTER TABLE specimengroup ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Defines a name for a group of specimens. Possible applications can be: many plants which went through selfing process; groups for next years testing; groups for genotyping.';

ALTER TABLE specimengroupentry ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Maintains the many to many relationship between specimens and specimens groups. ';

ALTER TABLE specimenkeyword ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='keywords for a specimen';

ALTER TABLE storage ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='General storage locations in a tree like hierarchy. Allows construction of locations such as: - Building 1 - Room 7 - Rack 5  - Shelf 299.';

ALTER TABLE systemgroup ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Definitions of system groups. Most important in setting record level privileges for many entities.';

ALTER TABLE systemuser ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='List of the system users who are authorised to access the system.';

-- Upgrade trait table BEGIN

DROP PROCEDURE IF EXISTS upgrade_trait_table;

DELIMITER //

CREATE PROCEDURE upgrade_trait_table()
BEGIN

DECLARE max_type_id, no_more_trait_dtype, is_t_dtype_exist, type_id INT default 0;

DECLARE t_dtype VARCHAR(255);

DECLARE cur_trait_dtype CURSOR FOR SELECT DISTINCT TraitDataType FROM trait;

DECLARE CONTINUE HANDLER FOR NOT FOUND SET no_more_trait_dtype = 1;

SELECT MAX(TypeId) INTO max_type_id FROM generaltype;

SET max_type_id = max_type_id + 1;

SET foreign_key_checks=0;

CREATE TABLE trait_tmp LIKE trait;
INSERT trait_tmp SELECT * FROM trait;

OPEN cur_trait_dtype;

FETCH cur_trait_dtype INTO t_dtype;

REPEAT

SELECT COUNT(TypeId) INTO is_t_dtype_exist FROM generaltype WHERE TypeName=t_dtype AND Class='traitdatatype';

IF is_t_dtype_exist = 0 THEN

INSERT INTO generaltype(TypeId,TypeName,Class) VALUES(max_type_id,t_dtype,'traitdatatype');

SET type_id = max_type_id;

SET max_type_id = max_type_id + 1;

ELSE

SELECT TypeId INTO type_id FROM generaltype WHERE TypeName=t_dtype AND Class='traitdatatype';

END IF;

UPDATE trait_tmp SET TraitDataType=type_id WHERE TraitDataType=t_dtype;

FETCH cur_trait_dtype INTO t_dtype;

UNTIL no_more_trait_dtype = 1
END REPEAT;

CLOSE cur_trait_dtype;

ALTER TABLE trait_tmp ADD COLUMN TraitLevel set('trialunit', 'subtrialunit', 'notetrialunit') NOT NULL DEFAULT 'trialunit' comment 'level at which trait is being used (scored), additional global distinction',
                  CHANGE COLUMN TraitDataType TraitDataType integer(11) NOT NULL comment 'data type as per general type Class traitdatatype (e.g.  DATE, TEXT, CATEGORICAL, ELAPSED_DAYS, INTEGER, DECIMAL) possibly others',
                  ADD INDEX xt_TraitDataType (TraitDataType),
                  ADD INDEX xt_TraitLevel (TraitLevel),
                  ENGINE=InnoDB DEFAULT CHARACTER SET utf8 comment='Defines the measurement values for the genotype and trial. The specification of a validation rule is optional, however the format must adhere to either a regular or boolean expression. For example a validation rule could be: - Regular Expression TraitValRule=([A-Z]*) - Boolean Expression TraitValRule=(xg1 and xk50) ';

DROP TABLE IF EXISTS trait;

CREATE TABLE trait LIKE trait_tmp;
INSERT trait SELECT * FROM trait_tmp;

DROP TABLE IF EXISTS trait_tmp;

SET foreign_key_checks=1;

END//

DELIMITER ;

CALL upgrade_trait_table();

DROP PROCEDURE IF EXISTS upgrade_trait_table;

-- Upgrade trait table END

ALTER TABLE traitalias ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='List of alias names for traits. Sometime for e.g. multinational organisations the same trait can be translated into several languages.  The TraitLang column provides standard language code for translation interfaces. ';

ALTER TABLE treatment ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Description (or value) for a treatment for trial unit (plot). Useful if trying to measure response to certain level of irrigations, fertilisation, etc.';

ALTER TABLE trial ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='This table contains list of trials (equivalent to field experiments) performed within sites. ';

ALTER TABLE trialdimension ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Optional definition of the trial dimensionality. If user wants to define that X dimension is called e.g. row and Y dimension is called column - this is a place to do it. In the future this can be extended to contain trial level information about e.g. plot width, plot height, plot spaces, etc. Trial and dimention combination has to be unique - forced by unique index.';

ALTER TABLE trialevent ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Trial events are additional descriptors for operations (events) affecting an entire trial.  Example events:  - spray nitrogen 10 tons,  - rain shed over trial during flowering season,  - catastrophic rainfall or thunder, etc.';

ALTER TABLE trialgroup ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Multi location trial grouping. Arbitrary grouping of trials, can be used e.g. for multienvironmental trials or group of trials in multi year experiment, which may or may not share the design.';

ALTER TABLE trialgroupentry ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Many to many link between trials and trial group';

ALTER TABLE trialtrait ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Part of the trial definition. List of traits expected to be measured for a trial. This table should be rather treated as a control checkpoint, while inserting real measurements into samplemeasurement table.';

ALTER TABLE trialunit ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='This table stores information about each unit of the trial. It assumes that the unit is homogeneous.  One trial unit can contain more than one specimen (e.g. for hybrid plants or when one plant died and another was replanted in place).  Trial unit is a measured unit, which can be further divided by sample types distinguished within.';

ALTER TABLE trialunitkeyword ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='keywords for a trial unit';

ALTER TABLE trialunitspecimen ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Maintains the many to many relationship between trialunit and specimens. If specimen is the representation of the whole genotype (or composition of genotypes), it will have a single record here. Allows the sampling of multiple specimens from a unit.  For instances of long lived trials (e.g. tree living 30 years) this enables the reassignment of the same plant into different trial units.';

ALTER TABLE workflow ENGINE=InnoDB  DEFAULT CHARACTER SET utf8 comment='Contains workflows used in the system for trial workflows and can also be used to link to other processes.  Caters for the definition of multiple workflows for different situations.';

COMMIT;

