--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions';


SET search_path = public, pg_catalog;

--
-- Name: _group_concat(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION _group_concat(text, text) RETURNS text
    LANGUAGE sql IMMUTABLE
    AS $_$
SELECT CASE
WHEN $2 IS NULL THEN $1
WHEN $1 IS NULL THEN $2
ELSE $1 operator(pg_catalog.||) ' ' operator(pg_catalog.||) $2
END
$_$;


ALTER FUNCTION public._group_concat(text, text) OWNER TO postgres;

--
-- Name: group_concat(text); Type: AGGREGATE; Schema: public; Owner: postgres
--

CREATE AGGREGATE group_concat(text) (
    SFUNC = _group_concat,
    STYPE = text
);


ALTER AGGREGATE public.group_concat(text) OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: contactloc; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE contactloc (
    contactid bigint NOT NULL,
    contactlocation geography(MultiPoint,4326) NOT NULL
);


ALTER TABLE contactloc OWNER TO kddart_dal;

--
-- Name: COLUMN contactloc.contactid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN contactloc.contactid IS '(FK) contact id from the main database';


--
-- Name: COLUMN contactloc.contactlocation; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN contactloc.contactlocation IS 'contact location - should have spatial index GIST in PostGIS!!!';


--
-- Name: datadevice; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE datadevice (
    layerattrib bigint NOT NULL,
    deviceid character varying(100) NOT NULL,
    deviceparam character varying NOT NULL,
    active smallint DEFAULT 1 NOT NULL
);


ALTER TABLE datadevice OWNER TO kddart_dal;

--
-- Name: COLUMN datadevice.layerattrib; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN datadevice.layerattrib IS 'id of the attribute column of the layer where this device will be logging into';


--
-- Name: COLUMN datadevice.deviceid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN datadevice.deviceid IS '(FK) Device Id from the core database - DeviceRegister table';


--
-- Name: COLUMN datadevice.deviceparam; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN datadevice.deviceparam IS 'Name of the parameter from the device for that attribute';


--
-- Name: COLUMN datadevice.active; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN datadevice.active IS '[0,1] flag to indicate if this definition is active. Definitions should not be removed';


--
-- Name: layer; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layer (
    id integer NOT NULL,
    parent bigint,
    name character varying(100) NOT NULL,
    alias character varying(100),
    layertype character varying(30) DEFAULT 'layer'::character varying NOT NULL,
    layermetadata text,
    iseditable smallint DEFAULT 1 NOT NULL,
    createuser bigint DEFAULT 0 NOT NULL,
    createtime timestamp without time zone NOT NULL,
    lastupdateuser bigint NOT NULL,
    lastupdatetime timestamp without time zone NOT NULL,
    srid bigint DEFAULT 4326 NOT NULL,
    geometrytype character varying(30) NOT NULL,
    description character varying(254),
    owngroupid bigint NOT NULL,
    accessgroupid bigint DEFAULT 0 NOT NULL,
    owngroupperm smallint NOT NULL,
    accessgroupperm smallint DEFAULT 0 NOT NULL,
    otherperm smallint DEFAULT 0 NOT NULL
);


ALTER TABLE layer OWNER TO kddart_dal;

--
-- Name: COLUMN layer.id; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.id IS 'internal id';


--
-- Name: COLUMN layer.parent; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.parent IS 'id of the parent layer';


--
-- Name: COLUMN layer.name; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.name IS 'layer name';


--
-- Name: COLUMN layer.alias; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.alias IS 'layer alias';


--
-- Name: COLUMN layer.layertype; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.layertype IS 'layer, layer2d, layerimg - these three values refer to the base name of the real layer';


--
-- Name: COLUMN layer.layermetadata; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.layermetadata IS 'metadata for a layer. Can be a piece of xml or some sort of other agreed convention to store info about data';


--
-- Name: COLUMN layer.iseditable; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.iseditable IS '0|1 flag defining if layer can be edited. Set to 0 to disable edits.';


--
-- Name: COLUMN layer.createuser; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.createuser IS 'id of the system user, who created the layer';


--
-- Name: COLUMN layer.createtime; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.createtime IS 'date and time of the layer creation';


--
-- Name: COLUMN layer.lastupdateuser; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.lastupdateuser IS 'id of the system user, who last updated the layer info or field definition (not a data in the layer!)';


--
-- Name: COLUMN layer.lastupdatetime; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.lastupdatetime IS 'date and time of layer info or definition update';


--
-- Name: COLUMN layer.srid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.srid IS 'spatial reference id - refer to http://en.wikipedia.org/wiki/SRID';


--
-- Name: COLUMN layer.geometrytype; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.geometrytype IS 'for internal layers this is the type of the geometry column in LayerN table, have to match OGC standards (POINT, MULTIPOINT, POLYGON .. etc)';


--
-- Name: COLUMN layer.description; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.description IS 'layer description';


--
-- Name: COLUMN layer.owngroupid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.owngroupid IS 'group id which owns the record';


--
-- Name: COLUMN layer.accessgroupid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.accessgroupid IS 'group id which can access the record (different than owngroup)';


--
-- Name: COLUMN layer.owngroupperm; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.owngroupperm IS 'permission for the own group members';


--
-- Name: COLUMN layer.accessgroupperm; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.accessgroupperm IS 'permission for the other group members';


--
-- Name: COLUMN layer.otherperm; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer.otherperm IS 'permission for all the other system users';


--
-- Name: layer2; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layer2 (
    id integer NOT NULL,
    geometry geography(Point,4326)
);


ALTER TABLE layer2 OWNER TO kddart_dal;

--
-- Name: layer2_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layer2_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layer2_id_seq OWNER TO kddart_dal;

--
-- Name: layer2_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layer2_id_seq OWNED BY layer2.id;


--
-- Name: layer2attrib; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layer2attrib (
    id integer NOT NULL,
    layerid bigint,
    layerattrib bigint,
    value character varying(254),
    dt timestamp without time zone,
    systemuserid bigint
);


ALTER TABLE layer2attrib OWNER TO kddart_dal;

--
-- Name: layer2attrib_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layer2attrib_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layer2attrib_id_seq OWNER TO kddart_dal;

--
-- Name: layer2attrib_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layer2attrib_id_seq OWNED BY layer2attrib.id;


--
-- Name: layer2dn; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layer2dn (
    id integer NOT NULL,
    geometry geography(GeometryCollection,4326) NOT NULL,
    attributex bigint
);


ALTER TABLE layer2dn OWNER TO kddart_dal;

--
-- Name: COLUMN layer2dn.id; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer2dn.id IS 'numeric id of the geometric object';


--
-- Name: COLUMN layer2dn.geometry; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer2dn.geometry IS 'geometric object';


--
-- Name: COLUMN layer2dn.attributex; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layer2dn.attributex IS 'list of attributes defined in layerattrib table for this layer';


--
-- Name: layer2dn_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layer2dn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layer2dn_id_seq OWNER TO kddart_dal;

--
-- Name: layer2dn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layer2dn_id_seq OWNED BY layer2dn.id;


--
-- Name: layer_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layer_id_seq OWNER TO kddart_dal;

--
-- Name: layer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layer_id_seq OWNED BY layer.id;


--
-- Name: layerattrib; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layerattrib (
    id integer NOT NULL,
    unitid bigint NOT NULL,
    layer bigint NOT NULL,
    colname character varying(100) NOT NULL,
    coltype character varying(30) NOT NULL,
    colsize bigint NOT NULL,
    validation character varying(254),
    colunits character varying(100) NOT NULL
);


ALTER TABLE layerattrib OWNER TO kddart_dal;

--
-- Name: COLUMN layerattrib.id; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.id IS 'internal id';


--
-- Name: COLUMN layerattrib.unitid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.unitid IS 'unitid (FK) to generalunit table in core structure';


--
-- Name: COLUMN layerattrib.layer; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.layer IS 'layer id';


--
-- Name: COLUMN layerattrib.colname; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.colname IS 'name of the attribute column';


--
-- Name: COLUMN layerattrib.coltype; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.coltype IS 'type of the column';


--
-- Name: COLUMN layerattrib.colsize; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.colsize IS 'size of the column';


--
-- Name: COLUMN layerattrib.validation; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.validation IS 'rules for value validation';


--
-- Name: COLUMN layerattrib.colunits; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerattrib.colunits IS 'what units the value is in (e.g. deg Celsius, km, percent)';


--
-- Name: layerattrib_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layerattrib_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layerattrib_id_seq OWNER TO kddart_dal;

--
-- Name: layerattrib_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layerattrib_id_seq OWNED BY layerattrib.id;


--
-- Name: layerimgn; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layerimgn (
    id integer NOT NULL,
    geometry geography(GeometryCollection,4326) NOT NULL,
    imgfile character varying(1000) NOT NULL
);


ALTER TABLE layerimgn OWNER TO kddart_dal;

--
-- Name: COLUMN layerimgn.id; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerimgn.id IS 'numeric id of the geometric object';


--
-- Name: COLUMN layerimgn.geometry; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerimgn.geometry IS 'geometric object (polygon - usually rectangle - defined by corners of the image)';


--
-- Name: COLUMN layerimgn.imgfile; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layerimgn.imgfile IS 'path to the georeferenced image file. Geometry column in this case defines rectangle with the image boundaries';


--
-- Name: layerimgn_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layerimgn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layerimgn_id_seq OWNER TO kddart_dal;

--
-- Name: layerimgn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layerimgn_id_seq OWNED BY layerimgn.id;


--
-- Name: layern; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layern (
    id integer NOT NULL,
    geometry geography(GeometryCollection,4326) NOT NULL
);


ALTER TABLE layern OWNER TO kddart_dal;

--
-- Name: COLUMN layern.id; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layern.id IS 'internal id';


--
-- Name: COLUMN layern.geometry; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layern.geometry IS 'geo object of some geometrical type - should have spatial index GIST in PostGIS!!!';


--
-- Name: layern_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layern_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layern_id_seq OWNER TO kddart_dal;

--
-- Name: layern_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layern_id_seq OWNED BY layern.id;


--
-- Name: layernattrib; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE layernattrib (
    id integer NOT NULL,
    layerid bigint NOT NULL,
    layerattrib bigint NOT NULL,
    value character varying(254),
    dt timestamp without time zone,
    systemuserid bigint,
    deviceid character varying(100)
);


ALTER TABLE layernattrib OWNER TO kddart_dal;

--
-- Name: COLUMN layernattrib.id; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layernattrib.id IS 'internal id';


--
-- Name: COLUMN layernattrib.layerid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layernattrib.layerid IS 'id of the geometric object in layern table';


--
-- Name: COLUMN layernattrib.layerattrib; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layernattrib.layerattrib IS 'layer attribute id';


--
-- Name: COLUMN layernattrib.value; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layernattrib.value IS 'value of the parameter';


--
-- Name: COLUMN layernattrib.dt; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layernattrib.dt IS 'date and time';


--
-- Name: COLUMN layernattrib.systemuserid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN layernattrib.systemuserid IS 'system user, who inserted the data value (links to core database)';


--
-- Name: layernattrib_id_seq; Type: SEQUENCE; Schema: public; Owner: kddart_dal
--

CREATE SEQUENCE layernattrib_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE layernattrib_id_seq OWNER TO kddart_dal;

--
-- Name: layernattrib_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: kddart_dal
--

ALTER SEQUENCE layernattrib_id_seq OWNED BY layernattrib.id;


--
-- Name: siteloc; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE siteloc (
    siteid bigint NOT NULL,
    sitelocation geography(MultiPolygon,4326) NOT NULL
);


ALTER TABLE siteloc OWNER TO kddart_dal;

--
-- Name: COLUMN siteloc.siteid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN siteloc.siteid IS '(FK) site id from main database';


--
-- Name: COLUMN siteloc.sitelocation; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN siteloc.sitelocation IS 'polygon geometry for site - should have spatial index GIST in PostGIS!!!';


--
-- Name: trialloc; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE trialloc (
    trialid bigint NOT NULL,
    triallocation geography(MultiPolygon,4326) NOT NULL
);


ALTER TABLE trialloc OWNER TO kddart_dal;

--
-- Name: COLUMN trialloc.trialid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN trialloc.trialid IS '(FK) trial id from the main database';


--
-- Name: COLUMN trialloc.triallocation; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN trialloc.triallocation IS 'geometry object for the trial - should have spatial index GIST in PostGIS!!!';


--
-- Name: trialunitloc; Type: TABLE; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE TABLE trialunitloc (
    trialunitid bigint NOT NULL,
    trialunitlocation geography(GeometryCollection,4326) NOT NULL
);


ALTER TABLE trialunitloc OWNER TO kddart_dal;

--
-- Name: COLUMN trialunitloc.trialunitid; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN trialunitloc.trialunitid IS '(FK) trial unit id from the main database';


--
-- Name: COLUMN trialunitloc.trialunitlocation; Type: COMMENT; Schema: public; Owner: kddart_dal
--

COMMENT ON COLUMN trialunitloc.trialunitlocation IS 'geometry of the trial unit - should have spatial index GIST in PostGIS!!!';


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layer ALTER COLUMN id SET DEFAULT nextval('layer_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layer2 ALTER COLUMN id SET DEFAULT nextval('layer2_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layer2attrib ALTER COLUMN id SET DEFAULT nextval('layer2attrib_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layer2dn ALTER COLUMN id SET DEFAULT nextval('layer2dn_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layerattrib ALTER COLUMN id SET DEFAULT nextval('layerattrib_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layerimgn ALTER COLUMN id SET DEFAULT nextval('layerimgn_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layern ALTER COLUMN id SET DEFAULT nextval('layern_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layernattrib ALTER COLUMN id SET DEFAULT nextval('layernattrib_id_seq'::regclass);


--
-- Data for Name: contactloc; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY contactloc (contactid, contactlocation) FROM stdin;
\.


--
-- Data for Name: datadevice; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY datadevice (layerattrib, deviceid, deviceparam, active) FROM stdin;
\.


--
-- Data for Name: layer; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layer (id, parent, name, alias, layertype, layermetadata, iseditable, createuser, createtime, lastupdateuser, lastupdatetime, srid, geometrytype, description, owngroupid, accessgroupid, owngroupperm, accessgroupperm, otherperm) FROM stdin;
2	\N	MyLayer01	ml01xy	layer	\N	1	0	2015-11-29 20:22:48	0	2015-11-29 20:22:48	0	POINT	desc ml01 mod	0	0	7	0	5
\.


--
-- Data for Name: layer2; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layer2 (id, geometry) FROM stdin;
\.


--
-- Name: layer2_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layer2_id_seq', 1, false);


--
-- Data for Name: layer2attrib; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layer2attrib (id, layerid, layerattrib, value, dt, systemuserid) FROM stdin;
\.


--
-- Name: layer2attrib_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layer2attrib_id_seq', 1, false);


--
-- Data for Name: layer2dn; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layer2dn (id, geometry, attributex) FROM stdin;
\.


--
-- Name: layer2dn_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layer2dn_id_seq', 1, false);


--
-- Name: layer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layer_id_seq', 2, true);


--
-- Data for Name: layerattrib; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layerattrib (id, unitid, layer, colname, coltype, colsize, validation, colunits) FROM stdin;
3	1	2	attributeno2	Value	10	\N	Cdeg
4	1	2	attributeno1	Value	10	\N	Cdeg
\.


--
-- Name: layerattrib_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layerattrib_id_seq', 4, true);


--
-- Data for Name: layerimgn; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layerimgn (id, geometry, imgfile) FROM stdin;
\.


--
-- Name: layerimgn_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layerimgn_id_seq', 1, false);


--
-- Data for Name: layern; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layern (id, geometry) FROM stdin;
\.


--
-- Name: layern_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layern_id_seq', 1, false);


--
-- Data for Name: layernattrib; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY layernattrib (id, layerid, layerattrib, value, dt, systemuserid, deviceid) FROM stdin;
\.


--
-- Name: layernattrib_id_seq; Type: SEQUENCE SET; Schema: public; Owner: kddart_dal
--

SELECT pg_catalog.setval('layernattrib_id_seq', 1, false);


--
-- Data for Name: siteloc; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY siteloc (siteid, sitelocation) FROM stdin;
1	0106000020E610000001000000010300000001000000120000006F0340E8C8B96240638B043D32423EC0600340E01BBA6240F70A638528423EC0BD0340D067BA624043AAF7D4A9443EC0DC03405051BA6240D0B4FCDB31453EC0630340A844BA624018321F0593453EC0FA0340D03ABA6240E0F90A9F4B463EC06C0340902FBA62400C919B3704473EC0600340E01BBA6240E0C28EA99F473EC061044038E2B96240D67955D410493EC08F034068B2B96240849D3FD5644A3EC0AE0340E89BB96240C9FFD841004B3EC0240440C87FB96240996C96D3304B3EC0D903401899B96240CC26B2C468463EC06D034020A0B96240E726B473A6453EC0A4034000B1B962401335F9B514453EC05B034050CAB96240E4E365F782443EC055044088CEB962402CA5A5842B443EC06F0340E8C8B96240638B043D32423EC0
2	0106000020E6100000010000000103000000010000000E00000040A43F12FC54614088AC69C39B4141C05AA43F8E7F556140A356D920974141C0D7A43F1A11566140FD1A8F04D84141C014A53F6E175661405827F55DF74241C02AA43FEA8C556140364C5E00FC4241C05AA43F8E7F556140E791F456CB4241C0CFA43F6E63556140CD3D37CDB84241C046A43FA24D5561400B03DE0A964241C042A43FDA24556140234E58E34B4241C020A53F3E0C55614083CDDFE7184241C07CA43F6602556140A81A15AF084241C06BA43F42F9546140625A4AB3D54141C0FEA43FF6F9546140F3DAC092B74141C040A43F12FC54614088AC69C39B4141C0
3	0106000020E61000000100000001030000000100000005000000FBD1BDB0A2C958C0DE86E47067B53240C9D3BD7032C558C013BA313212B53240ABD2BDF01BC558C0D272E038C0A53240F2D1BD701ECA58C0D1FD847FEAA73240FBD1BDB0A2C958C0DE86E47067B53240
4	0106000020E61000000100000001030000000100000009000000718313E6C2B141401FD0C696A4140B40008313E662004440E2AAF9BE223807400E8313E682EF4340F1778551AD8407C0478313E6E2DB4240566BF713C7A703C02A8313E6822D4240E63FB148772400C0558313E6429B41404323BCD20226F7BF0E8313E6C25741400DC1B93FDEB76A3F558313E6429B4140143D5557929AE63F718313E6C2B141401FD0C696A4140B40
5	0106000020E61000000100000001030000000100000006000000590487F081523D403E0B7949889732C0050487F001773E40B2A4CC1686A732C0D88143F8902A4040663A1B16763732C0210487F081F53F40E2D6C4FEA31031C0B00387F081AC3D40A9B1387C4CC530C0590487F081523D403E0B7949889732C0
6	0106000020E61000000100000001030000000100000008000000DDFEFF9FB46B22405236E384C95B484022FFFF9F956C224098D600FEE95B484051FFFF3FA96D2240FA3A2D20F55B4840D8FDFF3F036E2240D9EF0AF1D05B4840B4FFFFBF466E224006BBFB67A45B48403BFEFFBFA06E2240FEFC5987625B484002FEFF1F256C22409AAE2AE6505B4840DDFEFF9FB46B22405236E384C95B4840
7	0106000020E6100000010000000103000000010000000A000000ED8C3041852A63404B3465D5CBAB3CC0C98D30F99F2A6340E932B61C05A93CC0F48C30D1D62A634045965CB3F0A73CC04E8D30F9F92A6340BDDD4C3018A83CC0448D30110F2B6340697E9E7D66A73CC09E8D3039322B634028CE002A67A83CC0BC8C3061552B634093F194C784A83CC0B68D3099592B63400166502037AA3CC0AF8C30B1412B6340D122AD2A2FAD3CC0ED8C3041852A63404B3465D5CBAB3CC0
\.


--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY spatial_ref_sys  FROM stdin;
\.


--
-- Data for Name: trialloc; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY trialloc (trialid, triallocation) FROM stdin;
2	0106000020E610000001000000010300000001000000050000003973BF0C00BA62409E369CB512473EC03773BF5205BA6240578A3BE2EE463EC0EC723FED08BA62408175CDD00A473EC0EE723FA703BA6240F068CDD12C473EC03973BF0C00BA62409E369CB512473EC0
4	0106000020E6100000010000000103000000010000000500000049A5FF3F4A5561406419F9B0234241C01FA5FF6C4A5561409D370A62E34141C034A4FF0980556140C42C6839E24141C034A4FF09805561407AB408F4214241C049A5FF3F4A5561406419F9B0234241C0
5	0106000020E6100000010000000103000000010000000500000077733F08EEB962405051365C5A473EC04A733F7BF3B96240A3AE7DED35473EC009733FB3F7B96240F683522559473EC05F733F13F2B962403B5337267B473EC077733F08EEB962405051365C5A473EC0
6	0106000020E61000000100000001030000000100000005000000CF733FC5E5B962400752534821473EC077733F65EBB962402789A0A2FB463EC0CA733F51F0B9624036D1377F22473EC0BA723FDEEAB9624096AAF7ED46473EC0CF733FC5E5B962400752534821473EC0
7	0106000020E61000000100000001030000000100000005000000A7A53F63B95561401629DAC5594241C0A7A53F63B95561409DCCC37F994241C094A53F3182556140F04612149A4241C094A53F3182556140D505EC08584241C0A7A53F63B95561401629DAC5594241C0
8	0106000020E61000000100000001030000000100000005000000FE03A0460ABA6240F37CC4DB72463EC0300420FD0FBA6240D94ED25278463EC0F103209211BA6240B01A621933463EC0710420C50BBA6240086E50A22D463EC0FE03A0460ABA6240F37CC4DB72463EC0
10	0106000020E61000000100000001030000000100000005000000B315C0E7EFC658C0AE50A4E7D9AE3240A615C0DADEC658C03C55F23ED1AE3240AB13C0F6E0C658C0EFF03546B1AE3240CA14C030F2C658C02D76F143BBAE3240B315C0E7EFC658C0AE50A4E7D9AE3240
9	0106000020E61000000100000001030000000100000005000000A382D3C5948A4240EC6B1701DBDCE8BFBE8253E49B8A424030C95E1F24DDE8BF8F82D3EC9A8A4240A9DE41F250DFE8BFA082D3B7938A4240040F95B318DFE8BFA382D3C5948A4240EC6B1701DBDCE8BF
11	0106000020E610000001000000010300000001000000050000007A12C03BC9C658C0350C59E0F9AE3240E912C04ABAC658C093FB15E3EDAE32400B124031BDC658C0DD786E94D0AE32400B13C092CCC658C04226FD3BDEAE32407A12C03BC9C658C0350C59E0F9AE3240
12	0106000020E610000001000000010300000001000000050000005E056717AD2D3F40919AA4BA7FDA31C08B05670F002E3F400962442191DA31C08F0567BBF92D3F40D1CFD19BB6DA31C0B505673FA32D3F4037A38DDCA1DA31C05E056717AD2D3F40919AA4BA7FDA31C0
1	0106000020E6100000010000000103000000010000000600000063733FB6F4B96240FF344885BF463EC016743F83FAB96240DC1656169B463EC023743F61FEB96240FE593E0EBA463EC0AD73BF04F9B9624010F37C4FE0463EC0AD73BF04F9B9624010F37C4FE0463EC063733FB6F4B96240FF344885BF463EC0
13	0106000020E610000001000000010300000001000000050000005914C0B6D5C658C0A51089006CAE32409113C022C4C658C0650BDAAC64AE32403C86BC2BC7C658C0608BAD5343AE32409A13C075DAC658C02492DC5B51AE32405914C0B6D5C658C0A51089006CAE3240
14	0106000020E61000000100000001030000000100000005000000FD743FC602BA6240C658B07978463EC0E6743F7409BA62403C9F17C37F463EC0FB743F0C08BA6240AF66DBC4B2463EC0E9743F8B01BA624058F4DF9FA6463EC0FD743FC602BA6240C658B07978463EC0
15	0106000020E610000001000000010300000001000000050000003D03403B0CBA6240EA6C277283463EC0660340B10EBA6240EF83677B86463EC04A02C0E60DBA624008D0C433B2463EC0530340D30ABA62404013862AAF463EC03D03403B0CBA6240EA6C277283463EC0
16	0106000020E61000000100000001030000000100000005000000328D30D5F02A6340EB36F83B35AA3CC0BC8C305CF12A6340E09452FE6DAA3CC00A8D30EC152B6340E09452FE6DAA3CC00A8D30EC152B6340736D558831AA3CC0328D30D5F02A6340EB36F83B35AA3CC0
\.


--
-- Data for Name: trialunitloc; Type: TABLE DATA; Schema: public; Owner: kddart_dal
--

COPY trialunitloc (trialunitid, trialunitlocation) FROM stdin;
3793	0107000020E61000000100000001010000001E166A4DF32A634027C286A757AA3CC0
3794	0107000020E61000000100000001010000001E166A4DF32A63408A1F63EE5AAA3CC0
3795	0107000020E61000000100000001010000001E166A4DF32A6340EE7C3F355EAA3CC0
3796	0107000020E61000000100000001010000001E166A4DF32A634051DA1B7C61AA3CC0
3797	0107000020E61000000100000001010000001E166A4DF32A6340B537F8C264AA3CC0
3798	0107000020E61000000100000001010000001E166A4DF32A63401895D40968AA3CC0
3799	0107000020E61000000100000001010000001E166A4DF32A63407CF2B0506BAA3CC0
3800	0107000020E61000000100000001010000001E166A4DF32A6340DF4F8D976EAA3CC0
3801	0107000020E61000000100000001010000001E166A4DF32A634043AD69DE71AA3CC0
3802	0107000020E61000000100000001010000001E166A4DF32A6340A60A462575AA3CC0
3803	0107000020E6100000010000000101000000D044D8F0F42A634027C286A757AA3CC0
3804	0107000020E6100000010000000101000000D044D8F0F42A63408A1F63EE5AAA3CC0
3805	0107000020E6100000010000000101000000D044D8F0F42A6340EE7C3F355EAA3CC0
3806	0107000020E6100000010000000101000000D044D8F0F42A634051DA1B7C61AA3CC0
3807	0107000020E6100000010000000101000000D044D8F0F42A6340B537F8C264AA3CC0
3808	0107000020E6100000010000000101000000D044D8F0F42A63401895D40968AA3CC0
3809	0107000020E6100000010000000101000000D044D8F0F42A63407CF2B0506BAA3CC0
3810	0107000020E6100000010000000101000000D044D8F0F42A6340DF4F8D976EAA3CC0
3811	0107000020E6100000010000000101000000D044D8F0F42A634043AD69DE71AA3CC0
3812	0107000020E6100000010000000101000000D044D8F0F42A6340A60A462575AA3CC0
3813	0107000020E610000001000000010100000082734694F64A634027C286A757AA3CC0
3814	0107000020E610000001000000010100000082734694F64A63408A1F63EE5AAA3CC0
3815	0107000020E610000001000000010100000082734694F64A6340EE7C3F355EAA3CC0
3816	0107000020E610000001000000010100000082734694F64A634051DA1B7C61AA3CC0
3817	0107000020E610000001000000010100000082734694F64A6340B537F8C264AA3CC0
3818	0107000020E610000001000000010100000082734694F64A63401895D40968AA3CC0
3819	0107000020E610000001000000010100000082734694F64A63407CF2B0506BAA3CC0
3820	0107000020E610000001000000010100000082734694F64A6340DF4F8D976EAA3CC0
3821	0107000020E610000001000000010100000082734694F64A634043AD69DE71AA3CC0
3822	0107000020E610000001000000010100000082734694F64A6340A60A462575AA3CC0
3823	0107000020E610000001000000010100000034A2B437F82A634027C286A757AA3CC0
3824	0107000020E610000001000000010100000034A2B437F82A63408A1F63EE5AAA3CC0
3825	0107000020E610000001000000010100000034A2B437F82A6340EE7C3F355EAA3CC0
3826	0107000020E610000001000000010100000034A2B437F82A634051DA1B7C61AA3CC0
3827	0107000020E610000001000000010100000034A2B437F82A6340B537F8C264AA3CC0
3828	0107000020E610000001000000010100000034A2B437F82A63401895D40968AA3CC0
3829	0107000020E610000001000000010100000034A2B437F82A63407CF2B0506BAA3CC0
3830	0107000020E610000001000000010100000034A2B437F82A6340DF4F8D976EAA3CC0
3831	0107000020E610000001000000010100000034A2B437F82A634043AD69DE71AA3CC0
3832	0107000020E610000001000000010100000034A2B437F82A6340A60A462575AA3CC0
3833	0107000020E6100000010000000101000000E5D022DBF92A634027C286A757AA3CC0
3834	0107000020E6100000010000000101000000E5D022DBF92A63408A1F63EE5AAA3CC0
3835	0107000020E6100000010000000101000000E5D022DBF92A6340EE7C3F355EAA3CC0
3836	0107000020E6100000010000000101000000E5D022DBF92A634051DA1B7C61AA3CC0
3837	0107000020E6100000010000000101000000E5D022DBF92A6340B537F8C264AA3CC0
3838	0107000020E6100000010000000101000000E5D022DBF92A63401895D40968AA3CC0
3839	0107000020E6100000010000000101000000E5D022DBF92A63407CF2B0506BAA3CC0
3840	0107000020E6100000010000000101000000E5D022DBF92A6340DF4F8D976EAA3CC0
3841	0107000020E6100000010000000101000000E5D022DBF92A634043AD69DE71AA3CC0
3842	0107000020E6100000010000000101000000E5D022DBF92A6340A60A462575AA3CC0
3843	0107000020E610000001000000010100000097FF907EFB2A634027C286A757AA3CC0
3844	0107000020E610000001000000010100000097FF907EFB2A63408A1F63EE5AAA3CC0
3845	0107000020E610000001000000010100000097FF907EFB2A6340EE7C3F355EAA3CC0
3846	0107000020E610000001000000010100000097FF907EFB2A634051DA1B7C61AA3CC0
3847	0107000020E610000001000000010100000097FF907EFB2A6340B537F8C264AA3CC0
3848	0107000020E610000001000000010100000097FF907EFB2A63401895D40968AA3CC0
3849	0107000020E610000001000000010100000097FF907EFB2A63407CF2B0506BAA3CC0
3850	0107000020E610000001000000010100000097FF907EFB2A6340DF4F8D976EAA3CC0
3851	0107000020E610000001000000010100000097FF907EFB2A634043AD69DE71AA3CC0
3852	0107000020E610000001000000010100000097FF907EFB2A6340A60A462575AA3CC0
3853	0107000020E6100000010000000101000000492EFF21FD2A634027C286A757AA3CC0
3854	0107000020E6100000010000000101000000492EFF21FD2A63408A1F63EE5AAA3CC0
3855	0107000020E6100000010000000101000000492EFF21FD2A6340EE7C3F355EAA3CC0
3856	0107000020E6100000010000000101000000492EFF21FD2A634051DA1B7C61AA3CC0
3857	0107000020E6100000010000000101000000492EFF21FD2A6340B537F8C264AA3CC0
3858	0107000020E6100000010000000101000000492EFF21FD2A63401895D40968AA3CC0
3859	0107000020E6100000010000000101000000492EFF21FD2A63407CF2B0506BAA3CC0
3860	0107000020E6100000010000000101000000492EFF21FD2A6340DF4F8D976EAA3CC0
3861	0107000020E6100000010000000101000000492EFF21FD2A634043AD69DE71AA3CC0
3862	0107000020E6100000010000000101000000492EFF21FD2A6340A60A462575AA3CC0
3863	0107000020E6100000010000000101000000FB5C6DC5FE2A634027C286A757AA3CC0
3864	0107000020E6100000010000000101000000FB5C6DC5FE2A63408A1F63EE5AAA3CC0
3865	0107000020E6100000010000000101000000FB5C6DC5FE2A6340EE7C3F355EAA3CC0
3866	0107000020E6100000010000000101000000FB5C6DC5FE2A634051DA1B7C61AA3CC0
3867	0107000020E6100000010000000101000000FB5C6DC5FE2A6340B537F8C264AA3CC0
3868	0107000020E6100000010000000101000000FB5C6DC5FE2A63401895D40968AA3CC0
3869	0107000020E6100000010000000101000000FB5C6DC5FE2A63407CF2B0506BAA3CC0
3870	0107000020E6100000010000000101000000FB5C6DC5FE2A6340DF4F8D976EAA3CC0
3871	0107000020E6100000010000000101000000FB5C6DC5FE2A634043AD69DE71AA3CC0
3872	0107000020E6100000010000000101000000FB5C6DC5FE2A6340A60A462575AA3CC0
3873	0107000020E6100000010000000101000000AC8BDB68002B634027C286A757AA3CC0
3874	0107000020E6100000010000000101000000AC8BDB68002B63408A1F63EE5AAA3CC0
3875	0107000020E6100000010000000101000000AC8BDB68002B6340EE7C3F355EAA3CC0
3876	0107000020E6100000010000000101000000AC8BDB68002B634051DA1B7C61AA3CC0
3877	0107000020E6100000010000000101000000AC8BDB68002B6340B537F8C264AA3CC0
3878	0107000020E6100000010000000101000000AC8BDB68002B63401895D40968AA3CC0
3879	0107000020E6100000010000000101000000AC8BDB68002B63407CF2B0506BAA3CC0
3880	0107000020E6100000010000000101000000AC8BDB68002B6340DF4F8D976EAA3CC0
3881	0107000020E6100000010000000101000000AC8BDB68002B634043AD69DE71AA3CC0
3882	0107000020E61000000100000001010000005EBA490C022B6340A60A462575AA3CC0
3883	0107000020E61000000100000001010000005EBA490C022B634027C286A757AA3CC0
3884	0107000020E61000000100000001010000005EBA490C022B63408A1F63EE5AAA3CC0
3885	0107000020E61000000100000001010000005EBA490C022B6340EE7C3F355EAA3CC0
3886	0107000020E61000000100000001010000005EBA490C022B634051DA1B7C61AA3CC0
3887	0107000020E61000000100000001010000005EBA490C022B6340B537F8C264AA3CC0
3888	0107000020E61000000100000001010000005EBA490C022B63401895D40968AA3CC0
3889	0107000020E61000000100000001010000005EBA490C022B63407CF2B0506BAA3CC0
3890	0107000020E61000000100000001010000005EBA490C022B6340DF4F8D976EAA3CC0
3891	0107000020E61000000100000001010000005EBA490C022B634043AD69DE71AA3CC0
3892	0107000020E61000000100000001010000005EBA490C022B6340A60A462575AA3CC0
3893	0107000020E610000001000000010100000010E9B7AF032B634027C286A757AA3CC0
3894	0107000020E610000001000000010100000010E9B7AF032B63408A1F63EE5AAA3CC0
3895	0107000020E610000001000000010100000010E9B7AF032B6340EE7C3F355EAA3CC0
3896	0107000020E610000001000000010100000010E9B7AF032B634051DA1B7C61AA3CC0
3897	0107000020E610000001000000010100000010E9B7AF032B6340B537F8C264AA3CC0
3898	0107000020E610000001000000010100000010E9B7AF032B63401895D40968AA3CC0
3899	0107000020E610000001000000010100000010E9B7AF032B63407CF2B0506BAA3CC0
3900	0107000020E610000001000000010100000010E9B7AF032B6340DF4F8D976EAA3CC0
3901	0107000020E610000001000000010100000010E9B7AF032B634043AD69DE71AA3CC0
3902	0107000020E610000001000000010100000010E9B7AF032B6340A60A462575AA3CC0
3903	0107000020E6100000010000000101000000C2172653052B634027C286A757AA3CC0
3904	0107000020E6100000010000000101000000C2172653052B63408A1F63EE5AAA3CC0
3905	0107000020E6100000010000000101000000C2172653052B6340EE7C3F355EAA3CC0
3906	0107000020E6100000010000000101000000C2172653052B634051DA1B7C61AA3CC0
3907	0107000020E6100000010000000101000000C2172653052B6340B537F8C264AA3CC0
3908	0107000020E6100000010000000101000000C2172653052B63401895D40968AA3CC0
3909	0107000020E6100000010000000101000000C2172653052B63407CF2B0506BAA3CC0
3910	0107000020E6100000010000000101000000C2172653052B6340DF4F8D976EAA3CC0
3911	0107000020E6100000010000000101000000C2172653052B634043AD69DE71AA3CC0
3912	0107000020E6100000010000000101000000C2172653052B6340A60A462575AA3CC0
3913	0107000020E6100000010000000101000000744694F6062B634027C286A757AA3CC0
3914	0107000020E6100000010000000101000000744694F6062B63408A1F63EE5AAA3CC0
3915	0107000020E6100000010000000101000000744694F6062B6340EE7C3F355EAA3CC0
3916	0107000020E6100000010000000101000000744694F6062B634051DA1B7C61AA3CC0
3917	0107000020E6100000010000000101000000744694F6062B6340B537F8C264AA3CC0
3918	0107000020E6100000010000000101000000744694F6062B63401895D40968AA3CC0
3919	0107000020E6100000010000000101000000744694F6062B63407CF2B0506BAA3CC0
3920	0107000020E6100000010000000101000000744694F6062B6340DF4F8D976EAA3CC0
3921	0107000020E6100000010000000101000000744694F6062B634043AD69DE71AA3CC0
3922	0107000020E6100000010000000101000000744694F6062B6340A60A462575AA3CC0
3923	0107000020E61000000100000001010000002575029A082B634027C286A757AA3CC0
3924	0107000020E61000000100000001010000002575029A082B63408A1F63EE5AAA3CC0
3925	0107000020E61000000100000001010000002575029A082B6340EE7C3F355EAA3CC0
3926	0107000020E61000000100000001010000002575029A082B634051DA1B7C61AA3CC0
3927	0107000020E61000000100000001010000002575029A082B6340B537F8C264AA3CC0
3928	0107000020E61000000100000001010000002575029A082B63401895D40968AA3CC0
3929	0107000020E61000000100000001010000002575029A082B63407CF2B0506BAA3CC0
3930	0107000020E61000000100000001010000002575029A082B6340DF4F8D976EAA3CC0
3931	0107000020E61000000100000001010000002575029A082B634043AD69DE71AA3CC0
3932	0107000020E61000000100000001010000002575029A082B6340A60A462575AA3CC0
3933	0107000020E6100000010000000101000000D7A3703D0A2B634027C286A757AA3CC0
3934	0107000020E6100000010000000101000000D7A3703D0A2B63408A1F63EE5AAA3CC0
3935	0107000020E6100000010000000101000000D7A3703D0A2B6340EE7C3F355EAA3CC0
3936	0107000020E6100000010000000101000000D7A3703D0A2B634051DA1B7C61AA3CC0
3937	0107000020E6100000010000000101000000D7A3703D0A2B6340B537F8C264AA3CC0
3938	0107000020E6100000010000000101000000D7A3703D0A2B63401895D40968AA3CC0
3939	0107000020E6100000010000000101000000D7A3703D0A2B63407CF2B0506BAA3CC0
3940	0107000020E6100000010000000101000000D7A3703D0A2B6340DF4F8D976EAA3CC0
3941	0107000020E6100000010000000101000000D7A3703D0A2B634043AD69DE71AA3CC0
3942	0107000020E6100000010000000101000000D7A3703D0A2B6340A60A462575AA3CC0
3943	0107000020E610000001000000010100000089D2DEE00B2B634027C286A757AA3CC0
3944	0107000020E610000001000000010100000089D2DEE00B2B63408A1F63EE5AAA3CC0
3945	0107000020E610000001000000010100000089D2DEE00B2B6340EE7C3F355EAA3CC0
3946	0107000020E610000001000000010100000089D2DEE00B2B634051DA1B7C61AA3CC0
3947	0107000020E610000001000000010100000089D2DEE00B2B6340B537F8C264AA3CC0
3948	0107000020E610000001000000010100000089D2DEE00B2B63401895D40968AA3CC0
3949	0107000020E610000001000000010100000089D2DEE00B2B63407CF2B0506BAA3CC0
3950	0107000020E610000001000000010100000089D2DEE00B2B6340DF4F8D976EAA3CC0
3951	0107000020E610000001000000010100000089D2DEE00B2B634043AD69DE71AA3CC0
3952	0107000020E610000001000000010100000089D2DEE00B2B6340A60A462575AA3CC0
3953	0107000020E61000000100000001010000003B014D840D2B634027C286A757AA3CC0
3954	0107000020E61000000100000001010000003B014D840D2B63408A1F63EE5AAA3CC0
3955	0107000020E61000000100000001010000003B014D840D2B6340EE7C3F355EAA3CC0
3956	0107000020E61000000100000001010000003B014D840D2B634051DA1B7C61AA3CC0
3957	0107000020E61000000100000001010000003B014D840D2B6340B537F8C264AA3CC0
3958	0107000020E61000000100000001010000003B014D840D2B63401895D40968AA3CC0
3959	0107000020E61000000100000001010000003B014D840D2B63407CF2B0506BAA3CC0
3960	0107000020E61000000100000001010000003B014D840D2B6340DF4F8D976EAA3CC0
3961	0107000020E61000000100000001010000003B014D840D2B634043AD69DE71AA3CC0
3962	0107000020E61000000100000001010000003B014D840D2B6340A60A462575AA3CC0
3963	0107000020E6100000010000000101000000EC2FBB270F2B634027C286A757AA3CC0
3964	0107000020E6100000010000000101000000EC2FBB270F2B63408A1F63EE5AAA3CC0
3965	0107000020E6100000010000000101000000EC2FBB270F2B6340EE7C3F355EAA3CC0
3966	0107000020E6100000010000000101000000EC2FBB270F2B634051DA1B7C61AA3CC0
3967	0107000020E6100000010000000101000000EC2FBB270F2B6340B537F8C264AA3CC0
3968	0107000020E6100000010000000101000000EC2FBB270F2B63401895D40968AA3CC0
3969	0107000020E6100000010000000101000000EC2FBB270F2B63407CF2B0506BAA3CC0
3970	0107000020E6100000010000000101000000EC2FBB270F2B6340DF4F8D976EAA3CC0
3971	0107000020E6100000010000000101000000EC2FBB270F2B634043AD69DE71AA3CC0
3972	0107000020E6100000010000000101000000EC2FBB270F2B6340A60A462575AA3CC0
3973	0107000020E61000000100000001010000009E5E29CB102B634027C286A757AA3CC0
3974	0107000020E61000000100000001010000009E5E29CB102B63408A1F63EE5AAA3CC0
3975	0107000020E61000000100000001010000009E5E29CB102B6340EE7C3F355EAA3CC0
3976	0107000020E61000000100000001010000009E5E29CB102B634051DA1B7C61AA3CC0
3977	0107000020E61000000100000001010000009E5E29CB102B6340B537F8C264AA3CC0
3978	0107000020E61000000100000001010000009E5E29CB102B63401895D40968AA3CC0
3979	0107000020E61000000100000001010000009E5E29CB102B63407CF2B0506BAA3CC0
3980	0107000020E61000000100000001010000009E5E29CB102B6340DF4F8D976EAA3CC0
3981	0107000020E61000000100000001010000009E5E29CB102B634043AD69DE71AA3CC0
3982	0107000020E61000000100000001010000009E5E29CB102B6340A60A462575AA3CC0
3983	0107000020E6100000010000000101000000508D976E122B634027C286A757AA3CC0
3984	0107000020E6100000010000000101000000508D976E122B63408A1F63EE5AAA3CC0
3985	0107000020E6100000010000000101000000508D976E122B6340EE7C3F355EAA3CC0
3986	0107000020E6100000010000000101000000508D976E122B634051DA1B7C61AA3CC0
3987	0107000020E6100000010000000101000000508D976E122B6340B537F8C264AA3CC0
3988	0107000020E6100000010000000101000000508D976E122B63401895D40968AA3CC0
3989	0107000020E6100000010000000101000000508D976E122B63407CF2B0506BAA3CC0
3990	0107000020E6100000010000000101000000508D976E122B6340DF4F8D976EAA3CC0
\.


--
-- Name: contactloc_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY contactloc
    ADD CONSTRAINT contactloc_pkey PRIMARY KEY (contactid);


--
-- Name: layer2_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layer2
    ADD CONSTRAINT layer2_pkey PRIMARY KEY (id);


--
-- Name: layer2attrib_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layer2attrib
    ADD CONSTRAINT layer2attrib_pkey PRIMARY KEY (id);


--
-- Name: layer2dn_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layer2dn
    ADD CONSTRAINT layer2dn_pkey PRIMARY KEY (id);


--
-- Name: layer_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layer
    ADD CONSTRAINT layer_pkey PRIMARY KEY (id);


--
-- Name: layerattrib_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layerattrib
    ADD CONSTRAINT layerattrib_pkey PRIMARY KEY (id);


--
-- Name: layerimgn_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layerimgn
    ADD CONSTRAINT layerimgn_pkey PRIMARY KEY (id);


--
-- Name: layern_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layern
    ADD CONSTRAINT layern_pkey PRIMARY KEY (id);


--
-- Name: layernattrib_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layernattrib
    ADD CONSTRAINT layernattrib_pkey PRIMARY KEY (id);


--
-- Name: siteloc_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY siteloc
    ADD CONSTRAINT siteloc_pkey PRIMARY KEY (siteid);


--
-- Name: trialloc_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY trialloc
    ADD CONSTRAINT trialloc_pkey PRIMARY KEY (trialid);


--
-- Name: trialunitloc_pkey; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY trialunitloc
    ADD CONSTRAINT trialunitloc_pkey PRIMARY KEY (trialunitid);


--
-- Name: xdatadevice_unique; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY datadevice
    ADD CONSTRAINT xdatadevice_unique UNIQUE (deviceid, deviceparam, layerattrib);


--
-- Name: xlayer_name; Type: CONSTRAINT; Schema: public; Owner: kddart_dal; Tablespace: 
--

ALTER TABLE ONLY layer
    ADD CONSTRAINT xlayer_name UNIQUE (name);


--
-- Name: layer2_sp_index; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX layer2_sp_index ON layer2 USING gist (geometry);


--
-- Name: xcl_contactlocation; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xcl_contactlocation ON contactloc USING gist (contactlocation);


--
-- Name: xdatadevice_layerattrib; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xdatadevice_layerattrib ON datadevice USING btree (layerattrib);


--
-- Name: xl2d_geometry; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xl2d_geometry ON layer2dn USING gist (geometry);


--
-- Name: xlayer_parent; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayer_parent ON layer USING btree (parent);


--
-- Name: xlayerattrib_layer; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayerattrib_layer ON layerattrib USING btree (layer);


--
-- Name: xlayerattrib_unitid; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayerattrib_unitid ON layerattrib USING btree (unitid);


--
-- Name: xlayernattrib_dt; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayernattrib_dt ON layernattrib USING btree (dt);


--
-- Name: xlayernattrib_layerattrib; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayernattrib_layerattrib ON layernattrib USING btree (layerattrib);


--
-- Name: xlayernattrib_layerid; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayernattrib_layerid ON layernattrib USING btree (layerid);


--
-- Name: xlayernattrib_sysuid; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlayernattrib_sysuid ON layernattrib USING btree (systemuserid);


--
-- Name: xlin_geometry; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xlin_geometry ON layerimgn USING gist (geometry);


--
-- Name: xln_geometry; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xln_geometry ON layern USING gist (geometry);


--
-- Name: xsl_sitelocation; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xsl_sitelocation ON siteloc USING gist (sitelocation);


--
-- Name: xtl_triallocation; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xtl_triallocation ON trialloc USING gist (triallocation);


--
-- Name: xtul_trialunitlocation; Type: INDEX; Schema: public; Owner: kddart_dal; Tablespace: 
--

CREATE INDEX xtul_trialunitlocation ON trialunitloc USING gist (trialunitlocation);


--
-- Name: datadevice_layerattrib_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY datadevice
    ADD CONSTRAINT datadevice_layerattrib_fkey FOREIGN KEY (layerattrib) REFERENCES layerattrib(id) DEFERRABLE;


--
-- Name: layer_parent_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layer
    ADD CONSTRAINT layer_parent_fkey FOREIGN KEY (parent) REFERENCES layer(id) DEFERRABLE;


--
-- Name: layerattrib_layer_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layerattrib
    ADD CONSTRAINT layerattrib_layer_fkey FOREIGN KEY (layer) REFERENCES layer(id) DEFERRABLE;


--
-- Name: layernattrib_layerattrib_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layernattrib
    ADD CONSTRAINT layernattrib_layerattrib_fkey FOREIGN KEY (layerattrib) REFERENCES layerattrib(id) DEFERRABLE;


--
-- Name: layernattrib_layerid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kddart_dal
--

ALTER TABLE ONLY layernattrib
    ADD CONSTRAINT layernattrib_layerid_fkey FOREIGN KEY (layerid) REFERENCES layern(id) DEFERRABLE;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: layer2; Type: ACL; Schema: public; Owner: kddart_dal
--

REVOKE ALL ON TABLE layer2 FROM PUBLIC;
REVOKE ALL ON TABLE layer2 FROM kddart_dal;
GRANT ALL ON TABLE layer2 TO kddart_dal;


--
-- Name: layer2_id_seq; Type: ACL; Schema: public; Owner: kddart_dal
--

REVOKE ALL ON SEQUENCE layer2_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE layer2_id_seq FROM kddart_dal;
GRANT ALL ON SEQUENCE layer2_id_seq TO kddart_dal;


--
-- Name: layer2attrib; Type: ACL; Schema: public; Owner: kddart_dal
--

REVOKE ALL ON TABLE layer2attrib FROM PUBLIC;
REVOKE ALL ON TABLE layer2attrib FROM kddart_dal;
GRANT ALL ON TABLE layer2attrib TO kddart_dal;


--
-- Name: layer2attrib_id_seq; Type: ACL; Schema: public; Owner: kddart_dal
--

REVOKE ALL ON SEQUENCE layer2attrib_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE layer2attrib_id_seq FROM kddart_dal;
GRANT ALL ON SEQUENCE layer2attrib_id_seq TO kddart_dal;


--
-- PostgreSQL database dump complete
--

