/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.concurrent.atomic.AtomicInteger;

public class MonetSavepoint
implements Savepoint {
    private static AtomicInteger highestId = new AtomicInteger(0);
    private final String name;
    private final int id;

    public MonetSavepoint(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.id = MonetSavepoint.getNextId();
        this.name = name;
    }

    public MonetSavepoint() {
        this.id = MonetSavepoint.getNextId();
        this.name = null;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.name != null) {
            throw new SQLException("Cannot getID for named savepoint", "3B000");
        }
        return this.getId();
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.name == null) {
            throw new SQLException("Unable to retrieve name of unnamed savepoint", "3B000");
        }
        return this.name;
    }

    int getId() {
        return this.id;
    }

    String getName() {
        return "MonetDBSP" + this.id;
    }

    private static int getNextId() {
        return highestId.incrementAndGet();
    }

    private static int getHighestId() {
        return highestId.get();
    }
}

