/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetDatabaseMetaData
extends MonetWrapper
implements DatabaseMetaData {
    private Connection con;
    private String env_current_user;
    private String env_monet_version;
    private String env_max_clients;
    private static final String FunctionsSelect = "SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" ";
    private static final String FunctionsWhere = "WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ";
    private static final String keyQuery = "SELECT cast(null AS varchar(1)) AS \"PKTABLE_CAT\", \"pkschema\".\"name\" AS \"PKTABLE_SCHEM\", \"pktable\".\"name\" AS \"PKTABLE_NAME\", \"pkkeycol\".\"name\" AS \"PKCOLUMN_NAME\", cast(null AS varchar(1)) AS \"FKTABLE_CAT\", \"fkschema\".\"name\" AS \"FKTABLE_SCHEM\", \"fktable\".\"name\" AS \"FKTABLE_NAME\", \"fkkeycol\".\"name\" AS \"FKCOLUMN_NAME\", CAST(1 + \"pkkeycol\".\"nr\" AS smallint) AS \"KEY_SEQ\", 3 AS \"UPDATE_RULE\", 3 AS \"DELETE_RULE\", \"fkkey\".\"name\" AS \"FK_NAME\", \"pkkey\".\"name\" AS \"PK_NAME\", 7 AS \"DEFERRABILITY\" FROM \"sys\".\"keys\" AS \"fkkey\", \"sys\".\"keys\" AS \"pkkey\", \"sys\".\"objects\" AS \"fkkeycol\", \"sys\".\"objects\" AS \"pkkeycol\", \"sys\".\"tables\" AS \"fktable\", \"sys\".\"tables\" AS \"pktable\", \"sys\".\"schemas\" AS \"fkschema\", \"sys\".\"schemas\" AS \"pkschema\" WHERE \"fktable\".\"id\" = \"fkkey\".\"table_id\" AND \"pktable\".\"id\" = \"pkkey\".\"table_id\" AND \"fkkey\".\"id\" = \"fkkeycol\".\"id\" AND \"pkkey\".\"id\" = \"pkkeycol\".\"id\" AND \"fkschema\".\"id\" = \"fktable\".\"schema_id\" AND \"pkschema\".\"id\" = \"pktable\".\"schema_id\" AND \"fkkey\".\"rkey\" > -1 AND \"fkkey\".\"rkey\" = \"pkkey\".\"id\" AND \"fkkeycol\".\"nr\" = \"pkkeycol\".\"nr\"";

    public MonetDatabaseMetaData(Connection parent) {
        this.con = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getEnvValues() {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery("SELECT \"name\", \"value\" FROM \"sys\".\"environment\" WHERE \"name\" IN ('monet_version', 'max_clients') UNION SELECT 'current_user' as \"name\", current_user as \"value\"");
            if (rs != null) {
                while (rs.next()) {
                    String prop = rs.getString("name");
                    String value = rs.getString("value");
                    if ("current_user".equals(prop)) {
                        this.env_current_user = value;
                        continue;
                    }
                    if ("monet_version".equals(prop)) {
                        this.env_monet_version = value;
                        continue;
                    }
                    if (!"max_clients".equals(prop)) continue;
                    this.env_max_clients = value;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private ResultSet executeMetaDataQuery(String query) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        stmt = this.con.createStatement(1004, 1007);
        if (stmt != null) {
            rs = stmt.executeQuery(query);
            if (rs != null) {
                stmt.closeOnCompletion();
            } else {
                stmt.close();
            }
        }
        return rs;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return ((MonetConnection)this.con).getJDBCURL();
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.env_current_user == null) {
            this.getEnvValues();
        }
        return this.env_current_user;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "MonetDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        return this.env_monet_version;
    }

    @Override
    public String getDriverName() {
        return "MonetDB Native Driver";
    }

    @Override
    public String getDriverVersion() {
        return MonetDriver.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return MonetDriver.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return MonetDriver.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        String keywords = this.getConcatenatedStringFromQuery("SELECT \"keyword\" FROM \"sys\".\"keywords\" ORDER BY 1");
        return keywords.length() > 0 ? keywords : "ADMIN,AFTER,AGGREGATE,ALWAYS,ASYMMETRIC,ATOMIC,AUTO_INCREMENT,BEFORE,BIGINT,BIGSERIAL,BINARY,BLOB,CALL,CHAIN,CLOB,COMMITTED,COPY,CORR,CUME_DIST,CURRENT_ROLE,CYCLE,DATABASE,DELIMITERS,DENSE_RANK,DO,EACH,ELSEIF,ENCRYPTED,EVERY,EXCLUDE,FOLLOWING,FUNCTION,GENERATED,IF,ILIKE,INCREMENT,LAG,LEAD,LIMIT,LOCALTIME,LOCALTIMESTAMP,LOCKED,MAXVALUE,MEDIAN,MEDIUMINT,MERGE,MINVALUE,NEW,NOCYCLE,NOMAXVALUE,NOMINVALUE,NOW,OFFSET,OLD,OTHERS,OVER,PARTITION,PERCENT_RANK,PLAN,PRECEDING,PROD,QUANTILE,RANGE,RANK,RECORDS,REFERENCING,REMOTE,RENAME,REPEATABLE,REPLICA,RESTART,RETURN,RETURNS,ROW_NUMBER,ROWS,SAMPLE,SAVEPOINT,SCHEMA,SEQUENCE,SERIAL,SERIALIZABLE,SIMPLE,START,STATEMENT,STDIN,STDOUT,STREAM,STRING,SYMMETRIC,TIES,TINYINT,TRIGGER,UNBOUNDED,UNCOMMITTED,UNENCRYPTED,WHILE,XMLAGG,XMLATTRIBUTES,XMLCOMMENT,XMLCONCAT,XMLDOCUMENT,XMLELEMENT,XMLFOREST,XMLNAMESPACES,XMLPARSE,XMLPI,XMLQUERY,XMLSCHEMA,XMLTEXT,XMLVALIDATE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConcatenatedStringFromQuery(String query) {
        StringBuilder sb = new StringBuilder(1024);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery(query);
            boolean isfirst = true;
            while (rs.next()) {
                String value = rs.getString(1);
                if (value == null) continue;
                if (isfirst) {
                    isfirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(value);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return sb.toString();
    }

    @Override
    public String getNumericFunctions() {
        String match = "('tinyint', 'smallint', 'int', 'bigint', 'hugeint', 'decimal', 'double', 'real') ) AND \"mod\" <> 'str'";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN " + match + " ORDER BY 1");
    }

    @Override
    public String getStringFunctions() {
        String match = "('char', 'varchar', 'clob', 'json') ) OR \"mod\" = 'str'";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN " + match + " ORDER BY 1");
    }

    @Override
    public String getSystemFunctions() {
        String wherePart = "WHERE \"id\" NOT IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1) AND \"id\" IN (SELECT \"function_id\" FROM \"sys\".\"systemfunctions\") AND \"type\" = 1 UNION SELECT 'cast' UNION SELECT 'convert' UNION SELECT 'coalesce' UNION SELECT 'extract' UNION SELECT 'ifthenelse' UNION SELECT 'isnull' UNION SELECT 'nullif'";
        return this.getConcatenatedStringFromQuery(FunctionsSelect + wherePart + " ORDER BY 1");
    }

    @Override
    public String getTimeDateFunctions() {
        String match = "('date', 'time', 'timestamp', 'timetz', 'timestamptz', 'sec_interval', 'month_interval') )";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN " + match + " ORDER BY 1");
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        switch (fromType) {
            case 16: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case 12: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 12: 
            case 2005: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 92: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 1024;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        if (this.env_max_clients == null) {
            this.getEnvValues();
        }
        int max_clients = 16;
        if (this.env_max_clients != null) {
            try {
                max_clients = Integer.parseInt(this.env_max_clients);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return max_clients;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 1024;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 1024;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 1024;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 512;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(980);
        query.append("SELECT cast(null as varchar(1)) AS \"PROCEDURE_CAT\", \"schemas\".\"name\" AS \"PROCEDURE_SCHEM\", \"functions\".\"name\" AS \"PROCEDURE_NAME\", cast(null as char(1)) AS \"Field4\", cast(null as char(1)) AS \"Field5\", cast(null as char(1)) AS \"Field6\", cast(\"functions\".\"func\" as varchar(9999)) AS \"REMARKS\", CAST(").append(1).append(" AS smallint) AS \"PROCEDURE_TYPE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" JOIN \"sys\".\"schemas\" ON (\"functions\".\"schema_id\" = \"schemas\".\"id\") WHERE \"functions\".\"type\" = 2");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (procedureNamePattern != null) {
            query.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(procedureNamePattern));
        }
        query.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(2900);
        query.append("SELECT cast(null as varchar(1)) AS \"PROCEDURE_CAT\", \"schemas\".\"name\" AS \"PROCEDURE_SCHEM\", \"functions\".\"name\" AS \"PROCEDURE_NAME\", \"args\".\"name\" AS \"COLUMN_NAME\", CAST(CASE \"args\".\"inout\" WHEN 0 THEN (CASE \"args\".\"number\" WHEN 0 THEN ").append(5).append(" ELSE ").append(4).append(" END) WHEN 1 THEN ").append(1).append(" ELSE ").append(0).append(" END AS smallint) AS \"COLUMN_TYPE\", CAST(").append(MonetDriver.getSQLTypeMap("\"args\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"args\".\"type\" AS \"TYPE_NAME\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE \"args\".\"type_digits\" END AS \"PRECISION\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE \"args\".\"type_digits\" END AS \"LENGTH\", CAST(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','sec_interval') THEN \"args\".\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", CAST(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric') THEN 10 WHEN \"args\".\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", CAST(").append(2).append(" AS smallint) AS \"NULLABLE\", CAST(null as char(1)) AS \"REMARKS\", CAST(null as char(1)) AS \"COLUMN_DEF\", CAST(0 as int) AS \"SQL_DATA_TYPE\", CAST(0 as int) AS \"SQL_DATETIME_SUB\", CAST(CASE WHEN \"args\".\"type\" IN ('char','varchar','clob') THEN \"args\".\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", CAST(\"args\".\"number\" + 1 as int) AS \"ORDINAL_POSITION\", CAST('' as varchar(3)) AS \"IS_NULLABLE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\", \"sys\".\"functions\", \"sys\".\"schemas\" WHERE \"args\".\"func_id\" = \"functions\".\"id\" AND \"functions\".\"schema_id\" = \"schemas\".\"id\" AND \"functions\".\"type\" = 2");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (procedureNamePattern != null) {
            query.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(procedureNamePattern));
        }
        if (columnNamePattern != null) {
            query.append(" AND \"args\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(columnNamePattern));
        }
        query.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    private static final String composeMatchPart(String in) {
        if (in == null) {
            return "IS NULL";
        }
        String sql = "= '";
        if (in.contains("%") || in.contains("_")) {
            sql = "LIKE '";
        }
        String escaped = in.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
        return sql + escaped + "'";
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean preJul2015 = "11.19.15".compareTo(this.getDatabaseProductVersion()) >= 0;
        StringBuilder query = new StringBuilder(1600);
        if (preJul2015 && types != null && types.length > 0) {
            query.append("SELECT * FROM (");
        }
        query.append("SELECT DISTINCT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", ");
        if (preJul2015) {
            query.append("CASE WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (0, 10) AND \"tables\".\"temporary\" = 0 THEN 'SYSTEM TABLE' WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (1, 11) AND \"tables\".\"temporary\" = 0 THEN 'SYSTEM VIEW' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 0 AND \"tables\".\"temporary\" = 0 THEN 'TABLE' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 1 AND \"tables\".\"temporary\" = 0 THEN 'VIEW' WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (0, 20) AND \"tables\".\"temporary\" = 1 THEN 'SYSTEM SESSION TABLE' WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (1, 21) AND \"tables\".\"temporary\" = 1 THEN 'SYSTEM SESSION VIEW' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" IN (0, 30) AND \"tables\".\"temporary\" = 1 THEN 'SESSION TABLE' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" IN (1, 31) AND \"tables\".\"temporary\" = 1 THEN 'SESSION VIEW' END AS \"TABLE_TYPE\", ");
        } else {
            query.append("\"table_types\".\"table_type_name\" AS \"TABLE_TYPE\", ");
        }
        query.append("\"tables\".\"query\" AS \"REMARKS\", cast(null as char(1)) AS \"TYPE_CAT\", cast(null as char(1)) AS \"TYPE_SCHEM\", cast(null as char(1)) AS \"TYPE_NAME\", cast(null as char(1)) AS \"SELF_REFERENCING_COL_NAME\", cast(null as char(1)) AS \"REF_GENERATION\" FROM \"sys\".\"tables\", \"sys\".\"schemas\"");
        if (!preJul2015) {
            query.append(", \"sys\".\"table_types\"");
        }
        query.append(" WHERE \"tables\".\"schema_id\" = \"schemas\".\"id\"");
        if (!preJul2015) {
            query.append(" AND \"tables\".\"type\" = \"table_types\".\"table_type_id\"");
        }
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (tableNamePattern != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(tableNamePattern));
        }
        if (types != null && types.length > 0) {
            if (preJul2015) {
                query.append(") AS \"getTables\" WHERE \"TABLE_TYPE\" IN (");
            } else {
                query.append(" AND \"table_types\".\"table_type_name\" IN (");
            }
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("'").append(types[i]).append("'");
            }
            query.append(")");
        }
        query.append(" ORDER BY \"TABLE_TYPE\", \"TABLE_SCHEM\", \"TABLE_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        StringBuilder query = new StringBuilder(170);
        query.append("SELECT \"name\" AS \"TABLE_SCHEM\", cast(null as char(1)) AS \"TABLE_CATALOG\" FROM \"sys\".\"schemas\"");
        if (catalog != null && catalog.length() > 0) {
            query.append(" WHERE 1 = 0");
        } else if (schemaPattern != null) {
            query.append(" WHERE \"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        query.append(" ORDER BY \"TABLE_SCHEM\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\" WHERE 1 = 0");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        boolean preJul2015;
        String query = "SELECT \"table_type_name\" AS \"TABLE_TYPE\" FROM \"sys\".\"table_types\" ORDER BY 1";
        boolean bl = preJul2015 = "11.19.15".compareTo(this.getDatabaseProductVersion()) >= 0;
        if (preJul2015) {
            query = "SELECT 'SESSION TABLE' AS \"TABLE_TYPE\" UNION ALL SELECT 'SESSION VIEW' UNION ALL SELECT 'SYSTEM SESSION TABLE' UNION ALL SELECT 'SYSTEM SESSION VIEW' UNION ALL SELECT 'SYSTEM TABLE' UNION ALL SELECT 'SYSTEM VIEW' UNION ALL SELECT 'TABLE' UNION ALL SELECT 'VIEW' ORDER BY 1";
        }
        return this.executeMetaDataQuery(query);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(2450);
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"columns\".\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"columns\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"columns\".\"type\" AS \"TYPE_NAME\", \"columns\".\"type_digits\" AS \"COLUMN_SIZE\", 0 AS \"BUFFER_LENGTH\", \"columns\".\"type_scale\" AS \"DECIMAL_DIGITS\", cast(CASE WHEN \"columns\".\"type\" IN ('decimal', 'numeric', 'sec_interval') THEN 10 WHEN \"columns\".\"type\" IN ('int', 'smallint', 'tinyint', 'bigint', 'hugeint', 'float', 'real', 'double', 'oid', 'wrd') THEN 2 ELSE 0 END AS int) AS \"NUM_PREC_RADIX\", cast(CASE \"null\" WHEN true THEN ").append(1).append(" WHEN false THEN ").append(0).append(" END AS int) AS \"NULLABLE\", cast(null AS varchar(1)) AS \"REMARKS\", \"columns\".\"default\" AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN \"columns\".\"type\" IN ('char','varchar','clob') THEN \"columns\".\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(\"columns\".\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast(CASE \"null\" WHEN true THEN 'YES' WHEN false THEN 'NO' ELSE '' END AS varchar(3)) AS \"IS_NULLABLE\", cast(null AS varchar(1)) AS \"SCOPE_CATALOG\", cast(null AS varchar(1)) AS \"SCOPE_SCHEMA\", cast(null AS varchar(1)) AS \"SCOPE_TABLE\", cast(").append(MonetDriver.getJavaType("other")).append(" AS smallint) AS \"SOURCE_DATA_TYPE\", cast(CASE WHEN \"columns\".\"default\" IS NOT NULL AND \"columns\".\"default\" LIKE 'next value for %' THEN 'YES' ELSE 'NO' END AS varchar(3)) AS \"IS_AUTOINCREMENT\", cast('NO' AS varchar(3)) AS \"IS_GENERATEDCOLUMN\" FROM \"sys\".\"columns\", \"sys\".\"tables\", \"sys\".\"schemas\" WHERE \"columns\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\"");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (tableNamePattern != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(tableNamePattern));
        }
        if (columnNamePattern != null) {
            query.append(" AND \"columns\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(columnNamePattern));
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(1100);
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"columns\".\"name\" AS \"COLUMN_NAME\", \"grantors\".\"name\" AS \"GRANTOR\", \"grantees\".\"name\" AS \"GRANTEE\", CAST(CASE \"privileges\".\"privileges\" WHEN 1 THEN 'SELECT' WHEN 2 THEN 'UPDATE' WHEN 4 THEN 'INSERT' WHEN 8 THEN 'DELETE' WHEN 16 THEN 'EXECUTE' WHEN 32 THEN 'GRANT' ELSE NULL END AS varchar(7)) AS \"PRIVILEGE\", CAST(CASE \"privileges\".\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\", \"sys\".\"tables\", \"sys\".\"schemas\", \"sys\".\"columns\", \"sys\".\"auths\" AS \"grantors\", \"sys\".\"auths\" AS \"grantees\" WHERE \"privileges\".\"obj_id\" = \"columns\".\"id\" AND \"columns\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"privileges\".\"auth_id\" = \"grantees\".\"id\" AND \"privileges\".\"grantor\" = \"grantors\".\"id\"");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (tableNamePattern != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(tableNamePattern));
        }
        if (columnNamePattern != null) {
            query.append(" AND \"columns\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(columnNamePattern));
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(1000);
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"grantors\".\"name\" AS \"GRANTOR\", \"grantees\".\"name\" AS \"GRANTEE\", CAST(CASE \"privileges\".\"privileges\" WHEN 1 THEN 'SELECT' WHEN 2 THEN 'UPDATE' WHEN 4 THEN 'INSERT' WHEN 8 THEN 'DELETE' WHEN 16 THEN 'EXECUTE' WHEN 32 THEN 'GRANT' ELSE NULL END AS varchar(7)) AS \"PRIVILEGE\", CAST(CASE \"privileges\".\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\", \"sys\".\"tables\", \"sys\".\"schemas\", \"sys\".\"auths\" AS \"grantors\", \"sys\".\"auths\" AS \"grantees\" WHERE \"privileges\".\"obj_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"privileges\".\"auth_id\" = \"grantees\".\"id\" AND \"privileges\".\"grantor\" = \"grantors\".\"id\"");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (tableNamePattern != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(tableNamePattern));
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        StringBuilder query = new StringBuilder(1500);
        query.append("SELECT CAST(").append(2).append(" AS smallint) AS \"SCOPE\", \"columns\".\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"columns\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"columns\".\"type\" AS \"TYPE_NAME\", \"columns\".\"type_digits\" AS \"COLUMN_SIZE\", CAST(0 as int) AS \"BUFFER_LENGTH\", CAST(\"columns\".\"type_scale\" AS smallint) AS \"DECIMAL_DIGITS\", CAST(").append(1).append(" AS smallint) AS \"PSEUDO_COLUMN\" FROM \"sys\".\"keys\", \"sys\".\"objects\", \"sys\".\"columns\", \"sys\".\"tables\", \"sys\".\"schemas\" WHERE \"keys\".\"id\" = \"objects\".\"id\" AND \"keys\".\"table_id\" = \"tables\".\"id\" AND \"keys\".\"table_id\" = \"columns\".\"table_id\" AND \"objects\".\"name\" = \"columns\".\"name\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"keys\".\"type\" IN (0, 1)");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schema != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schema));
        }
        if (table != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(table));
        }
        if (scope != 2 && scope != 1 && scope != 0) {
            query.append(" AND 1 = 0");
        }
        if (!nullable) {
            query.append(" AND \"columns\".\"null\" = false");
        }
        query.append(" ORDER BY \"keys\".\"type\", \"columns\".\"name\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT CAST(0 as smallint) AS \"SCOPE\", CAST(null as varchar(1)) AS \"COLUMN_NAME\", CAST(0 as int) AS \"DATA_TYPE\", CAST(null as varchar(1)) AS \"TYPE_NAME\", CAST(0 as int) AS \"COLUMN_SIZE\", CAST(0 as int) AS \"BUFFER_LENGTH\", CAST(0 as smallint) AS \"DECIMAL_DIGITS\", CAST(0 as smallint) AS \"PSEUDO_COLUMN\" WHERE 1 = 0";
        return this.executeMetaDataQuery(query);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder query = new StringBuilder(600);
        query.append("SELECT cast(null AS varchar(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"objects\".\"name\" AS \"COLUMN_NAME\", CAST(1 + \"objects\".\"nr\" AS smallint) AS \"KEY_SEQ\",  \"keys\".\"name\" AS \"PK_NAME\" FROM \"sys\".\"keys\", \"sys\".\"objects\", \"sys\".\"tables\", \"sys\".\"schemas\" WHERE \"keys\".\"id\" = \"objects\".\"id\" AND \"keys\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"keys\".\"type\" = 0");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schema != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schema));
        }
        if (table != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(table));
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder query = new StringBuilder(keyQuery.length() + 250);
        query.append(keyQuery);
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schema != null) {
            query.append(" AND \"fkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schema));
        }
        if (table != null) {
            query.append(" AND \"fktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(table));
        }
        query.append(" ORDER BY \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder query = new StringBuilder(keyQuery.length() + 250);
        query.append(keyQuery);
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schema != null) {
            query.append(" AND \"pkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schema));
        }
        if (table != null) {
            query.append(" AND \"pktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(table));
        }
        query.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getCrossReference(String pcatalog, String pschema, String ptable, String fcatalog, String fschema, String ftable) throws SQLException {
        StringBuilder query = new StringBuilder(keyQuery.length() + 350);
        query.append(keyQuery);
        if (pcatalog != null && pcatalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (pschema != null) {
            query.append(" AND \"pkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(pschema));
        }
        if (ptable != null) {
            query.append(" AND \"pktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(ptable));
        }
        if (fcatalog != null && fcatalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (fschema != null) {
            query.append(" AND \"fkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(fschema));
        }
        if (ftable != null) {
            query.append(" AND \"fktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(ftable));
        }
        query.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        StringBuilder query = new StringBuilder(2300);
        query.append("SELECT \"sqlname\" AS \"TYPE_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"sqlname\"")).append(" AS int) AS \"DATA_TYPE\", \"digits\" AS \"PRECISION\", cast(CASE WHEN \"systemname\" IN ('str', 'inet', 'json', 'url', 'uuid') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_PREFIX\", cast(CASE WHEN \"systemname\" IN ('str', 'inet', 'json', 'url', 'uuid') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_SUFFIX\", CASE WHEN \"sqlname\" IN ('char', 'varchar') THEN 'max length' WHEN \"sqlname\" = 'decimal' THEN 'precision, scale' WHEN \"sqlname\" IN ('time', 'timetz', 'timestamp', 'timestamptz', 'sec_interval') THEN 'precision' ELSE NULL END AS \"CREATE_PARAMS\", cast(CASE WHEN \"systemname\" = 'oid' THEN ").append(0).append(" ELSE ").append(1).append(" END AS smallint) AS \"NULLABLE\", CASE WHEN \"systemname\" IN ('str', 'json', 'url') THEN true ELSE false END AS \"CASE_SENSITIVE\", cast(CASE \"systemname\" WHEN 'table' THEN ").append(0).append(" WHEN 'str' THEN ").append(1).append(" WHEN 'sqlblob' THEN ").append(1).append(" ELSE ").append(2).append(" END AS smallint) AS \"SEARCHABLE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','real','double','sec_interval','month_interval') THEN false ELSE true END AS \"UNSIGNED_ATTRIBUTE\", CASE \"sqlname\" WHEN 'decimal' THEN true ELSE false END AS \"FIXED_PREC_SCALE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','oid','wrd') THEN true ELSE false END AS \"AUTO_INCREMENT\", \"systemname\" AS \"LOCAL_TYPE_NAME\", cast(0 AS smallint) AS \"MINIMUM_SCALE\", cast(CASE WHEN \"sqlname\" = 'decimal' THEN (CASE \"systemname\" WHEN 'lng' THEN 18 WHEN 'hge' THEN 38 WHEN 'int' THEN 9 WHEN 'sht' THEN 4 WHEN 'bte' THEN 2 ELSE 0 END) WHEN \"sqlname\" IN ('sec_interval', 'timestamp', 'timestamptz') THEN 9 ELSE 0 END AS smallint) AS \"MAXIMUM_SCALE\", cast(0 AS int) AS \"SQL_DATA_TYPE\", cast(0 AS int) AS \"SQL_DATETIME_SUB\", cast(\"radix\" as int) AS \"NUM_PREC_RADIX\" FROM \"sys\".\"types\" ORDER BY \"DATA_TYPE\", \"sqlname\", \"id\"");
        return this.executeMetaDataQuery(query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String table_row_count = "0";
        if (!approximate && schema != null && table != null && schema.length() > 0 && table.length() > 0) {
            ResultSet count = null;
            try {
                String count_value;
                count = this.executeMetaDataQuery("SELECT COUNT(*) FROM \"" + schema + "\".\"" + table + "\"");
                if (count != null && count.next() && (count_value = count.getString(1)) != null && count_value.length() > 0) {
                    table_row_count = count_value;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (count != null) {
                    try {
                        count.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        StringBuilder query = new StringBuilder(1250);
        query.append("SELECT CAST(null AS char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", CASE WHEN \"keys\".\"name\" IS NULL THEN true ELSE false END AS \"NON_UNIQUE\", CAST(null AS varchar(1)) AS \"INDEX_QUALIFIER\", \"idxs\".\"name\" AS \"INDEX_NAME\", CASE \"idxs\".\"type\" WHEN 0 THEN ").append(2).append(" ELSE ").append(3).append(" END AS \"TYPE\", CAST(\"objects\".\"nr\" +1 AS smallint) AS \"ORDINAL_POSITION\", \"columns\".\"name\" AS \"COLUMN_NAME\", CAST(null AS varchar(1)) AS \"ASC_OR_DESC\", CAST(").append(table_row_count).append(" AS int) AS \"CARDINALITY\", CAST(0 AS int) AS \"PAGES\", CAST(null AS varchar(1)) AS \"FILTER_CONDITION\" FROM \"sys\".\"idxs\" LEFT JOIN \"sys\".\"keys\" ON \"idxs\".\"name\" = \"keys\".\"name\", \"sys\".\"schemas\", \"sys\".\"objects\", \"sys\".\"columns\", \"sys\".\"tables\" WHERE \"idxs\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"idxs\".\"id\" = \"objects\".\"id\" AND \"tables\".\"id\" = \"columns\".\"table_id\" AND \"objects\".\"name\" = \"columns\".\"name\" AND (\"keys\".\"type\" IS NULL OR \"keys\".\"type\" = 1)");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schema != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schema));
        }
        if (table != null) {
            query.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(table));
        }
        if (unique) {
            query.append(" AND \"keys\".\"name\" IS NOT NULL");
        }
        query.append(" ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        StringBuilder query = new StringBuilder(990);
        if (types != null && types.length > 0) {
            query.append("SELECT * FROM (");
        }
        query.append("SELECT cast(null as char(1)) AS \"TYPE_CAT\", \"schemas\".\"name\" AS \"TYPE_SCHEM\", \"types\".\"sqlname\" AS \"TYPE_NAME\", CASE \"types\".\"sqlname\" WHEN 'inet' THEN 'nl.cwi.monetdb.jdbc.types.INET' WHEN 'json' THEN 'java.lang.String' WHEN 'url'  THEN 'nl.cwi.monetdb.jdbc.types.URL' WHEN 'uuid' THEN 'java.lang.String' ELSE 'java.lang.Object' END AS \"CLASS_NAME\", CAST(CASE WHEN \"types\".\"sqlname\" IN ('inet', 'json', 'url', 'uuid') THEN ").append(2000).append(" ELSE ").append(2002).append(" END AS int) AS \"DATA_TYPE\", \"types\".\"systemname\" AS \"REMARKS\", cast(null as smallint) AS \"BASE_TYPE\" FROM \"sys\".\"types\" JOIN \"sys\".\"schemas\" ON \"types\".\"schema_id\" = \"schemas\".\"id\" WHERE \"types\".\"id\" > 99 AND \"types\".\"eclass\" >= 15");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (typeNamePattern != null) {
            query.append(" AND \"types\".\"sqlname\" ").append(MonetDatabaseMetaData.composeMatchPart(typeNamePattern));
        }
        if (types != null && types.length > 0) {
            query.append(") AS getUDTs WHERE \"DATA_TYPE\" IN (");
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append(types[i]);
            }
            query.append(")");
        }
        query.append(" ORDER BY \"DATA_TYPE\", \"TYPE_SCHEM\", \"TYPE_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    public boolean rowChangesAreDetected(int type) {
        return false;
    }

    public boolean rowChangesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", cast(null as char(1)) AS \"SUPERTYPE_CAT\", '' AS \"SUPERTYPE_SCHEM\", '' AS \"SUPERTYPE_NAME\" WHERE 1 = 0";
        return this.executeMetaDataQuery(query);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"SUPERTABLE_NAME\" WHERE 1 = 0";
        return this.executeMetaDataQuery(query);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", '' AS \"ATTR_NAME\", CAST(0 as int) AS \"DATA_TYPE\", '' AS \"ATTR_TYPE_NAME\", CAST(0 as int) AS \"ATTR_SIZE\", CAST(0 as int) AS \"DECIMAL_DIGITS\", CAST(0 as int) AS \"NUM_PREC_RADIX\", CAST(0 as int) AS \"NULLABLE\", '' AS \"REMARKS\", '' AS \"ATTR_DEF\", CAST(0 as int) AS \"SQL_DATA_TYPE\", CAST(0 as int) AS \"SQL_DATETIME_SUB\", CAST(0 as int) AS \"CHAR_OCTET_LENGTH\", CAST(0 as int) AS \"ORDINAL_POSITION\", 'YES' AS \"IS_NULLABLE\", '' AS \"SCOPE_CATALOG\", '' AS \"SCOPE_SCHEMA\", '' AS \"SCOPE_TABLE\", CAST(0 as smallint) AS \"SOURCE_DATA_TYPE\" WHERE 1 = 0";
        return this.executeMetaDataQuery(query);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        int major = 0;
        if (this.env_monet_version != null) {
            try {
                int start = this.env_monet_version.indexOf(".");
                major = Integer.parseInt(this.env_monet_version.substring(0, start));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return major;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        int minor = 0;
        if (this.env_monet_version != null) {
            try {
                int start = this.env_monet_version.indexOf(".");
                int end = this.env_monet_version.indexOf(".", start + 1);
                minor = Integer.parseInt(this.env_monet_version.substring(start + 1, end));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return minor;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 1;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String query = "SELECT 'host' AS \"NAME\", CAST(1024 as int) AS \"MAX_LEN\", 'localhost' AS \"DEFAULT_VALUE\", 'DSN or IP-address of machine running MonetDB' AS \"DESCRIPTION\" UNION ALL SELECT 'port', 5, '50000', 'communication port number of MonetDB server process' UNION ALL SELECT 'user', 128, '', 'user name to login to MonetDB server' UNION ALL SELECT 'password', 128, '', 'password for user name to login to MonetDB server' UNION ALL SELECT 'language', 16, 'sql', 'language (sql or mal) used to parse commands in MonetDB server' UNION ALL SELECT 'debug', 5, 'false', 'boolean flag true or false' UNION ALL SELECT 'hash', 128, '', 'hash string' UNION ALL SELECT 'treat_blob_as_binary', 5, 'false', 'boolean flag true or false' UNION ALL SELECT 'so_timeout', 10, '0', 'timeout of communication socket. 0 means no timeout is set' ORDER BY \"NAME\"";
        return this.executeMetaDataQuery(query);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(800);
        query.append("SELECT cast(null as varchar(1)) AS \"FUNCTION_CAT\", \"schemas\".\"name\" AS \"FUNCTION_SCHEM\", \"functions\".\"name\" AS \"FUNCTION_NAME\", cast(\"functions\".\"func\" as varchar(9999)) AS \"REMARKS\", CASE \"functions\".\"type\" WHEN 1 THEN ").append(1).append(" WHEN 2 THEN ").append(1).append(" WHEN 3 THEN ").append(1).append(" WHEN 4 THEN ").append(1).append(" WHEN 5 THEN ").append(2).append(" ELSE ").append(0).append(" END AS \"FUNCTION_TYPE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\", \"sys\".\"schemas\" WHERE \"functions\".\"schema_id\" = \"schemas\".\"id\" AND \"functions\".\"type\" <> 2");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (functionNamePattern != null) {
            query.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(functionNamePattern));
        }
        query.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(2600);
        query.append("SELECT DISTINCT CAST(null as char(1)) AS \"FUNCTION_CAT\", \"schemas\".\"name\" AS \"FUNCTION_SCHEM\", \"functions\".\"name\" AS \"FUNCTION_NAME\", \"args\".\"name\" AS \"COLUMN_NAME\", CAST(CASE \"args\".\"inout\" WHEN 0 THEN (CASE \"args\".\"number\" WHEN 0 THEN ").append(4).append(" ELSE ").append(3).append(" END) WHEN 1 THEN ").append(1).append(" ELSE ").append(0).append(" END AS smallint) AS \"COLUMN_TYPE\", CAST(").append(MonetDriver.getSQLTypeMap("\"args\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"args\".\"type\" AS \"TYPE_NAME\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE \"args\".\"type_digits\" END AS \"PRECISION\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE \"args\".\"type_digits\" END AS \"LENGTH\", CAST(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','sec_interval') THEN \"args\".\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", CAST(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric') THEN 10 WHEN \"args\".\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", CAST(").append(2).append(" AS smallint) AS \"NULLABLE\", CAST(null as char(1)) AS \"REMARKS\", CAST(CASE WHEN \"args\".\"type\" IN ('char','varchar','clob') THEN \"args\".\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", CAST(\"args\".\"number\" as int) AS \"ORDINAL_POSITION\", CAST('' as varchar(3)) AS \"IS_NULLABLE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\", \"sys\".\"functions\", \"sys\".\"schemas\" WHERE \"args\".\"func_id\" = \"functions\".\"id\" AND \"functions\".\"schema_id\" = \"schemas\".\"id\" AND \"functions\".\"type\" <> 2");
        if (catalog != null && catalog.length() > 0) {
            query.append(" AND 1 = 0");
        }
        if (schemaPattern != null) {
            query.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(schemaPattern));
        }
        if (functionNamePattern != null) {
            query.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(functionNamePattern));
        }
        if (columnNamePattern != null) {
            query.append(" AND \"args\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(columnNamePattern));
        }
        query.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "SELECT CAST(null as char(1)) AS \"TABLE_CAT\", CAST('' as varchar(1)) AS \"TABLE_SCHEM\", CAST('' as varchar(1)) AS \"TABLE_NAME\", CAST('' as varchar(1)) AS \"COLUMN_NAME\", CAST(0 as int) AS \"DATA_TYPE\", CAST(0 as int) AS \"COLUMN_SIZE\", CAST(0 as int) AS \"DECIMAL_DIGITS\", CAST(0 as int) AS \"NUM_PREC_RADIX\", CAST('' as varchar(1)) AS \"COLUMN_USAGE\", CAST(null as varchar(1)) AS \"REMARKS\", CAST(0 as int) AS \"CHAR_OCTET_LENGTH\", CAST('' as varchar(3)) AS \"IS_NULLABLE\" WHERE 1 = 0";
        return this.executeMetaDataQuery(query);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }
}

